/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.util;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import javax.imageio.ImageIO;

public class QrCodeDecoder {
    public static boolean[][] decodeQrCodeFromBase64(String base64Data) {
        try {
            String pureBase64 = base64Data;
            if (base64Data.contains(",")) {
                pureBase64 = base64Data.substring(base64Data.indexOf(",") + 1);
            }
            System.out.println("QR code base64 length: " + pureBase64.length());
            byte[] imageData = Base64.getDecoder().decode(pureBase64);
            System.out.println("QR code image data length: " + imageData.length);
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageData));
            if (image == null) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u7801Base64\u56fe\u50cf\u6570\u636e");
            }
            System.out.println("QR code image dimensions: " + image.getWidth() + "x" + image.getHeight());
            int width = image.getWidth();
            int height = image.getHeight();
            boolean[][] qrMatrix = new boolean[height][width];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int rgb = image.getRGB(x, y);
                    int red = rgb >> 16 & 0xFF;
                    int green = rgb >> 8 & 0xFF;
                    int blue = rgb & 0xFF;
                    double luminance = 0.299 * (double)red + 0.587 * (double)green + 0.114 * (double)blue;
                    qrMatrix[y][x] = luminance < 128.0;
                }
            }
            return qrMatrix;
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e8c\u7ef4\u7801\u89e3\u7801\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static String convertToChatDisplay(boolean[][] qrMatrix, String originalBase64) {
        if (qrMatrix == null || qrMatrix.length == 0) {
            return "\u4e8c\u7ef4\u7801\u6570\u636e\u4e3a\u7a7a";
        }
        int height = qrMatrix.length;
        int width = qrMatrix[0].length;
        System.out.println("QR code matrix dimensions: " + width + "x" + height);
        StringBuilder sb = new StringBuilder();
        sb.append("\u00a7a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
        sb.append("\u00a7a           \u4e8c\u7ef4\u7801\u626b\u63cf\u767b\u5f55\n");
        sb.append("\u00a7a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n\n");
        try {
            String fileName = "qrcode_" + System.currentTimeMillis() + ".png";
            Path qrDir = Paths.get("qrcodes", new String[0]);
            if (!Files.exists(qrDir, new LinkOption[0])) {
                Files.createDirectories(qrDir, new FileAttribute[0]);
            }
            Path qrFile = qrDir.resolve(fileName);
            String pureBase64 = originalBase64;
            if (originalBase64.contains(",")) {
                pureBase64 = originalBase64.substring(originalBase64.indexOf(",") + 1);
            }
            byte[] imageData = Base64.getDecoder().decode(pureBase64);
            Files.write(qrFile, imageData, new OpenOption[0]);
            sb.append("\u00a7a\u2705 \u4e8c\u7ef4\u7801\u5df2\u751f\u6210\uff01\n");
            sb.append("\u00a77\u4e8c\u7ef4\u7801\u5df2\u4fdd\u5b58\u5230\u670d\u52a1\u5668\u6587\u4ef6\n");
            sb.append("\u00a77\u6587\u4ef6\u540d\u79f0: \u00a7e" + fileName + "\n");
            sb.append("\u00a77\u6587\u4ef6\u8def\u5f84: \u00a7e" + qrFile.toAbsolutePath() + "\n\n");
            sb.append("\u00a77\u8bf7\u4f7f\u7528\u4ee5\u4e0b\u65b9\u5f0f\u626b\u63cf\u4e8c\u7ef4\u7801\uff1a\n");
            sb.append("\u00a771. \u4e0b\u8f7d\u4e8c\u7ef4\u7801\u6587\u4ef6\u540e\u4f7f\u7528APP\u626b\u63cf\n");
            sb.append("\u00a772. \u6216\u4f7f\u7528\u7f51\u6613\u4e91\u97f3\u4e50APP\u76f4\u63a5\u626b\u63cf\n\n");
        }
        catch (Exception e) {
            sb.append("\u00a7a\u2705 \u4e8c\u7ef4\u7801\u5df2\u751f\u6210\uff01\n");
            sb.append("\u00a77\u4e8c\u7ef4\u7801\u6570\u636e\u957f\u5ea6: \u00a7e" + originalBase64.length() + " \u5b57\u7b26\n\n");
            sb.append("\u00a7c\u65e0\u6cd5\u4fdd\u5b58\u4e8c\u7ef4\u7801\u6587\u4ef6\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5668\u7ba1\u7406\u5458\n");
            sb.append("\u00a77\u9519\u8bef\u4fe1\u606f: " + e.getMessage() + "\n\n");
        }
        sb.append("\u00a77\u4e8c\u7ef4\u7801\u6709\u6548\u65f6\u95f4: \u00a7e5\u5206\u949f\n");
        sb.append("\u00a77\u4f7f\u7528 \u00a76/nclogin status \u00a77\u68c0\u67e5\u767b\u5f55\u72b6\u6001");
        return sb.toString();
    }

    public static String processQrCodeForChat(String base64Data) {
        try {
            boolean[][] qrMatrix = QrCodeDecoder.decodeQrCodeFromBase64(base64Data);
            return QrCodeDecoder.convertToChatDisplay(qrMatrix, base64Data);
        }
        catch (Exception e) {
            return "\u00a7c\u4e8c\u7ef4\u7801\u5904\u7406\u5931\u8d25: " + e.getMessage();
        }
    }
}

