/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.util;

import java.awt.Desktop;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;

public class QrCodeWebDisplay {
    public static void displayQrCodeInBrowser(ServerPlayer player, String qrBase64, String qrKey) {
        try {
            Path htmlDir = Paths.get("qrcodes_html", new String[0]);
            if (!Files.exists(htmlDir, new LinkOption[0])) {
                Files.createDirectories(htmlDir, new FileAttribute[0]);
            }
            String fileName = "qrcode_" + player.m_20149_() + "_" + System.currentTimeMillis() + ".html";
            Path htmlFile = htmlDir.resolve(fileName);
            String pureBase64 = qrBase64;
            if (qrBase64.contains(",")) {
                pureBase64 = qrBase64.substring(qrBase64.indexOf(",") + 1);
            }
            String htmlContent = QrCodeWebDisplay.generateHtmlPage(pureBase64, qrKey, player.m_6302_());
            Files.write(htmlFile, htmlContent.getBytes("UTF-8"), new OpenOption[0]);
            String absolutePath = htmlFile.toAbsolutePath().toString();
            String fileUrl = "file:///" + absolutePath.replace("\\", "/");
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u2705 \u4e8c\u7ef4\u7801\u9875\u9762\u5df2\u751f\u6210\uff01"));
            MutableComponent clickableLink = Component.m_237113_((String)"\u00a7b\u00a7n\u70b9\u51fb\u8fd9\u91cc\u6253\u5f00\u4e8c\u7ef4\u7801\u9875\u9762").m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, fileUrl)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u70b9\u51fb\u5728\u6d4f\u89c8\u5668\u4e2d\u6253\u5f00\u4e8c\u7ef4\u7801\u9875\u9762"))));
            player.m_213846_((Component)clickableLink);
            player.m_213846_((Component)Component.m_237113_((String)("\u00a77\u6216\u624b\u52a8\u590d\u5236\u94fe\u63a5: \u00a7e" + fileUrl)));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u9875\u9762\u5c06\u81ea\u52a8\u663e\u793a\u4e8c\u7ef4\u7801\u5e76\u68c0\u67e5\u767b\u5f55\u72b6\u6001"));
            System.out.println("QR code HTML generated: " + absolutePath);
            System.out.println("File URL: " + fileUrl);
            QrCodeWebDisplay.tryAutoOpenBrowser(fileUrl);
        }
        catch (Exception e) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c\u4e8c\u7ef4\u7801\u9875\u9762\u751f\u6210\u5931\u8d25: " + e.getMessage())));
            System.out.println("Error generating QR code HTML: " + e.getMessage());
        }
    }

    private static void tryAutoOpenBrowser(String url) {
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(new URI(url));
                System.out.println("\u81ea\u52a8\u6253\u5f00\u6d4f\u89c8\u5668\u6210\u529f: " + url);
            } else {
                System.out.println("\u65e0\u6cd5\u81ea\u52a8\u6253\u5f00\u6d4f\u89c8\u5668\uff0c\u8bf7\u624b\u52a8\u8bbf\u95ee\u94fe\u63a5");
            }
        }
        catch (Exception e) {
            System.out.println("\u81ea\u52a8\u6253\u5f00\u6d4f\u89c8\u5668\u5931\u8d25: " + e.getMessage());
        }
    }

    private static String generateHtmlPage(String qrBase64, String qrKey, String playerName) {
        return "<!DOCTYPE html>\n<html lang=\"zh-CN\">\n<head>\n    <meta charset=\"UTF-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <title>\u7f51\u6613\u4e91\u97f3\u4e50\u767b\u5f55\u4e8c\u7ef4\u7801 - " + playerName + "</title>\n    <style>\n        body {\n            font-family: 'Microsoft YaHei', Arial, sans-serif;\n            text-align: center;\n            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);\n            min-height: 100vh;\n            margin: 0;\n            padding: 20px;\n            color: white;\n        }\n        .container {\n            max-width: 500px;\n            margin: 0 auto;\n            background: rgba(255, 255, 255, 0.1);\n            padding: 30px;\n            border-radius: 20px;\n            backdrop-filter: blur(10px);\n            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);\n        }\n        .qrcode {\n            margin: 20px 0;\n            padding: 20px;\n            background: white;\n            border-radius: 15px;\n            display: inline-block;\n        }\n        .qrcode img {\n            width: 250px;\n            height: 250px;\n            border: 3px solid #333;\n            border-radius: 10px;\n        }\n        .status {\n            margin: 20px 0;\n            padding: 15px;\n            background: rgba(255, 255, 255, 0.2);\n            border-radius: 10px;\n            font-size: 16px;\n        }\n        .success { color: #4CAF50; font-weight: bold; }\n        .waiting { color: #FF9800; }\n        .error { color: #f44336; }\n        .instructions {\n            text-align: left;\n            background: rgba(255, 255, 255, 0.1);\n            padding: 15px;\n            border-radius: 10px;\n            margin: 15px 0;\n        }\n        .countdown {\n            font-size: 18px;\n            font-weight: bold;\n            margin: 10px 0;\n        }\n    </style>\n</head>\n<body>\n    <div class=\"container\">\n        <h1>\ud83c\udfb5 \u7f51\u6613\u4e91\u97f3\u4e50\u767b\u5f55</h1>\n        <p>\u73a9\u5bb6: <strong>" + playerName + "</strong></p>\n        \n        <div class=\"qrcode\">\n            <img src=\"data:image/png;base64," + qrBase64 + "\" alt=\"\u7f51\u6613\u4e91\u97f3\u4e50\u767b\u5f55\u4e8c\u7ef4\u7801\">\n        </div>\n        \n        <div class=\"status\" id=\"status\">\n            <p class=\"waiting\">\ud83d\udd04 \u7b49\u5f85\u626b\u63cf\u4e2d...</p>\n            <p>\u8bf7\u4f7f\u7528\u7f51\u6613\u4e91\u97f3\u4e50APP\u626b\u63cf\u4e8c\u7ef4\u7801</p>\n        </div>\n        \n        <div class=\"countdown\" id=\"countdown\">\n            \u4e8c\u7ef4\u7801\u6709\u6548\u65f6\u95f4: <span id=\"time\">300</span> \u79d2\n        </div>\n        \n        <div class=\"instructions\">\n            <h3>\u4f7f\u7528\u8bf4\u660e:</h3>\n            <ol>\n                <li>\u6253\u5f00\u7f51\u6613\u4e91\u97f3\u4e50\u624b\u673aAPP</li>\n                <li>\u70b9\u51fb\u53f3\u4e0a\u89d2\u626b\u4e00\u626b\u529f\u80fd</li>\n                <li>\u626b\u63cf\u9875\u9762\u4e2d\u7684\u4e8c\u7ef4\u7801</li>\n                <li>\u5728APP\u4e2d\u786e\u8ba4\u767b\u5f55</li>\n                <li>\u9875\u9762\u5c06\u81ea\u52a8\u68c0\u6d4b\u767b\u5f55\u72b6\u6001</li>\n            </ol>\n        </div>\n    </div>\n    \n    <script>\n        const qrKey = '" + qrKey + "';\n        let timeLeft = 300; // 5\u5206\u949f\n        \n        // \u5012\u8ba1\u65f6\u51fd\u6570\n        function updateCountdown() {\n            const minutes = Math.floor(timeLeft / 60);\n            const seconds = timeLeft % 60;\n            document.getElementById('time').textContent = \n                minutes.toString().padStart(2, '0') + ':' + seconds.toString().padStart(2, '0');\n            \n            if (timeLeft <= 0) {\n                document.getElementById('status').innerHTML = \n                    '<p class=\"error\">\u274c \u4e8c\u7ef4\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u8fd4\u56de\u6e38\u620f\u91cd\u65b0\u751f\u6210</p>';\n                clearInterval(countdownInterval);\n                clearInterval(statusInterval);\n                return;\n            }\n            timeLeft--;\n        }\n        \n        // \u68c0\u67e5\u767b\u5f55\u72b6\u6001\n        async function checkLoginStatus() {\n            if (timeLeft <= 0) return;\n            \n            try {\n                const response = await fetch('/api/login/status?key=' + qrKey);\n                const data = await response.json();\n                \n                if (data.code === 803) {\n                    // \u767b\u5f55\u6210\u529f\n                    document.getElementById('status').innerHTML = \n                        '<p class=\"success\">\u2705 \u767b\u5f55\u6210\u529f\uff01</p>' +\n                        '<p>\u6b22\u8fce\u4f7f\u7528\u7f51\u6613\u4e91\u97f3\u4e50\u670d\u52a1</p>' +\n                        '<p>\u8bf7\u8fd4\u56de\u6e38\u620f\u7ee7\u7eed\u4f7f\u7528</p>';\n                    clearInterval(countdownInterval);\n                    clearInterval(statusInterval);\n                } else if (data.code === 800) {\n                    // \u4e8c\u7ef4\u7801\u8fc7\u671f\n                    document.getElementById('status').innerHTML = \n                        '<p class=\"error\">\u274c \u4e8c\u7ef4\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u8fd4\u56de\u6e38\u620f\u91cd\u65b0\u751f\u6210</p>';\n                    clearInterval(countdownInterval);\n                    clearInterval(statusInterval);\n                } else if (data.code === 801) {\n                    // \u7b49\u5f85\u626b\u63cf\n                    document.getElementById('status').innerHTML = \n                        '<p class=\"waiting\">\ud83d\udd04 \u7b49\u5f85\u626b\u63cf\u4e2d...</p>' +\n                        '<p>\u8bf7\u4f7f\u7528\u7f51\u6613\u4e91\u97f3\u4e50APP\u626b\u63cf\u4e8c\u7ef4\u7801</p>';\n                }\n            } catch (error) {\n                console.error('\u68c0\u67e5\u767b\u5f55\u72b6\u6001\u5931\u8d25:', error);\n            }\n        }\n        \n        // \u542f\u52a8\u5012\u8ba1\u65f6\u548c\u72b6\u6001\u68c0\u67e5\n        const countdownInterval = setInterval(updateCountdown, 1000);\n        const statusInterval = setInterval(checkLoginStatus, 5000);\n        \n        // \u7acb\u5373\u66f4\u65b0\u4e00\u6b21\n        updateCountdown();\n        checkLoginStatus();\n    </script>\n</body>\n</html>";
    }
}

