/*
 * Decompiled with CFR 0.152.
 */
package audio.javazoom.jl.jl.converter;

import audio.javazoom.jl.jl.converter.RiffFile;

public class WaveFile
extends RiffFile {
    public static final int MAX_WAVE_CHANNELS = 2;
    private Chunk waveFormat;
    private RiffFile.RiffChunkHeader pcmData = new RiffFile.RiffChunkHeader();
    private long pcmDataOffset = 0L;
    private int numSamples = 0;

    public WaveFile() {
        this.waveFormat = new Chunk();
        this.pcmData.ckID = WaveFile.fourCC("data");
        this.pcmData.ckSize = 0;
        this.numSamples = 0;
    }

    public int openForWrite(String filename, int samplingRate, short bitsPerSample, short numChannels) {
        byte[] theWave;
        if (filename == null || bitsPerSample != 8 && bitsPerSample != 16 || numChannels < 1 || numChannels > 2) {
            return 4;
        }
        this.waveFormat.data.config(samplingRate, bitsPerSample, numChannels);
        int retcode = this.Open(filename, 1);
        if (retcode == 0 && (retcode = this.write(theWave = new byte[]{87, 65, 86, 69}, 4)) == 0) {
            retcode = this.write(this.waveFormat.header, 8);
            retcode = this.write(this.waveFormat.data.wFormatTag, 2);
            retcode = this.write(this.waveFormat.data.nChannels, 2);
            retcode = this.write(this.waveFormat.data.nSamplesPerSec, 4);
            retcode = this.write(this.waveFormat.data.nAvgBytesPerSec, 4);
            retcode = this.write(this.waveFormat.data.nBlockAlign, 2);
            retcode = this.write(this.waveFormat.data.nBitsPerSample, 2);
            if (retcode == 0) {
                this.pcmDataOffset = this.currentFilePosition();
                retcode = this.write(this.pcmData, 8);
            }
        }
        return retcode;
    }

    public int writeData(short[] data, int numData) {
        int extraBytes = numData * 2;
        this.pcmData.ckSize += extraBytes;
        return super.write(data, extraBytes);
    }

    @Override
    public int close() {
        int rc = 0;
        if (this.fmode == 1) {
            rc = this.backpatch(this.pcmDataOffset, this.pcmData, 8);
        }
        if (rc == 0) {
            rc = super.close();
        }
        return rc;
    }

    public int samplingRate() {
        return this.waveFormat.data.nSamplesPerSec;
    }

    public short bitsPerSample() {
        return this.waveFormat.data.nBitsPerSample;
    }

    public short numChannels() {
        return this.waveFormat.data.nChannels;
    }

    public int numSamples() {
        return this.numSamples;
    }

    public int openForWrite(String filename, WaveFile otherWave) {
        return this.openForWrite(filename, otherWave.samplingRate(), otherWave.bitsPerSample(), otherWave.numChannels());
    }

    @Override
    public long currentFilePosition() {
        return super.currentFilePosition();
    }

    static class Chunk {
        public RiffFile.RiffChunkHeader header = new RiffFile.RiffChunkHeader();
        public ChunkData data = new ChunkData();

        public Chunk() {
            this.header.ckID = RiffFile.fourCC("fmt ");
            this.header.ckSize = 16;
        }

        public int verifyValidity() {
            boolean ret;
            boolean bl = ret = this.header.ckID == RiffFile.fourCC("fmt ") && (this.data.nChannels == 1 || this.data.nChannels == 2) && this.data.nAvgBytesPerSec == this.data.nChannels * this.data.nSamplesPerSec * this.data.nBitsPerSample / 8 && this.data.nBlockAlign == this.data.nChannels * this.data.nBitsPerSample / 8;
            if (ret) {
                return 1;
            }
            return 0;
        }
    }

    static class ChunkData {
        public short wFormatTag = 1;
        public short nChannels = 0;
        public int nSamplesPerSec = 0;
        public int nAvgBytesPerSec = 0;
        public short nBlockAlign = 0;
        public short nBitsPerSample = 0;

        public ChunkData() {
            this.config(44100, (short)16, (short)1);
        }

        public void config(int newSamplingRate, short newBitsPerSample, short newNumChannels) {
            this.nSamplesPerSec = newSamplingRate;
            this.nChannels = newNumChannels;
            this.nBitsPerSample = newBitsPerSample;
            this.nAvgBytesPerSec = this.nChannels * this.nSamplesPerSec * this.nBitsPerSample / 8;
            this.nBlockAlign = (short)(this.nChannels * this.nBitsPerSample / 8);
        }
    }

    public static class WaveFileSample {
        public short[] chan = new short[2];
    }
}

