/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.service;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;

public class EqualizerService {
    private static final Map<UUID, float[]> playerEQSettings = new ConcurrentHashMap<UUID, float[]>();
    private static final Map<String, EQPreset> presetCache = new HashMap<String, EQPreset>();

    public static float[] getEQSettings(ServerPlayer player) {
        return playerEQSettings.getOrDefault(player.m_20148_(), new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f});
    }

    public static JsonObject setBandGain(ServerPlayer player, FrequencyBand band, float gain) {
        float[] eqSettings = EqualizerService.getEQSettings(player);
        eqSettings[band.ordinal()] = Math.max(-12.0f, Math.min(12.0f, gain));
        playerEQSettings.put(player.m_20148_(), eqSettings);
        JsonObject result = new JsonObject();
        result.addProperty("code", (Number)200);
        result.addProperty("message", band.getDisplayName() + "\u589e\u76ca\u5df2\u8bbe\u7f6e\u4e3a: " + gain + "dB");
        return result;
    }

    public static JsonObject setEQPreset(ServerPlayer player, String presetName) {
        EQPreset preset = presetCache.get(presetName.toLowerCase());
        if (preset == null) {
            JsonObject result = new JsonObject();
            result.addProperty("code", (Number)500);
            result.addProperty("error", "\u672a\u77e5\u7684\u5747\u8861\u5668\u9884\u8bbe: " + presetName);
            return result;
        }
        playerEQSettings.put(player.m_20148_(), preset.getGains());
        JsonObject result = new JsonObject();
        result.addProperty("code", (Number)200);
        result.addProperty("message", "\u5747\u8861\u5668\u9884\u8bbe\u5df2\u8bbe\u7f6e\u4e3a: " + preset.getDisplayName());
        return result;
    }

    public static JsonObject resetEQ(ServerPlayer player) {
        playerEQSettings.put(player.m_20148_(), EQPreset.FLAT.getGains());
        JsonObject result = new JsonObject();
        result.addProperty("code", (Number)200);
        result.addProperty("message", "\u5747\u8861\u5668\u5df2\u91cd\u7f6e\u4e3a\u5e73\u5766");
        return result;
    }

    public static JsonObject getEQStatus(ServerPlayer player) {
        float[] eqSettings = EqualizerService.getEQSettings(player);
        JsonObject result = new JsonObject();
        result.addProperty("code", (Number)200);
        JsonObject bands = new JsonObject();
        for (FrequencyBand band : FrequencyBand.values()) {
            bands.addProperty(band.name(), (Number)Float.valueOf(eqSettings[band.ordinal()]));
        }
        result.add("bands", (JsonElement)bands);
        return result;
    }

    public static float applyEQ(float sample, float[] eqSettings, float sampleRate) {
        float overallGain = 1.0f;
        for (float gain : eqSettings) {
            overallGain *= (float)Math.pow(10.0, (double)gain / 20.0);
        }
        return sample * overallGain;
    }

    public static void clearEQSettings(ServerPlayer player) {
        playerEQSettings.remove(player.m_20148_());
    }

    public static JsonObject getPresetList() {
        JsonObject result = new JsonObject();
        result.addProperty("code", (Number)200);
        JsonObject presets = new JsonObject();
        for (EQPreset preset : EQPreset.values()) {
            presets.addProperty(preset.name(), preset.getDisplayName());
        }
        result.add("presets", (JsonElement)presets);
        return result;
    }

    static {
        for (EQPreset preset : EQPreset.values()) {
            presetCache.put(preset.name().toLowerCase(), preset);
        }
    }

    public static enum FrequencyBand {
        BASS(60, "\u4f4e\u97f3"),
        LOW_MID(250, "\u4e2d\u4f4e\u97f3"),
        MID(1000, "\u4e2d\u97f3"),
        HIGH_MID(4000, "\u4e2d\u9ad8\u97f3"),
        TREBLE(16000, "\u9ad8\u97f3");

        private final int frequency;
        private final String displayName;

        private FrequencyBand(int frequency, String displayName) {
            this.frequency = frequency;
            this.displayName = displayName;
        }

        public int getFrequency() {
            return this.frequency;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    public static enum EQPreset {
        FLAT("\u5e73\u5766", new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f}),
        BASS_BOOST("\u4f4e\u97f3\u589e\u5f3a", new float[]{6.0f, 3.0f, 0.0f, -2.0f, -3.0f}),
        TREBLE_BOOST("\u9ad8\u97f3\u589e\u5f3a", new float[]{-3.0f, -2.0f, 0.0f, 3.0f, 6.0f}),
        VOCAL("\u4eba\u58f0\u7a81\u51fa", new float[]{-2.0f, 0.0f, 4.0f, 2.0f, -1.0f}),
        ROCK("\u6447\u6eda", new float[]{4.0f, 2.0f, 0.0f, 2.0f, 4.0f}),
        JAZZ("\u7235\u58eb", new float[]{3.0f, 1.0f, -1.0f, 1.0f, 3.0f}),
        CLASSICAL("\u53e4\u5178", new float[]{2.0f, 1.0f, 0.0f, 1.0f, 2.0f});

        private final String displayName;
        private final float[] gains;

        private EQPreset(String displayName, float[] gains) {
            this.displayName = displayName;
            this.gains = gains;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public float[] getGains() {
            return this.gains;
        }
    }
}

