/*
 * Decompiled with CFR 0.152.
 */
package audio.javazoom.jl.jl.decoder;

import audio.javazoom.jl.jl.decoder.Bitstream;
import audio.javazoom.jl.jl.decoder.Crc16;
import audio.javazoom.jl.jl.decoder.DecoderException;
import audio.javazoom.jl.jl.decoder.FrameDecoder;
import audio.javazoom.jl.jl.decoder.Header;
import audio.javazoom.jl.jl.decoder.Obuffer;
import audio.javazoom.jl.jl.decoder.SynthesisFilter;

class LayerIDecoder
implements FrameDecoder {
    protected Bitstream stream;
    protected Header header;
    protected SynthesisFilter filter1;
    protected SynthesisFilter filter2;
    protected Obuffer buffer;
    protected int whichChannels;
    protected int mode;
    protected int num_subbands;
    protected Subband[] subbands;
    protected Crc16 crc = new Crc16();

    public void create(Bitstream stream, Header header, SynthesisFilter filterA, SynthesisFilter filterB, Obuffer buffer, int whichCh) {
        this.stream = stream;
        this.header = header;
        this.filter1 = filterA;
        this.filter2 = filterB;
        this.buffer = buffer;
        this.whichChannels = whichCh;
    }

    @Override
    public void decodeFrame() throws DecoderException {
        this.num_subbands = this.header.numberOfSubbands();
        this.subbands = new Subband[32];
        this.mode = this.header.mode();
        this.createSubbands();
        this.readAllocation();
        this.readScaleFactorSelection();
        if (this.crc != null || this.header.checksumOk()) {
            this.readScaleFactors();
            this.readSampleData();
        }
    }

    protected void createSubbands() {
        if (this.mode == 3) {
            for (int i = 0; i < this.num_subbands; ++i) {
                this.subbands[i] = new SubbandLayer1(i);
            }
        } else if (this.mode == 1) {
            int i;
            for (i = 0; i < this.header.intensityStereoBound(); ++i) {
                this.subbands[i] = new SubbandLayer1Stereo(i);
            }
            while (i < this.num_subbands) {
                this.subbands[i] = new SubbandLayer1IntensityStereo(i);
                ++i;
            }
        } else {
            for (int i = 0; i < this.num_subbands; ++i) {
                this.subbands[i] = new SubbandLayer1Stereo(i);
            }
        }
    }

    protected void readAllocation() throws DecoderException {
        for (int i = 0; i < this.num_subbands; ++i) {
            this.subbands[i].readAllocation(this.stream, this.header, this.crc);
        }
    }

    protected void readScaleFactorSelection() {
    }

    protected void readScaleFactors() {
        for (int i = 0; i < this.num_subbands; ++i) {
            this.subbands[i].readScaleFactor(this.stream, this.header);
        }
    }

    protected void readSampleData() {
        boolean readReady = false;
        boolean writeReady = false;
        int mode = this.header.mode();
        do {
            int i;
            for (i = 0; i < this.num_subbands; ++i) {
                readReady = this.subbands[i].readSampleData(this.stream);
            }
            do {
                for (i = 0; i < this.num_subbands; ++i) {
                    writeReady = this.subbands[i].put_next_sample(this.whichChannels, this.filter1, this.filter2);
                }
                this.filter1.calculate_pcm_samples(this.buffer);
                if (this.whichChannels != 0 || mode == 3) continue;
                this.filter2.calculate_pcm_samples(this.buffer);
            } while (!writeReady);
        } while (!readReady);
    }

    static abstract class Subband {
        public static final float[] scaleFactors = new float[]{2.0f, 1.587401f, 1.2599211f, 1.0f, 0.7937005f, 0.62996054f, 0.5f, 0.39685026f, 0.31498027f, 0.25f, 0.19842513f, 0.15749013f, 0.125f, 0.099212565f, 0.07874507f, 0.0625f, 0.049606282f, 0.039372534f, 0.03125f, 0.024803141f, 0.019686267f, 0.015625f, 0.012401571f, 0.009843133f, 0.0078125f, 0.0062007853f, 0.0049215667f, 0.00390625f, 0.0031003926f, 0.0024607833f, 0.001953125f, 0.0015501963f, 0.0012303917f, 9.765625E-4f, 7.7509816E-4f, 6.1519584E-4f, 4.8828125E-4f, 3.8754908E-4f, 3.0759792E-4f, 2.4414062E-4f, 1.9377454E-4f, 1.5379896E-4f, 1.2207031E-4f, 9.688727E-5f, 7.689948E-5f, 6.1035156E-5f, 4.8443635E-5f, 3.844974E-5f, 3.0517578E-5f, 2.4221818E-5f, 1.922487E-5f, 1.5258789E-5f, 1.2110909E-5f, 9.612435E-6f, 7.6293945E-6f, 6.0554544E-6f, 4.8062175E-6f, 3.8146973E-6f, 3.0277272E-6f, 2.4031087E-6f, 1.9073486E-6f, 1.5138636E-6f, 1.2015544E-6f, 0.0f};

        Subband() {
        }

        public abstract void readAllocation(Bitstream var1, Header var2, Crc16 var3) throws DecoderException;

        public abstract void readScaleFactor(Bitstream var1, Header var2);

        public abstract boolean readSampleData(Bitstream var1);

        public abstract boolean put_next_sample(int var1, SynthesisFilter var2, SynthesisFilter var3);
    }

    static class SubbandLayer1
    extends Subband {
        public static final float[] tableFactor = new float[]{0.0f, 0.6666667f, 0.2857143f, 0.13333334f, 0.06451613f, 0.031746034f, 0.015748031f, 0.007843138f, 0.0039138943f, 0.0019550342f, 9.770396E-4f, 4.884005E-4f, 2.4417043E-4f, 1.2207776E-4f, 6.103702E-5f};
        public static final float[] tableOffset = new float[]{0.0f, -0.6666667f, -0.8571429f, -0.9333334f, -0.9677419f, -0.98412704f, -0.992126f, -0.9960785f, -0.99804306f, -0.9990225f, -0.9995115f, -0.99975586f, -0.9998779f, -0.99993896f, -0.9999695f};
        protected int subbandNumber;
        protected int sampleNumber;
        protected int allocation;
        protected float scaleFactor;
        protected int sampleLength;
        protected float sample;
        protected float factor;
        protected float offset;

        public SubbandLayer1(int subbandNumber) {
            this.subbandNumber = subbandNumber;
            this.sampleNumber = 0;
        }

        @Override
        public void readAllocation(Bitstream stream, Header header, Crc16 crc) throws DecoderException {
            this.allocation = stream.getBits(4);
            if (this.allocation == 15) {
                throw new DecoderException(514, null);
            }
            if (crc != null) {
                crc.addBits(this.allocation, 4);
            }
            if (this.allocation != 0) {
                this.sampleLength = this.allocation + 1;
                this.factor = tableFactor[this.allocation];
                this.offset = tableOffset[this.allocation];
            }
        }

        @Override
        public void readScaleFactor(Bitstream stream, Header header) {
            if (this.allocation != 0) {
                this.scaleFactor = scaleFactors[stream.getBits(6)];
            }
        }

        @Override
        public boolean readSampleData(Bitstream stream) {
            if (this.allocation != 0) {
                this.sample = stream.getBits(this.sampleLength);
            }
            if (++this.sampleNumber == 12) {
                this.sampleNumber = 0;
                return true;
            }
            return false;
        }

        @Override
        public boolean put_next_sample(int channels, SynthesisFilter filter1, SynthesisFilter filter2) {
            if (this.allocation != 0 && channels != 2) {
                float scaled_sample = (this.sample * this.factor + this.offset) * this.scaleFactor;
                filter1.inputSample(scaled_sample, this.subbandNumber);
            }
            return true;
        }
    }

    static class SubbandLayer1Stereo
    extends SubbandLayer1 {
        protected int channel2Allocation;
        protected float channel2ScaleFactor;
        protected int channel2SampleLength;
        protected float channel2Sample;
        protected float channel2Factor;
        protected float channel2Offset;

        public SubbandLayer1Stereo(int subbandNumber) {
            super(subbandNumber);
        }

        @Override
        public void readAllocation(Bitstream stream, Header header, Crc16 crc) throws DecoderException {
            this.allocation = stream.getBits(4);
            this.channel2Allocation = stream.getBits(4);
            if (crc != null) {
                crc.addBits(this.allocation, 4);
                crc.addBits(this.channel2Allocation, 4);
            }
            if (this.allocation != 0) {
                this.sampleLength = this.allocation + 1;
                this.factor = tableFactor[this.allocation];
                this.offset = tableOffset[this.allocation];
            }
            if (this.channel2Allocation != 0) {
                this.channel2SampleLength = this.channel2Allocation + 1;
                this.channel2Factor = tableFactor[this.channel2Allocation];
                this.channel2Offset = tableOffset[this.channel2Allocation];
            }
        }

        @Override
        public void readScaleFactor(Bitstream stream, Header header) {
            if (this.allocation != 0) {
                this.scaleFactor = scaleFactors[stream.getBits(6)];
            }
            if (this.channel2Allocation != 0) {
                this.channel2ScaleFactor = scaleFactors[stream.getBits(6)];
            }
        }

        @Override
        public boolean readSampleData(Bitstream stream) {
            boolean returnValue = super.readSampleData(stream);
            if (this.channel2Allocation != 0) {
                this.channel2Sample = stream.getBits(this.channel2SampleLength);
            }
            return returnValue;
        }

        @Override
        public boolean put_next_sample(int channels, SynthesisFilter filter1, SynthesisFilter filter2) {
            super.put_next_sample(channels, filter1, filter2);
            if (this.channel2Allocation != 0 && channels != 1) {
                float sample2 = (this.channel2Sample * this.channel2Factor + this.channel2Offset) * this.channel2ScaleFactor;
                if (channels == 0) {
                    filter2.inputSample(sample2, this.subbandNumber);
                } else {
                    filter1.inputSample(sample2, this.subbandNumber);
                }
            }
            return true;
        }
    }

    static class SubbandLayer1IntensityStereo
    extends SubbandLayer1 {
        protected float channel2ScaleFactor;

        public SubbandLayer1IntensityStereo(int subbandNumber) {
            super(subbandNumber);
        }

        @Override
        public void readAllocation(Bitstream stream, Header header, Crc16 crc) throws DecoderException {
            super.readAllocation(stream, header, crc);
        }

        @Override
        public void readScaleFactor(Bitstream stream, Header header) {
            if (this.allocation != 0) {
                this.scaleFactor = scaleFactors[stream.getBits(6)];
                this.channel2ScaleFactor = scaleFactors[stream.getBits(6)];
            }
        }

        @Override
        public boolean readSampleData(Bitstream stream) {
            return super.readSampleData(stream);
        }

        @Override
        public boolean put_next_sample(int channels, SynthesisFilter filter1, SynthesisFilter filter2) {
            if (this.allocation != 0) {
                this.sample = this.sample * this.factor + this.offset;
                if (channels == 0) {
                    float sample1 = this.sample * this.scaleFactor;
                    float sample2 = this.sample * this.channel2ScaleFactor;
                    filter1.inputSample(sample1, this.subbandNumber);
                    filter2.inputSample(sample2, this.subbandNumber);
                } else if (channels == 1) {
                    float sample1 = this.sample * this.scaleFactor;
                    filter1.inputSample(sample1, this.subbandNumber);
                } else {
                    float sample2 = this.sample * this.channel2ScaleFactor;
                    filter1.inputSample(sample2, this.subbandNumber);
                }
            }
            return true;
        }
    }
}

