/*
 * Decompiled with CFR 0.152.
 */
package audio.javazoom.jl.jl.decoder;

import audio.javazoom.jl.jl.decoder.Obuffer;

public class SampleBuffer
extends Obuffer {
    private final short[] buffer = new short[2304];
    private final int[] bufferP = new int[2];
    private final int channels;
    private final int frequency;

    public SampleBuffer(int sample_frequency, int number_of_channels) {
        this.channels = number_of_channels;
        this.frequency = sample_frequency;
        for (int i = 0; i < number_of_channels; ++i) {
            this.bufferP[i] = (short)i;
        }
    }

    public int getChannelCount() {
        return this.channels;
    }

    public int getSampleFrequency() {
        return this.frequency;
    }

    public short[] getBuffer() {
        return this.buffer;
    }

    public int getBufferLength() {
        return this.bufferP[0];
    }

    @Override
    public void append(int channel, short value) {
        this.buffer[this.bufferP[channel]] = value;
        int n = channel;
        this.bufferP[n] = this.bufferP[n] + this.channels;
    }

    @Override
    public void appendSamples(int channel, float[] f) {
        int pos = this.bufferP[channel];
        int i = 0;
        while (i < 32) {
            short s;
            float fs;
            fs = (fs = f[i++]) > 32767.0f ? 32767.0f : Math.max(fs, -32767.0f);
            this.buffer[pos] = s = (short)fs;
            pos += this.channels;
        }
        this.bufferP[channel] = pos;
    }

    @Override
    public void writeBuffer(int val) {
    }

    @Override
    public void close() {
    }

    @Override
    public void clearBuffer() {
        for (int i = 0; i < this.channels; ++i) {
            this.bufferP[i] = (short)i;
        }
    }

    @Override
    public void setStopFlag() {
    }
}

