/*
 * Decompiled with CFR 0.152.
 */
package audio.javazoom.jl.jl.player;

import audio.javazoom.jl.jl.decoder.JavaLayerException;
import audio.javazoom.jl.jl.player.AudioDevice;
import audio.javazoom.jl.jl.player.AudioDeviceFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;

public class FactoryRegistry {
    private static final Logger logger = Logger.getLogger(FactoryRegistry.class.getName());
    private static FactoryRegistry instance = null;
    public final Map<Class<? extends AudioDeviceFactory>, AudioDeviceFactory> factories = new HashMap<Class<? extends AudioDeviceFactory>, AudioDeviceFactory>();

    public static synchronized FactoryRegistry systemRegistry() {
        if (instance == null) {
            instance = new FactoryRegistry();
            instance.registerDefaultFactories();
        }
        return instance;
    }

    public void addFactory(AudioDeviceFactory factory) {
        this.factories.put(factory.getClass(), factory);
    }

    public void removeFactoryType(Class<?> cls) {
        this.factories.remove(cls);
    }

    public void removeFactory(AudioDeviceFactory factory) {
        this.factories.remove(factory.getClass());
    }

    public AudioDevice createAudioDevice(Class<? extends AudioDeviceFactory> clazz) throws JavaLayerException {
        return this.factories.get(clazz).createAudioDevice();
    }

    public AudioDevice createAudioDevice() throws JavaLayerException {
        AudioDevice device = null;
        JavaLayerException lastEx = null;
        logger.fine("factories order: " + Arrays.toString(this.getFactoriesPriority()));
        for (AudioDeviceFactory factory : this.getFactoriesPriority()) {
            try {
                device = factory.createAudioDevice();
                break;
            }
            catch (JavaLayerException ex) {
                lastEx = ex;
            }
        }
        if (device == null && lastEx != null) {
            throw new JavaLayerException("Cannot create AudioDevice", lastEx);
        }
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AudioDeviceFactory[] getFactoriesPriority() {
        Map<Class<? extends AudioDeviceFactory>, AudioDeviceFactory> map = this.factories;
        synchronized (map) {
            return (AudioDeviceFactory[])this.factories.values().stream().sorted((o1, o2) -> o2.priority() - o1.priority()).toArray(AudioDeviceFactory[]::new);
        }
    }

    protected void registerDefaultFactories() {
        ServiceLoader<AudioDeviceFactory> loader = ServiceLoader.load(AudioDeviceFactory.class);
        for (AudioDeviceFactory factory : loader) {
            logger.fine("initial factory: " + factory);
            this.addFactory(factory);
        }
    }
}

