/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.command;

import celia.adwadg.ncm.NeteaseCloudMusicAPI;
import celia.adwadg.ncm.command.DebugCommand;
import celia.adwadg.ncm.config.ModConfig;
import celia.adwadg.ncm.service.AudioService;
import celia.adwadg.ncm.service.BossBarService;
import celia.adwadg.ncm.service.EqualizerService;
import celia.adwadg.ncm.service.LyricsService;
import celia.adwadg.ncm.service.MusicService;
import celia.adwadg.ncm.service.PlaylistPlayerService;
import celia.adwadg.ncm.util.AudioCacheManager;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class MusicPlayerCommand
implements Command<CommandSourceStack> {
    private static final Map<String, Long> searchResults = new HashMap<String, Long>();
    private static String currentSearchKeyword = "";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        DebugCommand.register(dispatcher);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ncmusic").then(Commands.m_82127_((String)"search").then(Commands.m_82129_((String)"keywords", (ArgumentType)StringArgumentType.greedyString()).executes(MusicPlayerCommand::searchMusic)))).then(Commands.m_82127_((String)"play").then(Commands.m_82129_((String)"target", (ArgumentType)StringArgumentType.greedyString()).executes(MusicPlayerCommand::playMusic)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"control").then(Commands.m_82127_((String)"pause").executes(MusicPlayerCommand::pauseMusic))).then(Commands.m_82127_((String)"resume").executes(MusicPlayerCommand::resumeMusic))).then(Commands.m_82127_((String)"stop").executes(MusicPlayerCommand::stopMusic)))).then(Commands.m_82127_((String)"volume").then(Commands.m_82129_((String)"level", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(MusicPlayerCommand::setVolume)))).then(Commands.m_82127_((String)"status").executes(MusicPlayerCommand::getStatus))).then(Commands.m_82127_((String)"help").executes(MusicPlayerCommand::showHelp))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cache").then(Commands.m_82127_((String)"on").executes(MusicPlayerCommand::enableCache))).then(Commands.m_82127_((String)"off").executes(MusicPlayerCommand::disableCache))).then(Commands.m_82127_((String)"status").executes(MusicPlayerCommand::cacheStatus))).then(Commands.m_82127_((String)"clear").executes(MusicPlayerCommand::clearCache)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"bossbar").then(Commands.m_82127_((String)"show").executes(MusicPlayerCommand::showBossBar))).then(Commands.m_82127_((String)"hide").executes(MusicPlayerCommand::hideBossBar)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lyrics").then(Commands.m_82127_((String)"inventory").executes(MusicPlayerCommand::setLyricsInventoryMode))).then(Commands.m_82127_((String)"chat").executes(MusicPlayerCommand::setLyricsChatMode))).then(Commands.m_82127_((String)"off").executes(MusicPlayerCommand::setLyricsOffMode))).then(Commands.m_82127_((String)"load").then(Commands.m_82129_((String)"songId", (ArgumentType)IntegerArgumentType.integer()).executes(MusicPlayerCommand::loadLyrics))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"equalizer").then(Commands.m_82127_((String)"preset").then(Commands.m_82129_((String)"preset_name", (ArgumentType)StringArgumentType.greedyString()).executes(MusicPlayerCommand::setEQPreset)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"band").then(Commands.m_82127_((String)"bass").then(Commands.m_82129_((String)"gain", (ArgumentType)FloatArgumentType.floatArg((float)-12.0f, (float)12.0f)).executes(MusicPlayerCommand::setBassGain)))).then(Commands.m_82127_((String)"low_mid").then(Commands.m_82129_((String)"gain", (ArgumentType)FloatArgumentType.floatArg((float)-12.0f, (float)12.0f)).executes(MusicPlayerCommand::setLowMidGain)))).then(Commands.m_82127_((String)"mid").then(Commands.m_82129_((String)"gain", (ArgumentType)FloatArgumentType.floatArg((float)-12.0f, (float)12.0f)).executes(MusicPlayerCommand::setMidGain)))).then(Commands.m_82127_((String)"high_mid").then(Commands.m_82129_((String)"gain", (ArgumentType)FloatArgumentType.floatArg((float)-12.0f, (float)12.0f)).executes(MusicPlayerCommand::setHighMidGain)))).then(Commands.m_82127_((String)"treble").then(Commands.m_82129_((String)"gain", (ArgumentType)FloatArgumentType.floatArg((float)-12.0f, (float)12.0f)).executes(MusicPlayerCommand::setTrebleGain))))).then(Commands.m_82127_((String)"reset").executes(MusicPlayerCommand::resetEQ))).then(Commands.m_82127_((String)"status").executes(MusicPlayerCommand::getEQStatus))).then(Commands.m_82127_((String)"presets").executes(MusicPlayerCommand::listEQPresets)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"playlist").then(Commands.m_82127_((String)"load").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.greedyString()).executes(MusicPlayerCommand::loadPlaylist)))).then(Commands.m_82127_((String)"next").executes(MusicPlayerCommand::playlistNext))).then(Commands.m_82127_((String)"prev").executes(MusicPlayerCommand::playlistPrev))).then(Commands.m_82127_((String)"status").executes(MusicPlayerCommand::playlistStatus))).then(Commands.m_82127_((String)"info").executes(MusicPlayerCommand::playlistInfo))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sort").then(Commands.m_82127_((String)"sequential").executes(MusicPlayerCommand::setPlayOrderSequential))).then(Commands.m_82127_((String)"shuffle").executes(MusicPlayerCommand::setPlayOrderShuffle))).then(Commands.m_82127_((String)"repeat_one").executes(MusicPlayerCommand::setPlayOrderRepeatOne))).then(Commands.m_82127_((String)"repeat_all").executes(MusicPlayerCommand::setPlayOrderRepeatAll)))).then(Commands.m_82127_((String)"shuffle").executes(MusicPlayerCommand::shufflePlaylist))).then(Commands.m_82127_((String)"play").then(Commands.m_82129_((String)"songId", (ArgumentType)IntegerArgumentType.integer()).executes(MusicPlayerCommand::playlistPlay)))).then(Commands.m_82127_((String)"clear").executes(MusicPlayerCommand::clearPlaylist))));
    }

    private static int searchMusic(CommandContext<CommandSourceStack> context) {
        String keywords = StringArgumentType.getString(context, (String)"keywords");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            MusicService musicService = NeteaseCloudMusicAPI.getMusicService();
            JsonObject result = musicService.search(keywords, 10, 0, 1);
            System.out.println("API\u54cd\u5e94: " + result.toString());
            if (!result.has("code")) {
                source.m_81352_((Component)new TextComponent("\u00a7cAPI\u54cd\u5e94\u7f3a\u5c11code\u5b57\u6bb5"));
                return 0;
            }
            int code = result.get("code").getAsInt();
            if (code != 200) {
                String errorMsg = result.has("message") ? result.get("message").getAsString() : "\u672a\u77e5\u9519\u8bef";
                source.m_81352_((Component)new TextComponent("\u00a7c\u641c\u7d22\u5931\u8d25 (" + code + "): " + errorMsg));
                return 0;
            }
            if (!result.has("result")) {
                source.m_81352_((Component)new TextComponent("\u00a7cAPI\u54cd\u5e94\u7f3a\u5c11result\u5b57\u6bb5"));
                return 0;
            }
            JsonObject resultObj = result.getAsJsonObject("result");
            if (!resultObj.has("songs")) {
                source.m_81352_((Component)new TextComponent("\u00a7cAPI\u54cd\u5e94\u7f3a\u5c11songs\u5b57\u6bb5"));
                return 0;
            }
            JsonElement songsElement = resultObj.get("songs");
            if (!songsElement.isJsonArray()) {
                source.m_81352_((Component)new TextComponent("\u00a7cAPI\u54cd\u5e94\u683c\u5f0f\u9519\u8bef: songs\u4e0d\u662f\u6570\u7ec4"));
                return 0;
            }
            JsonArray songs = songsElement.getAsJsonArray();
            searchResults.clear();
            currentSearchKeyword = keywords;
            source.m_81354_((Component)new TextComponent("\u00a7a\u641c\u7d22 '" + keywords + "' \u7ed3\u679c:"), false);
            int i = 0;
            while (i < songs.size()) {
                JsonObject song = songs.get(i).getAsJsonObject();
                long id = song.get("id").getAsLong();
                String name = song.get("name").getAsString();
                StringBuilder artists = new StringBuilder();
                if (song.has("ar")) {
                    JsonArray artistsArray = song.getAsJsonArray("ar");
                    for (JsonElement artist : artistsArray) {
                        if (artists.length() > 0) {
                            artists.append(", ");
                        }
                        artists.append(artist.getAsJsonObject().get("name").getAsString());
                    }
                }
                String album = song.has("al") ? song.getAsJsonObject("al").get("name").getAsString() : "";
                searchResults.put(String.valueOf(i + 1), id);
                int finalI = i++;
                String clickableText = String.format("\u00a7e%d. \u00a7b%s \u00a77- \u00a76%s \u00a78(\u4e13\u8f91: %s)", finalI + 1, name, artists, album);
                MutableComponent clickableComponent = new TextComponent(clickableText).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ncmusic play " + (finalI + 1))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("\u00a7a\u70b9\u51fb\u64ad\u653e\u6b64\u6b4c\u66f2\n\u00a77ID: " + id))));
                source.m_81354_((Component)clickableComponent, false);
            }
            source.m_81354_((Component)new TextComponent("\u00a7a\u4f7f\u7528 /ncmusic play <\u5e8f\u53f7> \u64ad\u653e\u6b4c\u66f2"), false);
            return songs.size();
        }
        catch (IOException e) {
            source.m_81352_((Component)new TextComponent("\u00a7c\u641c\u7d22\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()));
            return 0;
        }
        catch (Exception e) {
            source.m_81352_((Component)new TextComponent("\u00a7c\u5904\u7406\u54cd\u5e94\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()));
            e.printStackTrace();
            return 0;
        }
    }

    private static int playMusic(CommandContext<CommandSourceStack> context) {
        String target = StringArgumentType.getString(context, (String)"target");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            long songId;
            if (target.matches("^\\d+$")) {
                int number = Integer.parseInt(target);
                if (!searchResults.isEmpty() && number >= 1 && number <= searchResults.size()) {
                    songId = searchResults.get(String.valueOf(number));
                    source.m_81354_((Component)new TextComponent("\u00a7a\u64ad\u653e\u641c\u7d22\u7ed3\u679c\u7684\u7b2c" + number + "\u9996\u6b4c\u66f2"), false);
                } else {
                    songId = number;
                    source.m_81354_((Component)new TextComponent("\u00a7a\u64ad\u653e\u6b4c\u66f2 ID: " + songId), false);
                }
            } else {
                source.m_81352_((Component)new TextComponent("\u00a7c\u65e0\u6548\u7684\u53c2\u6570\uff0c\u8bf7\u8f93\u5165\u6570\u5b57\u5e8f\u53f7\u6216\u6b4c\u66f2ID"));
                return 0;
            }
            return MusicPlayerCommand.playSong(source, songId);
        }
        catch (NumberFormatException e) {
            source.m_81352_((Component)new TextComponent("\u00a7c\u65e0\u6548\u7684\u6570\u5b57\u683c\u5f0f"));
            return 0;
        }
    }

    private static int playSong(CommandSourceStack source, long songId) {
        try {
            AudioService audioService = NeteaseCloudMusicAPI.getAudioService();
            JsonObject result = audioService.playSong(songId, 128000);
            if (result.has("code") && result.get("code").getAsInt() == 200) {
                source.m_81354_((Component)new TextComponent("\u00a7a\u5f00\u59cb\u64ad\u653e\u6b4c\u66f2 ID: " + songId), false);
                return 1;
            }
            String errorMsg = result.has("error") ? result.get("error").getAsString() : "\u672a\u77e5\u9519\u8bef";
            source.m_81352_((Component)new TextComponent("\u00a7c\u64ad\u653e\u5931\u8d25: " + errorMsg));
            return 0;
        }
        catch (IOException e) {
            source.m_81352_((Component)new TextComponent("\u00a7c\u64ad\u653e\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()));
            return 0;
        }
        catch (Exception e) {
            source.m_81352_((Component)new TextComponent("\u00a7c\u64ad\u653e\u5904\u7406\u9519\u8bef: " + e.getMessage()));
            return 0;
        }
    }

    private static int pauseMusic(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        AudioService audioService = NeteaseCloudMusicAPI.getAudioService();
        JsonObject result = audioService.pause();
        if (result.get("code").getAsInt() == 200) {
            source.m_81354_((Component)new TextComponent("\u00a7a\u97f3\u4e50\u5df2\u6682\u505c"), false);
            return 1;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u6682\u505c\u5931\u8d25: " + result.get("error").getAsString()));
        return 0;
    }

    private static int resumeMusic(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        AudioService audioService = NeteaseCloudMusicAPI.getAudioService();
        JsonObject result = audioService.resume();
        if (result.get("code").getAsInt() == 200) {
            source.m_81354_((Component)new TextComponent("\u00a7a\u97f3\u4e50\u5df2\u6062\u590d\u64ad\u653e"), false);
            return 1;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u6062\u590d\u5931\u8d25: " + result.get("error").getAsString()));
        return 0;
    }

    private static int stopMusic(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        AudioService audioService = NeteaseCloudMusicAPI.getAudioService();
        JsonObject result = audioService.stop();
        if (result.get("code").getAsInt() == 200) {
            source.m_81354_((Component)new TextComponent("\u00a7a\u97f3\u4e50\u5df2\u505c\u6b62"), false);
            return 1;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u505c\u6b62\u5931\u8d25: " + result.get("error").getAsString()));
        return 0;
    }

    private static int setVolume(CommandContext<CommandSourceStack> context) {
        float volume = FloatArgumentType.getFloat(context, (String)"level");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        AudioService audioService = NeteaseCloudMusicAPI.getAudioService();
        JsonObject result = audioService.setVolume(volume);
        if (result.get("code").getAsInt() == 200) {
            source.m_81354_((Component)new TextComponent("\u00a7a\u97f3\u91cf\u5df2\u8bbe\u7f6e\u4e3a: " + volume), false);
            return 1;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u97f3\u91cf\u8bbe\u7f6e\u5931\u8d25: " + result.get("error").getAsString()));
        return 0;
    }

    private static int getStatus(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        AudioService audioService = NeteaseCloudMusicAPI.getAudioService();
        JsonObject result = audioService.getPlaybackStatus();
        if (result.get("code").getAsInt() == 200) {
            String songIdStr;
            JsonElement songIdElement;
            JsonObject data = result.getAsJsonObject("data");
            boolean isPlaying = data.get("isPlaying").getAsBoolean();
            String currentSongId = "\u65e0";
            if (data.has("currentSongId") && !data.get("currentSongId").isJsonNull() && (songIdElement = data.get("currentSongId")).isJsonPrimitive() && (songIdStr = songIdElement.getAsString()) != null && !songIdStr.equals("null") && !songIdStr.isEmpty()) {
                currentSongId = songIdStr;
            }
            float volume = data.get("volume").getAsFloat();
            int activePlayers = data.get("activePlayers").getAsInt();
            Object statusMessage = String.format("\u00a7a\u64ad\u653e\u72b6\u6001: \u00a7e%s\n\u00a7a\u5f53\u524d\u6b4c\u66f2: \u00a7e%s\n\u00a7a\u97f3\u91cf: \u00a7e%.1f\n\u00a7a\u6d3b\u8dc3\u64ad\u653e\u5668: \u00a7e%d", isPlaying ? "\u6b63\u5728\u64ad\u653e" : "\u5df2\u6682\u505c/\u505c\u6b62", currentSongId, Float.valueOf(volume), activePlayers);
            if (!currentSearchKeyword.isEmpty()) {
                statusMessage = (String)statusMessage + "\n\u00a7a\u6700\u8fd1\u641c\u7d22: \u00a7e" + currentSearchKeyword;
            }
            String finalStatusMessage = statusMessage;
            source.m_81354_((Component)new TextComponent(finalStatusMessage), false);
            return 1;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u83b7\u53d6\u72b6\u6001\u5931\u8d25"));
        return 0;
    }

    private static int showBossBar(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            NeteaseCloudMusicAPI.getBossBarService();
            BossBarService.showBossBar(player);
            source.m_81354_((Component)new TextComponent("\u00a7a\u5df2\u663e\u793aBossBar\u6b4c\u66f2\u4fe1\u606f"), false);
            return 1;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4"));
        return 0;
    }

    private static int hideBossBar(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            NeteaseCloudMusicAPI.getBossBarService();
            BossBarService.hideBossBar(player);
            source.m_81354_((Component)new TextComponent("\u00a7a\u5df2\u9690\u85cfBossBar\u6b4c\u66f2\u4fe1\u606f"), false);
            return 1;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4"));
        return 0;
    }

    private static int showHelp(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String helpMessage = "\u00a76=== NeteaseCloudMusic \u64ad\u653e\u5668\u5e2e\u52a9 ===\n\u00a7a/ncmusic search <\u5173\u952e\u8bcd> \u00a77- \u641c\u7d22\u97f3\u4e50\n\u00a7a/ncmusic play <\u5e8f\u53f7\u6216ID> \u00a77- \u64ad\u653e\u6b4c\u66f2 (\u81ea\u52a8\u8bc6\u522b\u641c\u7d22\u5e8f\u53f7\u6216\u6b4c\u66f2ID)\n\u00a7a/ncmusic control pause \u00a77- \u6682\u505c\u64ad\u653e\n\u00a7a/ncmusic control resume \u00a77- \u6062\u590d\u64ad\u653e\n\u00a7a/ncmusic control stop \u00a77- \u505c\u6b62\u64ad\u653e\n\u00a7a/ncmusic volume <0.0-1.0> \u00a77- \u8bbe\u7f6e\u97f3\u91cf\n\u00a7a/ncmusic status \u00a77- \u67e5\u770b\u64ad\u653e\u72b6\u6001\n\u00a7a/ncmusic bossbar show \u00a77- \u663e\u793aBossBar\u6b4c\u66f2\u4fe1\u606f\n\u00a7a/ncmusic bossbar hide \u00a77- \u9690\u85cfBossBar\u6b4c\u66f2\u4fe1\u606f\n\u00a7a/ncmusic lyrics inventory \u00a77- \u7269\u54c1\u680f\u4e0a\u65b9\u663e\u793a\u6b4c\u8bcd\n\u00a7a/ncmusic lyrics chat \u00a77- \u804a\u5929\u6846\u663e\u793a\u6b4c\u8bcd\n\u00a7a/ncmusic lyrics off \u00a77- \u5173\u95ed\u6b4c\u8bcd\u663e\u793a\n\u00a7a/ncmusic lyrics load <\u6b4c\u66f2ID> \u00a77- \u624b\u52a8\u52a0\u8f7d\u6b4c\u8bcd\n\u00a7a/ncmusic equalizer preset <\u9884\u8bbe\u540d> \u00a77- \u8bbe\u7f6e\u5747\u8861\u5668\u9884\u8bbe\n\u00a7a/ncmusic equalizer band <\u9891\u6bb5> <\u589e\u76ca> \u00a77- \u8bbe\u7f6e\u9891\u6bb5\u589e\u76ca\n\u00a7a/ncmusic equalizer reset \u00a77- \u91cd\u7f6e\u5747\u8861\u5668\n\u00a7a/ncmusic equalizer status \u00a77- \u67e5\u770b\u5747\u8861\u5668\u72b6\u6001\n\u00a7a/ncmusic equalizer presets \u00a77- \u5217\u51fa\u53ef\u7528\u9884\u8bbe\n\u00a7a/ncmusic help \u00a77- \u663e\u793a\u5e2e\u52a9\u4fe1\u606f\n\u00a7a/ncmusic cache on \u00a77- \u542f\u7528\u97f3\u9891\u7f13\u5b58\n\u00a7a/ncmusic cache off \u00a77- \u7981\u7528\u97f3\u9891\u7f13\u5b58\n\u00a7a/ncmusic cache status \u00a77- \u67e5\u770b\u7f13\u5b58\u72b6\u6001\n\u00a7a/ncmusic cache clear \u00a77- \u6e05\u7406\u7f13\u5b58\u6587\u4ef6\n";
        source.m_81354_((Component)new TextComponent(helpMessage), false);
        return 1;
    }

    private static int setLyricsInventoryMode(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        LyricsService.setDisplayMode(LyricsService.DisplayMode.INVENTORY);
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            LyricsService.setLyricsEnabled(player, true);
            source.m_81354_((Component)new TextComponent("\u00a7a\u6b4c\u8bcd\u663e\u793a\u6a21\u5f0f\u5df2\u8bbe\u7f6e\u4e3a: \u7269\u54c1\u680f\u4e0a\u65b9 (\u5df2\u542f\u7528)"), false);
        } else {
            source.m_81354_((Component)new TextComponent("\u00a7a\u6b4c\u8bcd\u663e\u793a\u6a21\u5f0f\u5df2\u8bbe\u7f6e\u4e3a: \u7269\u54c1\u680f\u4e0a\u65b9"), false);
        }
        return 1;
    }

    private static int setLyricsChatMode(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        LyricsService.setDisplayMode(LyricsService.DisplayMode.CHAT);
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            LyricsService.setLyricsEnabled(player, true);
            source.m_81354_((Component)new TextComponent("\u00a7a\u6b4c\u8bcd\u663e\u793a\u6a21\u5f0f\u5df2\u8bbe\u7f6e\u4e3a: \u804a\u5929\u6846 (\u5df2\u542f\u7528)"), false);
        } else {
            source.m_81354_((Component)new TextComponent("\u00a7a\u6b4c\u8bcd\u663e\u793a\u6a21\u5f0f\u5df2\u8bbe\u7f6e\u4e3a: \u804a\u5929\u6846"), false);
        }
        return 1;
    }

    private static int setLyricsOffMode(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            LyricsService.setLyricsEnabled(player, false);
            LyricsService.clearLyricsForPlayer(player);
            source.m_81354_((Component)new TextComponent("\u00a7a\u5df2\u5173\u95ed\u6b4c\u8bcd\u663e\u793a\u5e76\u6e05\u9664\u6b4c\u8bcd\u6570\u636e"), false);
            return 1;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4"));
        return 0;
    }

    private static int loadLyrics(CommandContext<CommandSourceStack> context) {
        int songId = IntegerArgumentType.getInteger(context, (String)"songId");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            try {
                LyricsService.loadAndDisplayLyrics(player, songId);
                source.m_81354_((Component)new TextComponent("\u00a7a\u6b63\u5728\u52a0\u8f7d\u6b4c\u66f2 " + songId + " \u7684\u6b4c\u8bcd..."), false);
                return 1;
            }
            catch (Exception e) {
                source.m_81352_((Component)new TextComponent("\u00a7c\u52a0\u8f7d\u6b4c\u8bcd\u5931\u8d25: " + e.getMessage()));
                return 0;
            }
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4"));
        return 0;
    }

    private static int loadPlaylist(CommandContext<CommandSourceStack> context) {
        String idString = StringArgumentType.getString(context, (String)"id");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            try {
                long playlistId = Long.parseLong(idString);
                PlaylistPlayerService playlistService = NeteaseCloudMusicAPI.getPlaylistPlayerService();
                JsonObject result = PlaylistPlayerService.loadPlaylist(player, playlistId);
                if (result.get("code").getAsInt() == 200) {
                    String playlistName = result.has("playlistName") ? result.get("playlistName").getAsString() : "\u672a\u77e5\u6b4c\u5355";
                    int totalSongs = result.get("totalSongs").getAsInt();
                    source.m_81354_((Component)new TextComponent("\u00a7a\u5df2\u52a0\u8f7d\u6b4c\u5355: \u00a7e" + playlistName + " \u00a7a(\u5171 " + totalSongs + " \u9996\u6b4c\u66f2)"), false);
                    return 1;
                }
                source.m_81352_((Component)new TextComponent("\u00a7c\u52a0\u8f7d\u6b4c\u5355\u5931\u8d25: " + result.get("error").getAsString()));
                return 0;
            }
            catch (NumberFormatException e) {
                source.m_81352_((Component)new TextComponent("\u00a7c\u65e0\u6548\u7684\u6b4c\u5355ID\u683c\u5f0f\uff0c\u8bf7\u8f93\u5165\u6570\u5b57ID"));
                return 0;
            }
            catch (IOException e) {
                source.m_81352_((Component)new TextComponent("\u00a7c\u52a0\u8f7d\u6b4c\u5355\u5931\u8d25: " + e.getMessage()));
                return 0;
            }
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4"));
        return 0;
    }

    private static int playlistNext(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlaylistPlayerService playlistService = NeteaseCloudMusicAPI.getPlaylistPlayerService();
            JsonObject result = PlaylistPlayerService.playNext(player);
            if (result.get("code").getAsInt() == 200) {
                long songId = result.get("songId").getAsLong();
                int position = result.get("position").getAsInt();
                int total = result.get("total").getAsInt();
                source.m_81354_((Component)new TextComponent("\u00a7a\u6b63\u5728\u64ad\u653e\u4e0b\u4e00\u9996: \u00a7e" + songId + " \u00a7a(\u7b2c " + position + "/" + total + " \u9996)"), false);
                return 1;
            }
            source.m_81352_((Component)new TextComponent("\u00a7c\u64ad\u653e\u4e0b\u4e00\u9996\u5931\u8d25: " + result.get("error").getAsString()));
            return 0;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4"));
        return 0;
    }

    private static int playlistPrev(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlaylistPlayerService playlistService = NeteaseCloudMusicAPI.getPlaylistPlayerService();
            JsonObject result = PlaylistPlayerService.playPrevious(player);
            if (result.get("code").getAsInt() == 200) {
                long songId = result.get("songId").getAsLong();
                int position = result.get("position").getAsInt();
                int total = result.get("total").getAsInt();
                source.m_81354_((Component)new TextComponent("\u00a7a\u6b63\u5728\u64ad\u653e\u4e0a\u4e00\u9996: \u00a7e" + songId + " \u00a7a(\u7b2c " + position + "/" + total + " \u9996)"), false);
                return 1;
            }
            source.m_81352_((Component)new TextComponent("\u00a7c\u64ad\u653e\u4e0a\u4e00\u9996\u5931\u8d25: " + result.get("error").getAsString()));
            return 0;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4"));
        return 0;
    }

    private static int playlistStatus(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlaylistPlayerService playlistService = NeteaseCloudMusicAPI.getPlaylistPlayerService();
            JsonObject result = PlaylistPlayerService.getPlaylistStatus(player);
            if (result.get("code").getAsInt() == 200) {
                long playlistId = result.get("playlistId").getAsLong();
                long currentSongId = result.get("currentSongId").getAsLong();
                int position = result.get("currentPosition").getAsInt();
                int total = result.get("totalSongs").getAsInt();
                String playOrder = result.get("playOrder").getAsString();
                boolean isPlaying = result.get("isPlaying").getAsBoolean();
                String status = String.format("\u00a7a\u6b4c\u5355\u72b6\u6001:\n\u00a7a\u6b4c\u5355ID: \u00a7e%d\n\u00a7a\u5f53\u524d\u6b4c\u66f2: \u00a7e%d\n\u00a7a\u4f4d\u7f6e: \u00a7e%d/%d\n\u00a7a\u64ad\u653e\u987a\u5e8f: \u00a7e%s\n\u00a7a\u64ad\u653e\u72b6\u6001: \u00a7e%s", playlistId, currentSongId, position, total, playOrder, isPlaying ? "\u6b63\u5728\u64ad\u653e" : "\u5df2\u6682\u505c");
                source.m_81354_((Component)new TextComponent(status), false);
                return 1;
            }
            source.m_81352_((Component)new TextComponent("\u00a7c\u83b7\u53d6\u6b4c\u5355\u72b6\u6001\u5931\u8d25: " + result.get("error").getAsString()));
            return 0;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4"));
        return 0;
    }

    private static int playlistInfo(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlaylistPlayerService playlistService = NeteaseCloudMusicAPI.getPlaylistPlayerService();
            PlaylistPlayerService.PlaylistState state = PlaylistPlayerService.getPlayerPlaylist(player);
            if (state == null) {
                source.m_81352_((Component)new TextComponent("\u00a7c\u8bf7\u5148\u52a0\u8f7d\u6b4c\u5355"));
                return 0;
            }
            try {
                MusicService musicService = NeteaseCloudMusicAPI.getMusicService();
                JsonObject playlistDetail = musicService.getPlaylistDetail(state.playlistId);
                if (playlistDetail.has("code") && playlistDetail.get("code").getAsInt() == 200 && playlistDetail.has("playlist")) {
                    JsonObject playlist = playlistDetail.getAsJsonObject("playlist");
                    String playlistName = playlist.has("name") ? playlist.get("name").getAsString() : "\u672a\u77e5\u6b4c\u5355";
                    String creator = playlist.has("creator") ? playlist.getAsJsonObject("creator").get("nickname").getAsString() : "\u672a\u77e5\u521b\u5efa\u8005";
                    int playCount = playlist.has("playCount") ? playlist.get("playCount").getAsInt() : 0;
                    source.m_81354_((Component)new TextComponent("\u00a76=== \u6b4c\u5355\u4fe1\u606f ==="), false);
                    source.m_81354_((Component)new TextComponent("\u00a7a\u6b4c\u5355\u540d\u79f0: \u00a7e" + playlistName), false);
                    source.m_81354_((Component)new TextComponent("\u00a7a\u521b\u5efa\u8005: \u00a7e" + creator), false);
                    source.m_81354_((Component)new TextComponent("\u00a7a\u64ad\u653e\u6b21\u6570: \u00a7e" + playCount), false);
                    source.m_81354_((Component)new TextComponent("\u00a7a\u6b4c\u66f2\u6570\u91cf: \u00a7e" + state.getTotalSongs()), false);
                    source.m_81354_((Component)new TextComponent("\u00a76=== \u6b4c\u66f2\u5217\u8868 ==="), false);
                    int i = 0;
                    while (i < state.songIds.size()) {
                        JsonArray songs;
                        long songId = state.songIds.get(i);
                        JsonObject songDetail = musicService.getSongDetail(songId);
                        String songName = "\u672a\u77e5\u6b4c\u66f2";
                        String artists = "\u672a\u77e5\u827a\u4eba";
                        if (songDetail.has("songs") && (songs = songDetail.getAsJsonArray("songs")).size() > 0) {
                            JsonObject song = songs.get(0).getAsJsonObject();
                            String string = songName = song.has("name") ? song.get("name").getAsString() : "\u672a\u77e5\u6b4c\u66f2";
                            if (song.has("ar")) {
                                JsonArray artistsArray = song.getAsJsonArray("ar");
                                StringBuilder artistsBuilder = new StringBuilder();
                                for (JsonElement artist : artistsArray) {
                                    if (artistsBuilder.length() > 0) {
                                        artistsBuilder.append(", ");
                                    }
                                    artistsBuilder.append(artist.getAsJsonObject().get("name").getAsString());
                                }
                                artists = artistsBuilder.toString();
                            }
                        }
                        int finalI = i++;
                        String clickableText = String.format("\u00a7e%d. \u00a7b%s \u00a77- \u00a76%s", finalI + 1, songName, artists);
                        MutableComponent clickableComponent = new TextComponent(clickableText).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ncmusic playlist play " + songId)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("\u00a7a\u70b9\u51fb\u64ad\u653e\u6b64\u6b4c\u66f2\n\u00a77ID: " + songId + "\n\u00a77\u4f4d\u7f6e: " + (finalI + 1) + "/" + state.getTotalSongs()))));
                        source.m_81354_((Component)clickableComponent, false);
                    }
                    return 1;
                }
                source.m_81352_((Component)new TextComponent("\u00a7c\u83b7\u53d6\u6b4c\u5355\u8be6\u60c5\u5931\u8d25"));
                return 0;
            }
            catch (IOException e) {
                source.m_81352_((Component)new TextComponent("\u00a7c\u83b7\u53d6\u6b4c\u5355\u4fe1\u606f\u5931\u8d25: " + e.getMessage()));
                return 0;
            }
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4"));
        return 0;
    }

    private static int setPlayOrderSequential(CommandContext<CommandSourceStack> context) {
        return MusicPlayerCommand.setPlayOrder(context, PlaylistPlayerService.PlayOrder.SEQUENTIAL);
    }

    private static int setPlayOrderShuffle(CommandContext<CommandSourceStack> context) {
        return MusicPlayerCommand.setPlayOrder(context, PlaylistPlayerService.PlayOrder.SHUFFLE);
    }

    private static int setPlayOrderRepeatOne(CommandContext<CommandSourceStack> context) {
        return MusicPlayerCommand.setPlayOrder(context, PlaylistPlayerService.PlayOrder.REPEAT_ONE);
    }

    private static int setPlayOrderRepeatAll(CommandContext<CommandSourceStack> context) {
        return MusicPlayerCommand.setPlayOrder(context, PlaylistPlayerService.PlayOrder.REPEAT_ALL);
    }

    private static int setPlayOrder(CommandContext<CommandSourceStack> context, PlaylistPlayerService.PlayOrder order) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlaylistPlayerService playlistService = NeteaseCloudMusicAPI.getPlaylistPlayerService();
            JsonObject result = PlaylistPlayerService.setPlayOrder(player, order);
            if (result.get("code").getAsInt() == 200) {
                source.m_81354_((Component)new TextComponent("\u00a7a" + result.get("message").getAsString()), false);
                return 1;
            }
            source.m_81352_((Component)new TextComponent("\u00a7c\u8bbe\u7f6e\u64ad\u653e\u987a\u5e8f\u5931\u8d25: " + result.get("error").getAsString()));
            return 0;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4"));
        return 0;
    }

    private static int shufflePlaylist(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlaylistPlayerService playlistService = NeteaseCloudMusicAPI.getPlaylistPlayerService();
            JsonObject result = PlaylistPlayerService.shufflePlaylist(player);
            if (result.get("code").getAsInt() == 200) {
                source.m_81354_((Component)new TextComponent("\u00a7a" + result.get("message").getAsString()), false);
                return 1;
            }
            source.m_81352_((Component)new TextComponent("\u00a7c\u968f\u673a\u6392\u5e8f\u5931\u8d25: " + result.get("error").getAsString()));
            return 0;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4"));
        return 0;
    }

    private static int playlistPlay(CommandContext<CommandSourceStack> context) {
        int songId = IntegerArgumentType.getInteger(context, (String)"songId");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlaylistPlayerService playlistService = NeteaseCloudMusicAPI.getPlaylistPlayerService();
            JsonObject result = PlaylistPlayerService.playSongFromPlaylist(player, songId);
            if (result.get("code").getAsInt() == 200) {
                source.m_81354_((Component)new TextComponent("\u00a7a" + result.get("message").getAsString()), false);
                return 1;
            }
            source.m_81352_((Component)new TextComponent("\u00a7c" + result.get("error").getAsString()));
            return 0;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4"));
        return 0;
    }

    private static int clearPlaylist(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlaylistPlayerService playlistService = NeteaseCloudMusicAPI.getPlaylistPlayerService();
            PlaylistPlayerService.clearPlaylist(player);
            source.m_81354_((Component)new TextComponent("\u00a7a\u5df2\u6e05\u9664\u5f53\u524d\u6b4c\u5355"), false);
            return 1;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4"));
        return 0;
    }

    private static int setEQPreset(CommandContext<CommandSourceStack> context) {
        String presetName = StringArgumentType.getString(context, (String)"preset_name");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            JsonObject result = EqualizerService.setEQPreset(player, presetName);
            if (result.get("code").getAsInt() == 200) {
                source.m_81354_((Component)new TextComponent("\u00a7a" + result.get("message").getAsString()), false);
                return 1;
            }
            source.m_81352_((Component)new TextComponent("\u00a7c" + result.get("error").getAsString()));
            return 0;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4"));
        return 0;
    }

    private static int setBassGain(CommandContext<CommandSourceStack> context) {
        return MusicPlayerCommand.setBandGain(context, EqualizerService.FrequencyBand.BASS);
    }

    private static int setLowMidGain(CommandContext<CommandSourceStack> context) {
        return MusicPlayerCommand.setBandGain(context, EqualizerService.FrequencyBand.LOW_MID);
    }

    private static int setMidGain(CommandContext<CommandSourceStack> context) {
        return MusicPlayerCommand.setBandGain(context, EqualizerService.FrequencyBand.MID);
    }

    private static int setHighMidGain(CommandContext<CommandSourceStack> context) {
        return MusicPlayerCommand.setBandGain(context, EqualizerService.FrequencyBand.HIGH_MID);
    }

    private static int setTrebleGain(CommandContext<CommandSourceStack> context) {
        return MusicPlayerCommand.setBandGain(context, EqualizerService.FrequencyBand.TREBLE);
    }

    private static int setBandGain(CommandContext<CommandSourceStack> context, EqualizerService.FrequencyBand band) {
        float gain = FloatArgumentType.getFloat(context, (String)"gain");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            JsonObject result = EqualizerService.setBandGain(player, band, gain);
            if (result.get("code").getAsInt() == 200) {
                source.m_81354_((Component)new TextComponent("\u00a7a" + result.get("message").getAsString()), false);
                return 1;
            }
            source.m_81352_((Component)new TextComponent("\u00a7c\u8bbe\u7f6e\u5747\u8861\u5668\u5931\u8d25"));
            return 0;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4"));
        return 0;
    }

    private static int resetEQ(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            JsonObject result = EqualizerService.resetEQ(player);
            if (result.get("code").getAsInt() == 200) {
                source.m_81354_((Component)new TextComponent("\u00a7a" + result.get("message").getAsString()), false);
                return 1;
            }
            source.m_81352_((Component)new TextComponent("\u00a7c\u91cd\u7f6e\u5747\u8861\u5668\u5931\u8d25"));
            return 0;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4"));
        return 0;
    }

    private static int getEQStatus(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            JsonObject result = EqualizerService.getEQStatus(player);
            if (result.get("code").getAsInt() == 200) {
                JsonObject bands = result.getAsJsonObject("bands");
                String status = String.format("\u00a7a\u5747\u8861\u5668\u72b6\u6001:\n\u00a7a\u4f4e\u97f3(60Hz): \u00a7e%.1fdB\n\u00a7a\u4e2d\u4f4e\u97f3(250Hz): \u00a7e%.1fdB\n\u00a7a\u4e2d\u97f3(1kHz): \u00a7e%.1fdB\n\u00a7a\u4e2d\u9ad8\u97f3(4kHz): \u00a7e%.1fdB\n\u00a7a\u9ad8\u97f3(16kHz): \u00a7e%.1fdB", Float.valueOf(bands.get("BASS").getAsFloat()), Float.valueOf(bands.get("LOW_MID").getAsFloat()), Float.valueOf(bands.get("MID").getAsFloat()), Float.valueOf(bands.get("HIGH_MID").getAsFloat()), Float.valueOf(bands.get("TREBLE").getAsFloat()));
                source.m_81354_((Component)new TextComponent(status), false);
                return 1;
            }
            source.m_81352_((Component)new TextComponent("\u00a7c\u83b7\u53d6\u5747\u8861\u5668\u72b6\u6001\u5931\u8d25"));
            return 0;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4"));
        return 0;
    }

    private static int listEQPresets(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        JsonObject result = EqualizerService.getPresetList();
        if (result.get("code").getAsInt() == 200) {
            JsonObject presets = result.getAsJsonObject("presets");
            source.m_81354_((Component)new TextComponent("\u00a7a\u53ef\u7528\u5747\u8861\u5668\u9884\u8bbe:"), false);
            for (String presetKey : presets.keySet()) {
                String presetName = presets.get(presetKey).getAsString();
                source.m_81354_((Component)new TextComponent("\u00a7e" + presetKey + " \u00a77- \u00a7a" + presetName), false);
            }
            source.m_81354_((Component)new TextComponent("\u00a7a\u4f7f\u7528 /ncmusic equalizer preset <\u9884\u8bbe\u540d> \u5e94\u7528\u9884\u8bbe"), false);
            return 1;
        }
        source.m_81352_((Component)new TextComponent("\u00a7c\u83b7\u53d6\u9884\u8bbe\u5217\u8868\u5931\u8d25"));
        return 0;
    }

    private static int enableCache(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ModConfig.ENABLE_AUDIO_CACHE.set((Object)true);
        source.m_81354_((Component)new TextComponent("\u00a7a\u97f3\u9891\u7f13\u5b58\u5df2\u542f\u7528"), false);
        return 1;
    }

    private static int disableCache(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ModConfig.ENABLE_AUDIO_CACHE.set((Object)false);
        source.m_81354_((Component)new TextComponent("\u00a7a\u97f3\u9891\u7f13\u5b58\u5df2\u7981\u7528"), false);
        return 1;
    }

    private static int cacheStatus(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            boolean enabled = (Boolean)ModConfig.ENABLE_AUDIO_CACHE.get();
            int maxSize = (Integer)ModConfig.CACHE_MAX_SIZE_MB.get();
            int expireHours = (Integer)ModConfig.CACHE_EXPIRE_HOURS.get();
            AudioService audioService = NeteaseCloudMusicAPI.getAudioService();
            String cacheDetails = "";
            try {
                Field cacheField = audioService.getClass().getDeclaredField("audioCacheManager");
                cacheField.setAccessible(true);
                AudioCacheManager cacheManager = (AudioCacheManager)cacheField.get(audioService);
                if (cacheManager != null) {
                    JsonObject cacheStatus = cacheManager.getCacheStatus();
                    int totalFiles = cacheStatus.get("totalFiles").getAsInt();
                    int totalSizeMB = cacheStatus.get("totalSizeMB").getAsInt();
                    int usedMemoryMB = cacheStatus.get("usedMemoryMB").getAsInt();
                    int maxMemoryMB = cacheStatus.get("maxMemoryMB").getAsInt();
                    int memoryUsagePercent = cacheStatus.get("memoryUsagePercent").getAsInt();
                    cacheDetails = String.format("\n\u00a7a\u7f13\u5b58\u6587\u4ef6\u6570: \u00a7e%d\n\u00a7a\u7f13\u5b58\u5927\u5c0f: \u00a7e%dMB\n\u00a7a\u5185\u5b58\u4f7f\u7528: \u00a7e%dMB/%dMB (%d%%)", totalFiles, totalSizeMB, usedMemoryMB, maxMemoryMB, memoryUsagePercent);
                }
            }
            catch (Exception e) {
                cacheDetails = "\n\u00a7c\u7f13\u5b58\u7ba1\u7406\u5668\u672a\u521d\u59cb\u5316";
            }
            String statusMessage = String.format("\u00a7a\u7f13\u5b58\u72b6\u6001:\n\u00a7a\u542f\u7528\u72b6\u6001: \u00a7e%s\n\u00a7a\u6700\u5927\u7f13\u5b58: \u00a7e%dMB\n\u00a7a\u8fc7\u671f\u65f6\u95f4: \u00a7e%d\u5c0f\u65f6%s", enabled ? "\u5df2\u542f\u7528" : "\u5df2\u7981\u7528", maxSize, expireHours, cacheDetails);
            source.m_81354_((Component)new TextComponent(statusMessage), false);
        }
        catch (Exception e) {
            source.m_81352_((Component)new TextComponent("\u00a7c\u83b7\u53d6\u7f13\u5b58\u72b6\u6001\u5931\u8d25: " + e.getMessage()));
        }
        return 1;
    }

    private static int clearCache(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            Path cacheDir = Paths.get(".", "ncm_cache");
            if (Files.exists(cacheDir, new LinkOption[0])) {
                Files.walk(cacheDir, new FileVisitOption[0]).filter(path -> !path.equals(cacheDir)).forEach(path -> {
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (IOException e) {
                        System.err.println("\u5220\u9664\u7f13\u5b58\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
                    }
                });
                source.m_81354_((Component)new TextComponent("\u00a7a\u7f13\u5b58\u76ee\u5f55\u5df2\u6e05\u7406"), false);
            } else {
                source.m_81354_((Component)new TextComponent("\u00a7a\u7f13\u5b58\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u6e05\u7406"), false);
            }
        }
        catch (Exception e) {
            source.m_81352_((Component)new TextComponent("\u00a7c\u6e05\u7406\u7f13\u5b58\u5931\u8d25: " + e.getMessage()));
        }
        return 1;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return MusicPlayerCommand.showHelp(context);
    }
}

