/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.service;

import audio.javazoom.jl.jl.decoder.Decoder;
import audio.javazoom.jl.jl.player.AudioDevice;
import audio.javazoom.jl.jl.player.JavaSoundAudioDevice;
import audio.javazoom.jl.jl.player.Player;
import celia.adwadg.ncm.NeteaseCloudMusicAPI;
import celia.adwadg.ncm.audio.EqualizerAudioDevice;
import celia.adwadg.ncm.audio.VolumeControlledAudioDevice;
import celia.adwadg.ncm.config.ModConfig;
import celia.adwadg.ncm.service.BossBarService;
import celia.adwadg.ncm.service.LyricsService;
import celia.adwadg.ncm.service.PlaylistPlayerService;
import celia.adwadg.ncm.util.AudioCacheManager;
import celia.adwadg.ncm.util.HttpClientUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.server.ServerLifecycleHooks;

public class AudioService {
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private final Map<String, Player> activePlayers = new ConcurrentHashMap<String, Player>();
    private Player currentPlayer;
    private AudioDevice currentAudioDevice;
    private String currentSongId;
    private boolean isPlaying = false;
    private float volume = 1.0f;
    private Thread currentPlaybackThread;
    private int pausePosition = 0;
    private AudioCacheManager audioCacheManager;

    public JsonObject playSong(long songId, int br, ServerPlayer player) throws IOException {
        String url;
        JsonObject firstSong;
        JsonArray dataArray;
        JsonElement dataElement;
        JsonObject urlResult = this.getSongUrl(songId, br);
        System.out.println("\u6b4c\u66f2URL\u54cd\u5e94: " + urlResult.toString());
        if (urlResult.has("code") && urlResult.get("code").getAsInt() == 200 && urlResult.has("data") && (dataElement = urlResult.get("data")).isJsonArray() && (dataArray = dataElement.getAsJsonArray()).size() > 0 && (firstSong = dataArray.get(0).getAsJsonObject()).has("url") && !(url = firstSong.get("url").getAsString()).isEmpty()) {
            JsonObject songDetail = this.getSongDetail(songId);
            if (player != null) {
                this.loadLyricsForPlayer(player, songId);
            }
            return this.playFromUrl(url, String.valueOf(songId), songDetail, player);
        }
        return this.createErrorResult("\u65e0\u6cd5\u83b7\u53d6\u6b4c\u66f2\u64ad\u653e\u94fe\u63a5");
    }

    public JsonObject playSong(long songId, int br) throws IOException {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                for (ServerPlayer player : server.m_6846_().m_11314_()) {
                    NeteaseCloudMusicAPI.getLyricsService();
                    if (!LyricsService.isLyricsEnabled(player)) continue;
                    this.loadLyricsForPlayer(player, songId);
                }
            }
        }
        catch (Exception e) {
            System.err.println("\u81ea\u52a8\u52a0\u8f7d\u6b4c\u8bcd\u5931\u8d25: " + e.getMessage());
        }
        return this.playSong(songId, br, null);
    }

    private void loadLyricsForPlayer(ServerPlayer player, long songId) {
        try {
            LyricsService.loadAndDisplayLyrics(player, songId);
        }
        catch (Exception e) {
            System.err.println("\u52a0\u8f7d\u6b4c\u8bcd\u5931\u8d25: " + e.getMessage());
        }
    }

    public JsonObject playFromUrl(String audioUrl, String trackId, JsonObject songDetail, ServerPlayer player) {
        return this.playFromUrl(audioUrl, trackId, songDetail, player, 0);
    }

    public JsonObject playFromUrl(String audioUrl, String trackId, JsonObject songDetail, ServerPlayer player, int startPosition) {
        JsonArray songs;
        System.out.println("Request to play: " + trackId + " from URL: " + audioUrl + " at position: " + startPosition + "ms");
        this.stopCurrentPlayback();
        String songName = "\u672a\u77e5\u6b4c\u66f2";
        String artists = "\u672a\u77e5\u827a\u4eba";
        int duration = 180000;
        if (songDetail != null && songDetail.has("songs") && (songs = songDetail.getAsJsonArray("songs")).size() > 0) {
            JsonObject song = songs.get(0).getAsJsonObject();
            if (song.has("name")) {
                songName = song.get("name").getAsString();
            }
            if (song.has("ar")) {
                JsonArray artistsArray = song.getAsJsonArray("ar");
                StringBuilder artistsBuilder = new StringBuilder();
                for (JsonElement artist : artistsArray) {
                    if (artistsBuilder.length() > 0) {
                        artistsBuilder.append(", ");
                    }
                    artistsBuilder.append(artist.getAsJsonObject().get("name").getAsString());
                }
                artists = artistsBuilder.toString();
            }
            if (song.has("dt")) {
                duration = song.get("dt").getAsInt();
            }
        }
        NeteaseCloudMusicAPI.getBossBarService();
        BossBarService.updateSongInfo(songName, artists, startPosition, duration, true);
        NeteaseCloudMusicAPI.getBossBarService();
        BossBarService.setLoadingState(true);
        this.executorService.submit(() -> {
            try {
                Object connection;
                InputStream audioStream;
                block41: {
                    boolean useCache;
                    if (this.audioCacheManager == null) {
                        try {
                            this.audioCacheManager = new AudioCacheManager(((Integer)ModConfig.CACHE_MAX_SIZE_MB.get()).intValue(), ((Integer)ModConfig.CACHE_EXPIRE_HOURS.get()).intValue());
                        }
                        catch (Exception e) {
                            System.err.println("\u97f3\u9891\u7f13\u5b58\u7ba1\u7406\u5668\u521d\u59cb\u5316\u5931\u8d25: " + e.getMessage());
                            this.audioCacheManager = null;
                        }
                    }
                    boolean bl = useCache = (Boolean)ModConfig.ENABLE_AUDIO_CACHE.get() != false && this.audioCacheManager != null;
                    if (useCache) {
                        try {
                            long songId = Long.parseLong(trackId);
                            String cacheKey = AudioCacheManager.generateCacheKey(songId, 128000);
                            InputStream cachedStream = this.audioCacheManager.getCachedAudio(cacheKey);
                            if (cachedStream != null) {
                                System.out.println("\u4ece\u7f13\u5b58\u64ad\u653e\u6b4c\u66f2: " + trackId);
                                audioStream = cachedStream;
                                break block41;
                            }
                            System.out.println("\u4e0b\u8f7d\u5e76\u7f13\u5b58\u6b4c\u66f2: " + trackId);
                            URL url = new URL(audioUrl);
                            HttpURLConnection connection2 = (HttpURLConnection)url.openConnection();
                            connection2.setRequestProperty("User-Agent", "Mozilla/5.0");
                            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                            try (BufferedInputStream networkStream = new BufferedInputStream(connection2.getInputStream());){
                                int bytesRead;
                                byte[] data = new byte[8192];
                                while ((bytesRead = ((InputStream)networkStream).read(data)) != -1) {
                                    buffer.write(data, 0, bytesRead);
                                }
                            }
                            byte[] audioData = buffer.toByteArray();
                            try (ByteArrayInputStream dataStream = new ByteArrayInputStream(audioData);){
                                this.audioCacheManager.cacheAudio(cacheKey, dataStream, audioData.length);
                            }
                            audioStream = new ByteArrayInputStream(audioData);
                        }
                        catch (Exception e) {
                            System.err.println("\u7f13\u5b58\u5904\u7406\u5931\u8d25\uff0c\u4f7f\u7528\u539f\u59cbURL: " + e.getMessage());
                            URL url = new URL(audioUrl);
                            connection = (HttpURLConnection)url.openConnection();
                            ((URLConnection)connection).setRequestProperty("User-Agent", "Mozilla/5.0");
                            audioStream = new BufferedInputStream(((URLConnection)connection).getInputStream());
                        }
                    } else {
                        URL url = new URL(audioUrl);
                        HttpURLConnection connection3 = (HttpURLConnection)url.openConnection();
                        connection3.setRequestProperty("User-Agent", "Mozilla/5.0");
                        audioStream = new BufferedInputStream(connection3.getInputStream());
                    }
                }
                try {
                    JavaSoundAudioDevice device;
                    if (player != null) {
                        EqualizerAudioDevice eqDevice = new EqualizerAudioDevice(player);
                        eqDevice.setVolume(this.volume);
                        device = eqDevice;
                        System.out.println("Created equalizer audio device for player: " + player.m_7755_().getString());
                    } else {
                        VolumeControlledAudioDevice volDevice = new VolumeControlledAudioDevice();
                        volDevice.setVolume(this.volume);
                        device = volDevice;
                        System.out.println("Created volume controlled audio device");
                    }
                    try {
                        device.open((Decoder)null);
                        System.out.println("Audio device opened successfully");
                        device.close();
                    }
                    catch (Exception e) {
                        System.err.println("Audio device test failed: " + e.getMessage());
                        e.printStackTrace();
                    }
                    Player audioPlayer = new Player(audioStream, device);
                    connection = this;
                    synchronized (connection) {
                        this.currentPlayer = audioPlayer;
                        this.currentAudioDevice = device;
                        this.currentSongId = trackId;
                        this.activePlayers.put(trackId, audioPlayer);
                        this.isPlaying = true;
                        System.out.println("Now playing: " + trackId + ", active players: " + this.activePlayers.size() + ", isPlaying: " + this.isPlaying);
                    }
                    NeteaseCloudMusicAPI.getBossBarService();
                    BossBarService.setLoadingState(false);
                    try {
                        System.out.println("Starting playback...");
                        Thread playbackThread = new Thread(() -> {
                            try {
                                long startTime = System.currentTimeMillis();
                                Thread progressThread = new Thread(() -> {
                                    while (!Thread.currentThread().isInterrupted() && this.isPlaying) {
                                        try {
                                            Thread.sleep(1000L);
                                            if (!this.isPlaying || this.currentPlayer == null) continue;
                                            int currentPos = this.currentPlayer.getPosition() + startPosition;
                                            NeteaseCloudMusicAPI.getBossBarService();
                                            BossBarService.syncWithAudioService(currentPos, true);
                                            if (this.currentSongId == null) continue;
                                            try {
                                                long songId = Long.parseLong(this.currentSongId);
                                                NeteaseCloudMusicAPI.getLyricsService();
                                                LyricsService.syncWithAudioService(currentPos, true, songId);
                                            }
                                            catch (NumberFormatException e) {
                                                System.err.println("\u65e0\u6548\u7684\u6b4c\u66f2ID\u683c\u5f0f: " + this.currentSongId);
                                            }
                                        }
                                        catch (InterruptedException e) {
                                            break;
                                        }
                                        catch (Exception e) {
                                            System.err.println("\u8fdb\u5ea6\u66f4\u65b0\u9519\u8bef: " + e.getMessage());
                                        }
                                    }
                                });
                                progressThread.setDaemon(true);
                                progressThread.start();
                                audioPlayer.play();
                                System.out.println("Playback completed");
                                AudioService audioService = this;
                                synchronized (audioService) {
                                    if (this.currentPlayer == audioPlayer) {
                                        this.isPlaying = false;
                                        this.currentPlayer = null;
                                        this.currentAudioDevice = null;
                                        if (this.currentSongId != null) {
                                            try {
                                                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                                                if (server != null) {
                                                    for (ServerPlayer onlinePlayer : server.m_6846_().m_11314_()) {
                                                        NeteaseCloudMusicAPI.getPlaylistPlayerService();
                                                        PlaylistPlayerService.autoPlayNext(onlinePlayer);
                                                    }
                                                }
                                            }
                                            catch (Exception e) {
                                                System.err.println("\u81ea\u52a8\u64ad\u653e\u4e0b\u4e00\u9996\u5931\u8d25: " + e.getMessage());
                                            }
                                        }
                                        this.currentSongId = null;
                                        System.out.println("Playback finished and reset: " + trackId + ", isPlaying: " + this.isPlaying);
                                        NeteaseCloudMusicAPI.getBossBarService();
                                        BossBarService.updateSongInfo("", "", 0, 0, false);
                                    }
                                    this.activePlayers.remove(trackId);
                                    System.out.println("Playback finished: " + trackId + ", active players: " + this.activePlayers.size() + ", isPlaying: " + this.isPlaying);
                                }
                            }
                            catch (Exception e) {
                                System.err.println("\u64ad\u653e\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef: " + e.getMessage());
                                e.printStackTrace();
                                AudioService audioService = this;
                                synchronized (audioService) {
                                    if (this.currentPlayer == audioPlayer) {
                                        this.isPlaying = false;
                                        this.currentPlayer = null;
                                        this.currentAudioDevice = null;
                                        this.currentSongId = null;
                                        NeteaseCloudMusicAPI.getBossBarService();
                                        BossBarService.updateSongInfo("", "", 0, 0, false);
                                    }
                                    this.activePlayers.remove(trackId);
                                }
                            }
                        });
                        playbackThread.setDaemon(true);
                        AudioService audioService = this;
                        synchronized (audioService) {
                            this.currentPlaybackThread = playbackThread;
                        }
                        playbackThread.start();
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        System.err.println("\u64ad\u653e\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    System.err.println("JavaZoom\u64ad\u653e\u5668\u4e5f\u5931\u8d25: " + e.getMessage());
                    AudioService audioService = this;
                    synchronized (audioService) {
                        this.isPlaying = false;
                        this.currentPlayer = null;
                        this.currentSongId = null;
                        this.activePlayers.remove(trackId);
                        NeteaseCloudMusicAPI.getBossBarService();
                        BossBarService.updateSongInfo("", "", 0, 0, false);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("\u64ad\u653e\u5931\u8d25: " + e.getMessage());
                AudioService audioService = this;
                synchronized (audioService) {
                    this.isPlaying = false;
                    this.currentPlayer = null;
                    this.currentSongId = null;
                    this.activePlayers.remove(trackId);
                    NeteaseCloudMusicAPI.getBossBarService();
                    BossBarService.updateSongInfo("", "", 0, 0, false);
                }
            }
        });
        return this.createSuccessResult("\u5f00\u59cb\u64ad\u653e: " + trackId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject pause() {
        AudioService audioService = this;
        synchronized (audioService) {
            System.out.println("Pause requested - currentPlayer: " + this.currentPlayer + ", isPlaying: " + this.isPlaying + ", playbackThread: " + this.currentPlaybackThread + ", activePlayers: " + this.activePlayers.size());
            if (this.currentPlayer != null && this.isPlaying || !this.activePlayers.isEmpty()) {
                String[] parts;
                System.out.println("Pausing playback");
                if (this.currentPlaybackThread != null) {
                    try {
                        this.currentPlaybackThread.interrupt();
                        System.out.println("Playback thread interrupted");
                    }
                    catch (Exception e) {
                        System.err.println("Error interrupting playback thread: " + e.getMessage());
                    }
                    this.currentPlaybackThread = null;
                }
                if (this.currentPlayer != null) {
                    try {
                        this.pausePosition = this.currentPlayer.getPosition();
                        System.out.println("Paused at position: " + this.pausePosition + "ms");
                        if (this.currentSongId != null) {
                            try {
                                long songId = Long.parseLong(this.currentSongId);
                                NeteaseCloudMusicAPI.getLyricsService();
                                LyricsService.syncWithAudioService(this.pausePosition, false, songId);
                            }
                            catch (NumberFormatException e) {
                                System.err.println("\u65e0\u6548\u7684\u6b4c\u66f2ID\u683c\u5f0f: " + this.currentSongId);
                            }
                        }
                        this.currentPlayer.close();
                        System.out.println("Current player closed successfully");
                    }
                    catch (Exception e) {
                        System.err.println("Error closing current player: " + e.getMessage());
                    }
                    this.currentPlayer = null;
                }
                for (Player player : this.activePlayers.values()) {
                    try {
                        player.close();
                        System.out.println("Active player closed");
                    }
                    catch (Exception e) {
                        System.err.println("Error closing active player: " + e.getMessage());
                    }
                }
                this.activePlayers.clear();
                this.isPlaying = false;
                NeteaseCloudMusicAPI.getBossBarService();
                String currentStatus = BossBarService.getCurrentStatus();
                if (!currentStatus.equals("\u65e0\u6b4c\u66f2\u64ad\u653e") && (parts = currentStatus.split(" - ")).length >= 2) {
                    String songName = parts[0];
                    String artistAndTime = parts[1];
                    String artist = artistAndTime.split(" \\[")[0];
                    NeteaseCloudMusicAPI.getBossBarService();
                    BossBarService.updateSongInfo(songName, artist, this.pausePosition, 180000, false);
                }
                return this.createSuccessResult("\u64ad\u653e\u5df2\u6682\u505c");
            }
            return this.createErrorResult("\u6ca1\u6709\u6b63\u5728\u64ad\u653e\u7684\u97f3\u9891");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject resume() {
        AudioService audioService = this;
        synchronized (audioService) {
            System.out.println("Resume requested - currentSongId: " + this.currentSongId + ", isPlaying: " + this.isPlaying + ", pausePosition: " + this.pausePosition + "ms");
            if (this.currentSongId != null && !this.isPlaying) {
                System.out.println("Resuming playback: " + this.currentSongId + " from position: " + this.pausePosition + "ms");
                if (this.pausePosition <= 0) {
                    System.out.println("Resuming from beginning (pause position is 0)");
                    try {
                        String url;
                        JsonObject firstSong;
                        JsonArray dataArray;
                        JsonElement dataElement;
                        JsonObject urlResult = this.getSongUrl(Long.parseLong(this.currentSongId), 128000);
                        if (urlResult.has("code") && urlResult.get("code").getAsInt() == 200 && urlResult.has("data") && (dataElement = urlResult.get("data")).isJsonArray() && (dataArray = dataElement.getAsJsonArray()).size() > 0 && (firstSong = dataArray.get(0).getAsJsonObject()).has("url") && !(url = firstSong.get("url").getAsString()).isEmpty()) {
                            return this.playFromUrl(url, this.currentSongId, null, null, this.pausePosition);
                        }
                        return this.createErrorResult("\u65e0\u6cd5\u83b7\u53d6\u6b4c\u66f2\u94fe\u63a5");
                    }
                    catch (Exception e) {
                        return this.createErrorResult("\u6062\u590d\u64ad\u653e\u5931\u8d25: " + e.getMessage());
                    }
                }
                System.out.println("\u4ece\u4f4d\u7f6e\u6062\u590d\u64ad\u653e: " + this.pausePosition + "ms");
                try {
                    String url;
                    JsonObject firstSong;
                    JsonArray dataArray;
                    JsonElement dataElement;
                    NeteaseCloudMusicAPI.getBossBarService();
                    BossBarService.syncWithAudioService(this.pausePosition, true);
                    JsonObject urlResult = this.getSongUrl(Long.parseLong(this.currentSongId), 128000);
                    if (urlResult.has("code") && urlResult.get("code").getAsInt() == 200 && urlResult.has("data") && (dataElement = urlResult.get("data")).isJsonArray() && (dataArray = dataElement.getAsJsonArray()).size() > 0 && (firstSong = dataArray.get(0).getAsJsonObject()).has("url") && !(url = firstSong.get("url").getAsString()).isEmpty()) {
                        long remaining;
                        long skipped;
                        long actuallySkipped;
                        URL audioUrl = new URL(url);
                        HttpURLConnection connection = (HttpURLConnection)audioUrl.openConnection();
                        connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                        long bytesToSkip = this.pausePosition * 16 * 1024 / 1000;
                        System.out.println("\u9700\u8981\u8df3\u8fc7 " + bytesToSkip + " \u5b57\u8282");
                        BufferedInputStream originalStream = new BufferedInputStream(connection.getInputStream());
                        for (skipped = 0L; skipped < bytesToSkip && (actuallySkipped = ((InputStream)originalStream).skip(remaining = bytesToSkip - skipped)) != 0L; skipped += actuallySkipped) {
                        }
                        System.out.println("\u5b9e\u9645\u8df3\u8fc7 " + skipped + " \u5b57\u8282");
                        return this.playFromInputStream(originalStream, this.currentSongId, null, null, this.pausePosition);
                    }
                    return this.createErrorResult("\u65e0\u6cd5\u83b7\u53d6\u6b4c\u66f2\u94fe\u63a5");
                }
                catch (Exception e) {
                    System.err.println("\u6062\u590d\u64ad\u653e\u5931\u8d25: " + e.getMessage());
                    e.printStackTrace();
                    try {
                        String url;
                        JsonObject firstSong;
                        JsonArray dataArray;
                        JsonElement dataElement;
                        JsonObject urlResult = this.getSongUrl(Long.parseLong(this.currentSongId), 128000);
                        if (urlResult.has("code") && urlResult.get("code").getAsInt() == 200 && urlResult.has("data") && (dataElement = urlResult.get("data")).isJsonArray() && (dataArray = dataElement.getAsJsonArray()).size() > 0 && (firstSong = dataArray.get(0).getAsJsonObject()).has("url") && !(url = firstSong.get("url").getAsString()).isEmpty()) {
                            return this.playFromUrl(url, this.currentSongId, null, null, this.pausePosition);
                        }
                    }
                    catch (Exception ex) {
                        return this.createErrorResult("\u6062\u590d\u64ad\u653e\u5931\u8d25: " + ex.getMessage());
                    }
                    return this.createErrorResult("\u6062\u590d\u64ad\u653e\u5931\u8d25: " + e.getMessage());
                }
            }
            return this.createErrorResult("\u65e0\u6cd5\u6062\u590d\u64ad\u653e");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject stop() {
        System.out.println("Stopping all playback and clearing song ID");
        AudioService audioService = this;
        synchronized (audioService) {
            this.stopCurrentPlayback();
            this.currentSongId = null;
        }
        return this.createSuccessResult("\u64ad\u653e\u5df2\u505c\u6b62");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject setVolume(float volume) {
        float newVolume;
        this.volume = newVolume = Math.max(0.0f, Math.min(1.0f, volume));
        AudioService audioService = this;
        synchronized (audioService) {
            if (this.currentAudioDevice != null && this.isPlaying && this.currentAudioDevice instanceof VolumeControlledAudioDevice) {
                VolumeControlledAudioDevice device = (VolumeControlledAudioDevice)this.currentAudioDevice;
                device.setVolume(newVolume);
                System.out.println("Volume changed to: " + newVolume + " (real-time adjustment applied)");
            }
        }
        return this.createSuccessResult("\u97f3\u91cf\u8bbe\u7f6e\u4e3a: " + this.volume);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject getPlaybackStatus() {
        AudioService audioService = this;
        synchronized (audioService) {
            JsonObject status = new JsonObject();
            status.addProperty("isPlaying", Boolean.valueOf(this.isPlaying));
            status.addProperty("currentSongId", this.currentSongId != null ? this.currentSongId : "\u65e0");
            status.addProperty("volume", (Number)Float.valueOf(this.volume));
            status.addProperty("activePlayers", (Number)this.activePlayers.size());
            status.addProperty("currentPosition", (Number)this.getCurrentPosition());
            return this.createSuccessResult(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentPosition() {
        AudioService audioService = this;
        synchronized (audioService) {
            if (this.currentPlayer != null && this.isPlaying) {
                return this.currentPlayer.getPosition();
            }
            return this.pausePosition;
        }
    }

    public JsonObject getSongUrl(long id, int br) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        params.put("br", String.valueOf(br));
        return HttpClientUtil.get("song/url", params);
    }

    public JsonObject getSongDetail(long id) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ids", String.valueOf(id));
        return HttpClientUtil.get("song/detail", params);
    }

    public JsonObject downloadSong(long songId, int br, String savePath) {
        return this.createErrorResult("\u4e0b\u8f7d\u529f\u80fd\u6682\u672a\u5b9e\u73b0");
    }

    public JsonObject preloadSong(long songId, int br) {
        return this.createErrorResult("\u9884\u52a0\u8f7d\u529f\u80fd\u6682\u672a\u5b9e\u73b0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopCurrentPlayback() {
        AudioService audioService = this;
        synchronized (audioService) {
            System.out.println("Stopping current playback, active players: " + this.activePlayers.size() + ", playbackThread: " + this.currentPlaybackThread);
            if (this.currentPlaybackThread != null) {
                try {
                    this.currentPlaybackThread.interrupt();
                    System.out.println("Playback thread interrupted");
                }
                catch (Exception e) {
                    System.err.println("Error interrupting playback thread: " + e.getMessage());
                }
                this.currentPlaybackThread = null;
            }
            if (this.currentPlayer != null) {
                this.currentPlayer.close();
                this.currentPlayer = null;
            }
            this.isPlaying = false;
            if (this.currentSongId != null) {
                try {
                    long songId = Long.parseLong(this.currentSongId);
                    NeteaseCloudMusicAPI.getLyricsService();
                    LyricsService.syncWithAudioService(0, false, songId);
                }
                catch (NumberFormatException e) {
                    System.err.println("\u65e0\u6548\u7684\u6b4c\u66f2ID\u683c\u5f0f: " + this.currentSongId);
                }
            }
            for (Player player : this.activePlayers.values()) {
                try {
                    player.close();
                }
                catch (Exception e) {
                    System.err.println("\u5173\u95ed\u64ad\u653e\u5668\u5931\u8d25: " + e.getMessage());
                }
            }
            this.activePlayers.clear();
        }
    }

    public void shutdown() {
        this.stopCurrentPlayback();
        this.executorService.shutdown();
    }

    public void init() {
        if (this.executorService.isShutdown() || this.executorService.isTerminated()) {
            this.executorService = Executors.newCachedThreadPool();
            System.out.println("AudioService\u7ebf\u7a0b\u6c60\u5df2\u91cd\u65b0\u521d\u59cb\u5316");
        }
    }

    private JsonObject playFromInputStream(InputStream audioStream, String trackId, JsonObject songDetail, ServerPlayer player, int startPosition) {
        JsonArray songs;
        System.out.println("Playing from input stream: " + trackId + " from position: " + startPosition + "ms");
        this.stopCurrentPlayback();
        String songName = "\u672a\u77e5\u6b4c\u66f2";
        String artists = "\u672a\u77e5\u827a\u4eba";
        int duration = 180000;
        if (songDetail != null && songDetail.has("songs") && (songs = songDetail.getAsJsonArray("songs")).size() > 0) {
            JsonObject song = songs.get(0).getAsJsonObject();
            if (song.has("name")) {
                songName = song.get("name").getAsString();
            }
            if (song.has("ar")) {
                JsonArray artistsArray = song.getAsJsonArray("ar");
                StringBuilder artistsBuilder = new StringBuilder();
                for (JsonElement artist : artistsArray) {
                    if (artistsBuilder.length() > 0) {
                        artistsBuilder.append(", ");
                    }
                    artistsBuilder.append(artist.getAsJsonObject().get("name").getAsString());
                }
                artists = artistsBuilder.toString();
            }
            if (song.has("dt")) {
                duration = song.get("dt").getAsInt();
            }
        }
        NeteaseCloudMusicAPI.getBossBarService();
        BossBarService.updateSongInfo(songName, artists, startPosition, duration, true);
        this.executorService.submit(() -> {
            try {
                try {
                    JavaSoundAudioDevice device;
                    if (player != null) {
                        EqualizerAudioDevice eqDevice = new EqualizerAudioDevice(player);
                        eqDevice.setVolume(this.volume);
                        device = eqDevice;
                        System.out.println("Created equalizer audio device for player: " + player.m_7755_().getString());
                    } else {
                        VolumeControlledAudioDevice volDevice = new VolumeControlledAudioDevice();
                        volDevice.setVolume(this.volume);
                        device = volDevice;
                        System.out.println("Created volume controlled audio device");
                    }
                    try {
                        device.open((Decoder)null);
                        System.out.println("Audio device opened successfully");
                        device.close();
                    }
                    catch (Exception e) {
                        System.err.println("Audio device test failed: " + e.getMessage());
                        e.printStackTrace();
                    }
                    Player audioPlayer = new Player(audioStream, device);
                    AudioService audioService = this;
                    synchronized (audioService) {
                        this.currentPlayer = audioPlayer;
                        this.currentAudioDevice = device;
                        this.currentSongId = trackId;
                        this.activePlayers.put(trackId, audioPlayer);
                        this.isPlaying = true;
                        System.out.println("Now playing: " + trackId + ", active players: " + this.activePlayers.size() + ", isPlaying: " + this.isPlaying);
                    }
                    try {
                        System.out.println("Starting playback from position: " + startPosition + "ms...");
                        Thread playbackThread = new Thread(() -> {
                            try {
                                long startTime = System.currentTimeMillis();
                                Thread progressThread = new Thread(() -> {
                                    while (!Thread.currentThread().isInterrupted() && this.isPlaying) {
                                        try {
                                            Thread.sleep(1000L);
                                            if (!this.isPlaying || this.currentPlayer == null) continue;
                                            int currentPos = this.currentPlayer.getPosition() + startPosition;
                                            NeteaseCloudMusicAPI.getBossBarService();
                                            BossBarService.syncWithAudioService(currentPos, true);
                                            if (this.currentSongId == null) continue;
                                            try {
                                                long songId = Long.parseLong(this.currentSongId);
                                                NeteaseCloudMusicAPI.getLyricsService();
                                                LyricsService.syncWithAudioService(currentPos, true, songId);
                                            }
                                            catch (NumberFormatException e) {
                                                System.err.println("\u65e0\u6548\u7684\u6b4c\u66f2ID\u683c\u5f0f: " + this.currentSongId);
                                            }
                                        }
                                        catch (InterruptedException e) {
                                            break;
                                        }
                                        catch (Exception e) {
                                            System.err.println("\u8fdb\u5ea6\u66f4\u65b0\u9519\u8bef: " + e.getMessage());
                                        }
                                    }
                                });
                                progressThread.setDaemon(true);
                                progressThread.start();
                                audioPlayer.play();
                                System.out.println("Playback completed");
                                AudioService audioService = this;
                                synchronized (audioService) {
                                    if (this.currentPlayer == audioPlayer) {
                                        this.isPlaying = false;
                                        this.currentPlayer = null;
                                        this.currentAudioDevice = null;
                                        if (this.currentSongId != null) {
                                            try {
                                                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                                                if (server != null) {
                                                    for (ServerPlayer onlinePlayer : server.m_6846_().m_11314_()) {
                                                        NeteaseCloudMusicAPI.getPlaylistPlayerService();
                                                        PlaylistPlayerService.autoPlayNext(onlinePlayer);
                                                    }
                                                }
                                            }
                                            catch (Exception e) {
                                                System.err.println("\u81ea\u52a8\u64ad\u653e\u4e0b\u4e00\u9996\u5931\u8d25: " + e.getMessage());
                                            }
                                        }
                                        this.currentSongId = null;
                                        System.out.println("Playback finished and reset: " + trackId + ", isPlaying: " + this.isPlaying);
                                        NeteaseCloudMusicAPI.getBossBarService();
                                        BossBarService.updateSongInfo("", "", 0, 0, false);
                                    }
                                    this.activePlayers.remove(trackId);
                                    System.out.println("Playback finished: " + trackId + ", active players: " + this.activePlayers.size() + ", isPlaying: " + this.isPlaying);
                                }
                            }
                            catch (Exception e) {
                                System.err.println("\u64ad\u653e\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef: " + e.getMessage());
                                e.printStackTrace();
                                AudioService audioService = this;
                                synchronized (audioService) {
                                    if (this.currentPlayer == audioPlayer) {
                                        this.isPlaying = false;
                                        this.currentPlayer = null;
                                        this.currentAudioDevice = null;
                                        this.currentSongId = null;
                                        NeteaseCloudMusicAPI.getBossBarService();
                                        BossBarService.updateSongInfo("", "", 0, 0, false);
                                    }
                                    this.activePlayers.remove(trackId);
                                }
                            }
                        });
                        playbackThread.setDaemon(true);
                        AudioService audioService2 = this;
                        synchronized (audioService2) {
                            this.currentPlaybackThread = playbackThread;
                        }
                        playbackThread.start();
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        System.err.println("\u64ad\u653e\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    System.err.println("JavaZoom\u64ad\u653e\u5668\u4e5f\u5931\u8d25: " + e.getMessage());
                    AudioService audioService = this;
                    synchronized (audioService) {
                        this.isPlaying = false;
                        this.currentPlayer = null;
                        this.currentSongId = null;
                        this.activePlayers.remove(trackId);
                        NeteaseCloudMusicAPI.getBossBarService();
                        BossBarService.updateSongInfo("", "", 0, 0, false);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("\u64ad\u653e\u5931\u8d25: " + e.getMessage());
                AudioService audioService = this;
                synchronized (audioService) {
                    this.isPlaying = false;
                    this.currentPlayer = null;
                    this.currentSongId = null;
                    this.activePlayers.remove(trackId);
                    NeteaseCloudMusicAPI.getBossBarService();
                    BossBarService.updateSongInfo("", "", 0, 0, false);
                }
            }
        });
        return this.createSuccessResult("\u4ece\u4f4d\u7f6e " + startPosition + "ms \u5f00\u59cb\u64ad\u653e: " + trackId);
    }

    private JsonObject createSuccessResult(String message) {
        JsonObject result = new JsonObject();
        result.addProperty("code", (Number)200);
        result.addProperty("message", message);
        return result;
    }

    private JsonObject createSuccessResult(JsonObject data) {
        JsonObject result = new JsonObject();
        result.addProperty("code", (Number)200);
        result.add("data", (JsonElement)data);
        return result;
    }

    private JsonObject createErrorResult(String message) {
        JsonObject result = new JsonObject();
        result.addProperty("code", (Number)500);
        result.addProperty("error", message);
        return result;
    }
}

