/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.service;

import celia.adwadg.ncm.NeteaseCloudMusicAPI;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;

public class DebugService {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static boolean debugMode = false;

    public static JsonObject testApiCall(String apiPath, Map<String, String> params) throws IOException {
        JsonObject result = null;
        try {
            switch (apiPath) {
                case "cloudsearch": {
                    String keywords = params.get("keywords");
                    int limit = Integer.parseInt(params.get("limit"));
                    int type = Integer.parseInt(params.get("type"));
                    result = NeteaseCloudMusicAPI.getMusicService().search(keywords, limit, 0, type);
                    break;
                }
                case "song/detail": {
                    long songId = Long.parseLong(params.get("ids"));
                    result = NeteaseCloudMusicAPI.getMusicService().getSongDetail(songId);
                    break;
                }
                case "song/url": {
                    long urlSongId = Long.parseLong(params.get("id"));
                    int br = Integer.parseInt(params.get("br"));
                    result = NeteaseCloudMusicAPI.getMusicService().getSongUrl(urlSongId, br);
                    break;
                }
                case "playlist/detail": {
                    throw new IOException("PlaylistService.getPlaylistDetail \u65b9\u6cd5\u4e0d\u5b58\u5728");
                }
                default: {
                    throw new IOException("\u4e0d\u652f\u6301\u7684API\u8def\u5f84: " + apiPath);
                }
            }
            if (debugMode) {
                System.out.println("=== API\u8c03\u8bd5\u4fe1\u606f ===");
                System.out.println("API\u8def\u5f84: " + apiPath);
                System.out.println("\u8bf7\u6c42\u53c2\u6570: " + params);
                System.out.println("\u54cd\u5e94\u7ed3\u679c:");
                System.out.println(gson.toJson((JsonElement)result));
                System.out.println("===================");
            }
        }
        catch (Exception e) {
            System.err.println("API\u6d4b\u8bd5\u8c03\u7528\u5931\u8d25: " + e.getMessage());
            throw new IOException("API\u6d4b\u8bd5\u8c03\u7528\u5931\u8d25", e);
        }
        return result;
    }

    public static String getApiResponseStructure(String apiPath, Map<String, String> params) throws IOException {
        JsonObject result = DebugService.testApiCall(apiPath, params);
        return DebugService.analyzeJsonStructure((JsonElement)result, "");
    }

    public static String analyzeJsonStructure(JsonElement element, String indent) {
        StringBuilder structure = new StringBuilder();
        if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            structure.append(indent).append("Object: {\n");
            for (Map.Entry entry : obj.entrySet()) {
                structure.append(indent).append("  ").append((String)entry.getKey()).append(": ");
                structure.append(DebugService.analyzeJsonStructure((JsonElement)entry.getValue(), indent + "  ").trim());
                structure.append(",\n");
            }
            if (!obj.entrySet().isEmpty()) {
                structure.setLength(structure.length() - 2);
                structure.append("\n");
            }
            structure.append(indent).append("}");
        } else if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            structure.append(indent).append("Array: [\n");
            if (!array.isEmpty()) {
                structure.append(DebugService.analyzeJsonStructure(array.get(0), indent + "  ")).append("\n");
                structure.append(indent).append("]");
            } else {
                structure.append(indent).append("  (empty array)\n");
                structure.append(indent).append("]");
            }
        } else if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isString()) {
                structure.append("String: \"").append(primitive.getAsString()).append("\"");
            } else if (primitive.isNumber()) {
                structure.append("Number: ").append(primitive.getAsNumber());
            } else if (primitive.isBoolean()) {
                structure.append("Boolean: ").append(primitive.getAsBoolean());
            }
        } else if (element.isJsonNull()) {
            structure.append("null");
        }
        return structure.toString();
    }

    public static void sendDebugInfo(ServerPlayer player, String message) {
        if (player != null) {
            player.m_6352_((Component)new TextComponent("\u00a76[\u8c03\u8bd5] \u00a7f" + message), player.m_142081_());
        }
        System.out.println("[\u8c03\u8bd5] " + message);
    }

    public static void logApiCall(String apiPath, Map<String, String> params, JsonObject result) {
        if (debugMode) {
            String logMessage = String.format("API\u8c03\u7528: %s, \u53c2\u6570: %s, \u7ed3\u679c\u4ee3\u7801: %d", apiPath, params, result.has("code") ? result.get("code").getAsInt() : -1);
            System.out.println(logMessage);
        }
    }

    public static void setDebugMode(boolean enabled) {
        debugMode = enabled;
        System.out.println("\u8c03\u8bd5\u6a21\u5f0f: " + (enabled ? "\u5df2\u542f\u7528" : "\u5df2\u7981\u7528"));
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static JsonObject testSongSearch(String keywords, int limit) throws IOException {
        return NeteaseCloudMusicAPI.getMusicService().search(keywords, limit, 0, 1);
    }

    public static JsonObject testSongDetail(long songId) throws IOException {
        return NeteaseCloudMusicAPI.getMusicService().getSongDetail(songId);
    }

    public static JsonObject testSongUrl(long songId, int br) throws IOException {
        return NeteaseCloudMusicAPI.getMusicService().getSongUrl(songId, br);
    }

    public static JsonObject testCheckMusic(long songId, int br) throws IOException {
        return NeteaseCloudMusicAPI.getMusicService().checkMusicAvailable(songId, br);
    }

    public static JsonObject testLyric(long songId) throws IOException {
        return NeteaseCloudMusicAPI.getMusicService().getLyric(songId);
    }

    public static JsonObject testAlbum(long albumId) throws IOException {
        return NeteaseCloudMusicAPI.getMusicService().getAlbum(albumId);
    }

    public static JsonObject testArtist(long artistId) throws IOException {
        return NeteaseCloudMusicAPI.getMusicService().getArtist(artistId);
    }

    public static JsonObject testPlaylistDetail(long playlistId) throws IOException {
        throw new IOException("PlaylistService.getPlaylistDetail \u65b9\u6cd5\u4e0d\u5b58\u5728");
    }

    public static JsonObject testUserPlaylist(long userId) throws IOException {
        throw new IOException("UserService.getUserPlaylist \u65b9\u6cd5\u4e0d\u5b58\u5728");
    }

    public static JsonObject testUserDetail(long userId) throws IOException {
        throw new IOException("UserService.getUserDetail \u65b9\u6cd5\u4e0d\u5b58\u5728");
    }

    public static JsonObject testComments(long songId) throws IOException {
        throw new IOException("CommentService.getComments \u65b9\u6cd5\u7b7e\u540d\u4e0d\u5339\u914d");
    }

    public static JsonObject testMvDetail(long mvId) throws IOException {
        throw new IOException("MvService.getMvDetail \u65b9\u6cd5\u4e0d\u5b58\u5728");
    }

    public static JsonObject testDjProgram(long djId) throws IOException {
        throw new IOException("DjService.getDjProgram \u65b9\u6cd5\u4e0d\u5b58\u5728");
    }

    public static JsonObject testPhoneLogin(String phone, String password) throws IOException {
        return NeteaseCloudMusicAPI.getAuthService().phoneLogin(phone, password);
    }

    public static JsonObject testEmailLogin(String email, String password) throws IOException {
        return NeteaseCloudMusicAPI.getAuthService().emailLogin(email, password);
    }

    public static JsonObject testQrCodeLogin() throws IOException {
        return NeteaseCloudMusicAPI.getAuthService().qrCodeLogin();
    }

    public static JsonObject testLoginStatus() throws IOException {
        return NeteaseCloudMusicAPI.getAuthService().getLoginStatus();
    }

    public static String getApiStructureExample(String apiName) {
        switch (apiName.toLowerCase()) {
            case "search": {
                return "\u97f3\u4e50\u641c\u7d22\n\u65b9\u6cd5: MusicService.search(keywords, limit, offset, type)\n\u793a\u4f8b: getMusicService().search(\"\u5468\u6770\u4f26\", 10, 0, 1)";
            }
            case "detail": {
                return "\u6b4c\u66f2\u8be6\u60c5\n\u65b9\u6cd5: MusicService.getSongDetail(songId)\n\u793a\u4f8b: getMusicService().getSongDetail(347230)";
            }
            case "url": {
                return "\u6b4c\u66f2URL\n\u65b9\u6cd5: MusicService.getSongUrl(songId, br)\n\u793a\u4f8b: getMusicService().getSongUrl(347230, 128000)";
            }
            case "lyric": {
                return "\u6b4c\u8bcd\u83b7\u53d6\n\u65b9\u6cd5: MusicService.getLyric(songId)\n\u793a\u4f8b: getMusicService().getLyric(347230)";
            }
            case "album": {
                return "\u4e13\u8f91\u4fe1\u606f\n\u65b9\u6cd5: MusicService.getAlbum(albumId)\n\u793a\u4f8b: getMusicService().getAlbum(32311)";
            }
            case "artist": {
                return "\u827a\u4eba\u4fe1\u606f\n\u65b9\u6cd5: MusicService.getArtist(artistId)\n\u793a\u4f8b: getMusicService().getArtist(6452)";
            }
            case "playlist": {
                return "\u6b4c\u5355\u8be6\u60c5\n\u65b9\u6cd5: PlaylistService.getPlaylistDetail(playlistId)\n\u793a\u4f8b: getPlaylistService().getPlaylistDetail(156934569)";
            }
            case "user": {
                return "\u7528\u6237\u4fe1\u606f\n\u65b9\u6cd5: UserService.getUserDetail(userId)\n\u793a\u4f8b: getUserService().getUserDetail(123456)";
            }
            case "comments": {
                return "\u6b4c\u66f2\u8bc4\u8bba\n\u65b9\u6cd5: CommentService.getComments(songId, offset, limit)\n\u793a\u4f8b: getCommentService().getComments(347230, 0, 20)";
            }
            case "mv": {
                return "MV\u8be6\u60c5\n\u65b9\u6cd5: MvService.getMvDetail(mvId)\n\u793a\u4f8b: getMvService().getMvDetail(5436712)";
            }
            case "dj": {
                return "\u7535\u53f0\u8282\u76ee\n\u65b9\u6cd5: DjService.getDjProgram(djId)\n\u793a\u4f8b: getDjService().getDjProgram(336355127)";
            }
            case "login": {
                return "\u624b\u673a\u767b\u5f55\n\u65b9\u6cd5: AuthService.phoneLogin(phone, password)\n\u793a\u4f8b: getAuthService().phoneLogin(\"13800138000\", \"password\")";
            }
        }
        return "\u672a\u77e5API: " + apiName + "\n\u53ef\u7528API: search, detail, url, lyric, album, artist, playlist, user, comments, mv, dj, login";
    }
}

