/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.service;

import celia.adwadg.ncm.NeteaseCloudMusicAPI;
import celia.adwadg.ncm.service.MusicService;
import celia.adwadg.ncm.util.LyricsParser;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class LyricsService {
    private static final Map<UUID, LyricsDisplay> playerLyrics = new HashMap<UUID, LyricsDisplay>();
    private static final Map<UUID, Boolean> playerLyricsEnabled = new HashMap<UUID, Boolean>();
    private static final Map<UUID, String> lastChatLyric = new HashMap<UUID, String>();
    private static DisplayMode displayMode = DisplayMode.INVENTORY;

    public static void setLyricsForPlayer(ServerPlayer player, long songId, List<LyricsParser.LyricLine> lyrics, List<LyricsParser.WordLyric> wordLyrics) {
        LyricsDisplay display = new LyricsDisplay(songId, lyrics, wordLyrics);
        playerLyrics.put(player.m_142081_(), display);
        if (displayMode == DisplayMode.INVENTORY) {
            LyricsService.updateInventoryDisplay(player, display);
        }
    }

    public static void clearLyricsForPlayer(ServerPlayer player) {
        UUID playerId = player.m_142081_();
        playerLyrics.remove(playerId);
        lastChatLyric.remove(playerId);
        if (displayMode == DisplayMode.INVENTORY) {
            LyricsService.clearInventoryDisplay(player);
        }
    }

    public static void setDisplayMode(DisplayMode mode) {
        displayMode = mode;
        for (UUID playerId : playerLyrics.keySet()) {
            ServerPlayer player = LyricsService.getPlayerById(playerId);
            if (player == null) continue;
            LyricsService.clearInventoryDisplay(player);
        }
    }

    public static DisplayMode getDisplayMode() {
        return displayMode;
    }

    public static void setLyricsEnabled(ServerPlayer player, boolean enabled) {
        playerLyricsEnabled.put(player.m_142081_(), enabled);
        if (!enabled) {
            LyricsService.clearLyricsForPlayer(player);
        }
    }

    public static boolean isLyricsEnabled(ServerPlayer player) {
        return playerLyricsEnabled.getOrDefault(player.m_142081_(), false);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (Map.Entry<UUID, LyricsDisplay> entry : playerLyrics.entrySet()) {
                ServerPlayer player = LyricsService.getPlayerById(entry.getKey());
                LyricsDisplay display = entry.getValue();
                if (player == null || display == null || !playerLyricsEnabled.getOrDefault(player.m_142081_(), false).booleanValue() || displayMode != DisplayMode.INVENTORY) continue;
                LyricsService.updateInventoryDisplay(player, display);
            }
        }
    }

    private static void updateInventoryDisplay(ServerPlayer player, LyricsDisplay display) {
        String currentLyric;
        if (display.hasLyrics() && !(currentLyric = display.getCurrentLyric()).isEmpty()) {
            TextComponent lyricComponent = new TextComponent("\u00a76\u266a \u00a7e" + currentLyric + " \u00a76\u266a");
            player.m_5661_((Component)lyricComponent, true);
        }
    }

    private static void clearInventoryDisplay(ServerPlayer player) {
        player.m_5661_((Component)new TextComponent(""), true);
    }

    private static void updateChatDisplay(ServerPlayer player, LyricsDisplay display) {
        if (display.hasLyrics()) {
            String currentLyric = display.getCurrentLyric();
            String previousLyric = display.getPreviousLyric();
            if (!currentLyric.isEmpty() && !currentLyric.equals(previousLyric)) {
                player.m_6352_((Component)new TextComponent("\u00a7a\u266a \u00a7f" + currentLyric + " \u00a7a\u266a"), player.m_142081_());
            }
        }
    }

    private static ServerPlayer getPlayerById(UUID playerId) {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                return server.m_6846_().m_11259_(playerId);
            }
        }
        catch (Exception e) {
            System.err.println("\u83b7\u53d6\u73a9\u5bb6\u5b9e\u4f8b\u5931\u8d25: " + e.getMessage());
        }
        return null;
    }

    public static void syncWithAudioService(int position, boolean playing, long songId) {
        for (Map.Entry<UUID, LyricsDisplay> entry : playerLyrics.entrySet()) {
            String lastDisplayed;
            ServerPlayer player;
            UUID playerId = entry.getKey();
            LyricsDisplay display = entry.getValue();
            if (!playerLyricsEnabled.getOrDefault(playerId, false).booleanValue() || display.songId != songId || !playing) continue;
            String currentLyricBeforeUpdate = display.getCurrentLyric();
            display.updatePosition(position);
            String currentLyricAfterUpdate = display.getCurrentLyric();
            if (displayMode != DisplayMode.CHAT || currentLyricAfterUpdate.equals(currentLyricBeforeUpdate) || (player = LyricsService.getPlayerById(playerId)) == null || currentLyricAfterUpdate.equals(lastDisplayed = lastChatLyric.get(playerId))) continue;
            LyricsService.updateChatDisplay(player, display);
            lastChatLyric.put(playerId, currentLyricAfterUpdate);
        }
    }

    public static void updateAllDisplays() {
        for (Map.Entry<UUID, LyricsDisplay> entry : playerLyrics.entrySet()) {
            ServerPlayer player = LyricsService.getPlayerById(entry.getKey());
            LyricsDisplay display = entry.getValue();
            if (player == null || display == null || displayMode != DisplayMode.INVENTORY) continue;
            LyricsService.updateInventoryDisplay(player, display);
        }
    }

    public static void loadAndDisplayLyrics(ServerPlayer player, long songId) {
        try {
            JsonObject lyricResult;
            MusicService musicService = NeteaseCloudMusicAPI.getMusicService();
            if (musicService != null && (lyricResult = musicService.getLyric(songId)).has("code") && lyricResult.get("code").getAsInt() == 200) {
                JsonObject yrc;
                JsonObject lrc;
                String lrcContent = "";
                String yrcContent = "";
                if (lyricResult.has("lrc") && lyricResult.get("lrc").isJsonObject() && (lrc = lyricResult.get("lrc").getAsJsonObject()).has("lyric")) {
                    lrcContent = lrc.get("lyric").getAsString();
                }
                if (lyricResult.has("yrc") && lyricResult.get("yrc").isJsonObject() && (yrc = lyricResult.get("yrc").getAsJsonObject()).has("lyric")) {
                    yrcContent = yrc.get("lyric").getAsString();
                }
                List<LyricsParser.LyricLine> standardLyrics = LyricsParser.parseStandardLyrics(lrcContent);
                List<LyricsParser.WordLyric> wordLyrics = LyricsParser.parseWordLyrics(yrcContent);
                LyricsService.setLyricsForPlayer(player, songId, standardLyrics, wordLyrics);
            }
        }
        catch (Exception e) {
            System.err.println("\u52a0\u8f7d\u6b4c\u8bcd\u5931\u8d25: " + e.getMessage());
            player.m_6352_((Component)new TextComponent("\u00a7c\u52a0\u8f7d\u6b4c\u8bcd\u5931\u8d25"), player.m_142081_());
        }
    }

    public static class LyricsDisplay {
        private List<LyricsParser.LyricLine> lyrics;
        private List<LyricsParser.WordLyric> wordLyrics;
        private String currentLyric = "";
        private String previousLyric = "";
        private long songId;
        private int currentPosition = 0;

        public LyricsDisplay(long songId, List<LyricsParser.LyricLine> lyrics, List<LyricsParser.WordLyric> wordLyrics) {
            this.songId = songId;
            this.lyrics = lyrics;
            this.wordLyrics = wordLyrics;
        }

        public void updatePosition(int position) {
            this.currentPosition = position;
            String newLyric = LyricsParser.getCurrentLyric(this.lyrics, position);
            if (!newLyric.equals(this.currentLyric)) {
                this.previousLyric = this.currentLyric;
                this.currentLyric = newLyric;
            }
        }

        public String getCurrentLyric() {
            return this.currentLyric;
        }

        public String getPreviousLyric() {
            return this.previousLyric;
        }

        public List<String> getCurrentWords() {
            return LyricsParser.getCurrentWords(this.wordLyrics, this.currentPosition);
        }

        public boolean hasLyrics() {
            return this.lyrics != null && !this.lyrics.isEmpty();
        }
    }

    public static enum DisplayMode {
        INVENTORY,
        CHAT;

    }
}

