/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.service;

import celia.adwadg.ncm.util.HttpClientUtil;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;

public class MusicService {
    public JsonObject search(String keywords, int limit, int offset, int type) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("keywords", keywords);
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        params.put("type", String.valueOf(type));
        return HttpClientUtil.get("cloudsearch", params);
    }

    public JsonObject getSongDetail(long id) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ids", String.valueOf(id));
        return HttpClientUtil.get("song/detail", params);
    }

    public JsonObject getSongUrl(long id, int br) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        params.put("br", String.valueOf(br));
        return HttpClientUtil.get("song/url", params);
    }

    public JsonObject checkMusicAvailable(long id, int br) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        params.put("br", String.valueOf(br));
        return HttpClientUtil.get("check/music", params);
    }

    public JsonObject getLyric(long id) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        return HttpClientUtil.get("lyric", params);
    }

    public JsonObject getAlbum(long id) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        return HttpClientUtil.get("album", params);
    }

    public JsonObject getArtist(long id) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        return HttpClientUtil.get("artist", params);
    }

    public JsonObject getArtistSongs(long id, int limit, int offset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        return HttpClientUtil.get("artist/songs", params);
    }

    public JsonObject getArtistAlbums(long id, int limit, int offset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        return HttpClientUtil.get("artist/album", params);
    }

    public JsonObject getArtistMvs(long id, int limit, int offset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        return HttpClientUtil.get("artist/mv", params);
    }

    public JsonObject getPlaylistDetail(long id) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        return HttpClientUtil.get("playlist/detail", params);
    }

    public JsonObject getPlaylistSongs(long id, int limit, int offset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        return HttpClientUtil.get("playlist/track/all", params);
    }

    public JsonObject getDailyRecommendations() throws IOException {
        return HttpClientUtil.get("recommend/songs", null);
    }

    public JsonObject getPersonalizedPlaylists(int limit) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", String.valueOf(limit));
        return HttpClientUtil.get("personalized", params);
    }

    public JsonObject getNewSongs() throws IOException {
        return HttpClientUtil.get("top/song", null);
    }

    public JsonObject getTopList() throws IOException {
        return HttpClientUtil.get("toplist", null);
    }

    public JsonObject getTopListDetail() throws IOException {
        return HttpClientUtil.get("toplist/detail", null);
    }

    public JsonObject getSimilarSongs(long id) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        return HttpClientUtil.get("simi/song", params);
    }

    public JsonObject getSimilarPlaylists(long id) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        return HttpClientUtil.get("simi/playlist", params);
    }

    public JsonObject getComments(long id, int type, int limit, int offset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        params.put("type", String.valueOf(type));
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        return HttpClientUtil.get("comment/new", params);
    }

    public JsonObject likeSong(long id, boolean like) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        params.put("like", String.valueOf(like));
        return HttpClientUtil.get("like", params);
    }
}

