/*
 * Decompiled with CFR 0.152.
 */
package com.serveroptimiser;

import com.serveroptimiser.commands.AutoFillOpsCommand;
import com.serveroptimiser.commands.AutoFillPermsCommand;
import com.serveroptimiser.commands.ServerOptimiserCommand;
import com.serveroptimiser.commands.SystemStatsCommand;
import com.serveroptimiser.config.ConfigManager;
import com.serveroptimiser.libs.bstats.bukkit.Metrics;
import com.serveroptimiser.listeners.OptimizationListener;
import com.serveroptimiser.optimization.ChunkManager;
import com.serveroptimiser.optimization.EntityOptimizer;
import com.serveroptimiser.optimization.LagDetector;
import com.serveroptimiser.optimization.TPSManager;
import com.serveroptimiser.utils.PerformanceMonitor;
import com.serveroptimiser.utils.TaskScheduler;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ServerOptimiserPlugin
extends JavaPlugin {
    private ConfigManager configManager;
    private EntityOptimizer entityOptimizer;
    private ChunkManager chunkManager;
    private TPSManager tpsManager;
    private LagDetector lagDetector;
    private PerformanceMonitor performanceMonitor;
    private TaskScheduler taskScheduler;

    public void onEnable() {
        this.getLogger().info("ServerOptimiser v2 is starting up...");
        this.configManager = new ConfigManager(this);
        this.configManager.loadConfig();
        this.initializeOptimizationComponents();
        this.registerCommands();
        this.registerListeners();
        this.startBackgroundTasks();
        this.initializeBStats();
        this.getLogger().info("ServerOptimiser v2 has been enabled successfully!");
        this.getLogger().info("Use /serveroptimiser or /so for the master optimization command");
    }

    public void onDisable() {
        this.getLogger().info("ServerOptimiser v2 is shutting down...");
        if (this.taskScheduler != null) {
            this.taskScheduler.shutdown();
        }
        if (this.performanceMonitor != null) {
            this.performanceMonitor.stop();
        }
        this.getLogger().info("ServerOptimiser v2 has been disabled.");
    }

    private void initializeOptimizationComponents() {
        this.performanceMonitor = new PerformanceMonitor(this);
        this.taskScheduler = new TaskScheduler(this);
        this.entityOptimizer = new EntityOptimizer(this, this.configManager);
        this.chunkManager = new ChunkManager(this, this.configManager);
        this.tpsManager = new TPSManager(this, this.configManager, this.performanceMonitor);
        this.lagDetector = new LagDetector(this, this.configManager, this.performanceMonitor);
    }

    private void registerCommands() {
        this.getCommand("serveroptimiser").setExecutor((CommandExecutor)new ServerOptimiserCommand(this));
        this.getCommand("autofillops").setExecutor((CommandExecutor)new AutoFillOpsCommand(this, this.configManager));
        this.getCommand("autofillperms").setExecutor((CommandExecutor)new AutoFillPermsCommand(this, this.configManager));
        this.getCommand("obstats").setExecutor((CommandExecutor)new SystemStatsCommand(this));
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new OptimizationListener(this, this.entityOptimizer, this.chunkManager), (Plugin)this);
    }

    private void startBackgroundTasks() {
        this.performanceMonitor.start();
        this.taskScheduler.scheduleEntityOptimization(this.entityOptimizer);
        this.taskScheduler.scheduleChunkOptimization(this.chunkManager);
        this.taskScheduler.scheduleLagDetection(this.lagDetector);
        this.taskScheduler.scheduleTPSMonitoring(this.tpsManager);
    }

    private void initializeBStats() {
        try {
            Metrics metrics = new Metrics(this, 23157);
            if (this.configManager.isVerboseOutput()) {
                this.getLogger().info("bStats metrics initialized successfully");
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to initialize bStats: " + e.getMessage());
        }
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public EntityOptimizer getEntityOptimizer() {
        return this.entityOptimizer;
    }

    public ChunkManager getChunkManager() {
        return this.chunkManager;
    }

    public TPSManager getTpsManager() {
        return this.tpsManager;
    }

    public LagDetector getLagDetector() {
        return this.lagDetector;
    }

    public PerformanceMonitor getPerformanceMonitor() {
        return this.performanceMonitor;
    }

    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }
}

