/*
 * Decompiled with CFR 0.152.
 */
package com.serveroptimiser.commands;

import com.serveroptimiser.ServerOptimiserPlugin;
import com.serveroptimiser.config.ConfigManager;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.ServerOperator;

public class AutoFillOpsCommand
implements CommandExecutor {
    private final ServerOptimiserPlugin plugin;
    private final ConfigManager config;

    public AutoFillOpsCommand(ServerOptimiserPlugin plugin, ConfigManager config) {
        this.plugin = plugin;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("serveroptimiser.autofill.ops")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return true;
        }
        List<String> autoOpsPlayers = this.config.getAutoOpsPlayers();
        if (autoOpsPlayers.isEmpty()) {
            sender.sendMessage("\u00a7e[ServerOptimiser] No players configured for auto-ops. Check your config.yml");
            return true;
        }
        sender.sendMessage("\u00a7a[ServerOptimiser] Starting auto-fill for ops...");
        AtomicInteger addedOps = new AtomicInteger(0);
        AtomicInteger skippedOps = new AtomicInteger(0);
        for (String playerName : autoOpsPlayers) {
            if (playerName.trim().isEmpty()) continue;
            OfflinePlayer offlinePlayer = this.plugin.getServer().getOfflinePlayer(playerName);
            if (offlinePlayer.hasPlayedBefore() || offlinePlayer.isOnline()) {
                if (!offlinePlayer.isOp()) {
                    Player onlinePlayer;
                    offlinePlayer.setOp(true);
                    addedOps.incrementAndGet();
                    if (offlinePlayer.isOnline() && (onlinePlayer = offlinePlayer.getPlayer()) != null) {
                        onlinePlayer.sendMessage("\u00a7a[ServerOptimiser] You have been granted operator permissions.");
                    }
                    if (!this.config.isVerboseOutput()) continue;
                    this.plugin.getLogger().info("Auto-ops: Granted operator permissions to " + playerName);
                    continue;
                }
                skippedOps.incrementAndGet();
                continue;
            }
            this.plugin.getLogger().warning("Auto-ops: Player '" + playerName + "' not found or has never joined the server");
            skippedOps.incrementAndGet();
        }
        String resultMessage = String.format("\u00a7a[ServerOptimiser] Auto-ops completed. Added: %d, Skipped: %d", addedOps.get(), skippedOps.get());
        sender.sendMessage(resultMessage);
        if (addedOps.get() > 0 && addedOps.get() > 1) {
            String alertMessage = String.format("\u00a7e[ServerOptimiser] %s granted ops to %d player(s) via auto-fill", sender.getName(), addedOps.get());
            this.plugin.getServer().getOnlinePlayers().stream().filter(ServerOperator::isOp).filter(player -> !player.equals((Object)sender)).forEach(player -> player.sendMessage(alertMessage));
        }
        if (this.config.isAutoSyncServers()) {
            this.syncOpsAcrossServers(sender, autoOpsPlayers);
        }
        return true;
    }

    private void syncOpsAcrossServers(CommandSender sender, List<String> playerNames) {
        sender.sendMessage("\u00a7e[ServerOptimiser] Multi-server sync is configured but not yet implemented.");
        sender.sendMessage("\u00a77This feature requires BungeeCord/Velocity integration.");
        this.plugin.getLogger().info("Auto-ops sync requested for " + playerNames.size() + " players");
    }

    public void cleanupUnauthorizedOps(CommandSender sender) {
        if (!sender.hasPermission("serveroptimiser.autofill.cleanup")) {
            sender.sendMessage("\u00a7cYou don't have permission to cleanup ops.");
            return;
        }
        List<String> authorizedOps = this.config.getAutoOpsPlayers();
        AtomicInteger removedOps = new AtomicInteger(0);
        for (OfflinePlayer offlinePlayer : this.plugin.getServer().getOperators()) {
            Player onlinePlayer;
            String playerName = offlinePlayer.getName();
            if (playerName == null || authorizedOps.contains(playerName) || sender instanceof Player && playerName.equals(sender.getName())) continue;
            offlinePlayer.setOp(false);
            removedOps.incrementAndGet();
            if (offlinePlayer.isOnline() && (onlinePlayer = offlinePlayer.getPlayer()) != null) {
                onlinePlayer.sendMessage("\u00a7c[ServerOptimiser] Your operator permissions have been removed.");
            }
            if (!this.config.isVerboseOutput()) continue;
            this.plugin.getLogger().info("Auto-ops cleanup: Removed operator permissions from " + playerName);
        }
        if (removedOps.get() > 0) {
            sender.sendMessage(String.format("\u00a7a[ServerOptimiser] Cleaned up %d unauthorized ops.", removedOps.get()));
        } else {
            sender.sendMessage("\u00a7e[ServerOptimiser] No unauthorized ops found to clean up.");
        }
    }

    public void listOpsStatus(CommandSender sender) {
        List<String> authorizedOps = this.config.getAutoOpsPlayers();
        sender.sendMessage("\u00a7e[ServerOptimiser] Current Operators:");
        boolean hasOps = false;
        for (OfflinePlayer offlinePlayer : this.plugin.getServer().getOperators()) {
            String playerName = offlinePlayer.getName();
            if (playerName == null) continue;
            hasOps = true;
            boolean isAuthorized = authorizedOps.contains(playerName);
            String status = isAuthorized ? "\u00a7aAuthorized" : "\u00a7cUnauthorized";
            String onlineStatus = offlinePlayer.isOnline() ? "\u00a7aOnline" : "\u00a77Offline";
            sender.sendMessage(String.format("\u00a77- \u00a7f%s \u00a77(%s, %s)", playerName, status, onlineStatus));
        }
        if (!hasOps) {
            sender.sendMessage("\u00a77No operators found.");
        }
        sender.sendMessage("\u00a7e[ServerOptimiser] Configured auto-ops:");
        if (authorizedOps.isEmpty()) {
            sender.sendMessage("\u00a77No players configured for auto-ops.");
        } else {
            for (String playerName : authorizedOps) {
                boolean isCurrentlyOp = this.plugin.getServer().getOfflinePlayer(playerName).isOp();
                String status = isCurrentlyOp ? "\u00a7aIs Op" : "\u00a7cNot Op";
                sender.sendMessage(String.format("\u00a77- \u00a7f%s \u00a77(%s)", playerName, status));
            }
        }
    }
}

