/*
 * Decompiled with CFR 0.152.
 */
package com.serveroptimiser.commands;

import com.serveroptimiser.ServerOptimiserPlugin;
import com.serveroptimiser.config.ConfigManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class AutoFillPermsCommand
implements CommandExecutor {
    private final ServerOptimiserPlugin plugin;
    private final ConfigManager config;
    private final Map<String, String[]> predefinedGroups;

    public AutoFillPermsCommand(ServerOptimiserPlugin plugin, ConfigManager config) {
        this.plugin = plugin;
        this.config = config;
        this.predefinedGroups = this.initializePredefinedGroups();
    }

    private Map<String, String[]> initializePredefinedGroups() {
        HashMap<String, String[]> groups = new HashMap<String, String[]>();
        groups.put("admin", new String[]{"serveroptimiser.*", "bukkit.command.*", "minecraft.command.*", "worldedit.*", "worldguard.*", "essentials.*"});
        groups.put("moderator", new String[]{"serveroptimiser.basic", "essentials.kick", "essentials.ban", "essentials.mute", "essentials.tp", "essentials.tphere", "worldguard.region.*"});
        groups.put("helper", new String[]{"serveroptimiser.stats", "essentials.tp", "essentials.msg", "essentials.helpop", "worldguard.region.info"});
        groups.put("vip", new String[]{"essentials.sethome.multiple.3", "essentials.kit.vip", "essentials.fly", "essentials.nick"});
        groups.put("player", new String[]{"essentials.sethome", "essentials.home", "essentials.spawn", "essentials.kit.starter", "essentials.msg", "essentials.list"});
        return groups;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!sender.hasPermission("serveroptimiser.autofill.perms")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.runAutoFillFromConfig(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "list": {
                this.listPermissionGroups(sender);
                break;
            }
            case "apply": {
                if (args.length < 3) {
                    sender.sendMessage("\u00a7cUsage: /autofillperms apply <player> <group>");
                    return true;
                }
                this.applyGroupToPlayer(sender, args[1], args[2]);
                break;
            }
            case "remove": {
                if (args.length < 3) {
                    sender.sendMessage("\u00a7cUsage: /autofillperms remove <player> <group>");
                    return true;
                }
                this.removeGroupFromPlayer(sender, args[1], args[2]);
                break;
            }
            case "check": {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7cUsage: /autofillperms check <player>");
                    return true;
                }
                this.checkPlayerPermissions(sender, args[1]);
                break;
            }
            case "reload": {
                this.runAutoFillFromConfig(sender);
                break;
            }
            default: {
                sender.sendMessage("\u00a7cUnknown subcommand. Use: list, apply, remove, check, reload");
            }
        }
        return true;
    }

    private void runAutoFillFromConfig(CommandSender sender) {
        List<String> autoPermGroups = this.config.getAutoPermGroups();
        if (autoPermGroups.isEmpty()) {
            sender.sendMessage("\u00a7e[ServerOptimiser] No permission groups configured for auto-fill. Check your config.yml");
            return;
        }
        sender.sendMessage("\u00a7a[ServerOptimiser] Starting auto-fill for permissions...");
        AtomicInteger playersUpdated = new AtomicInteger(0);
        AtomicInteger permissionsAdded = new AtomicInteger(0);
        for (String groupEntry : autoPermGroups) {
            String groupName;
            if (groupEntry.trim().isEmpty()) continue;
            String[] parts = groupEntry.split(":");
            String playerName = null;
            if (parts.length == 2) {
                playerName = parts[0].trim();
                groupName = parts[1].trim();
            } else {
                groupName = parts[0].trim();
            }
            if (playerName != null) {
                int added;
                Player player = this.plugin.getServer().getPlayer(playerName);
                if (player == null || (added = this.applyGroupPermissions(player, groupName)) <= 0) continue;
                playersUpdated.incrementAndGet();
                permissionsAdded.addAndGet(added);
                continue;
            }
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                int added = this.applyGroupPermissions(player, groupName);
                if (added <= 0) continue;
                playersUpdated.incrementAndGet();
                permissionsAdded.addAndGet(added);
            }
        }
        String resultMessage = String.format("\u00a7a[ServerOptimiser] Auto-perms completed. Players updated: %d, Permissions added: %d", playersUpdated.get(), permissionsAdded.get());
        sender.sendMessage(resultMessage);
        if (this.config.isAutoSyncServers()) {
            sender.sendMessage("\u00a7e[ServerOptimiser] Multi-server permission sync is configured but not yet implemented.");
        }
    }

    private int applyGroupPermissions(Player player, String groupName) {
        String[] permissions = this.predefinedGroups.get(groupName.toLowerCase());
        if (permissions == null) {
            if (this.config.isVerboseOutput()) {
                this.plugin.getLogger().warning("Unknown permission group: " + groupName);
            }
            return 0;
        }
        PermissionAttachment attachment = player.addAttachment((Plugin)this.plugin);
        int added = 0;
        for (String permission : permissions) {
            if (player.hasPermission(permission)) continue;
            attachment.setPermission(permission, true);
            ++added;
        }
        if (added > 0) {
            player.sendMessage(String.format("\u00a7a[ServerOptimiser] You have been granted %d permissions from group '%s'", added, groupName));
            if (this.config.isVerboseOutput()) {
                this.plugin.getLogger().info(String.format("Auto-perms: Applied group '%s' to player '%s' (%d permissions)", groupName, player.getName(), added));
            }
        }
        return added;
    }

    private void applyGroupToPlayer(CommandSender sender, String playerName, String groupName) {
        Player player = this.plugin.getServer().getPlayer(playerName);
        if (player == null) {
            sender.sendMessage("\u00a7c[ServerOptimiser] Player '" + playerName + "' is not online.");
            return;
        }
        int added = this.applyGroupPermissions(player, groupName);
        if (added > 0) {
            sender.sendMessage(String.format("\u00a7a[ServerOptimiser] Applied group '%s' to player '%s' (%d permissions)", groupName, playerName, added));
        } else {
            sender.sendMessage(String.format("\u00a7e[ServerOptimiser] No new permissions added to player '%s' from group '%s'", playerName, groupName));
        }
    }

    private void removeGroupFromPlayer(CommandSender sender, String playerName, String groupName) {
        Player player = this.plugin.getServer().getPlayer(playerName);
        if (player == null) {
            sender.sendMessage("\u00a7c[ServerOptimiser] Player '" + playerName + "' is not online.");
            return;
        }
        String[] permissions = this.predefinedGroups.get(groupName.toLowerCase());
        if (permissions == null) {
            sender.sendMessage("\u00a7c[ServerOptimiser] Unknown permission group: " + groupName);
            if (this.config.isVerboseOutput()) {
                this.plugin.getLogger().warning("Unknown permission group: " + groupName);
            }
            return;
        }
        PermissionAttachment attachment = player.addAttachment((Plugin)this.plugin);
        int removed = 0;
        for (String permission : permissions) {
            if (!player.hasPermission(permission)) continue;
            attachment.setPermission(permission, false);
            ++removed;
        }
        sender.sendMessage(String.format("\u00a7a[ServerOptimiser] Removed group '%s' from player '%s' (%d permissions)", groupName, playerName, removed));
        if (removed > 0) {
            player.sendMessage(String.format("\u00a7c[ServerOptimiser] %d permissions have been removed from group '%s'", removed, groupName));
        }
    }

    private void checkPlayerPermissions(CommandSender sender, String playerName) {
        Player player = this.plugin.getServer().getPlayer(playerName);
        if (player == null) {
            sender.sendMessage("\u00a7c[ServerOptimiser] Player '" + playerName + "' is not online.");
            return;
        }
        sender.sendMessage("\u00a7e[ServerOptimiser] Permission check for " + playerName + ":");
        for (Map.Entry<String, String[]> group : this.predefinedGroups.entrySet()) {
            String groupName = group.getKey();
            String[] permissions = group.getValue();
            int hasCount = 0;
            for (String permission : permissions) {
                if (!player.hasPermission(permission)) continue;
                ++hasCount;
            }
            if (hasCount <= 0) continue;
            String status = hasCount == permissions.length ? "\u00a7aFull" : "\u00a7ePartial";
            sender.sendMessage(String.format("\u00a77- %s: %s \u00a77(%d/%d)", groupName, status, hasCount, permissions.length));
        }
        sender.sendMessage(String.format("\u00a77Total effective permissions: %d", player.getEffectivePermissions().size()));
    }

    private void listPermissionGroups(CommandSender sender) {
        sender.sendMessage("\u00a7e[ServerOptimiser] Available Permission Groups:");
        for (Map.Entry<String, String[]> group : this.predefinedGroups.entrySet()) {
            String groupName = group.getKey();
            int permCount = group.getValue().length;
            sender.sendMessage(String.format("\u00a77- \u00a7f%s \u00a77(%d permissions)", groupName, permCount));
        }
        sender.sendMessage("\u00a77Use '/autofillperms apply <player> <group>' to apply a group");
        sender.sendMessage("\u00a77Use '/autofillperms check <player>' to check player permissions");
    }
}

