/*
 * Decompiled with CFR 0.152.
 */
package com.serveroptimiser.commands;

import com.serveroptimiser.ServerOptimiserPlugin;
import com.serveroptimiser.commands.AutoFillOpsCommand;
import com.serveroptimiser.commands.AutoFillPermsCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ServerOptimiserCommand
implements CommandExecutor,
TabCompleter {
    private final ServerOptimiserPlugin plugin;

    public ServerOptimiserCommand(ServerOptimiserPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!sender.hasPermission("serveroptimiser.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.runFullOptimization(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "full": 
            case "all": {
                this.runFullOptimization(sender);
                break;
            }
            case "entities": {
                this.runEntityOptimization(sender);
                break;
            }
            case "chunks": {
                this.runChunkOptimization(sender);
                break;
            }
            case "tps": {
                this.handleTPSCommand(sender, args);
                break;
            }
            case "lag": {
                this.runLagDetection(sender);
                break;
            }
            case "autofill": {
                this.runAutoFill(sender);
                break;
            }
            case "stats": 
            case "status": {
                this.showStats(sender);
                break;
            }
            case "reload": {
                this.reloadConfig(sender);
                break;
            }
            case "help": {
                this.showHelp(sender);
                break;
            }
            default: {
                sender.sendMessage("\u00a7cUnknown subcommand. Use '/so help' for available commands.");
            }
        }
        return true;
    }

    private void runFullOptimization(final CommandSender sender) {
        sender.sendMessage("\u00a7a[ServerOptimiser] Starting full server optimization...");
        new BukkitRunnable(){

            public void run() {
                long startTime = System.currentTimeMillis();
                ServerOptimiserCommand.this.plugin.getEntityOptimizer().optimizeEntities();
                ServerOptimiserCommand.this.plugin.getChunkManager().optimizeChunks();
                ServerOptimiserCommand.this.plugin.getTpsManager().forceOptimization();
                ServerOptimiserCommand.this.plugin.getLagDetector().triggerLagDetection();
                if (ServerOptimiserCommand.this.plugin.getConfigManager().isFullOptimizationDefault()) {
                    new AutoFillOpsCommand(ServerOptimiserCommand.this.plugin, ServerOptimiserCommand.this.plugin.getConfigManager()).onCommand(sender, null, null, new String[0]);
                    new AutoFillPermsCommand(ServerOptimiserCommand.this.plugin, ServerOptimiserCommand.this.plugin.getConfigManager()).onCommand(sender, null, null, new String[0]);
                }
                final long duration = System.currentTimeMillis() - startTime;
                new BukkitRunnable(){

                    public void run() {
                        sender.sendMessage(String.format("\u00a7a[ServerOptimiser] Full optimization completed in %dms", duration));
                        if (ServerOptimiserCommand.this.plugin.getConfigManager().isVerboseOutput()) {
                            sender.sendMessage("\u00a77- Entities optimized: " + ServerOptimiserCommand.this.plugin.getEntityOptimizer().getTotalEntitiesRemoved());
                            sender.sendMessage("\u00a77- Chunks unloaded: " + ServerOptimiserCommand.this.plugin.getChunkManager().getTotalChunksUnloaded());
                            sender.sendMessage("\u00a77- TPS adjustments: " + ServerOptimiserCommand.this.plugin.getTpsManager().getTotalAdjustmentsMade());
                        }
                    }
                }.runTask((Plugin)ServerOptimiserCommand.this.plugin);
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private void runEntityOptimization(final CommandSender sender) {
        sender.sendMessage("\u00a7a[ServerOptimiser] Optimizing entities...");
        new BukkitRunnable(){

            public void run() {
                ServerOptimiserCommand.this.plugin.getEntityOptimizer().optimizeEntities();
                ServerOptimiserCommand.this.plugin.getEntityOptimizer().optimizeEntityAI();
                new BukkitRunnable(){

                    public void run() {
                        sender.sendMessage("\u00a7a[ServerOptimiser] Entity optimization completed.");
                    }
                }.runTask((Plugin)ServerOptimiserCommand.this.plugin);
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private void runChunkOptimization(final CommandSender sender) {
        sender.sendMessage("\u00a7a[ServerOptimiser] Optimizing chunks...");
        new BukkitRunnable(){

            public void run() {
                ServerOptimiserCommand.this.plugin.getChunkManager().optimizeChunks();
                ServerOptimiserCommand.this.plugin.getChunkManager().preloadPlayerChunks();
                new BukkitRunnable(){

                    public void run() {
                        sender.sendMessage("\u00a7a[ServerOptimiser] Chunk optimization completed.");
                    }
                }.runTask((Plugin)ServerOptimiserCommand.this.plugin);
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private void handleTPSCommand(CommandSender sender, String[] args) {
        if (args.length == 1) {
            double currentTPS = this.plugin.getPerformanceMonitor().getCurrentTPS();
            double targetTPS = this.plugin.getTpsManager().getCurrentTPSTarget();
            boolean throttling = this.plugin.getTpsManager().isThrottling();
            sender.sendMessage("\u00a7e[ServerOptimiser] TPS Status:");
            sender.sendMessage(String.format("\u00a77Current TPS: \u00a7f%.2f", currentTPS));
            sender.sendMessage(String.format("\u00a77Target TPS: \u00a7f%.1f", targetTPS));
            sender.sendMessage(String.format("\u00a77Throttling: \u00a7f%s", throttling ? "ON" : "OFF"));
            sender.sendMessage(String.format("\u00a77Manual Limit: \u00a7f%s", this.plugin.getTpsManager().isManuallyLimited() ? "ON" : "OFF"));
            return;
        }
        if (args[1].equalsIgnoreCase("optimize")) {
            sender.sendMessage("\u00a7a[ServerOptimiser] Forcing TPS optimization...");
            this.plugin.getTpsManager().forceOptimization();
            return;
        }
        if (args[1].equalsIgnoreCase("reset")) {
            this.plugin.getTpsManager().resetTPS();
            sender.sendMessage("\u00a7a[ServerOptimiser] TPS reset to normal (20 TPS)");
            return;
        }
        try {
            double targetTPS = Double.parseDouble(args[1]);
            if (this.plugin.getTpsManager().setTPSTarget(targetTPS)) {
                if (targetTPS < 20.0) {
                    sender.sendMessage(String.format("\u00a7a[ServerOptimiser] TPS limited to %.1f to save CPU usage", targetTPS));
                } else {
                    sender.sendMessage(String.format("\u00a7a[ServerOptimiser] TPS set to %.1f (normal)", targetTPS));
                }
            } else {
                sender.sendMessage("\u00a7cInvalid TPS value. Must be between " + this.plugin.getConfigManager().getMinTPS() + " and " + this.plugin.getConfigManager().getMaxTPS());
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid TPS value. Use a number between 5 and 20, or 'reset' to restore normal TPS.");
        }
    }

    private void runLagDetection(final CommandSender sender) {
        sender.sendMessage("\u00a7a[ServerOptimiser] Running lag detection...");
        this.plugin.getLagDetector().triggerLagDetection();
        new BukkitRunnable(){

            public void run() {
                sender.sendMessage(ServerOptimiserCommand.this.plugin.getLagDetector().getLagReport());
            }
        }.runTaskLater((Plugin)this.plugin, 40L);
    }

    private void runAutoFill(CommandSender sender) {
        sender.sendMessage("\u00a7a[ServerOptimiser] Running auto-fill for ops and permissions...");
        new AutoFillOpsCommand(this.plugin, this.plugin.getConfigManager()).onCommand(sender, null, null, new String[0]);
        new AutoFillPermsCommand(this.plugin, this.plugin.getConfigManager()).onCommand(sender, null, null, new String[0]);
    }

    private void showStats(CommandSender sender) {
        sender.sendMessage("\u00a7e[ServerOptimiser] Performance Statistics:");
        sender.sendMessage(String.format("\u00a77Current TPS: \u00a7f%.2f", this.plugin.getPerformanceMonitor().getCurrentTPS()));
        sender.sendMessage(String.format("\u00a77Memory Usage: \u00a7f%.1f MB", this.plugin.getPerformanceMonitor().getMemoryUsage()));
        sender.sendMessage(String.format("\u00a77Entities Removed: \u00a7f%d", this.plugin.getEntityOptimizer().getTotalEntitiesRemoved()));
        sender.sendMessage(String.format("\u00a77Chunks Unloaded: \u00a7f%d", this.plugin.getChunkManager().getTotalChunksUnloaded()));
        sender.sendMessage(String.format("\u00a77TPS Adjustments: \u00a7f%d", this.plugin.getTpsManager().getTotalAdjustmentsMade()));
        sender.sendMessage(String.format("\u00a77Lag Detections: \u00a7f%d", this.plugin.getLagDetector().getTotalLagDetections()));
        sender.sendMessage(String.format("\u00a77Loaded Worlds: \u00a7f%d", this.plugin.getServer().getWorlds().size()));
        sender.sendMessage(String.format("\u00a77Online Players: \u00a7f%d", this.plugin.getServer().getOnlinePlayers().size()));
    }

    private void reloadConfig(CommandSender sender) {
        sender.sendMessage("\u00a7a[ServerOptimiser] Reloading configuration...");
        this.plugin.getConfigManager().reloadConfiguration();
        sender.sendMessage("\u00a7a[ServerOptimiser] Configuration reloaded successfully.");
    }

    private void showHelp(CommandSender sender) {
        sender.sendMessage("\u00a7e[ServerOptimiser] Available Commands:");
        sender.sendMessage("\u00a77/so \u00a7f- Run full optimization");
        sender.sendMessage("\u00a77/so full \u00a7f- Run full optimization");
        sender.sendMessage("\u00a77/so entities \u00a7f- Optimize entities only");
        sender.sendMessage("\u00a77/so chunks \u00a7f- Optimize chunks only");
        sender.sendMessage("\u00a77/so tps \u00a7f- Show TPS status");
        sender.sendMessage("\u00a77/so tps <value> \u00a7f- Limit TPS to save CPU (5-20)");
        sender.sendMessage("\u00a77/so tps reset \u00a7f- Reset TPS to normal (20)");
        sender.sendMessage("\u00a77/so tps optimize \u00a7f- Force TPS optimization");
        sender.sendMessage("\u00a77/so lag \u00a7f- Run lag detection");
        sender.sendMessage("\u00a77/so autofill \u00a7f- Run auto-fill for ops/perms");
        sender.sendMessage("\u00a77/so stats \u00a7f- Show performance statistics");
        sender.sendMessage("\u00a77/so reload \u00a7f- Reload configuration");
        sender.sendMessage("\u00a77/so help \u00a7f- Show this help");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("serveroptimiser.admin")) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            return Arrays.asList("full", "entities", "chunks", "tps", "lag", "autofill", "stats", "reload", "help");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("tps")) {
            return Arrays.asList("optimize", "reset", "5", "10", "12", "15", "18", "20");
        }
        return new ArrayList<String>();
    }
}

