/*
 * Decompiled with CFR 0.152.
 */
package com.serveroptimiser.commands;

import com.serveroptimiser.ServerOptimiserPlugin;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class SystemStatsCommand
implements CommandExecutor {
    private final ServerOptimiserPlugin plugin;

    public SystemStatsCommand(ServerOptimiserPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("serveroptimiser.stats")) {
            sender.sendMessage("\u00a7cYou don't have permission to view system statistics.");
            return true;
        }
        sender.sendMessage("\u00a7e[ServerOptimiser] System Statistics:");
        sender.sendMessage("\u00a77" + "=".repeat(45));
        this.showCPUStats(sender);
        this.showRAMStats(sender);
        this.showStorageStats(sender);
        this.showServerStats(sender);
        sender.sendMessage("\u00a77" + "=".repeat(45));
        return true;
    }

    private void showCPUStats(CommandSender sender) {
        java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        String cpuModel = System.getProperty("os.name") + " " + System.getProperty("os.arch");
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        double cpuUsage = -1.0;
        if (osBean instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean sunOsBean = (OperatingSystemMXBean)osBean;
            cpuUsage = sunOsBean.getProcessCpuLoad() * 100.0;
        }
        sender.sendMessage("\u00a76CPU Information:");
        sender.sendMessage("\u00a77  Model: \u00a7f" + cpuModel);
        sender.sendMessage("\u00a77  Cores: \u00a7f" + availableProcessors);
        if (cpuUsage >= 0.0) {
            String cpuColor = cpuUsage > 80.0 ? "\u00a7c" : (cpuUsage > 60.0 ? "\u00a7e" : "\u00a7a");
            sender.sendMessage("\u00a77  Usage: " + cpuColor + String.format("%.1f%%", cpuUsage));
        } else {
            sender.sendMessage("\u00a77  Usage: \u00a78N/A");
        }
    }

    private void showRAMStats(CommandSender sender) {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        double usedGB = (double)usedMemory / 1.073741824E9;
        double maxGB = (double)maxMemory / 1.073741824E9;
        double usagePercent = (double)usedMemory * 100.0 / (double)maxMemory;
        String ramColor = usagePercent > 85.0 ? "\u00a7c" : (usagePercent > 70.0 ? "\u00a7e" : "\u00a7a");
        sender.sendMessage("\u00a76RAM Information:");
        sender.sendMessage("\u00a77  Used: " + ramColor + String.format("%.2f GB", usedGB));
        sender.sendMessage("\u00a77  Max: \u00a7f" + String.format("%.2f GB", maxGB));
        sender.sendMessage("\u00a77  Usage: " + ramColor + String.format("%.1f%%", usagePercent));
    }

    private void showStorageStats(CommandSender sender) {
        File serverDir = new File(".");
        long totalSpace = serverDir.getTotalSpace();
        long freeSpace = serverDir.getFreeSpace();
        long usedSpace = totalSpace - freeSpace;
        double usedGB = (double)usedSpace / 1.073741824E9;
        double totalGB = (double)totalSpace / 1.073741824E9;
        double usagePercent = (double)usedSpace * 100.0 / (double)totalSpace;
        String storageColor = usagePercent > 90.0 ? "\u00a7c" : (usagePercent > 80.0 ? "\u00a7e" : "\u00a7a");
        sender.sendMessage("\u00a76Storage Information:");
        sender.sendMessage("\u00a77  Used: " + storageColor + String.format("%.2f GB", usedGB));
        sender.sendMessage("\u00a77  Total: \u00a7f" + String.format("%.2f GB", totalGB));
        sender.sendMessage("\u00a77  Usage: " + storageColor + String.format("%.1f%%", usagePercent));
    }

    private void showServerStats(CommandSender sender) {
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        long uptime = runtimeBean.getUptime();
        long hours = uptime / 3600000L;
        long minutes = uptime % 3600000L / 60000L;
        double currentTPS = this.plugin.getPerformanceMonitor().getCurrentTPS();
        String tpsColor = currentTPS >= 19.5 ? "\u00a7a" : (currentTPS >= 18.0 ? "\u00a7e" : "\u00a7c");
        sender.sendMessage("\u00a76Server Information:");
        sender.sendMessage("\u00a77  Uptime: \u00a7f" + hours + "h " + minutes + "m");
        sender.sendMessage("\u00a77  TPS: " + tpsColor + String.format("%.2f", currentTPS));
        sender.sendMessage("\u00a77  Players: \u00a7f" + this.plugin.getServer().getOnlinePlayers().size());
        sender.sendMessage("\u00a77  Worlds: \u00a7f" + this.plugin.getServer().getWorlds().size());
    }
}

