/*
 * Decompiled with CFR 0.152.
 */
package com.serveroptimiser.config;

import com.serveroptimiser.ServerOptimiserPlugin;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final ServerOptimiserPlugin plugin;
    private FileConfiguration config;

    public ConfigManager(ServerOptimiserPlugin plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.plugin.getLogger().info("Configuration loaded with safe defaults");
    }

    public int getMaxMobsPerChunk() {
        return this.config.getInt("entity-optimization.max-mobs-per-chunk", 50);
    }

    public int getMaxAnimalsPerChunk() {
        return this.config.getInt("entity-optimization.max-animals-per-chunk", 30);
    }

    public boolean isAsyncAIEnabled() {
        return this.config.getBoolean("entity-optimization.async-ai-enabled", true);
    }

    public int getEntityDespawnTimer() {
        return this.config.getInt("entity-optimization.despawn-timer-minutes", 5);
    }

    public boolean isAutoRemoveInvisibleEntities() {
        return this.config.getBoolean("entity-optimization.auto-remove-invisible", true);
    }

    public int getChunkUnloadDelay() {
        return this.config.getInt("chunk-management.unload-delay-minutes", 10);
    }

    public int getMaxLoadedChunks() {
        return this.config.getInt("chunk-management.max-loaded-chunks", 2000);
    }

    public boolean isSmartCachingEnabled() {
        return this.config.getBoolean("chunk-management.smart-caching", true);
    }

    public double getMinTPS() {
        return Math.max(5.0, this.config.getDouble("tps-management.min-tps", 15.0));
    }

    public double getMaxTPS() {
        return Math.min(20.0, this.config.getDouble("tps-management.max-tps", 20.0));
    }

    public boolean isAutoTickAdjustment() {
        return this.config.getBoolean("tps-management.auto-tick-adjustment", true);
    }

    public int getTickCheckInterval() {
        return this.config.getInt("tps-management.check-interval-seconds", 30);
    }

    public double getLagThreshold() {
        return this.config.getDouble("lag-detection.tps-threshold", 18.0);
    }

    public boolean isAutoKillLagSources() {
        return this.config.getBoolean("lag-detection.auto-kill-lag-sources", false);
    }

    public boolean isAlertAdmins() {
        return this.config.getBoolean("lag-detection.alert-admins", true);
    }

    public int getLagCheckInterval() {
        return this.config.getInt("lag-detection.check-interval-seconds", 60);
    }

    public List<String> getAutoOpsPlayers() {
        return this.config.getStringList("auto-fill.ops-players");
    }

    public List<String> getAutoPermGroups() {
        return this.config.getStringList("auto-fill.permission-groups");
    }

    public boolean isAutoSyncServers() {
        return this.config.getBoolean("auto-fill.sync-across-servers", false);
    }

    public int getItemCleanupRadius() {
        return this.config.getInt("cleanup.item-cleanup-radius", 100);
    }

    public int getItemMaxAge() {
        return this.config.getInt("cleanup.item-max-age-minutes", 10);
    }

    public int getMaxTileEntitiesPerChunk() {
        return this.config.getInt("cleanup.max-tile-entities-per-chunk", 64);
    }

    public boolean isFullOptimizationDefault() {
        return this.config.getBoolean("master-command.full-optimization-default", true);
    }

    public boolean isVerboseOutput() {
        return this.config.getBoolean("master-command.verbose-output", true);
    }

    public void reloadConfiguration() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.plugin.getLogger().info("Configuration reloaded");
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

