/*
 * Decompiled with CFR 0.152.
 */
package com.serveroptimiser.listeners;

import com.serveroptimiser.ServerOptimiserPlugin;
import com.serveroptimiser.optimization.ChunkManager;
import com.serveroptimiser.optimization.EntityOptimizer;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class OptimizationListener
implements Listener {
    private final ServerOptimiserPlugin plugin;
    private final EntityOptimizer entityOptimizer;
    private final ChunkManager chunkManager;

    public OptimizationListener(ServerOptimiserPlugin plugin, EntityOptimizer entityOptimizer, ChunkManager chunkManager) {
        this.plugin = plugin;
        this.entityOptimizer = entityOptimizer;
        this.chunkManager = chunkManager;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChunkLoad(final ChunkLoadEvent event) {
        this.chunkManager.updateChunkAccess(event.getChunk());
        new BukkitRunnable(){

            public void run() {
                if (event.getWorld().getLoadedChunks().length > OptimizationListener.this.plugin.getConfigManager().getMaxLoadedChunks()) {
                    OptimizationListener.this.chunkManager.optimizeChunks();
                }
            }
        }.runTaskLater((Plugin)this.plugin, 20L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChunkUnload(ChunkUnloadEvent event) {
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntitySpawn(final EntitySpawnEvent event) {
        new BukkitRunnable(){

            public void run() {
                int entityCount = event.getLocation().getChunk().getEntities().length;
                if (entityCount > OptimizationListener.this.plugin.getConfigManager().getMaxMobsPerChunk() + OptimizationListener.this.plugin.getConfigManager().getMaxAnimalsPerChunk()) {
                    OptimizationListener.this.entityOptimizer.optimizeEntities();
                }
            }
        }.runTaskLater((Plugin)this.plugin, 10L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getFrom().getChunk().equals((Object)event.getTo().getChunk())) {
            return;
        }
        this.chunkManager.updateChunkAccess(event.getTo().getChunk());
        if (event.getFrom().distance(event.getTo()) > 10.0) {
            new BukkitRunnable(){

                public void run() {
                    OptimizationListener.this.chunkManager.preloadPlayerChunks();
                }
            }.runTaskLater((Plugin)this.plugin, 5L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onItemSpawn(ItemSpawnEvent event) {
        new BukkitRunnable(){

            public void run() {
                OptimizationListener.this.cleanupExcessItems();
            }
        }.runTaskLater((Plugin)this.plugin, 100L);
    }

    private void cleanupExcessItems() {
        this.plugin.getServer().getWorlds().forEach(world -> world.getEntitiesByClass(Item.class).forEach(item -> {
            if (item.getTicksLived() > this.plugin.getConfigManager().getItemMaxAge() * 60 * 20) {
                item.remove();
                return;
            }
            boolean playerNearby = world.getPlayers().stream().anyMatch(player -> player.getLocation().distance(item.getLocation()) < (double)this.plugin.getConfigManager().getItemCleanupRadius());
            if (!playerNearby && item.getTicksLived() > 1200) {
                item.remove();
            }
        }));
    }
}

