/*
 * Decompiled with CFR 0.152.
 */
package com.serveroptimiser.optimization;

import com.serveroptimiser.ServerOptimiserPlugin;
import com.serveroptimiser.config.ConfigManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChunkManager {
    private final ServerOptimiserPlugin plugin;
    private final ConfigManager config;
    private final Map<Chunk, Long> chunkLastAccessed;
    private final Set<Chunk> chunksToUnload;
    private final AtomicInteger chunksUnloaded;

    public ChunkManager(ServerOptimiserPlugin plugin, ConfigManager config) {
        this.plugin = plugin;
        this.config = config;
        this.chunkLastAccessed = new ConcurrentHashMap<Chunk, Long>();
        this.chunksToUnload = ConcurrentHashMap.newKeySet();
        this.chunksUnloaded = new AtomicInteger(0);
    }

    public void optimizeChunks() {
        new BukkitRunnable(){

            public void run() {
                int totalUnloaded = 0;
                for (World world : ChunkManager.this.plugin.getServer().getWorlds()) {
                    totalUnloaded += ChunkManager.this.optimizeWorldChunks(world);
                }
                if (totalUnloaded > 0 && ChunkManager.this.config.isVerboseOutput()) {
                    ChunkManager.this.plugin.getLogger().info("Chunk optimization completed. Unloaded " + totalUnloaded + " chunks.");
                }
                ChunkManager.this.chunksUnloaded.addAndGet(totalUnloaded);
            }
        }.runTask((Plugin)this.plugin);
    }

    private int optimizeWorldChunks(World world) {
        Chunk[] loadedChunks = world.getLoadedChunks();
        int unloaded = 0;
        if (loadedChunks.length > this.config.getMaxLoadedChunks()) {
            unloaded += this.unloadExcessChunks(world, loadedChunks);
        }
        this.optimizeTileEntities(loadedChunks);
        return unloaded += this.unloadUnusedChunks(world, loadedChunks);
    }

    private int unloadExcessChunks(World world, Chunk[] loadedChunks) {
        int unloaded = 0;
        int toUnload = loadedChunks.length - this.config.getMaxLoadedChunks();
        ArrayList<Chunk> sortedChunks = new ArrayList<Chunk>(Arrays.asList(loadedChunks));
        sortedChunks.sort((c1, c2) -> {
            long time1 = this.chunkLastAccessed.getOrDefault(c1, 0L);
            long time2 = this.chunkLastAccessed.getOrDefault(c2, 0L);
            return Long.compare(time1, time2);
        });
        for (final Chunk chunk : sortedChunks) {
            if (unloaded >= toUnload) break;
            if (!this.canUnloadChunk(chunk)) continue;
            new BukkitRunnable(this){

                public void run() {
                    if (chunk.isLoaded()) {
                        chunk.unload(true);
                    }
                }
            }.runTask((Plugin)this.plugin);
            ++unloaded;
        }
        return unloaded;
    }

    private int unloadUnusedChunks(World world, Chunk[] loadedChunks) {
        int unloaded = 0;
        long currentTime = System.currentTimeMillis();
        long unloadDelay = (long)(this.config.getChunkUnloadDelay() * 60) * 1000L;
        for (final Chunk chunk : loadedChunks) {
            long lastAccessed = this.chunkLastAccessed.getOrDefault(chunk, currentTime);
            if (currentTime - lastAccessed <= unloadDelay || !this.canUnloadChunk(chunk)) continue;
            new BukkitRunnable(this){

                public void run() {
                    if (chunk.isLoaded()) {
                        chunk.unload(true);
                    }
                }
            }.runTask((Plugin)this.plugin);
            this.chunkLastAccessed.remove(chunk);
            ++unloaded;
        }
        return unloaded;
    }

    private boolean canUnloadChunk(Chunk chunk) {
        for (Player player : chunk.getWorld().getPlayers()) {
            if (!player.getLocation().getChunk().equals((Object)chunk) && !this.isChunkNearby(player.getLocation().getChunk(), chunk, 2)) continue;
            return false;
        }
        World world = chunk.getWorld();
        Chunk spawnChunk = world.getSpawnLocation().getChunk();
        return !this.isChunkNearby(chunk, spawnChunk, 5);
    }

    private boolean isChunkNearby(Chunk chunk1, Chunk chunk2, int radius) {
        int deltaX = Math.abs(chunk1.getX() - chunk2.getX());
        int deltaZ = Math.abs(chunk1.getZ() - chunk2.getZ());
        return deltaX <= radius && deltaZ <= radius;
    }

    private void optimizeTileEntities(Chunk[] chunks) {
        if (!this.plugin.getServer().isPrimaryThread()) {
            return;
        }
        for (Chunk chunk : chunks) {
            try {
                BlockState[] tileEntities = chunk.getTileEntities();
                if (tileEntities.length <= this.config.getMaxTileEntitiesPerChunk()) continue;
                this.optimizeChunkTileEntities(chunk, tileEntities);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
    }

    private void optimizeChunkTileEntities(Chunk chunk, BlockState[] tileEntities) {
        int toRemove = tileEntities.length - this.config.getMaxTileEntitiesPerChunk();
        int removed = 0;
        for (final BlockState tileEntity : tileEntities) {
            if (removed >= toRemove) break;
            if (!(tileEntity instanceof TileState) || !this.isRemovableTileEntity(tileEntity)) continue;
            new BukkitRunnable(this){

                public void run() {
                    tileEntity.getBlock().breakNaturally();
                }
            }.runTask((Plugin)this.plugin);
            ++removed;
        }
    }

    private boolean isRemovableTileEntity(BlockState tileEntity) {
        return false;
    }

    public void updateChunkAccess(Chunk chunk) {
        if (this.config.isSmartCachingEnabled()) {
            this.chunkLastAccessed.put(chunk, System.currentTimeMillis());
        }
    }

    public void preloadPlayerChunks() {
        new BukkitRunnable(){

            public void run() {
                for (World world : ChunkManager.this.plugin.getServer().getWorlds()) {
                    for (Player player : world.getPlayers()) {
                        Chunk playerChunk = player.getLocation().getChunk();
                        for (int x = -1; x <= 1; ++x) {
                            for (int z = -1; z <= 1; ++z) {
                                int chunkZ;
                                int chunkX = playerChunk.getX() + x;
                                if (world.isChunkLoaded(chunkX, chunkZ = playerChunk.getZ() + z)) continue;
                                world.loadChunk(chunkX, chunkZ);
                                ChunkManager.this.updateChunkAccess(world.getChunkAt(chunkX, chunkZ));
                            }
                        }
                    }
                }
            }
        }.runTask((Plugin)this.plugin);
    }

    public Map<Chunk, Long> getChunkAccessTimes() {
        return new HashMap<Chunk, Long>(this.chunkLastAccessed);
    }

    public int getTotalChunksUnloaded() {
        return this.chunksUnloaded.get();
    }

    public void resetStats() {
        this.chunksUnloaded.set(0);
    }
}

