/*
 * Decompiled with CFR 0.152.
 */
package com.serveroptimiser.optimization;

import com.serveroptimiser.ServerOptimiserPlugin;
import com.serveroptimiser.config.ConfigManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Animals;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EntityOptimizer {
    private final ServerOptimiserPlugin plugin;
    private final ConfigManager config;
    private final Map<Chunk, Integer> chunkEntityCounts;
    private final AtomicInteger entitiesRemoved;

    public EntityOptimizer(ServerOptimiserPlugin plugin, ConfigManager config) {
        this.plugin = plugin;
        this.config = config;
        this.chunkEntityCounts = new HashMap<Chunk, Integer>();
        this.entitiesRemoved = new AtomicInteger(0);
    }

    public void optimizeEntities() {
        new BukkitRunnable(){

            public void run() {
                int totalRemoved = 0;
                for (World world : EntityOptimizer.this.plugin.getServer().getWorlds()) {
                    totalRemoved += EntityOptimizer.this.optimizeWorldEntities(world);
                }
                if (totalRemoved > 0 && EntityOptimizer.this.config.isVerboseOutput()) {
                    EntityOptimizer.this.plugin.getLogger().info("Entity optimization completed. Removed " + totalRemoved + " entities.");
                }
                EntityOptimizer.this.entitiesRemoved.addAndGet(totalRemoved);
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private int optimizeWorldEntities(World world) {
        int removed = 0;
        for (Chunk chunk : world.getLoadedChunks()) {
            removed += this.optimizeChunkEntities(chunk);
        }
        return removed;
    }

    private int optimizeChunkEntities(Chunk chunk) {
        Entity[] entities = chunk.getEntities();
        int removed = 0;
        int mobCount = 0;
        int animalCount = 0;
        for (Entity entity : entities) {
            if (entity instanceof Monster) {
                ++mobCount;
                continue;
            }
            if (!(entity instanceof Animals)) continue;
            ++animalCount;
        }
        if (mobCount > this.config.getMaxMobsPerChunk()) {
            removed += this.removeExcessEntities(entities, Monster.class, mobCount - this.config.getMaxMobsPerChunk());
        }
        if (animalCount > this.config.getMaxAnimalsPerChunk()) {
            removed += this.removeExcessEntities(entities, Animals.class, animalCount - this.config.getMaxAnimalsPerChunk());
        }
        if (this.config.isAutoRemoveInvisibleEntities()) {
            removed += this.removeInvisibleEntities(entities);
        }
        this.chunkEntityCounts.put(chunk, entities.length - (removed += this.removeOldEntities(entities)));
        return removed;
    }

    private int removeExcessEntities(Entity[] entities, Class<? extends Entity> entityType, int toRemove) {
        int removed = 0;
        for (final Entity entity : entities) {
            if (removed >= toRemove) break;
            if (!entityType.isInstance(entity) || entity.isPersistent() || entity.getCustomName() != null || entity.getTicksLived() <= 1200) continue;
            new BukkitRunnable(this){

                public void run() {
                    if (entity.isValid()) {
                        entity.remove();
                    }
                }
            }.runTask((Plugin)this.plugin);
            ++removed;
        }
        return removed;
    }

    private int removeInvisibleEntities(Entity[] entities) {
        int removed = 0;
        for (final Entity entity : entities) {
            ArmorStand armorStand;
            if ((!(entity instanceof ArmorStand) || (armorStand = (ArmorStand)entity).isVisible() || this.hasAnyEquipment(armorStand)) && (!(entity instanceof ItemFrame) || !((ItemFrame)entity).getItem().getType().isAir())) continue;
            new BukkitRunnable(this){

                public void run() {
                    if (entity.isValid()) {
                        entity.remove();
                    }
                }
            }.runTask((Plugin)this.plugin);
            ++removed;
        }
        return removed;
    }

    private int removeOldEntities(Entity[] entities) {
        int removed = 0;
        int maxAge = this.config.getEntityDespawnTimer() * 60 * 20;
        for (final Entity entity : entities) {
            if (entity.isPersistent() || entity.getCustomName() != null || entity.getTicksLived() <= maxAge || entity instanceof Player || entity instanceof Villager) continue;
            new BukkitRunnable(this){

                public void run() {
                    if (entity.isValid()) {
                        entity.remove();
                    }
                }
            }.runTask((Plugin)this.plugin);
            ++removed;
        }
        return removed;
    }

    public void optimizeEntityAI() {
        if (!this.config.isAsyncAIEnabled()) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                for (World world : EntityOptimizer.this.plugin.getServer().getWorlds()) {
                    for (Entity entity : world.getEntities()) {
                        Mob mob;
                        if (!(entity instanceof Mob) || !(mob = (Mob)entity).getLocation().getWorld().getPlayers().stream().noneMatch(player -> player.getLocation().distance(mob.getLocation()) < 32.0)) continue;
                        mob.setAI(false);
                        new BukkitRunnable(this){

                            public void run() {
                                if (mob.isValid()) {
                                    mob.setAI(true);
                                }
                            }
                        }.runTaskLater((Plugin)EntityOptimizer.this.plugin, 100L);
                    }
                }
            }
        }.runTask((Plugin)this.plugin);
    }

    private boolean hasAnyEquipment(ArmorStand armorStand) {
        return !armorStand.getEquipment().getItemInMainHand().getType().isAir() || !armorStand.getEquipment().getItemInOffHand().getType().isAir() || !armorStand.getEquipment().getHelmet().getType().isAir() || !armorStand.getEquipment().getChestplate().getType().isAir() || !armorStand.getEquipment().getLeggings().getType().isAir() || !armorStand.getEquipment().getBoots().getType().isAir();
    }

    public Map<Chunk, Integer> getChunkEntityCounts() {
        return new HashMap<Chunk, Integer>(this.chunkEntityCounts);
    }

    public int getTotalEntitiesRemoved() {
        return this.entitiesRemoved.get();
    }

    public void resetStats() {
        this.entitiesRemoved.set(0);
        this.chunkEntityCounts.clear();
    }
}

