/*
 * Decompiled with CFR 0.152.
 */
package com.serveroptimiser.utils;

import com.serveroptimiser.ServerOptimiserPlugin;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.ArrayDeque;
import java.util.Deque;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PerformanceMonitor {
    private final ServerOptimiserPlugin plugin;
    private final Deque<Double> tpsHistory;
    private final MemoryMXBean memoryBean;
    private boolean isMonitoring;
    private double currentTPS;
    private long lastTick;
    private final Object tpsLock = new Object();

    public PerformanceMonitor(ServerOptimiserPlugin plugin) {
        this.plugin = plugin;
        this.tpsHistory = new ArrayDeque<Double>();
        this.memoryBean = ManagementFactory.getMemoryMXBean();
        this.isMonitoring = false;
        this.currentTPS = 20.0;
        this.lastTick = System.currentTimeMillis();
    }

    public void start() {
        if (this.isMonitoring) {
            return;
        }
        this.isMonitoring = true;
        new BukkitRunnable(){

            public void run() {
                if (!PerformanceMonitor.this.isMonitoring) {
                    this.cancel();
                    return;
                }
                PerformanceMonitor.this.updateTPS();
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        this.plugin.getLogger().info("Performance monitoring started");
    }

    public void stop() {
        this.isMonitoring = false;
        this.plugin.getLogger().info("Performance monitoring stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTPS() {
        long currentTime = System.currentTimeMillis();
        long timeDiff = currentTime - this.lastTick;
        double calculatedTPS = Math.min(20.0, 20000.0 / (double)Math.max(timeDiff, 50L));
        Object object = this.tpsLock;
        synchronized (object) {
            this.currentTPS = calculatedTPS;
            this.tpsHistory.addLast(calculatedTPS);
            if (this.tpsHistory.size() > 60) {
                this.tpsHistory.removeFirst();
            }
        }
        this.lastTick = currentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getCurrentTPS() {
        Object object = this.tpsLock;
        synchronized (object) {
            return this.currentTPS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAverageTPS() {
        Object object = this.tpsLock;
        synchronized (object) {
            if (this.tpsHistory.isEmpty()) {
                return 20.0;
            }
            return this.tpsHistory.stream().mapToDouble(Double::doubleValue).average().orElse(20.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMinTPS() {
        Object object = this.tpsLock;
        synchronized (object) {
            if (this.tpsHistory.isEmpty()) {
                return 20.0;
            }
            return this.tpsHistory.stream().mapToDouble(Double::doubleValue).min().orElse(20.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMaxTPS() {
        Object object = this.tpsLock;
        synchronized (object) {
            if (this.tpsHistory.isEmpty()) {
                return 20.0;
            }
            return this.tpsHistory.stream().mapToDouble(Double::doubleValue).max().orElse(20.0);
        }
    }

    public double getMemoryUsage() {
        long usedMemory = this.memoryBean.getHeapMemoryUsage().getUsed();
        return (double)usedMemory / 1048576.0;
    }

    public double getMaxMemory() {
        long maxMemory = this.memoryBean.getHeapMemoryUsage().getMax();
        return (double)maxMemory / 1048576.0;
    }

    public double getMemoryUsagePercent() {
        long used = this.memoryBean.getHeapMemoryUsage().getUsed();
        long max = this.memoryBean.getHeapMemoryUsage().getMax();
        if (max <= 0L) {
            return 0.0;
        }
        return (double)used * 100.0 / (double)max;
    }

    public boolean isServerLagging() {
        return this.getCurrentTPS() < 18.0 || this.getMemoryUsagePercent() > 85.0;
    }

    public String getPerformanceStatus() {
        double tps = this.getCurrentTPS();
        double memoryPercent = this.getMemoryUsagePercent();
        String tpsStatus = tps >= 19.5 ? "\u00a7aExcellent" : (tps >= 18.0 ? "\u00a7eGood" : (tps >= 15.0 ? "\u00a76Fair" : "\u00a7cPoor"));
        String memoryStatus = memoryPercent < 60.0 ? "\u00a7aLow" : (memoryPercent < 80.0 ? "\u00a7eModerate" : (memoryPercent < 90.0 ? "\u00a76High" : "\u00a7cCritical"));
        return String.format("TPS: %s \u00a77(%.2f) \u00a7f| Memory: %s \u00a77(%.1f%%)", tpsStatus, tps, memoryStatus, memoryPercent);
    }

    public void forceGarbageCollection() {
        System.gc();
        this.plugin.getLogger().info("Forced garbage collection");
    }

    public boolean isMonitoring() {
        return this.isMonitoring;
    }
}

