/*
 * Decompiled with CFR 0.152.
 */
package com.serveroptimiser.utils;

import com.serveroptimiser.ServerOptimiserPlugin;
import com.serveroptimiser.optimization.ChunkManager;
import com.serveroptimiser.optimization.EntityOptimizer;
import com.serveroptimiser.optimization.LagDetector;
import com.serveroptimiser.optimization.TPSManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Item;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class TaskScheduler {
    private final ServerOptimiserPlugin plugin;
    private final List<BukkitTask> scheduledTasks;

    public TaskScheduler(ServerOptimiserPlugin plugin) {
        this.plugin = plugin;
        this.scheduledTasks = new ArrayList<BukkitTask>();
    }

    public void scheduleEntityOptimization(final EntityOptimizer entityOptimizer) {
        BukkitTask task = new BukkitRunnable(this){

            public void run() {
                entityOptimizer.optimizeEntities();
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 100L, 1200L);
        this.scheduledTasks.add(task);
        BukkitTask aiTask = new BukkitRunnable(this){

            public void run() {
                entityOptimizer.optimizeEntityAI();
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 600L, 2400L);
        this.scheduledTasks.add(aiTask);
    }

    public void scheduleChunkOptimization(final ChunkManager chunkManager) {
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                if (TaskScheduler.this.plugin.getPerformanceMonitor().getCurrentTPS() > 18.0) {
                    chunkManager.optimizeChunks();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 1800L, 3600L);
        this.scheduledTasks.add(task);
        BukkitTask preloadTask = new BukkitRunnable(this){

            public void run() {
                chunkManager.preloadPlayerChunks();
            }
        }.runTaskTimer((Plugin)this.plugin, 200L, 400L);
        this.scheduledTasks.add(preloadTask);
    }

    public void scheduleTPSMonitoring(final TPSManager tpsManager) {
        BukkitTask task = new BukkitRunnable(this){

            public void run() {
                tpsManager.monitorAndAdjustTPS();
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, (long)this.plugin.getConfigManager().getTickCheckInterval() * 20L);
        this.scheduledTasks.add(task);
    }

    public void scheduleLagDetection(final LagDetector lagDetector) {
        lagDetector.startMonitoring();
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                if (TaskScheduler.this.plugin.getPerformanceMonitor().getCurrentTPS() < TaskScheduler.this.plugin.getConfigManager().getLagThreshold()) {
                    lagDetector.triggerLagDetection();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 2400L, (long)this.plugin.getConfigManager().getLagCheckInterval() * 20L);
        this.scheduledTasks.add(task);
    }

    public void scheduleMaintenanceTasks() {
        BukkitTask cleanupTask = new BukkitRunnable(){

            public void run() {
                TaskScheduler.this.performMaintenanceCleanup();
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 6000L, 12000L);
        this.scheduledTasks.add(cleanupTask);
        BukkitTask gcTask = new BukkitRunnable(){

            public void run() {
                if (TaskScheduler.this.plugin.getServer().getOnlinePlayers().size() < 5 && TaskScheduler.this.plugin.getPerformanceMonitor().getMemoryUsagePercent() > 70.0) {
                    TaskScheduler.this.plugin.getPerformanceMonitor().forceGarbageCollection();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 18000L, 36000L);
        this.scheduledTasks.add(gcTask);
    }

    public void schedulePerformanceReports() {
        BukkitTask reportTask = new BukkitRunnable(){

            public void run() {
                TaskScheduler.this.generatePerformanceReport();
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 12000L, 72000L);
        this.scheduledTasks.add(reportTask);
    }

    private void performMaintenanceCleanup() {
        this.plugin.getServer().getWorlds().forEach(world -> world.getEntitiesByClass(Item.class).forEach(item -> {
            if (item.getTicksLived() > this.plugin.getConfigManager().getItemMaxAge() * 60 * 20) {
                item.remove();
            }
        }));
        if (System.currentTimeMillis() % 86400000L < 600000L) {
            this.plugin.getEntityOptimizer().resetStats();
            this.plugin.getChunkManager().resetStats();
            this.plugin.getTpsManager().resetStats();
            this.plugin.getLagDetector().resetStats();
        }
    }

    private void generatePerformanceReport() {
        double currentTPS = this.plugin.getPerformanceMonitor().getCurrentTPS();
        boolean isLagging = this.plugin.getPerformanceMonitor().isServerLagging();
        if (!this.plugin.getConfigManager().isVerboseOutput() && !isLagging) {
            return;
        }
        if (isLagging || currentTPS < 17.0) {
            String report = String.format("Performance Alert - TPS: %.2f | Memory: %.1f%% | Entities Removed: %d | Chunks Unloaded: %d", currentTPS, this.plugin.getPerformanceMonitor().getMemoryUsagePercent(), this.plugin.getEntityOptimizer().getTotalEntitiesRemoved(), this.plugin.getChunkManager().getTotalChunksUnloaded());
            if (isLagging) {
                this.plugin.getLogger().warning(report);
                if (currentTPS < 15.0) {
                    this.plugin.getServer().getOnlinePlayers().stream().filter(player -> player.hasPermission("serveroptimiser.alerts")).forEach(player -> player.sendMessage("\u00a7c[ServerOptimiser] " + report));
                }
            } else if (this.plugin.getConfigManager().isVerboseOutput()) {
                this.plugin.getLogger().info(report);
            }
        }
    }

    public void shutdown() {
        for (BukkitTask task : this.scheduledTasks) {
            if (task == null || task.isCancelled()) continue;
            task.cancel();
        }
        this.scheduledTasks.clear();
        this.plugin.getLogger().info("All scheduled optimization tasks have been cancelled");
    }

    public int getActiveTaskCount() {
        return (int)this.scheduledTasks.stream().filter(task -> task != null && !task.isCancelled()).count();
    }

    public void rescheduleAll() {
        this.shutdown();
        this.scheduleEntityOptimization(this.plugin.getEntityOptimizer());
        this.scheduleChunkOptimization(this.plugin.getChunkManager());
        this.scheduleTPSMonitoring(this.plugin.getTpsManager());
        this.scheduleLagDetection(this.plugin.getLagDetector());
        this.scheduleMaintenanceTasks();
        this.schedulePerformanceReports();
        this.plugin.getLogger().info("All optimization tasks have been rescheduled");
    }
}

