/*
 * Decompiled with CFR 0.152.
 */
package beeted.sethome;

import beeted.sethome.SetHome;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class HomeTabCompleter
implements TabCompleter {
    private final SetHome plugin;

    public HomeTabCompleter(SetHome plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        FileConfiguration config = this.plugin.getConfig();
        String configuredCommand = config.getString("menu.open-command", "/home").replace("/", "");
        if ((command.getName().equalsIgnoreCase(configuredCommand) || alias.equalsIgnoreCase(configuredCommand)) && sender instanceof Player) {
            Iterator playerFile;
            Player player = (Player)sender;
            if (args.length == 1) {
                if (player.hasPermission("sethome.reload")) {
                    suggestions.add("reload");
                }
                if (player.hasPermission("sethome.import.essentials") || player.hasPermission("sethome.import.huskhomes")) {
                    suggestions.add("import");
                }
                if (player.hasPermission("sethome.admin")) {
                    suggestions.add("admin");
                }
                suggestions.add("create");
                suggestions.add("delete");
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("open")) {
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    suggestions.add(onlinePlayer.getName());
                }
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("import")) {
                if (player.hasPermission("sethome.import.essentials")) {
                    suggestions.add("Essentials");
                }
                if (player.hasPermission("sethome.import.huskhomes")) {
                    suggestions.add("HuskHomes");
                }
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("create")) {
                suggestions.add("<home_name>");
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("delete") && ((File)((Object)(playerFile = this.plugin.getPlayerDataFile(player.getUniqueId())))).exists()) {
                suggestions.addAll(this.plugin.getHomesFor(player));
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("admin")) {
                suggestions.add("create");
                suggestions.add("delete");
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("admin") && args[1].equalsIgnoreCase("create")) {
                for (Player online : Bukkit.getOnlinePlayers()) {
                    suggestions.add(online.getName());
                }
            }
            if (args.length == 4 && args[0].equalsIgnoreCase("admin") && args[1].equalsIgnoreCase("create")) {
                suggestions.add("<home_name>");
            }
            if (args.length >= 5 && args.length <= 6 && args[0].equalsIgnoreCase("admin") && args[1].equalsIgnoreCase("create")) {
                suggestions.add("<x>");
                suggestions.add("<y>");
            }
            if (args.length == 7 && args[0].equalsIgnoreCase("admin") && args[1].equalsIgnoreCase("create")) {
                suggestions.add("<z>");
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("admin") && args[1].equalsIgnoreCase("delete")) {
                for (Player online : Bukkit.getOnlinePlayers()) {
                    suggestions.add(online.getName());
                }
            }
            if (args.length == 4 && args[0].equalsIgnoreCase("admin") && args[1].equalsIgnoreCase("delete")) {
                Player target = Bukkit.getPlayer((String)args[2]);
                if (target != null) {
                    suggestions.addAll(this.plugin.getHomesFor(target));
                } else {
                    suggestions.add("<home_name>");
                }
            }
        }
        return suggestions;
    }
}

