/*
 * Decompiled with CFR 0.152.
 */
package beeted.sethome;

import beeted.sethome.HomeImporter;
import beeted.sethome.Menu;
import beeted.sethome.SetHome;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class HomeCommandExecutor
implements CommandExecutor {
    private final SetHome plugin;
    private final HomeImporter homeImporter;
    private final Menu menu;

    public HomeCommandExecutor(SetHome plugin) {
        this.plugin = plugin;
        this.homeImporter = new HomeImporter(plugin);
        this.menu = new Menu(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        FileConfiguration config = this.plugin.getConfig();
        String userCommand = config.getString("menu.open-command").replace("/", "");
        if (command.getName().equalsIgnoreCase(userCommand)) {
            if (args.length == 0 && sender instanceof Player) {
                Player player = (Player)sender;
                if (!player.hasPermission("sethome.use")) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.no-permissions", "&cYou don't have permission to do that.")));
                    return true;
                }
                this.menu.openMainMenu(player);
                return true;
            }
            if (args.length == 7 && args[0].equalsIgnoreCase("admin") && args[1].equalsIgnoreCase("create")) {
                double z;
                double y;
                double x;
                if (!sender.hasPermission("sethome.admin")) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.no-permissions")));
                    return true;
                }
                OfflinePlayer targetPlayer = Bukkit.getOfflinePlayer((String)args[2]);
                if (targetPlayer == null || !targetPlayer.hasPlayedBefore()) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.player-not-found")));
                    return true;
                }
                String homeName = args[3];
                try {
                    x = Double.parseDouble(args[4]);
                    y = Double.parseDouble(args[5]);
                    z = Double.parseDouble(args[6]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.invalid-coordinates")));
                    return true;
                }
                File dataFolder = new File(this.plugin.getDataFolder(), "data");
                File playerFile = new File(dataFolder, targetPlayer.getUniqueId() + ".yml");
                YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
                if (playerConfig.contains(homeName)) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-exists")));
                    return true;
                }
                List homes = playerConfig.getStringList("homes");
                String worldName = targetPlayer.getPlayer() != null ? targetPlayer.getPlayer().getWorld().getName() : ((World)Bukkit.getWorlds().get(0)).getName();
                Location homeLocation = new Location(Bukkit.getWorld((String)worldName), x, y, z);
                homes.add(homeName);
                playerConfig.set("homes", (Object)homes);
                playerConfig.set(homeName + ".world", (Object)worldName);
                playerConfig.set(homeName + ".x", (Object)x);
                playerConfig.set(homeName + ".y", (Object)y);
                playerConfig.set(homeName + ".z", (Object)z);
                playerConfig.set(homeName + ".yaw", (Object)Float.valueOf(homeLocation.getYaw()));
                playerConfig.set(homeName + ".pitch", (Object)Float.valueOf(homeLocation.getPitch()));
                try {
                    playerConfig.save(playerFile);
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-established-to-other")).replace("%player%", targetPlayer.getName()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.saving-error")));
                }
                return true;
            }
            if (args.length == 4 && args[0].equalsIgnoreCase("admin") && args[1].equalsIgnoreCase("create")) {
                if (!sender.hasPermission("sethome.admin")) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.no-permissions")));
                    return true;
                }
                if (!(sender instanceof Player)) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.player-only")));
                    return true;
                }
                Player executor = (Player)sender;
                OfflinePlayer targetPlayer = Bukkit.getOfflinePlayer((String)args[2]);
                if (targetPlayer == null || !targetPlayer.hasPlayedBefore()) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.player-not-found")));
                    return true;
                }
                String homeName = args[3];
                File dataFolder = new File(this.plugin.getDataFolder(), "data");
                File playerFile = new File(dataFolder, targetPlayer.getUniqueId() + ".yml");
                YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
                if (playerConfig.contains(homeName)) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-exists")));
                    return true;
                }
                Location homeLocation = executor.getLocation();
                List homes = playerConfig.getStringList("homes");
                homes.add(homeName);
                playerConfig.set("homes", (Object)homes);
                playerConfig.set(homeName + ".world", (Object)homeLocation.getWorld().getName());
                playerConfig.set(homeName + ".x", (Object)homeLocation.getX());
                playerConfig.set(homeName + ".y", (Object)homeLocation.getY());
                playerConfig.set(homeName + ".z", (Object)homeLocation.getZ());
                playerConfig.set(homeName + ".yaw", (Object)Float.valueOf(homeLocation.getYaw()));
                playerConfig.set(homeName + ".pitch", (Object)Float.valueOf(homeLocation.getPitch()));
                try {
                    playerConfig.save(playerFile);
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-established-to-other")).replace("%player%", targetPlayer.getName()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.saving-error")));
                }
                return true;
            }
            if (args.length == 4 && args[0].equalsIgnoreCase("admin") && args[1].equalsIgnoreCase("delete")) {
                if (!sender.hasPermission("sethome.admin")) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.no-permissions")));
                    return true;
                }
                OfflinePlayer targetPlayer = Bukkit.getOfflinePlayer((String)args[2]);
                if (targetPlayer == null || !targetPlayer.hasPlayedBefore()) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.player-not-found")));
                    return true;
                }
                String homeName = args[3];
                File dataFolder = new File(this.plugin.getDataFolder(), "data");
                File playerFile = new File(dataFolder, targetPlayer.getUniqueId() + ".yml");
                YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
                if (!playerConfig.contains(homeName)) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-not-found")));
                    return true;
                }
                List homes = playerConfig.getStringList("homes");
                homes.remove(homeName);
                playerConfig.set("homes", (Object)homes);
                playerConfig.set(homeName, null);
                try {
                    playerConfig.save(playerFile);
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-removed-to-other")).replace("%player%", targetPlayer.getName()).replace("%home%", homeName));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.saving-error")));
                }
                return true;
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("admin") && args[1].equalsIgnoreCase("seeplayer")) {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.player-only")));
                    return true;
                }
                Player admin = (Player)sender;
                if (!admin.hasPermission("sethome.admin")) {
                    admin.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.no-permissions")));
                    return true;
                }
                OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[2]);
                if (target == null || !target.hasPlayedBefore()) {
                    admin.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.player-not-found")));
                    return true;
                }
                this.menu.openPlayerHomesInventory(admin, target, 0);
                return true;
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("create")) {
                File playerFile;
                YamlConfiguration playerConfig;
                if (!sender.hasPermission("sethome.use")) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.no-permissions")));
                    return true;
                }
                if (!(sender instanceof Player)) {
                    sender.sendMessage(ChatColor.RED + "You must be a player to use this command.");
                    return true;
                }
                Player player = (Player)sender;
                String homeName = args[1];
                File dataFolder = new File(this.plugin.getDataFolder(), "data");
                if (!dataFolder.exists()) {
                    dataFolder.mkdirs();
                }
                if ((playerConfig = YamlConfiguration.loadConfiguration((File)(playerFile = new File(dataFolder, player.getUniqueId() + ".yml")))).contains(homeName)) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-exists")));
                    return true;
                }
                List homes = playerConfig.getStringList("homes");
                int maxHomes = this.getMaxHomesForPlayer(player);
                if (homes.size() >= maxHomes) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-limit-reached").replace("%limit%", String.valueOf(maxHomes))));
                    return true;
                }
                Location homeLocation = player.getLocation();
                String worldName = homeLocation.getWorld().getName();
                homes.add(homeName);
                playerConfig.set("homes", (Object)homes);
                playerConfig.set(homeName + ".world", (Object)worldName);
                playerConfig.set(homeName + ".x", (Object)homeLocation.getX());
                playerConfig.set(homeName + ".y", (Object)homeLocation.getY());
                playerConfig.set(homeName + ".z", (Object)homeLocation.getZ());
                playerConfig.set(homeName + ".yaw", (Object)Float.valueOf(homeLocation.getYaw()));
                playerConfig.set(homeName + ".pitch", (Object)Float.valueOf(homeLocation.getPitch()));
                try {
                    playerConfig.save(playerFile);
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-established")).replace("%home%", homeName));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.saving-error")));
                }
                return true;
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("delete")) {
                if (!sender.hasPermission("sethome.use")) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.no-permissions")));
                    return true;
                }
                if (!(sender instanceof Player)) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.player-only")));
                    return true;
                }
                Player player = (Player)sender;
                String homeName = args[1];
                File dataFolder = new File(this.plugin.getDataFolder(), "data");
                File playerFile = new File(dataFolder, player.getUniqueId() + ".yml");
                if (!playerFile.exists()) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.player-not-found")));
                    return true;
                }
                YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
                if (!playerConfig.contains(homeName)) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-not-found")));
                    return true;
                }
                List homes = playerConfig.getStringList("homes");
                if (!homes.contains(homeName)) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-not-found")));
                    return true;
                }
                homes.remove(homeName);
                playerConfig.set("homes", (Object)homes);
                playerConfig.set(homeName, null);
                try {
                    playerConfig.save(playerFile);
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-removed")).replace("%home%", homeName));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.saving-error")));
                }
                return true;
            }
            if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
                if (sender.hasPermission("sethome.reload")) {
                    this.plugin.reloadConfig();
                    this.plugin.saveDefaultConfig();
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.plugin-reloaded", "&aPlugin reloaded successfully.")));
                } else {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.no-permissions", "&cYou don't have permission to do that.")));
                }
                return true;
            }
            if (args.length > 1 && args[0].equalsIgnoreCase("import") && args[1].equalsIgnoreCase("Essentials")) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (!player.hasPermission("sethome.import.essentials")) {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.import-no-permission")));
                        return true;
                    }
                    this.homeImporter.importHomesFromEssentialsForAllPlayers((CommandSender)player);
                } else if (sender instanceof ConsoleCommandSender) {
                    this.homeImporter.importHomesFromEssentialsForAllPlayers(sender);
                } else {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.console-or-player")));
                }
                return true;
            }
            if (args.length > 1 && args[0].equalsIgnoreCase("import") && args[1].equalsIgnoreCase("HuskHomes")) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (!player.hasPermission("sethome.import.huskhomes")) {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.import-no-permission")));
                        return true;
                    }
                    this.homeImporter.importHomesFromHuskHomesForAllPlayers((CommandSender)player, "HuskHomes/HuskHomesData.db");
                } else if (sender instanceof ConsoleCommandSender) {
                    this.homeImporter.importHomesFromHuskHomesForAllPlayers(sender, "HuskHomes/HuskHomesData.db");
                } else {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.console-or-player")));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxHomesForPlayer(Player player) {
        FileConfiguration config = this.plugin.getConfig();
        int defaultMaxHomes = config.getInt("default-maxhomes", 3);
        int maxHomes = -1;
        for (PermissionAttachmentInfo permInfo : player.getEffectivePermissions()) {
            String perm = permInfo.getPermission().toLowerCase();
            if (!perm.startsWith("sethome.maxhomes.")) continue;
            try {
                int value = Integer.parseInt(perm.replace("sethome.maxhomes.", ""));
                if (value <= maxHomes) continue;
                maxHomes = value;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return maxHomes > -1 ? maxHomes : defaultMaxHomes;
    }
}

