/*
 * Decompiled with CFR 0.152.
 */
package beeted.sethome;

import beeted.sethome.SetHome;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class HomeImporter {
    ConsoleCommandSender console = Bukkit.getConsoleSender();
    private final SetHome plugin;

    public HomeImporter(SetHome plugin) {
        this.plugin = plugin;
    }

    public void importHomesFromEssentialsForAllPlayers(CommandSender sender) {
        File essentialsDir = new File(this.plugin.getDataFolder().getParentFile(), "Essentials/userdata");
        File pluginDataDir = new File(this.plugin.getDataFolder(), "data");
        if (!essentialsDir.exists() || !essentialsDir.isDirectory()) {
            String message = "Essentials userdata directory not found: " + essentialsDir.getAbsolutePath();
            sender.sendMessage(ChatColor.RED + message);
            this.plugin.getLogger().warning(message);
            return;
        }
        File[] playerFiles = essentialsDir.listFiles((dir, name) -> name.endsWith(".yml"));
        if (playerFiles == null || playerFiles.length == 0) {
            String message = "No player data files found in Essentials/userdata.";
            sender.sendMessage(ChatColor.RED + message);
            this.plugin.getLogger().warning(message);
            return;
        }
        sender.sendMessage(ChatColor.GREEN + "Starting to import homes from Essentials for all players...");
        for (File essentialsPlayerFile : playerFiles) {
            try {
                YamlConfiguration pluginConfig;
                ArrayList<String> homeList;
                YamlConfiguration essentialsConfig = YamlConfiguration.loadConfiguration((File)essentialsPlayerFile);
                ConfigurationSection homesSection = essentialsConfig.getConfigurationSection("homes");
                if (homesSection == null) {
                    String message = "No homes found for player file: " + essentialsPlayerFile.getName();
                    sender.sendMessage(ChatColor.YELLOW + message);
                    this.plugin.getLogger().info(message);
                    continue;
                }
                String uuidString = essentialsPlayerFile.getName().replace(".yml", "");
                File pluginPlayerFile = new File(pluginDataDir, uuidString + ".yml");
                if (!pluginPlayerFile.exists()) {
                    pluginPlayerFile.getParentFile().mkdirs();
                    pluginPlayerFile.createNewFile();
                }
                if ((homeList = (pluginConfig = YamlConfiguration.loadConfiguration((File)pluginPlayerFile)).getStringList("homes")) == null) {
                    homeList = new ArrayList<String>();
                }
                for (String homeName : homesSection.getKeys(false)) {
                    if (homeList.contains(homeName)) continue;
                    homeList.add(homeName);
                    ConfigurationSection homeData = homesSection.getConfigurationSection(homeName);
                    ConfigurationSection newHomeData = pluginConfig.createSection(homeName);
                    newHomeData.set("world", (Object)homeData.getString("world-name"));
                    newHomeData.set("x", (Object)homeData.getDouble("x"));
                    newHomeData.set("y", (Object)homeData.getDouble("y"));
                    newHomeData.set("z", (Object)homeData.getDouble("z"));
                }
                pluginConfig.set("homes", homeList);
                pluginConfig.save(pluginPlayerFile);
                String message = "Successfully imported homes for player UUID: " + uuidString;
                sender.sendMessage(ChatColor.GREEN + message);
                this.plugin.getLogger().info(message);
            }
            catch (Exception e) {
                String message = "An error occurred while importing homes for file: " + essentialsPlayerFile.getName();
                sender.sendMessage(ChatColor.RED + message);
                this.plugin.getLogger().warning(message);
                e.printStackTrace();
            }
        }
        sender.sendMessage(ChatColor.GREEN + "All player homes have been successfully imported from Essentials!");
        this.plugin.getLogger().info("All player homes have been successfully imported from Essentials!");
    }

    public void importHomesFromHuskHomesForAllPlayers(CommandSender sender, String huskHomesDbPath) {
        File huskHomesDbFile = new File(this.plugin.getDataFolder().getParentFile(), huskHomesDbPath);
        File pluginDataDir = new File(this.plugin.getDataFolder(), "data");
        this.console.sendMessage(String.valueOf(pluginDataDir));
        this.console.sendMessage(String.valueOf(huskHomesDbFile));
        if (!huskHomesDbFile.exists()) {
            String message = "HuskHomes database file not found: " + huskHomesDbFile.getAbsolutePath();
            sender.sendMessage(ChatColor.RED + message);
            this.plugin.getLogger().warning(message);
            return;
        }
        sender.sendMessage(ChatColor.GREEN + "Starting to import homes from HuskHomes for all players...");
        try (Connection connection = DriverManager.getConnection("jdbc:sqlite:" + huskHomesDbFile.getAbsolutePath());){
            String query = "SELECT h.owner_uuid, s.name, p.x, p.y, p.z, p.yaw, p.pitch, p.world_name FROM huskhomes_homes h JOIN huskhomes_saved_positions s ON h.saved_position_id = s.id JOIN huskhomes_position_data p ON s.position_id = p.id";
            try (PreparedStatement statement = connection.prepareStatement(query);
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    YamlConfiguration playerConfig;
                    ArrayList<String> homeList;
                    String ownerUUID = resultSet.getString("owner_uuid");
                    String homeName = resultSet.getString("name");
                    double x = resultSet.getDouble("x");
                    double y = resultSet.getDouble("y");
                    double z = resultSet.getDouble("z");
                    float yaw = resultSet.getFloat("yaw");
                    float pitch = resultSet.getFloat("pitch");
                    String worldName = resultSet.getString("world_name");
                    File playerFile = new File(pluginDataDir, ownerUUID + ".yml");
                    if (!playerFile.exists()) {
                        playerFile.getParentFile().mkdirs();
                        playerFile.createNewFile();
                    }
                    if ((homeList = (playerConfig = YamlConfiguration.loadConfiguration((File)playerFile)).getStringList("homes")) == null) {
                        homeList = new ArrayList<String>();
                    }
                    if (homeList.contains(homeName)) continue;
                    homeList.add(homeName);
                    playerConfig.set("homes", homeList);
                    String homePath = homeName;
                    playerConfig.set(homePath + ".world", (Object)worldName);
                    playerConfig.set(homePath + ".x", (Object)x);
                    playerConfig.set(homePath + ".y", (Object)y);
                    playerConfig.set(homePath + ".z", (Object)z);
                    playerConfig.save(playerFile);
                }
            }
            sender.sendMessage(ChatColor.GREEN + "All player homes have been successfully imported from HuskHomes!");
            this.plugin.getLogger().info("All player homes have been successfully imported from HuskHomes!");
        }
        catch (Exception e) {
            String message = "An error occurred while importing homes from HuskHomes: " + e.getMessage();
            sender.sendMessage(ChatColor.RED + message);
            this.plugin.getLogger().warning(message);
            e.printStackTrace();
        }
    }
}

