/*
 * Decompiled with CFR 0.152.
 */
package beeted.sethome;

import beeted.sethome.AdminMenuHolder;
import beeted.sethome.PlayerMenuHolder;
import beeted.sethome.SetHome;
import beeted.sethome.utils.SkullUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Menu
implements Listener {
    private final SetHome plugin;
    private final Map<Player, String> pendingHomeNames = new HashMap<Player, String>();
    Map<Player, String> pendingAdminHomes = new HashMap<Player, String>();
    private final Map<Player, BukkitRunnable> teleportCooldowns = new HashMap<Player, BukkitRunnable>();
    private long cooldownTime;
    private final Map<Player, BukkitRunnable> teleportTasks = new HashMap<Player, BukkitRunnable>();
    private final Set<Player> teleportingPlayers = new HashSet<Player>();
    private final Map<UUID, OfflinePlayer> playerTargetMap = new HashMap<UUID, OfflinePlayer>();
    public static boolean isAdmin = false;
    private final Set<UUID> adminsDeletingOtherHome = new HashSet<UUID>();
    private final Map<Player, BukkitRunnable> teleportCountdownTasks = new HashMap<Player, BukkitRunnable>();

    public Menu(SetHome plugin) {
        this.plugin = plugin;
        this.reloadConfig();
    }

    private void reloadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        this.cooldownTime = config.getLong("teleport-cooldown") * 1000L;
    }

    @EventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (!(event.getInventory().getHolder() instanceof PlayerMenuHolder)) {
            return;
        }
        final Player player = (Player)event.getWhoClicked();
        final FileConfiguration config = this.plugin.getConfig();
        Inventory inventory = event.getInventory();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || !clickedItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        String itemName = meta.getDisplayName();
        String mainMenuTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("menu.gui-title"));
        String confirmationMenuTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("confirmation-menu.gui-title"));
        if (event.getView().getTitle().equals(mainMenuTitle)) {
            event.setCancelled(true);
            String setHomeItemName = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("menu.set-home-item.display-name"));
            String yourHomesItemName = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("menu.your-homes-item.display-name"));
            String adminItemName = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("admin-menu.display-name"));
            if (itemName.equals(adminItemName) && player.hasPermission("sethome.admin")) {
                player.closeInventory();
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.openAdminMenu(player, 0), 1L);
                return;
            }
            if (itemName.equals(setHomeItemName)) {
                String bypassPermission;
                String currentWorld = player.getWorld().getName();
                List blacklistedWorlds = config.getStringList("blacklisted-worlds");
                if (blacklistedWorlds.contains(currentWorld) && !player.hasPermission(bypassPermission = "sethome.world.bypass." + currentWorld)) {
                    String errorMessage = config.getString("messages.error-blacklisted-world");
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)errorMessage));
                    return;
                }
                this.pendingHomeNames.put(player, "");
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.enter-home-name")));
                player.closeInventory();
                return;
            }
            if (itemName.equals(yourHomesItemName)) {
                player.closeInventory();
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.openYourHomesInventory(player, 0), 1L);
                return;
            }
        }
        if (inventory.getHolder() instanceof PlayerMenuHolder) {
            String homeName;
            event.setCancelled(true);
            NamespacedKey pageKey = new NamespacedKey((Plugin)this.plugin, "menuPage");
            if (meta.getPersistentDataContainer().has(pageKey, PersistentDataType.INTEGER)) {
                int newPage = (Integer)meta.getPersistentDataContainer().get(pageKey, PersistentDataType.INTEGER);
                this.openYourHomesInventory(player, newPage);
                return;
            }
            if (itemName.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("homes-menu.go-back-item")))) {
                player.closeInventory();
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.openMainMenu(player), 1L);
                return;
            }
            if (itemName.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("homes-menu.close-item")))) {
                player.closeInventory();
                return;
            }
            if (event.getClick() == ClickType.LEFT && clickedItem.getType() == Material.RED_BED) {
                homeName = (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "homePosition"), PersistentDataType.STRING);
                if (homeName == null || homeName.isEmpty()) {
                    return;
                }
                if (player.hasPermission("sethome.cooldown.bypass")) {
                    this.teleportPlayerToHome(player, homeName);
                    return;
                }
                if (this.teleportCooldowns.containsKey(player)) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.teleport-in-progress")));
                    return;
                }
                final int cooldownSeconds = (int)(this.cooldownTime / 1000L);
                String cooldownMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.teleport-cooldown")).replace("%seconds%", String.valueOf(cooldownSeconds));
                player.sendMessage(cooldownMessage);
                this.teleportingPlayers.add(player);
                if (cooldownSeconds > 0) {
                    if (config.getBoolean("titles.cooldown-title.enable")) {
                        BukkitRunnable countdownTitle = new BukkitRunnable(this){
                            int secondsLeft;
                            final /* synthetic */ Menu this$0;
                            {
                                this.this$0 = this$0;
                                this.secondsLeft = cooldownSeconds;
                            }

                            public void run() {
                                if (!this.this$0.teleportingPlayers.contains(player)) {
                                    player.resetTitle();
                                    this.cancel();
                                    return;
                                }
                                String title = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("titles.cooldown-title.teleport-title"));
                                String subtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("titles.cooldown-title.teleport-subtitle"));
                                player.sendTitle(title.replace("%seconds%", String.valueOf(this.secondsLeft)), subtitle.replace("%seconds%", String.valueOf(this.secondsLeft)), 10, 20, 10);
                                if (config.getBoolean("action-bar.cooldown-title.enable")) {
                                    String actionBar = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("action-bar.cooldown-title.teleport-subtitle")).replace("%seconds%", String.valueOf(this.secondsLeft));
                                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(actionBar));
                                }
                                if (--this.secondsLeft <= 0) {
                                    this.cancel();
                                }
                            }
                        };
                        countdownTitle.runTaskTimer((Plugin)this.plugin, 0L, 20L);
                        this.teleportCountdownTasks.put(player, countdownTitle);
                    } else if (config.getBoolean("titles.static-title.enable")) {
                        player.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("titles.static-title.teleport-title")), ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("titles.static-title.teleport-subtitle")).replace("%seconds%", String.valueOf(cooldownSeconds)), 10, cooldownSeconds * 20, 10);
                        if (config.getBoolean("action-bar.static-title.enable")) {
                            String actionBar = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("action-bar.static-title.teleport-subtitle")).replace("%seconds%", String.valueOf(cooldownSeconds));
                            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(actionBar));
                        }
                    }
                }
                BukkitRunnable teleportTask = new BukkitRunnable(this){
                    final /* synthetic */ Menu this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        if (this.this$0.teleportingPlayers.contains(player)) {
                            this.this$0.teleportPlayerToHome(player, homeName);
                        }
                    }
                };
                teleportTask.runTaskLater((Plugin)this.plugin, this.cooldownTime / 50L);
                this.teleportTasks.put(player, teleportTask);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> ((Player)player).closeInventory());
            }
            if (event.getClick() == ClickType.RIGHT && clickedItem.getType() == Material.RED_BED && (homeName = (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "homePosition"), PersistentDataType.STRING)) != null && !homeName.isEmpty()) {
                this.pendingHomeNames.put(player, homeName);
                this.openConfirmationMenu(player, homeName);
            }
        }
        if (event.getView().getTitle().equals(confirmationMenuTitle)) {
            event.setCancelled(true);
            if (this.pendingHomeNames.isEmpty()) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-not-found")));
                player.closeInventory();
                return;
            }
            String confirmName = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("confirmation-menu.confirm-item.display-name"));
            String cancelName = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("confirmation-menu.cancel-item.display-name"));
            if (itemName.equals(confirmName)) {
                String homeName = this.pendingHomeNames.get(player);
                if ((homeName = homeName.trim()) == null || homeName.isEmpty()) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-not-found")));
                    player.closeInventory();
                    return;
                }
                File playerFile = new File(this.plugin.getDataFolder(), "data/" + player.getUniqueId() + ".yml");
                YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
                List homes = playerConfig.getStringList("homes");
                if (!homes.contains(homeName)) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-not-found")));
                    player.closeInventory();
                    return;
                }
                homes.remove(homeName);
                playerConfig.set("homes", (Object)homes);
                playerConfig.set(homeName, null);
                try {
                    playerConfig.save(playerFile);
                    String message = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-removed")).replace("%home%", homeName);
                    player.sendMessage(message);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    player.sendMessage(ChatColor.RED + "Error al guardar los cambios.");
                }
                this.pendingHomeNames.remove(player);
                player.closeInventory();
            }
            if (itemName.equals(cancelName)) {
                this.pendingHomeNames.remove(player);
                player.closeInventory();
            }
        }
    }

    private void teleportPlayerToHome(final Player player, String homeName) {
        File dataFolder = new File(this.plugin.getDataFolder(), "data");
        File playerFile = new File(dataFolder, player.getUniqueId() + ".yml");
        YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
        String worldName = playerConfig.getString(homeName + ".world");
        World world = Bukkit.getWorld((String)worldName);
        if (world != null) {
            double x = playerConfig.getDouble(homeName + ".x");
            double y = playerConfig.getDouble(homeName + ".y");
            double z = playerConfig.getDouble(homeName + ".z");
            float yaw = (float)playerConfig.getDouble(homeName + ".yaw");
            float pitch = (float)playerConfig.getDouble(homeName + ".pitch");
            Location homeLocation = new Location(world, x, y, z, yaw, pitch);
            player.teleport(homeLocation);
            String teleportedToHomePath = this.plugin.getConfig().getString("messages.teleported");
            String teleportMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)teleportedToHomePath);
            teleportMessage = teleportMessage.replace("%home%", homeName);
            player.sendMessage(teleportMessage);
            if (this.plugin.getConfig().getBoolean("titles.teleport-finish.enable")) {
                String title = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("titles.teleport-finish.title"));
                String subtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("titles.teleport-finish.subtitle", ""));
                int fadeIn = this.plugin.getConfig().getInt("titles.teleport-finish.fade-in", 10);
                int stay = this.plugin.getConfig().getInt("titles.teleport-finish.stay", 40);
                int fadeOut = this.plugin.getConfig().getInt("titles.teleport-finish.fade-out", 10);
                player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
            }
            if (this.plugin.getConfig().getBoolean("action-bar.teleport-finish.enable")) {
                final String actionBarMsg = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("action-bar.teleport-finish.message"));
                final int durationTicks = this.plugin.getConfig().getInt("action-bar.teleport-finish.duration-ticks", 40);
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(actionBarMsg));
                if (durationTicks > 20) {
                    new BukkitRunnable(this){
                        int ticksLeft;
                        final /* synthetic */ Menu this$0;
                        {
                            this.this$0 = this$0;
                            this.ticksLeft = durationTicks - 20;
                        }

                        public void run() {
                            if (this.ticksLeft <= 0) {
                                this.cancel();
                                return;
                            }
                            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(actionBarMsg));
                            this.ticksLeft -= 20;
                        }
                    }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
                }
            }
        } else {
            String worldNotFound = this.plugin.getConfig().getString("messages.world-not-found");
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)worldNotFound));
        }
        this.teleportCooldowns.remove(player);
        this.teleportingPlayers.remove(player);
    }

    private void openConfirmationMenu(Player player, String homeName) {
        FileConfiguration config = this.plugin.getConfig();
        Inventory confirmationMenu = Bukkit.createInventory((InventoryHolder)new PlayerMenuHolder(), (int)9, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("confirmation-menu.gui-title")));
        String confirmMaterialName = config.getString("confirmation-menu.confirm-item.material", "GREEN_WOOL");
        String cancelMaterialName = config.getString("confirmation-menu.cancel-item.material", "RED_WOOL");
        Material confirmMaterial = Material.getMaterial((String)confirmMaterialName.toUpperCase());
        Material cancelMaterial = Material.getMaterial((String)cancelMaterialName.toUpperCase());
        if (confirmMaterial == null) {
            confirmMaterial = Material.GREEN_WOOL;
        }
        if (cancelMaterial == null) {
            cancelMaterial = Material.RED_WOOL;
        }
        ItemStack confirmItem = new ItemStack(confirmMaterial);
        ItemMeta confirmMeta = confirmItem.getItemMeta();
        confirmMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("confirmation-menu.confirm-item.display-name", "&aConfirm")));
        confirmItem.setItemMeta(confirmMeta);
        ItemStack cancelItem = new ItemStack(cancelMaterial);
        ItemMeta cancelMeta = cancelItem.getItemMeta();
        cancelMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("confirmation-menu.cancel-item.display-name", "&cCancel")));
        cancelItem.setItemMeta(cancelMeta);
        confirmationMenu.setItem(3, confirmItem);
        confirmationMenu.setItem(5, cancelItem);
        player.openInventory(confirmationMenu);
        this.pendingHomeNames.put(player, homeName);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (this.teleportingPlayers.contains(player)) {
            FileConfiguration config = this.plugin.getConfig();
            boolean cancelOnMove = config.getBoolean("cancel-on-move");
            if (!cancelOnMove) {
                return;
            }
            Location from = event.getFrom();
            Location to = event.getTo();
            if (from.getBlockX() != to.getBlockX() || from.getBlockY() != to.getBlockY() || from.getBlockZ() != to.getBlockZ()) {
                BukkitRunnable teleportTask = this.teleportTasks.get(player);
                if (teleportTask != null) {
                    teleportTask.cancel();
                    this.teleportTasks.remove(player);
                    player.sendTitle("", "", 0, 0, 0);
                }
                String teleportCancelledMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.teleport-cancelled"));
                player.resetTitle();
                player.sendMessage(teleportCancelledMessage);
                this.teleportingPlayers.remove(player);
            }
        }
    }

    public void openMainMenu(Player player) {
        ItemStack setHomeItem;
        int[] borderSlots;
        FileConfiguration config = this.plugin.getConfig();
        String menuTitlePath = "menu.gui-title";
        Inventory menu = Bukkit.createInventory((InventoryHolder)new PlayerMenuHolder(), (int)27, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString(menuTitlePath)));
        String borderGlassColorName = config.getString("menu.glass-pane-color", "GRAY").toUpperCase();
        Material borderGlassMaterial = Material.matchMaterial((String)(borderGlassColorName + "_STAINED_GLASS_PANE"));
        if (borderGlassMaterial == null) {
            borderGlassMaterial = Material.GRAY_STAINED_GLASS_PANE;
        }
        ItemStack borderGlassPane = new ItemStack(borderGlassMaterial);
        ItemMeta borderGlassMeta = borderGlassPane.getItemMeta();
        borderGlassMeta.setDisplayName(" ");
        borderGlassPane.setItemMeta(borderGlassMeta);
        for (int slot : borderSlots = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26}) {
            menu.setItem(slot, borderGlassPane);
        }
        String centerGlassColorName = config.getString("menu.center-glass-color", "LIGHT_BLUE").toUpperCase();
        Material centerGlassMaterial = Material.matchMaterial((String)(centerGlassColorName + "_STAINED_GLASS_PANE"));
        if (centerGlassMaterial == null) {
            centerGlassMaterial = Material.LIGHT_BLUE_STAINED_GLASS_PANE;
        }
        ItemStack centerGlassPane = new ItemStack(centerGlassMaterial);
        ItemMeta centerGlassMeta = centerGlassPane.getItemMeta();
        centerGlassMeta.setDisplayName(" ");
        centerGlassPane.setItemMeta(centerGlassMeta);
        menu.setItem(10, centerGlassPane);
        menu.setItem(12, centerGlassPane);
        menu.setItem(14, centerGlassPane);
        menu.setItem(16, centerGlassPane);
        String setHomeMaterialName = config.getString("menu.set-home-item.material").toUpperCase();
        String setHomeValue = config.getString("menu.set-home-item.value");
        Material setHomeMaterial = Material.matchMaterial((String)setHomeMaterialName);
        if (setHomeMaterialName.equalsIgnoreCase("HEAD") && setHomeValue != null) {
            setHomeItem = SkullUtils.getHeadFromBase64(setHomeValue);
        } else {
            if (setHomeMaterial == null) {
                setHomeMaterial = Material.RED_BED;
            }
            setHomeItem = new ItemStack(setHomeMaterial);
        }
        ItemMeta setHomeMeta = setHomeItem.getItemMeta();
        setHomeMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("menu.set-home-item.display-name")));
        List setHomeLore = config.getStringList("menu.set-home-item.lore");
        for (int i = 0; i < setHomeLore.size(); ++i) {
            setHomeLore.set(i, ChatColor.translateAlternateColorCodes((char)'&', (String)((String)setHomeLore.get(i))));
        }
        setHomeMeta.setLore(setHomeLore);
        setHomeItem.setItemMeta(setHomeMeta);
        menu.setItem(11, setHomeItem);
        String homeListMaterialName = config.getString("menu.your-homes-item.material").toUpperCase();
        Material homeListMaterial = Material.matchMaterial((String)homeListMaterialName);
        if (homeListMaterial == null) {
            homeListMaterial = Material.OAK_DOOR;
        }
        ItemStack homeListItem = new ItemStack(homeListMaterial);
        ItemMeta homeListMeta = homeListItem.getItemMeta();
        homeListMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("menu.your-homes-item.display-name")));
        List homeListLore = config.getStringList("menu.your-homes-item.lore");
        for (int i = 0; i < homeListLore.size(); ++i) {
            homeListLore.set(i, ChatColor.translateAlternateColorCodes((char)'&', (String)((String)homeListLore.get(i))));
        }
        homeListMeta.setLore(homeListLore);
        homeListItem.setItemMeta(homeListMeta);
        menu.setItem(15, homeListItem);
        if (player.hasPermission("sethome.admin")) {
            String adminMaterialName = config.getString("admin-menu.material").toUpperCase();
            Material adminMaterial = Material.matchMaterial((String)adminMaterialName);
            if (adminMaterial == null) {
                adminMaterial = Material.BOOK;
            }
            ItemStack adminItem = new ItemStack(adminMaterial);
            ItemMeta adminMeta = adminItem.getItemMeta();
            adminMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("admin-menu.display-name")));
            List adminMenuLore = config.getStringList("admin-menu.lore");
            for (int i = 0; i < adminMenuLore.size(); ++i) {
                adminMenuLore.set(i, ChatColor.translateAlternateColorCodes((char)'&', (String)((String)adminMenuLore.get(i))));
            }
            adminMeta.setLore(adminMenuLore);
            adminItem.setItemMeta(adminMeta);
            menu.setItem(13, adminItem);
        } else {
            ItemStack infoItem = new ItemStack(Material.NETHER_STAR);
            ItemMeta infoMeta = infoItem.getItemMeta();
            infoMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("menu.info-title")));
            infoItem.setItemMeta(infoMeta);
            menu.setItem(13, infoItem);
        }
        player.openInventory(menu);
    }

    private void openYourHomesInventory(Player player, int page) {
        player.closeInventory();
        FileConfiguration config = this.plugin.getConfig();
        int size = config.getInt("homes-menu.size");
        File dataFolder = new File(this.plugin.getDataFolder(), "data");
        File playerFile = new File(dataFolder, player.getUniqueId() + ".yml");
        YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
        List homes = playerConfig.getStringList("homes");
        int itemsPerPage = size - 9;
        int totalPages = (int)Math.ceil((double)homes.size() / (double)itemsPerPage);
        if (totalPages == 0) {
            totalPages = 1;
        }
        String rawTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("homes-menu.gui-title")).replace("%page%", String.valueOf(page + 1)).replace("%maxpages%", String.valueOf(totalPages));
        Inventory homesMenu = Bukkit.createInventory((InventoryHolder)new PlayerMenuHolder(), (int)config.getInt("homes-menu.size"), (String)rawTitle);
        if (homes.isEmpty()) {
            ItemStack noHomesItem = new ItemStack(Material.PAPER);
            ItemMeta noHomesMeta = noHomesItem.getItemMeta();
            if (noHomesMeta != null) {
                String noHomesDisplayName = config.getString("homes-menu.no-homes-item.display-name");
                List noHomesLore = config.getStringList("homes-menu.no-homes-item.lore");
                if (noHomesDisplayName != null) {
                    noHomesMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)noHomesDisplayName));
                }
                if (noHomesLore != null) {
                    noHomesLore.replaceAll(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                    noHomesMeta.setLore(noHomesLore);
                }
                noHomesItem.setItemMeta(noHomesMeta);
            }
            homesMenu.setItem(22, noHomesItem);
        } else {
            int start = page * itemsPerPage;
            int end = Math.min(start + itemsPerPage, homes.size());
            for (int i = start; i < end; ++i) {
                String home = (String)homes.get(i);
                if (!playerConfig.contains(home)) continue;
                String world = playerConfig.getString(home + ".world");
                double x = playerConfig.getDouble(home + ".x");
                double y = playerConfig.getDouble(home + ".y");
                double z = playerConfig.getDouble(home + ".z");
                if (world == null) continue;
                ItemStack bedItem = new ItemStack(Material.RED_BED);
                ItemMeta bedMeta = bedItem.getItemMeta();
                String homeNamePath = config.getString("homes-menu.home-item.display-name");
                if (homeNamePath != null) {
                    String homeNameItem = ChatColor.translateAlternateColorCodes((char)'&', (String)homeNamePath).replace("%home%", home);
                    bedMeta.setDisplayName(homeNameItem);
                }
                bedMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "homePosition"), PersistentDataType.STRING, (Object)home);
                List lore = config.getStringList("homes-menu.home-item.lore");
                if (lore != null) {
                    for (int j = 0; j < lore.size(); ++j) {
                        lore.set(j, ChatColor.translateAlternateColorCodes((char)'&', (String)((String)lore.get(j)).replace("%home%", home).replace("%world%", world).replace("%x%", String.valueOf(Math.round(x))).replace("%y%", String.valueOf(Math.round(y))).replace("%z%", String.valueOf(Math.round(z)))));
                    }
                    bedMeta.setLore(lore);
                }
                bedItem.setItemMeta(bedMeta);
                homesMenu.addItem(new ItemStack[]{bedItem});
            }
        }
        for (int i = size - 9; i < size; ++i) {
            ItemStack glassPane = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
            ItemMeta meta = glassPane.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)"&f"));
                glassPane.setItemMeta(meta);
            }
            homesMenu.setItem(i, glassPane);
        }
        ItemStack goBack = new ItemStack(Material.ARROW);
        ItemMeta goBackMeta = goBack.getItemMeta();
        if (goBackMeta != null) {
            String goBackPath = config.getString("homes-menu.go-back-item");
            goBackMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)goBackPath));
            goBack.setItemMeta(goBackMeta);
        }
        homesMenu.setItem(size - 9 + 3, goBack);
        ItemStack close = new ItemStack(Material.BARRIER);
        ItemMeta closeMeta = close.getItemMeta();
        if (closeMeta != null) {
            String closePath = config.getString("homes-menu.close-item");
            closeMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)closePath));
            close.setItemMeta(closeMeta);
        }
        homesMenu.setItem(size - 9 + 4, close);
        if (page > 0) {
            ItemStack previousPage = new ItemStack(Material.PAPER);
            ItemMeta meta = previousPage.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("homes-menu.previous-page-item")));
                meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "menuPage"), PersistentDataType.INTEGER, (Object)(page - 1));
                previousPage.setItemMeta(meta);
            }
            homesMenu.setItem(size - 9 + 1, previousPage);
        }
        if (page < totalPages - 1) {
            ItemStack nextPage = new ItemStack(Material.PAPER);
            ItemMeta meta = nextPage.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("homes-menu.next-page-item")));
                meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "menuPage"), PersistentDataType.INTEGER, (Object)(page + 1));
                nextPage.setItemMeta(meta);
            }
            homesMenu.setItem(size - 9 + 7, nextPage);
        }
        player.openInventory(homesMenu);
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        File playerFile;
        YamlConfiguration playerConfig;
        Player player = event.getPlayer();
        FileConfiguration config = this.plugin.getConfig();
        if (this.plugin.isDeletingHome(player.getUniqueId())) {
            event.setCancelled(true);
            return;
        }
        if (!this.pendingHomeNames.containsKey(player) && !this.pendingAdminHomes.containsKey(player)) {
            return;
        }
        String message = event.getMessage();
        if (message.equalsIgnoreCase("cancel")) {
            this.pendingHomeNames.remove(player);
            this.pendingAdminHomes.remove(player);
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-cancelled")));
            event.setCancelled(true);
            return;
        }
        String homeName = message;
        File dataFolder = new File(this.plugin.getDataFolder(), "data");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        if ((playerConfig = YamlConfiguration.loadConfiguration((File)(playerFile = new File(dataFolder, player.getUniqueId() + ".yml")))).contains(homeName)) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-exists")));
            this.pendingHomeNames.remove(player);
            this.pendingAdminHomes.remove(player);
            event.setCancelled(true);
            return;
        }
        int maxHomes = this.getMaxHomesForPlayer(player);
        List homes = playerConfig.getStringList("homes");
        if (homes.size() >= maxHomes) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-limit-reached").replace("%limit%", String.valueOf(maxHomes))));
            this.pendingHomeNames.remove(player);
            this.pendingAdminHomes.remove(player);
            event.setCancelled(true);
            return;
        }
        Location loc = player.getLocation();
        String worldName = loc.getWorld().getName();
        homes.add(homeName);
        playerConfig.set("homes", (Object)homes);
        playerConfig.set(homeName + ".world", (Object)worldName);
        playerConfig.set(homeName + ".x", (Object)loc.getX());
        playerConfig.set(homeName + ".y", (Object)loc.getY());
        playerConfig.set(homeName + ".z", (Object)loc.getZ());
        playerConfig.set(homeName + ".yaw", (Object)Float.valueOf(loc.getYaw()));
        playerConfig.set(homeName + ".pitch", (Object)Float.valueOf(loc.getPitch()));
        try {
            playerConfig.save(playerFile);
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.home-established")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.pendingHomeNames.remove(player);
        this.pendingAdminHomes.remove(player);
        event.setCancelled(true);
    }

    private int getMaxHomesForPlayer(Player player) {
        FileConfiguration config = this.plugin.getConfig();
        int defaultMaxHomes = config.getInt("default-maxhomes", 3);
        int maxHomes = -1;
        for (PermissionAttachmentInfo permInfo : player.getEffectivePermissions()) {
            String perm = permInfo.getPermission().toLowerCase();
            if (!perm.startsWith("sethome.maxhomes.")) continue;
            try {
                int value = Integer.parseInt(perm.replace("sethome.maxhomes.", ""));
                if (value <= maxHomes) continue;
                maxHomes = value;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return maxHomes > -1 ? maxHomes : defaultMaxHomes;
    }

    public void openAdminMenu(Player player, int page) {
        int i;
        player.closeInventory();
        FileConfiguration config = this.plugin.getConfig();
        int size = config.getInt("admin-menu.size", 54);
        List<OfflinePlayer> players = Arrays.asList(Bukkit.getOfflinePlayers());
        players.sort(Comparator.comparing(OfflinePlayer::getName, String.CASE_INSENSITIVE_ORDER));
        int itemsPerPage = size - 9;
        int totalPages = (int)Math.ceil((double)players.size() / (double)itemsPerPage);
        if (totalPages == 0) {
            totalPages = 1;
        }
        String title = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("admin-menu.gui-title", "&8Admin Menu - Page %page%/%maxpages%")).replace("%page%", String.valueOf(page + 1)).replace("%maxpages%", String.valueOf(totalPages));
        Inventory menu = Bukkit.createInventory((InventoryHolder)new AdminMenuHolder(), (int)size, (String)title);
        int start = page * itemsPerPage;
        int end = Math.min(start + itemsPerPage, players.size());
        for (i = start; i < end; ++i) {
            OfflinePlayer target = players.get(i);
            ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)skull.getItemMeta();
            if (meta != null) {
                meta.setOwningPlayer(target);
                meta.setDisplayName(ChatColor.YELLOW + target.getName());
                List lore = config.getStringList("admin-menu.player-head-lore");
                lore.replaceAll(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line.replace("%player%", target.getName())));
                meta.setLore(lore);
                meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "adminHomeTarget"), PersistentDataType.STRING, (Object)target.getUniqueId().toString());
                skull.setItemMeta((ItemMeta)meta);
            }
            menu.addItem(new ItemStack[]{skull});
        }
        for (i = size - 9; i < size; ++i) {
            ItemStack glass = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
            ItemMeta meta = glass.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(" ");
                glass.setItemMeta(meta);
            }
            menu.setItem(i, glass);
        }
        ItemStack goBack = new ItemStack(Material.ARROW);
        ItemMeta goBackMeta = goBack.getItemMeta();
        if (goBackMeta != null) {
            String goBackPath = config.getString("admin-menu.go-back-item");
            goBackMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)goBackPath));
            goBack.setItemMeta(goBackMeta);
        }
        menu.setItem(size - 9 + 3, goBack);
        ItemStack close = new ItemStack(Material.BARRIER);
        ItemMeta closeMeta = close.getItemMeta();
        if (closeMeta != null) {
            String closePath = config.getString("homes-menu.close-item");
            closeMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)closePath));
            close.setItemMeta(closeMeta);
        }
        menu.setItem(size - 9 + 4, close);
        if (page > 0) {
            ItemStack prev = new ItemStack(Material.PAPER);
            ItemMeta prevMeta = prev.getItemMeta();
            prevMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("admin-menu.previous-page-item", "&7P\u00e1gina anterior")));
            prevMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "adminPage"), PersistentDataType.INTEGER, (Object)(page - 1));
            prev.setItemMeta(prevMeta);
            menu.setItem(size - 9 + 1, prev);
        }
        if (page < totalPages - 1) {
            ItemStack next = new ItemStack(Material.PAPER);
            ItemMeta nextMeta = next.getItemMeta();
            nextMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("admin-menu.next-page-item", "&7P\u00e1gina siguiente")));
            nextMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "adminPage"), PersistentDataType.INTEGER, (Object)(page + 1));
            next.setItemMeta(nextMeta);
            menu.setItem(size - 9 + 7, next);
        }
        player.openInventory(menu);
    }

    public void openPlayerHomesInventory(Player admin, OfflinePlayer target, int page) {
        admin.closeInventory();
        FileConfiguration config = this.plugin.getConfig();
        int size = config.getInt("homes-menu.size");
        File dataFolder = new File(this.plugin.getDataFolder(), "data");
        File playerFile = new File(dataFolder, target.getUniqueId() + ".yml");
        YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
        List homes = playerConfig.getStringList("homes");
        int itemsPerPage = size - 9;
        int totalPages = (int)Math.ceil((double)homes.size() / (double)itemsPerPage);
        if (totalPages == 0) {
            totalPages = 1;
        }
        String rawTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("admin-menu.admin-gui-title")).replace("%page%", String.valueOf(page + 1)).replace("%maxpages%", String.valueOf(totalPages)).replace("%player%", String.valueOf(target.getName()));
        Inventory homesMenu = Bukkit.createInventory((InventoryHolder)new AdminMenuHolder(), (int)size, (String)rawTitle);
        if (homes.isEmpty()) {
            ItemStack noHomesItem = new ItemStack(Material.PAPER);
            ItemMeta noHomesMeta = noHomesItem.getItemMeta();
            if (noHomesMeta != null) {
                String displayName = config.getString("homes-menu.no-homes-item.display-name");
                List lore = config.getStringList("homes-menu.no-homes-item.lore");
                noHomesMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)displayName));
                lore.replaceAll(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                noHomesMeta.setLore(lore);
                noHomesItem.setItemMeta(noHomesMeta);
            }
            homesMenu.setItem(22, noHomesItem);
        } else {
            int start = page * itemsPerPage;
            int end = Math.min(start + itemsPerPage, homes.size());
            for (int i = start; i < end; ++i) {
                String home = (String)homes.get(i);
                if (!playerConfig.contains(home)) continue;
                String world = playerConfig.getString(home + ".world");
                double x = playerConfig.getDouble(home + ".x");
                double y = playerConfig.getDouble(home + ".y");
                double z = playerConfig.getDouble(home + ".z");
                if (world == null) continue;
                ItemStack bedItem = new ItemStack(Material.RED_BED);
                ItemMeta bedMeta = bedItem.getItemMeta();
                String homeNamePath = config.getString("homes-menu.home-item.display-name");
                bedMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)homeNamePath).replace("%home%", home));
                bedMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "adminHomeName"), PersistentDataType.STRING, (Object)home);
                bedMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "adminHomeTarget"), PersistentDataType.STRING, (Object)target.getUniqueId().toString());
                List lore = config.getStringList("homes-menu.home-item.lore");
                for (int j = 0; j < lore.size(); ++j) {
                    lore.set(j, ChatColor.translateAlternateColorCodes((char)'&', (String)((String)lore.get(j)).replace("%home%", home).replace("%world%", world).replace("%x%", String.valueOf(x)).replace("%y%", String.valueOf(y)).replace("%z%", String.valueOf(z))));
                }
                bedMeta.setLore(lore);
                bedItem.setItemMeta(bedMeta);
                homesMenu.addItem(new ItemStack[]{bedItem});
            }
        }
        for (int i = size - 9; i < size; ++i) {
            ItemStack pane = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
            ItemMeta meta = pane.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(" ");
                pane.setItemMeta(meta);
            }
            homesMenu.setItem(i, pane);
        }
        ItemStack back = new ItemStack(Material.ARROW);
        ItemMeta backMeta = back.getItemMeta();
        if (backMeta != null) {
            String backPath = config.getString("homes-menu.go-back-item");
            backMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)backPath));
            back.setItemMeta(backMeta);
        }
        homesMenu.setItem(size - 9 + 3, back);
        ItemStack close = new ItemStack(Material.BARRIER);
        ItemMeta closeMeta = close.getItemMeta();
        if (closeMeta != null) {
            String closePath = config.getString("homes-menu.close-item");
            closeMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)closePath));
            close.setItemMeta(closeMeta);
        }
        homesMenu.setItem(size - 9 + 4, close);
        if (page > 0) {
            ItemStack prev = new ItemStack(Material.PAPER);
            ItemMeta meta = prev.getItemMeta();
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("homes-menu.previous-page-item")));
            meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "adminHomesPage"), PersistentDataType.INTEGER, (Object)(page - 1));
            meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "adminHomeTarget"), PersistentDataType.STRING, (Object)target.getUniqueId().toString());
            prev.setItemMeta(meta);
            homesMenu.setItem(size - 9 + 1, prev);
        }
        if (page < totalPages - 1) {
            ItemStack next = new ItemStack(Material.PAPER);
            ItemMeta meta = next.getItemMeta();
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("homes-menu.next-page-item")));
            meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "adminHomesPage"), PersistentDataType.INTEGER, (Object)(page + 1));
            meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "adminHomeTarget"), PersistentDataType.STRING, (Object)target.getUniqueId().toString());
            next.setItemMeta(meta);
            homesMenu.setItem(size - 9 + 7, next);
        }
        admin.openInventory(homesMenu);
    }

    @EventHandler
    public void onAdminInventoryClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder() instanceof AdminMenuHolder)) {
            return;
        }
        FileConfiguration config = this.plugin.getConfig();
        String adminConfirmationTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("confirmation-menu-admin.gui-title"));
        event.setCancelled(true);
        Player admin = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || !clickedItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        NamespacedKey pageKey = new NamespacedKey((Plugin)this.plugin, "adminPage");
        if (clickedItem.getType() == Material.PLAYER_HEAD) {
            OfflinePlayer target = this.getTargetFromItemMeta(meta);
            if (target == null) {
                admin.sendMessage(ChatColor.RED + "Error: No se pudo determinar el jugador.");
                return;
            }
            this.openPlayerHomesInventory(admin, target, 0);
            return;
        }
        if (meta.getPersistentDataContainer().has(pageKey, PersistentDataType.INTEGER)) {
            int newPage = (Integer)meta.getPersistentDataContainer().get(pageKey, PersistentDataType.INTEGER);
            this.openAdminMenu(admin, newPage);
            return;
        }
        NamespacedKey homesPageKey = new NamespacedKey((Plugin)this.plugin, "adminHomesPage");
        NamespacedKey homeTargetKey = new NamespacedKey((Plugin)this.plugin, "adminHomeTarget");
        if (meta.getPersistentDataContainer().has(homesPageKey, PersistentDataType.INTEGER) && meta.getPersistentDataContainer().has(homeTargetKey, PersistentDataType.STRING)) {
            int newPage = (Integer)meta.getPersistentDataContainer().get(homesPageKey, PersistentDataType.INTEGER);
            String uuidString = (String)meta.getPersistentDataContainer().get(homeTargetKey, PersistentDataType.STRING);
            OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuidString));
            this.openPlayerHomesInventory(admin, target, newPage);
            return;
        }
        String displayName = ChatColor.stripColor((String)meta.getDisplayName());
        String backItem = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("homes-menu.go-back-item")));
        String closeItem = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("homes-menu.close-item")));
        if (displayName.equalsIgnoreCase(backItem)) {
            admin.closeInventory();
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.openMainMenu(admin), 1L);
            return;
        }
        if (displayName.equalsIgnoreCase(closeItem)) {
            admin.closeInventory();
            return;
        }
        if (event.getClick() == ClickType.LEFT && clickedItem.getType() == Material.RED_BED) {
            String homeName = (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "adminHomeName"), PersistentDataType.STRING);
            if (homeName == null) {
                return;
            }
            OfflinePlayer target = this.getTargetFromItemMeta(meta);
            if (target == null) {
                admin.sendMessage(ChatColor.RED + "Error: No se pudo determinar el jugador.");
                return;
            }
            this.teleportPlayerToHome(admin, target, homeName);
            return;
        }
        if (event.getClick() == ClickType.RIGHT && clickedItem.getType() == Material.RED_BED) {
            String homeName = (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "adminHomeName"), PersistentDataType.STRING);
            if (homeName == null) {
                return;
            }
            OfflinePlayer target = this.getTargetFromItemMeta(meta);
            if (target == null) {
                admin.sendMessage(ChatColor.RED + "Error: No se pudo determinar el jugador.");
                return;
            }
            this.openAdminConfirmationMenu(admin, target, homeName);
            return;
        }
        if (event.getView().getTitle().equals(adminConfirmationTitle)) {
            event.setCancelled(true);
            UUID adminUUID = admin.getUniqueId();
            this.plugin.startDeletingHome(adminUUID);
            if (clickedItem == null || !clickedItem.hasItemMeta()) {
                return;
            }
            ItemMeta metaItem = clickedItem.getItemMeta();
            String itemName = ChatColor.stripColor((String)metaItem.getDisplayName());
            String confirmName = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("confirmation-menu-admin.confirm-item.display-name", "&aConfirm")));
            String cancelName = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("confirmation-menu-admin.cancel-item.display-name", "&cCancel")));
            if (itemName.equals(confirmName)) {
                UUID targetUUID;
                String homeName = (String)metaItem.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "homeName"), PersistentDataType.STRING);
                String uuidString = (String)metaItem.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "adminHomeTarget"), PersistentDataType.STRING);
                if (homeName == null || uuidString == null) {
                    admin.sendMessage(ChatColor.RED + "Error: No se pudo recuperar la informaci\u00f3n para eliminar el hogar.");
                    admin.closeInventory();
                    this.plugin.stopDeletingHome(adminUUID);
                    return;
                }
                try {
                    targetUUID = UUID.fromString(uuidString);
                }
                catch (IllegalArgumentException e) {
                    admin.sendMessage(ChatColor.RED + "Error: UUID del jugador inv\u00e1lido.");
                    admin.closeInventory();
                    this.plugin.stopDeletingHome(adminUUID);
                    return;
                }
                OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)targetUUID);
                File targetFile = new File(this.plugin.getDataFolder(), "data/" + targetUUID + ".yml");
                YamlConfiguration targetConfig = YamlConfiguration.loadConfiguration((File)targetFile);
                List homes = targetConfig.getStringList("homes");
                if (homes.contains(homeName)) {
                    homes.remove(homeName);
                    targetConfig.set("homes", (Object)homes);
                    targetConfig.set(homeName, null);
                    try {
                        targetConfig.save(targetFile);
                        String playerName = target.getName() != null ? target.getName() : targetUUID.toString();
                        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.admin-home-removed")).replace("%home%", homeName).replace("%player%", playerName);
                        admin.sendMessage(message);
                        admin.closeInventory();
                        event.setCancelled(true);
                        this.plugin.stopDeletingHome(adminUUID);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        admin.sendMessage(ChatColor.RED + "Ocurri\u00f3 un error al guardar los datos.");
                        this.plugin.stopDeletingHome(adminUUID);
                    }
                } else {
                    admin.sendMessage(ChatColor.RED + "El jugador no tiene un hogar con ese nombre.");
                    admin.closeInventory();
                    this.plugin.stopDeletingHome(adminUUID);
                }
            } else if (itemName.equals(cancelName)) {
                admin.sendMessage(ChatColor.GRAY + "Operaci\u00f3n cancelada.");
                admin.closeInventory();
                this.plugin.stopDeletingHome(adminUUID);
            }
            return;
        }
    }

    private OfflinePlayer getTargetFromItemMeta(ItemMeta meta) {
        if (meta == null) {
            return null;
        }
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "adminHomeTarget");
        if (!meta.getPersistentDataContainer().has(key, PersistentDataType.STRING)) {
            this.plugin.getLogger().warning("[SetHome] Item sin adminHomeTarget.");
            return null;
        }
        String uuidString = (String)meta.getPersistentDataContainer().get(key, PersistentDataType.STRING);
        if (uuidString == null) {
            this.plugin.getLogger().warning("[SetHome] adminHomeTarget es null.");
            return null;
        }
        if ((uuidString = uuidString.trim()).length() == 0) {
            this.plugin.getLogger().warning("[SetHome] adminHomeTarget est\u00e1 vac\u00edo.");
            return null;
        }
        try {
            UUID uuid = UUID.fromString(uuidString);
            return Bukkit.getOfflinePlayer((UUID)uuid);
        }
        catch (IllegalArgumentException ex) {
            this.plugin.getLogger().warning("[SetHome] UUID inv\u00e1lido: " + uuidString);
            return null;
        }
    }

    public void teleportPlayerToHome(Player admin, OfflinePlayer target, String homeName) {
        File dataFolder = new File(this.plugin.getDataFolder(), "data");
        File playerFile = new File(dataFolder, target.getUniqueId() + ".yml");
        YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
        if (!playerConfig.contains(homeName)) {
            String msg = this.plugin.getConfig().getString("messages.player-home-not-exist");
            if (msg != null) {
                msg = ChatColor.translateAlternateColorCodes((char)'&', (String)msg).replace("%home%", homeName).replace("%player%", target.getName());
                admin.sendMessage(msg);
            }
            return;
        }
        String world = playerConfig.getString(homeName + ".world");
        double x = playerConfig.getDouble(homeName + ".x");
        double y = playerConfig.getDouble(homeName + ".y");
        double z = playerConfig.getDouble(homeName + ".z");
        if (world == null) {
            admin.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)playerConfig.getString("messages.invalid-location")));
            return;
        }
        World targetWorld = Bukkit.getServer().getWorld(world);
        if (targetWorld == null) {
            admin.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)playerConfig.getString("messages.world-not-exist")));
            return;
        }
        Location homeLocation = new Location(targetWorld, x, y, z);
        admin.teleport(homeLocation);
        String message = this.plugin.getConfig().getString("messages.teleported-other-home");
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message).replace("%home%", homeName).replace("%player_home%", target.getName());
        admin.sendMessage(message);
    }

    public void openAdminConfirmationMenu(Player admin, OfflinePlayer target, String homeName) {
        FileConfiguration config = this.plugin.getConfig();
        Inventory confirmMenu = Bukkit.createInventory((InventoryHolder)new AdminMenuHolder(), (int)9, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("confirmation-menu-admin.gui-title")));
        String confirmMaterialName = config.getString("confirmation-menu.confirm-item.material", "GREEN_WOOL");
        String cancelMaterialName = config.getString("confirmation-menu.cancel-item.material", "RED_WOOL");
        Material confirmMaterial = Material.getMaterial((String)confirmMaterialName.toUpperCase());
        Material cancelMaterial = Material.getMaterial((String)cancelMaterialName.toUpperCase());
        if (confirmMaterial == null) {
            confirmMaterial = Material.GREEN_WOOL;
        }
        if (cancelMaterial == null) {
            cancelMaterial = Material.RED_WOOL;
        }
        ItemStack confirmItem = new ItemStack(confirmMaterial);
        ItemMeta confirmMeta = confirmItem.getItemMeta();
        confirmMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("confirmation-menu.confirm-item.display-name", "&aConfirm")));
        confirmMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "homeName"), PersistentDataType.STRING, (Object)homeName);
        confirmMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "adminHomeTarget"), PersistentDataType.STRING, (Object)target.getUniqueId().toString());
        confirmItem.setItemMeta(confirmMeta);
        ItemStack cancelItem = new ItemStack(cancelMaterial);
        ItemMeta cancelMeta = cancelItem.getItemMeta();
        cancelMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("confirmation-menu.cancel-item.display-name", "&cCancel")));
        cancelItem.setItemMeta(cancelMeta);
        confirmMenu.setItem(3, confirmItem);
        confirmMenu.setItem(5, cancelItem);
        admin.openInventory(confirmMenu);
        this.plugin.startDeletingHome(admin.getUniqueId());
        this.playerTargetMap.put(admin.getUniqueId(), target);
        this.pendingAdminHomes.put(admin, homeName);
    }
}

