/*
 * Decompiled with CFR 0.152.
 */
package beeted.sethome;

import beeted.sethome.HomeCommandExecutor;
import beeted.sethome.HomeTabCompleter;
import beeted.sethome.Menu;
import beeted.sethome.Metrics;
import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import dev.dejvokep.boostedyaml.settings.loader.LoaderSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SetHome
extends JavaPlugin {
    ConsoleCommandSender console = Bukkit.getConsoleSender();
    private HomeCommandExecutor commandExecutor;
    private HomeTabCompleter commandTabExecutor;
    private YamlDocument configYaml;
    private final Set<UUID> adminsDeletingHome = new HashSet<UUID>();

    public void startDeletingHome(UUID adminUUID) {
        this.adminsDeletingHome.add(adminUUID);
    }

    public void stopDeletingHome(UUID adminUUID) {
        this.adminsDeletingHome.remove(adminUUID);
    }

    public boolean isDeletingHome(UUID adminUUID) {
        return this.adminsDeletingHome.contains(adminUUID);
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadConfig();
        try {
            this.configYaml = YamlDocument.create(new File(this.getDataFolder(), "config.yml"), this.getResource("config.yml"), GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(true).build());
            this.configYaml.save();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getLogger().severe("Could not load config.yml.");
        }
        String userCommand = this.getConfig().getString("menu.open-command").replace("/", "");
        this.commandExecutor = new HomeCommandExecutor(this);
        this.getCommand(userCommand).setExecutor((CommandExecutor)this.commandExecutor);
        this.getCommand(userCommand).setTabCompleter((TabCompleter)new HomeTabCompleter(this));
        this.getLogger().info("SetHome GUI plugin enabled with dynamic command: /" + userCommand);
        this.getServer().getPluginManager().registerEvents((Listener)new Menu(this), (Plugin)this);
        int pluginId = 23348;
        new Metrics((Plugin)this, pluginId);
    }

    public HomeCommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public void onDisable() {
        this.console.sendMessage("[SetHome GUI] Saving your home...");
        this.console.sendMessage("[SetHome GUI] Saving config.");
    }

    public void registerConfig() {
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
    }

    public File getPlayerDataFile(UUID uuid) {
        File dataFolder = new File(this.getDataFolder(), "data");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        return new File(dataFolder, uuid.toString() + ".yml");
    }

    public List<String> getHomesFor(Player player) {
        List<String> homes = new ArrayList<String>();
        File file = this.getPlayerDataFile(player.getUniqueId());
        if (!file.exists()) {
            return homes;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        homes = config.getStringList("homes");
        return homes != null ? homes : new ArrayList();
    }
}

