package dev.ianaduarte.timber.mixin;

import com.mojang.datafixers.util.Pair;
import dev.ianaduarte.timber.util.LeafParticleSpawner;
import dev.ianaduarte.timber.util.TreeDirection;
import dev.ianaduarte.timber.util.TreeNode;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.*;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_7924;

@Mixin(class_2248.class)
public class LogMixin {
	@Unique private static final int MAX_LOGS = 512;
	@Unique private static final int MAX_LEAVES = 1024;
	@Unique private static final TreeDirection[] TOP_LEVEL_DIRECTIONS  = new TreeDirection[]{
		TreeDirection.NORTH, TreeDirection.NORTHUP,
		TreeDirection.NORTHEAST, TreeDirection.NORTHEASTUP,
		TreeDirection.NORTHWEST, TreeDirection.NORTHWESTUP,
		TreeDirection.SOUTH, TreeDirection.SOUTHUP,
		TreeDirection.SOUTHEAST, TreeDirection.SOUTHEASTUP,
		TreeDirection.SOUTHWEST, TreeDirection.SOUTHWESTUP,
		TreeDirection.EAST, TreeDirection.EASTUP,
		TreeDirection.WEST, TreeDirection.WESTUP,
		TreeDirection.UP
	};
	@Unique private static final double[] SPEED_MAP = new double[]{
		0.10, 0.20, 0.25, 0.30,
		0.32, 0.34, 0.36, 0.38,
		0.40, 0.42, 0.44, 0.46,
		0.48, 0.50, 0.52, 0.54,
		0.56, 0.58, 0.60, 0.62,
		0.64, 0.66, 0.68, 0.70,
		0.72, 0.74, 0.76, 0.78,
		0.80, 0.82, 0.84, 0.86
	};
	@Unique private static final double[] OFFSET_MAP = new double[]{
		0.25, 0.50, 1.00, 1.50,
		2.00, 2.50, 2.75, 3.00,
		3.25, 3.50, 3.75, 4.00,
		4.25, 4.50, 4.75, 5.00,
		5.25, 5.50, 5.75, 6.00,
		6.25, 6.50, 6.75, 7.00,
		7.25, 7.50, 7.75, 8.00,
		8.25, 8.50, 8.75, 9.00
	};
	
	@Unique
	private static boolean isSilkTouchMainHand(class_1657 player) {
		var silkTouchEnchantmentReference = player.method_73183().method_30349().method_30530(class_7924.field_41265).method_46747(class_1893.field_9099);
		return player.method_6047().method_58657().method_57536(silkTouchEnchantmentReference) != 0;
	}
	
	@Unique
	private static IntIntPair collectPositions(class_1937 level, class_2338 rootPos, class_2680 rootState, List<Pair<class_2338, class_2680>> outPositions, Vector3f outTendency) {
		var positionsToCheck = new ArrayDeque<TreeNode>();
		var checkedPositions = new HashSet<class_2338>();
		checkedPositions.add(rootPos);
		outPositions.add(Pair.of(rootPos, rootState));
		
		for(var direction : TOP_LEVEL_DIRECTIONS) {
			positionsToCheck.push(new TreeNode(rootPos.method_10081(direction.getOffset()), direction.getOpposite()));
		}
		
		int logCount = 0;
		int leafCount = 0;
		Vector3i tendencyAccum = new Vector3i(0, 1, 0);
		
		while(!positionsToCheck.isEmpty()) {
			var cNode = positionsToCheck.pop();
			var cPos = cNode.position();
			var cState = level.method_8320(cNode.position());
			
			if(checkedPositions.contains(cPos)) continue;
			checkedPositions.add(cPos);
			if(cState.method_26164(class_3481.field_15475)) {
				logCount++;
				tendencyAccum.add(cPos.method_10263() - rootPos.method_10263(), cPos.method_10264() - rootPos.method_10264(), cPos.method_10260() - rootPos.method_10260());
				if(logCount > MAX_LOGS) return IntIntPair.of(0, 0);
			}
			else if(cState.method_26164(class_3481.field_15503)) {
				leafCount++;
				tendencyAccum.add(
					(cPos.method_10263() - rootPos.method_10263()) / 4,
					(cPos.method_10264() - rootPos.method_10264()) / 4,
					(cPos.method_10260() - rootPos.method_10260()) / 4
				);
				if(leafCount > MAX_LEAVES) return IntIntPair.of(0, 0);
			}
			else {
				continue;
			}
			outPositions.add(Pair.of(cPos, cState));
			for(TreeDirection direction : TreeDirection.VALUES) {
				if(direction == cNode.fromDirection()) continue;
				
				var nPos = cNode.position().method_10081(direction.getOffset());
				if(checkedPositions.contains(nPos)) continue;
				positionsToCheck.push(new TreeNode(nPos, direction.getOpposite()));
			}
		}
		outTendency.set(tendencyAccum).normalize();
		return IntIntPair.of(logCount, leafCount);
	}
	
	@Unique
	private static void spawnFallingBlocks(class_1937 level, class_1657 player, class_2338 rootPos, List<Pair<class_2338, class_2680>> positionsToBreak) {
		double radY = class_3532.field_29847 * (player.method_36454() + 90.0F);
		double x = Math.cos(radY);
		double z = Math.sin(radY);
		boolean isXOriented = Math.abs(x) > Math.abs(z);
		
		for(var cPair : positionsToBreak) {
			var cPos = cPair.getFirst();
			var cState = cPair.getSecond();
			if(cState.method_26164(class_3481.field_15475) && cState.method_28498(class_2465.field_11459)) {
				cState = cState.method_11657(class_2465.field_11459, isXOriented ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051);
			}
			else if(cState.method_26164(class_3481.field_15503) && cState.method_28498(class_2397.field_11199)) {
				cState = cState.method_11657(class_2397.field_11199, class_2397.field_31111);
			}
			
			var index = Math.min(Math.abs(rootPos.method_10264() - cPos.method_10264()), 31);
			var cX = cPos.method_10263() + 0.5 + x * OFFSET_MAP[index];
			var cY = cPos.method_10264() - OFFSET_MAP[index];
			var cZ = cPos.method_10260() + 0.5 + z * OFFSET_MAP[index];
			
			var fallingBlock = new class_1540(level, cX, cY, cZ, cState);
			var motion = SPEED_MAP[index] * 1.05;
			var movement = new class_243(x * motion, 0.0, z * motion);
			fallingBlock.method_18799(movement);
			fallingBlock.field_7192 = 1;
			fallingBlock.field_6014 = cX;
			fallingBlock.field_6036 = cY;
			fallingBlock.field_5969 = cZ;
			
			fallingBlock.method_6963(cPos);
			if(cState.method_26164(class_3481.field_15475)) {
				fallingBlock.field_7193 = true;
				fallingBlock.method_6965(2.0F, 40);
			} else if(cState.method_26204() instanceof class_2397 leavesBlock){
				fallingBlock.field_7193 = false;
				//parameters do fucking NOTHING, because like, why would they :)))))
				((LeafParticleSpawner)leavesBlock).spawnParticles(
					level, cPos, level.field_9229.method_43051(0, 3),
					x * 512, -12, z * 512,
					0.2, 0.3
				);
			}
			
			level.method_8649(fallingBlock);
			level.method_8650(cPos, true);
		}
	}
	
	@Inject(method = "playerWillDestroy", at = @At("HEAD"))
	private void logBreak(class_1937 level, class_2338 pos, class_2680 state, class_1657 player, CallbackInfoReturnable<class_2680> cir) {
		if(!state.method_26164(class_3481.field_15475) || player.method_5715() || isSilkTouchMainHand(player)) return;
		
		var positionsToBreak = new ArrayList<Pair<class_2338, class_2680>>();
		var tendency = new Vector3f();
		var breakData = collectPositions(level, pos, state, positionsToBreak, tendency);
		
		//logCount, leafCount
		if(breakData.firstInt() < 1 || breakData.secondInt() < 2 || tendency.y <= 0.25) return;
		
		spawnFallingBlocks(level, player, pos, positionsToBreak);
		level.method_45447(null, pos, class_3417.field_14742, class_3419.field_15245);
	}
}
