/*
 * Decompiled with CFR 0.152.
 */
package dev.ianaduarte.timber.mixin;

import com.mojang.datafixers.util.Pair;
import dev.ianaduarte.timber.util.LeafParticleSpawner;
import dev.ianaduarte.timber.util.TreeDirection;
import dev.ianaduarte.timber.util.TreeNode;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2248.class})
public class LogMixin {
    @Unique
    private static final int MAX_LOGS = 512;
    @Unique
    private static final int MAX_LEAVES = 1024;
    @Unique
    private static final TreeDirection[] TOP_LEVEL_DIRECTIONS = new TreeDirection[]{TreeDirection.NORTH, TreeDirection.NORTHUP, TreeDirection.NORTHEAST, TreeDirection.NORTHEASTUP, TreeDirection.NORTHWEST, TreeDirection.NORTHWESTUP, TreeDirection.SOUTH, TreeDirection.SOUTHUP, TreeDirection.SOUTHEAST, TreeDirection.SOUTHEASTUP, TreeDirection.SOUTHWEST, TreeDirection.SOUTHWESTUP, TreeDirection.EAST, TreeDirection.EASTUP, TreeDirection.WEST, TreeDirection.WESTUP, TreeDirection.UP};
    @Unique
    private static final double[] SPEED_MAP = new double[]{0.1, 0.2, 0.25, 0.3, 0.32, 0.34, 0.36, 0.38, 0.4, 0.42, 0.44, 0.46, 0.48, 0.5, 0.52, 0.54, 0.56, 0.58, 0.6, 0.62, 0.64, 0.66, 0.68, 0.7, 0.72, 0.74, 0.76, 0.78, 0.8, 0.82, 0.84, 0.86};
    @Unique
    private static final double[] OFFSET_MAP = new double[]{0.25, 0.5, 1.0, 1.5, 2.0, 2.5, 2.75, 3.0, 3.25, 3.5, 3.75, 4.0, 4.25, 4.5, 4.75, 5.0, 5.25, 5.5, 5.75, 6.0, 6.25, 6.5, 6.75, 7.0, 7.25, 7.5, 7.75, 8.0, 8.25, 8.5, 8.75, 9.0};

    @Unique
    private static boolean isSilkTouchMainHand(class_1657 player) {
        class_6880.class_6883 silkTouchEnchantmentReference = player.method_73183().method_30349().method_30530(class_7924.field_41265).method_46747(class_1893.field_9099);
        return player.method_6047().method_58657().method_57536((class_6880)silkTouchEnchantmentReference) != 0;
    }

    @Unique
    private static IntIntPair collectPositions(class_1937 level, class_2338 rootPos, class_2680 rootState, List<Pair<class_2338, class_2680>> outPositions, Vector3f outTendency) {
        ArrayDeque<TreeNode> positionsToCheck = new ArrayDeque<TreeNode>();
        HashSet<class_2338> checkedPositions = new HashSet<class_2338>();
        checkedPositions.add(rootPos);
        outPositions.add((Pair<class_2338, class_2680>)Pair.of((Object)rootPos, (Object)rootState));
        for (TreeDirection direction : TOP_LEVEL_DIRECTIONS) {
            positionsToCheck.push(new TreeNode(rootPos.method_10081(direction.getOffset()), direction.getOpposite()));
        }
        int logCount = 0;
        int leafCount = 0;
        Vector3i tendencyAccum = new Vector3i(0, 1, 0);
        while (!positionsToCheck.isEmpty()) {
            TreeNode cNode = (TreeNode)positionsToCheck.pop();
            class_2338 cPos = cNode.position();
            class_2680 cState = level.method_8320(cNode.position());
            if (checkedPositions.contains(cPos)) continue;
            checkedPositions.add(cPos);
            if (cState.method_26164(class_3481.field_15475)) {
                tendencyAccum.add(cPos.method_10263() - rootPos.method_10263(), cPos.method_10264() - rootPos.method_10264(), cPos.method_10260() - rootPos.method_10260());
                if (++logCount > 512) {
                    return IntIntPair.of((int)0, (int)0);
                }
            } else {
                if (!cState.method_26164(class_3481.field_15503)) continue;
                tendencyAccum.add((cPos.method_10263() - rootPos.method_10263()) / 4, (cPos.method_10264() - rootPos.method_10264()) / 4, (cPos.method_10260() - rootPos.method_10260()) / 4);
                if (++leafCount > 1024) {
                    return IntIntPair.of((int)0, (int)0);
                }
            }
            outPositions.add((Pair<class_2338, class_2680>)Pair.of((Object)cPos, (Object)cState));
            for (TreeDirection direction : TreeDirection.VALUES) {
                class_2338 nPos;
                if (direction == cNode.fromDirection() || checkedPositions.contains(nPos = cNode.position().method_10081(direction.getOffset()))) continue;
                positionsToCheck.push(new TreeNode(nPos, direction.getOpposite()));
            }
        }
        outTendency.set((Vector3ic)tendencyAccum).normalize();
        return IntIntPair.of((int)logCount, (int)leafCount);
    }

    @Unique
    private static void spawnFallingBlocks(class_1937 level, class_1657 player, class_2338 rootPos, List<Pair<class_2338, class_2680>> positionsToBreak) {
        double radY = (float)Math.PI / 180 * (player.method_36454() + 90.0f);
        double x = Math.cos(radY);
        double z = Math.sin(radY);
        boolean isXOriented = Math.abs(x) > Math.abs(z);
        for (Pair<class_2338, class_2680> cPair : positionsToBreak) {
            class_2338 cPos = (class_2338)cPair.getFirst();
            class_2680 cState = (class_2680)cPair.getSecond();
            if (cState.method_26164(class_3481.field_15475) && cState.method_28498((class_2769)class_2465.field_11459)) {
                cState = (class_2680)cState.method_11657((class_2769)class_2465.field_11459, (Comparable)(isXOriented ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051));
            } else if (cState.method_26164(class_3481.field_15503) && cState.method_28498((class_2769)class_2397.field_11199)) {
                cState = (class_2680)cState.method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(7));
            }
            int index = Math.min(Math.abs(rootPos.method_10264() - cPos.method_10264()), 31);
            double cX = (double)cPos.method_10263() + 0.5 + x * OFFSET_MAP[index];
            double cY = (double)cPos.method_10264() - OFFSET_MAP[index];
            double cZ = (double)cPos.method_10260() + 0.5 + z * OFFSET_MAP[index];
            class_1540 fallingBlock = new class_1540(level, cX, cY, cZ, cState);
            double motion = SPEED_MAP[index] * 1.05;
            class_243 movement = new class_243(x * motion, 0.0, z * motion);
            fallingBlock.method_18799(movement);
            fallingBlock.field_7192 = 1;
            fallingBlock.field_6014 = cX;
            fallingBlock.field_6036 = cY;
            fallingBlock.field_5969 = cZ;
            fallingBlock.method_6963(cPos);
            if (cState.method_26164(class_3481.field_15475)) {
                fallingBlock.field_7193 = true;
                fallingBlock.method_6965(2.0f, 40);
            } else {
                class_2248 class_22482 = cState.method_26204();
                if (class_22482 instanceof class_2397) {
                    class_2397 leavesBlock = (class_2397)class_22482;
                    fallingBlock.field_7193 = false;
                    ((LeafParticleSpawner)leavesBlock).spawnParticles(level, cPos, level.field_9229.method_43051(0, 3), x * 512.0, -12.0, z * 512.0, 0.2, 0.3);
                }
            }
            level.method_8649((class_1297)fallingBlock);
            level.method_8650(cPos, true);
        }
    }

    @Inject(method={"method_9576(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;Lnet/minecraft/class_1657;)Lnet/minecraft/class_2680;"}, at={@At(value="HEAD")})
    private void logBreak(class_1937 level, class_2338 pos, class_2680 state, class_1657 player, CallbackInfoReturnable<class_2680> cir) {
        if (!state.method_26164(class_3481.field_15475) || player.method_5715() || LogMixin.isSilkTouchMainHand(player)) {
            return;
        }
        ArrayList<Pair<class_2338, class_2680>> positionsToBreak = new ArrayList<Pair<class_2338, class_2680>>();
        Vector3f tendency = new Vector3f();
        IntIntPair breakData = LogMixin.collectPositions(level, pos, state, positionsToBreak, tendency);
        if (breakData.firstInt() < 1 || breakData.secondInt() < 2 || (double)tendency.y <= 0.25) {
            return;
        }
        LogMixin.spawnFallingBlocks(level, player, pos, positionsToBreak);
        level.method_45447(null, pos, class_3417.field_14742, class_3419.field_15245);
    }
}

