/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.client.event.guipost;

import com.mojang.blaze3d.platform.Window;
import electrodynamics.common.item.gear.armor.types.ItemJetpack;
import electrodynamics.common.item.gear.armor.types.ItemServoLeggings;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import electrodynamics.registers.ElectrodynamicsItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.gas.GasStack;
import voltaic.api.item.IItemElectric;
import voltaic.client.event.AbstractPostGuiOverlayHandler;
import voltaic.prefab.utilities.ItemUtils;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.prefab.utilities.math.Color;
import voltaic.registers.VoltaicCapabilities;

public class HandlerArmorData
extends AbstractPostGuiOverlayHandler {
    private final Component statusGogglesOn = ElectroTextUtils.tooltip("nightvisiongoggles.status", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("nightvisiongoggles.on", new Object[0]).m_130940_(ChatFormatting.GREEN));
    private final Component statusGogglesOff = ElectroTextUtils.tooltip("nightvisiongoggles.status", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("nightvisiongoggles.off", new Object[0]).m_130940_(ChatFormatting.RED));

    public void renderToScreen(NamedGuiOverlay overlay, GuiGraphics graphics, Window window, Minecraft minecraft, float partialTicks) {
        if (!ElectroConstants.RENDER_COMBAT_ARMOR_STATUS) {
            return;
        }
        NonNullList armor = minecraft.f_91074_.m_150109_().f_35975_;
        graphics.m_280168_().m_85836_();
        int heightOffset = window.m_85446_();
        if (!((ItemStack)armor.get(0)).m_41619_() && HandlerArmorData.handleBoots((ItemStack)armor.get(0), overlay, graphics, window, minecraft, heightOffset)) {
            heightOffset -= 30;
        }
        if (!((ItemStack)armor.get(1)).m_41619_() && HandlerArmorData.handleLeggings((ItemStack)armor.get(1), overlay, graphics, window, minecraft, heightOffset)) {
            heightOffset -= 30;
        }
        if (!((ItemStack)armor.get(2)).m_41619_() && HandlerArmorData.handleChestplate((ItemStack)armor.get(2), overlay, graphics, window, minecraft, heightOffset)) {
            heightOffset -= 30;
        }
        if (!((ItemStack)armor.get(3)).m_41619_() && this.handleHelmet((ItemStack)armor.get(3), overlay, graphics, window, minecraft, heightOffset)) {
            heightOffset -= 30;
        }
        graphics.m_280168_().m_85849_();
    }

    private boolean handleHelmet(ItemStack helmet, NamedGuiOverlay overlay, GuiGraphics graphics, Window window, Minecraft minecraft, int heightOffset) {
        boolean renderItem = false;
        if (ItemUtils.testItems((Item)helmet.m_41720_(), (Item[])new Item[]{(Item)ElectrodynamicsItems.ITEM_NIGHTVISIONGOGGLES.get(), (Item)ElectrodynamicsItems.ITEM_COMBATHELMET.get()})) {
            renderItem = true;
            Component mode = helmet.m_41782_() && helmet.m_41783_().m_128471_("on") ? this.statusGogglesOn : this.statusGogglesOff;
            graphics.m_280430_(minecraft.f_91062_, mode, 35, heightOffset - 30, Color.BLACK.color());
            graphics.m_280614_(minecraft.f_91062_, (Component)ChatFormatter.getChatDisplayShort((double)((IItemElectric)helmet.m_41720_()).getJoulesStored(helmet), (IDisplayUnit)DisplayUnits.JOULES), 35, heightOffset - 20, Color.WHITE.color(), false);
        }
        if (renderItem) {
            RenderingUtils.renderItemScaled((GuiGraphics)graphics, (Item)helmet.m_41720_(), (int)10, (int)(heightOffset - 30), (float)1.5f);
        }
        return renderItem;
    }

    private static boolean handleChestplate(ItemStack chestplate, NamedGuiOverlay overlay, GuiGraphics graphics, Window window, Minecraft minecraft, int heightOffset) {
        Component mode;
        boolean renderItem = false;
        if (ItemUtils.testItems((Item)chestplate.m_41720_(), (Item[])new Item[]{(Item)ElectrodynamicsItems.ITEM_JETPACK.get()})) {
            renderItem = true;
            mode = ItemJetpack.getModeText(chestplate.m_41782_() ? chestplate.m_41783_().m_128451_("mode") : -1);
            chestplate.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).ifPresent(cap -> {
                GasStack gas = cap.getGasInTank(0);
                if (gas.isEmpty()) {
                    graphics.m_280430_(minecraft.f_91062_, mode, 35, heightOffset - 30, 0);
                    graphics.m_280430_(minecraft.f_91062_, (Component)VoltaicTextUtils.ratio((Component)Component.m_237113_((String)"0"), (Component)ChatFormatter.formatFluidMilibuckets((double)30000.0)), 35, heightOffset - 20, Color.WHITE.color());
                } else {
                    graphics.m_280430_(minecraft.f_91062_, mode, 35, heightOffset - 30, 0);
                    graphics.m_280614_(minecraft.f_91062_, (Component)VoltaicTextUtils.ratio((Component)ChatFormatter.formatFluidMilibuckets((double)gas.getAmount()), (Component)ChatFormatter.formatFluidMilibuckets((double)30000.0)), 35, heightOffset - 20, Color.WHITE.color(), false);
                }
            });
        }
        if (ItemUtils.testItems((Item)chestplate.m_41720_(), (Item[])new Item[]{(Item)ElectrodynamicsItems.ITEM_COMBATCHESTPLATE.get()})) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(0.8f, 0.8f, 0.8f);
            renderItem = true;
            mode = ItemJetpack.getModeText(chestplate.m_41782_() ? chestplate.m_41783_().m_128451_("mode") : -1);
            chestplate.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).ifPresent(cap -> {
                GasStack gas = cap.getGasInTank(0);
                int x = 43;
                if (gas.isEmpty()) {
                    graphics.m_280430_(minecraft.f_91062_, mode, x, (int)((float)(heightOffset - 34) / 0.8f), 0);
                    graphics.m_280430_(minecraft.f_91062_, (Component)VoltaicTextUtils.ratio((Component)Component.m_237113_((String)"0"), (Component)ChatFormatter.formatFluidMilibuckets((double)30000.0)), x, (int)((float)(heightOffset - 25) / 0.8f), -1);
                    graphics.m_280430_(minecraft.f_91062_, (Component)ElectroTextUtils.tooltip("ceramicplatecount", Component.m_237113_((String)("" + (chestplate.m_41782_() ? chestplate.m_41783_().m_128451_("plates") : 0)))).m_130940_(ChatFormatting.AQUA), x, (int)((float)(heightOffset - 16) / 0.8f), Color.WHITE.color());
                } else {
                    graphics.m_280430_(minecraft.f_91062_, mode, x, (int)((float)(heightOffset - 34) / 0.8f), 0);
                    graphics.m_280430_(minecraft.f_91062_, (Component)VoltaicTextUtils.ratio((Component)ChatFormatter.formatFluidMilibuckets((double)gas.getAmount()), (Component)ChatFormatter.formatFluidMilibuckets((double)30000.0)), x, (int)((float)(heightOffset - 25) / 0.8f), -1);
                    graphics.m_280430_(minecraft.f_91062_, (Component)ElectroTextUtils.tooltip("ceramicplatecount", Component.m_237113_((String)("" + (chestplate.m_41782_() ? chestplate.m_41783_().m_128451_("plates") : 0)))).m_130940_(ChatFormatting.AQUA), x, (int)((float)(heightOffset - 16) / 0.8f), Color.WHITE.color());
                }
            });
            graphics.m_280168_().m_85849_();
        }
        if (ItemUtils.testItems((Item)chestplate.m_41720_(), (Item[])new Item[]{(Item)ElectrodynamicsItems.ITEM_COMPOSITECHESTPLATE.get()})) {
            renderItem = true;
            graphics.m_280614_(minecraft.f_91062_, (Component)ElectroTextUtils.tooltip("ceramicplatecount", Component.m_237113_((String)("" + (chestplate.m_41782_() ? chestplate.m_41783_().m_128451_("plates") : 0)))).m_130940_(ChatFormatting.AQUA), 35, heightOffset - 25, -1, false);
        }
        if (renderItem) {
            RenderingUtils.renderItemScaled((GuiGraphics)graphics, (Item)chestplate.m_41720_(), (int)10, (int)(heightOffset - 30), (float)1.5f);
        }
        return renderItem;
    }

    private static boolean handleLeggings(ItemStack leggings, NamedGuiOverlay overlay, GuiGraphics graphics, Window window, Minecraft minecraft, int heightOffset) {
        boolean renderItem = false;
        if (ItemUtils.testItems((Item)leggings.m_41720_(), (Item[])new Item[]{(Item)ElectrodynamicsItems.ITEM_SERVOLEGGINGS.get(), (Item)ElectrodynamicsItems.ITEM_COMBATLEGGINGS.get()})) {
            renderItem = true;
            MutableComponent on = leggings.m_41782_() && leggings.m_41783_().m_128471_("on") ? ElectroTextUtils.tooltip("nightvisiongoggles.status", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("nightvisiongoggles.on", new Object[0]).m_130940_(ChatFormatting.GREEN)) : ElectroTextUtils.tooltip("nightvisiongoggles.status", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("nightvisiongoggles.off", new Object[0]).m_130940_(ChatFormatting.RED));
            int x = 43;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(0.8f, 0.8f, 0.8f);
            graphics.m_280430_(minecraft.f_91062_, (Component)on, x, (int)((float)(heightOffset - 34) / 0.8f), 0);
            graphics.m_280614_(minecraft.f_91062_, ItemServoLeggings.getModeText(leggings.m_41782_() ? leggings.m_41783_().m_128451_("mode") : -1), x, (int)((float)(heightOffset - 25) / 0.8f), Color.BLACK.color(), false);
            graphics.m_280614_(minecraft.f_91062_, (Component)ChatFormatter.getChatDisplayShort((double)((IItemElectric)leggings.m_41720_()).getJoulesStored(leggings), (IDisplayUnit)DisplayUnits.JOULES), x, (int)((float)(heightOffset - 16) / 0.8f), Color.WHITE.color(), false);
            graphics.m_280168_().m_85849_();
        }
        if (renderItem) {
            RenderingUtils.renderItemScaled((GuiGraphics)graphics, (Item)leggings.m_41720_(), (int)10, (int)(heightOffset - 30), (float)1.5f);
        }
        return renderItem;
    }

    private static boolean handleBoots(ItemStack boots, NamedGuiOverlay overlay, GuiGraphics graphics, Window window, Minecraft minecraft, int heightOffset) {
        boolean renderItem = false;
        if (ItemUtils.testItems((Item)boots.m_41720_(), (Item[])new Item[]{(Item)ElectrodynamicsItems.ITEM_HYDRAULICBOOTS.get(), (Item)ElectrodynamicsItems.ITEM_COMBATBOOTS.get()})) {
            renderItem = true;
            boots.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> graphics.m_280430_(minecraft.f_91062_, (Component)ChatFormatter.formatFluidMilibuckets((double)handler.getFluidInTank(0).getAmount()), 35, heightOffset - 25, Color.WHITE.color()));
        }
        if (renderItem) {
            RenderingUtils.renderItemScaled((GuiGraphics)graphics, (Item)boots.m_41720_(), (int)10, (int)(heightOffset - 30), (float)1.5f);
        }
        return renderItem;
    }
}

