/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.client.event.levelstage;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import voltaic.client.event.AbstractLevelStageHandler;

public class HandlerSeismicScanner
extends AbstractLevelStageHandler {
    public static final HandlerSeismicScanner INSTANCE = new HandlerSeismicScanner();
    private final HashMap<BlockPos, Long> pingedBlocks = new HashMap();

    public boolean shouldRender(RenderLevelStageEvent.Stage stage) {
        return stage == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS;
    }

    public void render(Camera camera, Frustum frustum, LevelRenderer renderer, PoseStack stack, Matrix4f projectionMatrix, Minecraft minecraft, int renderTick, float partialTick) {
        MultiBufferSource.BufferSource buffer = minecraft.m_91269_().m_110104_();
        VertexConsumer builder = buffer.m_6299_((RenderType)RenderType.f_110371_);
        Vec3 camPos = camera.m_90583_();
        Iterator<Map.Entry<BlockPos, Long>> it = this.pingedBlocks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<BlockPos, Long> entry = it.next();
            AABB box = new AABB(entry.getKey());
            stack.m_85836_();
            stack.m_85837_(-camPos.f_82479_, -camPos.f_82480_, -camPos.f_82481_);
            LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)builder, (AABB)box, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            stack.m_85849_();
            if (System.currentTimeMillis() - entry.getValue() <= 10000L && !minecraft.f_91073_.m_8055_(entry.getKey()).m_60795_()) continue;
            it.remove();
        }
        buffer.m_109912_((RenderType)RenderType.f_110371_);
    }

    public void clear() {
        this.pingedBlocks.clear();
    }

    public static void addBlock(BlockPos pos) {
        HandlerSeismicScanner.INSTANCE.pingedBlocks.put(pos, System.currentTimeMillis());
    }
}

