/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import electrodynamics.common.tile.machines.TileElectrolyticSeparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.utilities.RenderingUtils;

public class RenderElectrolyticSeparator
extends AbstractTileRenderer<TileElectrolyticSeparator> {
    private static final float MIN_X = 0.25f;
    private static final float MAX_X = 0.75f;
    private static final float MIN_Y = 0.375f;
    private static final float MAX_Y = 0.6875f;
    private static final float MIN_Z = 0.25f;
    private static final float MAX_Z = 0.75f;

    public RenderElectrolyticSeparator(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TileElectrolyticSeparator entity, float ticks, @NotNull PoseStack stack, @NotNull MultiBufferSource source, int light, int overlay) {
        PropertyFluidTank tank = ((ComponentFluidHandlerMulti)entity.getComponent(IComponentType.FluidHandler)).getInputTanks()[0];
        if (!tank.isEmpty() && tank.getFluidAmount() > 0) {
            FluidStack fluid = tank.getFluid();
            float yHeight = Math.max(Math.min((float)tank.getFluidAmount() / (float)tank.getCapacity(), 0.6875f), 0.375f);
            AABB aabb = new AABB(0.25, 0.375, 0.25, 0.75, (double)yHeight, 0.75);
            VertexConsumer builder = source.m_6299_(Sheets.m_110792_());
            RenderingUtils.renderFluidBox((PoseStack)stack, (Minecraft)Minecraft.m_91087_(), (VertexConsumer)builder, (AABB)aabb, (FluidStack)fluid, (int)light, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
        }
    }
}

