/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.client.screen.item;

import electrodynamics.common.inventory.container.item.ContainerSeismicScanner;
import electrodynamics.common.item.gear.tools.electric.ItemSeismicScanner;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.types.ScreenComponentMultiLabel;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.math.Color;
import voltaic.prefab.utilities.object.Location;

public class ScreenSeismicScanner
extends GenericScreen<ContainerSeismicScanner> {
    public ScreenSeismicScanner(ContainerSeismicScanner screenContainer, Inventory inv, Component titleIn) {
        super((GenericContainer)screenContainer, inv, titleIn);
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(this::getElectricInformation, -25, 2));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(15, 32, 10, Color.TEXT_GRAY, (Component)ElectroTextUtils.gui("seismicscanner.material", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(85, 25, 10, Color.TEXT_GRAY, (Component)ElectroTextUtils.gui("seismicscanner.dataheader", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentMultiLabel(0, 0, graphics -> {
            Location blockLoc;
            ItemStack ownerItem = ((ContainerSeismicScanner)this.f_97732_).getOwnerItem();
            Location playerLoc = ownerItem.m_41782_() ? Location.readFromNBT((CompoundTag)ownerItem.m_41783_(), (String)"locplayer") : new Location(0.0, 0.0, 0.0);
            Location location = blockLoc = ownerItem.m_41782_() ? Location.readFromNBT((CompoundTag)ownerItem.m_41783_(), (String)"locblock") : new Location(0.0, 0.0, 0.0);
            if (blockLoc.equals((Object)playerLoc)) {
                graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("seismicscanner.xcoordna", new Object[0]), 95, 35, 0x404040, false);
                graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("seismicscanner.ycoordna", new Object[0]), 95, 45, 0x404040, false);
                graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("seismicscanner.zcoordna", new Object[0]), 95, 55, 0x404040, false);
            } else {
                graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("seismicscanner.xcoord", blockLoc.intX()), 95, 35, 0x404040, false);
                graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("seismicscanner.ycoord", blockLoc.intY()), 95, 45, 0x404040, false);
                graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("seismicscanner.zcoord", blockLoc.intZ()), 95, 55, 0x404040, false);
            }
        }));
    }

    private List<? extends FormattedCharSequence> getElectricInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        ItemStack ownerItem = ((ContainerSeismicScanner)this.f_97732_).getOwnerItem();
        Item item = ownerItem.m_41720_();
        if (item instanceof ItemSeismicScanner) {
            ItemSeismicScanner scanner = (ItemSeismicScanner)item;
            list.add(ElectroTextUtils.gui("machine.usage", ChatFormatter.getChatDisplayShort((double)50.0, (IDisplayUnit)DisplayUnits.WATT).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            list.add(ElectroTextUtils.gui("machine.voltage", ChatFormatter.getChatDisplayShort((double)120.0, (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            list.add(ElectroTextUtils.gui("machine.stored", ChatFormatter.getChatDisplayShort((double)scanner.getJoulesStored(ownerItem), (IDisplayUnit)DisplayUnits.JOULES).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        }
        return list;
    }
}

