/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.client.screen.tile;

import electrodynamics.common.inventory.container.tile.ContainerBatteryBox;
import electrodynamics.common.tile.electricitygrid.batteries.TileBatteryBox;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.types.ScreenComponentMultiLabel;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.utilities.VoltaicTextUtils;

@OnlyIn(value=Dist.CLIENT)
public class ScreenBatteryBox
extends GenericScreen<ContainerBatteryBox> {
    public ScreenBatteryBox(ContainerBatteryBox container, Inventory playerInventory, Component title) {
        super((GenericContainer)container, playerInventory, title);
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(this::getElectricInformation, -25, 2));
        this.addComponent((AbstractScreenComponent)new ScreenComponentMultiLabel(0, 0, graphics -> {
            TileBatteryBox box = (TileBatteryBox)((ContainerBatteryBox)this.f_97732_).getSafeHost();
            if (box == null) {
                return;
            }
            ComponentElectrodynamic electro = (ComponentElectrodynamic)box.getComponent(IComponentType.Electrodynamic);
            graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("machine.current", ChatFormatter.getChatDisplayShort((double)((Double)box.powerOutput.getValue() * 20.0 * (Double)box.currentCapacityMultiplier.getValue() / electro.getVoltage()), (IDisplayUnit)DisplayUnits.AMPERE)), this.f_97730_, this.f_97731_ - 55, 0x404040, false);
            graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("machine.transfer", ChatFormatter.getChatDisplayShort((double)((Double)box.powerOutput.getValue() * 20.0 * (Double)box.currentCapacityMultiplier.getValue()), (IDisplayUnit)DisplayUnits.WATT)), this.f_97730_, this.f_97731_ - 42, 0x404040, false);
            graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("machine.voltage", ChatFormatter.getChatDisplayShort((double)electro.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE)), this.f_97730_, this.f_97731_ - 29, 0x404040, false);
            graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("machine.stored", VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)electro.getJoulesStored(), (IDisplayUnit)DisplayUnits.JOULES), (Component)ChatFormatter.getChatDisplayShort((double)((Double)box.maxJoules.getValue() * (Double)box.currentCapacityMultiplier.getValue()), (IDisplayUnit)DisplayUnits.JOULES))), this.f_97730_, this.f_97731_ - 16, 0x404040, false);
        }));
    }

    private List<? extends FormattedCharSequence> getElectricInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        TileBatteryBox box = (TileBatteryBox)((ContainerBatteryBox)this.f_97732_).getSafeHost();
        if (box == null) {
            return list;
        }
        ComponentElectrodynamic el = (ComponentElectrodynamic)box.getComponent(IComponentType.Electrodynamic);
        list.add(ElectroTextUtils.gui("machine.current", ChatFormatter.getChatDisplayShort((double)((Double)box.powerOutput.getValue() * 20.0 * (Double)box.currentCapacityMultiplier.getValue() / el.getVoltage()), (IDisplayUnit)DisplayUnits.AMPERE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        list.add(ElectroTextUtils.gui("machine.transfer", ChatFormatter.getChatDisplayShort((double)((Double)box.powerOutput.getValue() * 20.0 * (Double)box.currentCapacityMultiplier.getValue()), (IDisplayUnit)DisplayUnits.WATT).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        list.add(ElectroTextUtils.gui("machine.transfer", VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)((Double)box.powerOutput.getValue() * (Double)box.currentCapacityMultiplier.getValue()), (IDisplayUnit)DisplayUnits.FORGE_ENERGY_UNIT).m_130940_(ChatFormatting.GRAY), (Component)DisplayUnits.TIME_TICKS.getSymbol())).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        list.add(ElectroTextUtils.gui("machine.voltage", ChatFormatter.getChatDisplayShort((double)el.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        list.add(ElectroTextUtils.gui("machine.stored", VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)el.getJoulesStored(), (IDisplayUnit)DisplayUnits.JOULES), (Component)ChatFormatter.getChatDisplayShort((double)((Double)box.maxJoules.getValue() * (Double)box.currentCapacityMultiplier.getValue()), (IDisplayUnit)DisplayUnits.JOULES)).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        return list;
    }
}

