/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.client.screen.tile;

import electrodynamics.common.inventory.container.tile.ContainerCoalGenerator;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.tile.electricitygrid.generators.TileCoalGenerator;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.types.ScreenComponentMultiLabel;
import voltaic.prefab.screen.component.types.ScreenComponentProgress;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentTemperature;
import voltaic.prefab.screen.component.types.wrapper.WrapperInventoryIO;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.object.TransferPack;

@OnlyIn(value=Dist.CLIENT)
public class ScreenCoalGenerator
extends GenericScreen<ContainerCoalGenerator> {
    public ScreenCoalGenerator(ContainerCoalGenerator container, Inventory playerInventory, Component title) {
        super((GenericContainer)container, playerInventory, title);
        this.addComponent((AbstractScreenComponent)new ScreenComponentProgress(ScreenComponentProgress.ProgressBars.COUNTDOWN_FLAME, () -> {
            TileCoalGenerator box = (TileCoalGenerator)container.getSafeHost();
            if (box != null) {
                return (double)((Integer)box.burnTime.getValue()).intValue() / (double)((Integer)box.maxBurnTime.getValue()).intValue();
            }
            return 0.0;
        }, 25, 25));
        this.addComponent((AbstractScreenComponent)new ScreenComponentTemperature(this::getTemperatureInformation, -25, 28));
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(-25, 2));
        this.addComponent((AbstractScreenComponent)new ScreenComponentMultiLabel(0, 0, graphics -> {
            TileCoalGenerator coal = (TileCoalGenerator)((ContainerCoalGenerator)this.f_97732_).getSafeHost();
            if (coal == null) {
                return;
            }
            TransferPack output = TransferPack.ampsVoltage((double)(ElectroConstants.COALGENERATOR_AMPERAGE * Math.min((coal.heat.getValue() - 27.0) / 2973.0, 1.0)), (double)120.0);
            graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("coalgenerator.timeleft", ChatFormatter.getChatDisplayShort((double)((double)((Integer)coal.burnTime.getValue()).intValue() / 20.0), (IDisplayUnit)DisplayUnits.TIME_SECONDS)), this.f_97730_ + 60, this.f_97731_ - 53, 0x404040, false);
            graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("machine.current", ChatFormatter.getChatDisplayShort((double)output.getAmps(), (IDisplayUnit)DisplayUnits.AMPERE)), this.f_97730_ + 60, this.f_97731_ - 40, 0x404040, false);
            graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("machine.output", ChatFormatter.getChatDisplayShort((double)output.getWatts(), (IDisplayUnit)DisplayUnits.WATT)), this.f_97730_ + 60, this.f_97731_ - 27, 0x404040, false);
            graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("machine.voltage", ChatFormatter.getChatDisplayShort((double)output.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE)), this.f_97730_ + 60, this.f_97731_ - 14, 0x404040, false);
        }));
        new WrapperInventoryIO((GenericScreen)this, -25, 54, 75, 82, 8, 72);
    }

    private List<FormattedCharSequence> getTemperatureInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        TileCoalGenerator box = (TileCoalGenerator)((ContainerCoalGenerator)this.f_97732_).getSafeHost();
        if (box == null) {
            return list;
        }
        list.add(ElectroTextUtils.gui("coalgenerator.timeleft", ChatFormatter.getChatDisplayShort((double)((double)((Integer)box.burnTime.getValue()).intValue() / 20.0), (IDisplayUnit)DisplayUnits.TIME_SECONDS).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        list.add(ElectroTextUtils.gui("machine.temperature", ChatFormatter.getChatDisplayShort((double)(box.heat.getValue() * 0.8333333333333334), (IDisplayUnit)DisplayUnits.TEMPERATURE_CELCIUS).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        list.add(ElectroTextUtils.gui("machine.heat", ChatFormatter.getChatDisplayShort((double)((box.heat.getValue() - 27.0) / 2973.0 * 100.0), (IDisplayUnit)DisplayUnits.PERCENTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        return list;
    }
}

