/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.client.screen.tile;

import electrodynamics.common.inventory.container.tile.ContainerMotorComplex;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.tile.machines.quarry.TileMotorComplex;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.utilities.math.Color;

public class ScreenMotorComplex
extends GenericScreen<ContainerMotorComplex> {
    public ScreenMotorComplex(ContainerMotorComplex container, Inventory inv, Component titleIn) {
        super((GenericContainer)container, inv, titleIn);
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(this::getElectricInformation, -25, 2));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(30, 40, 10, Color.TEXT_GRAY, () -> {
            int blocksPerTick = 0;
            TileMotorComplex motor = (TileMotorComplex)((ContainerMotorComplex)this.f_97732_).getSafeHost();
            if (motor != null && ((Boolean)motor.isPowered.getValue()).booleanValue()) {
                blocksPerTick = (Integer)motor.speed.getValue();
            }
            return ElectroTextUtils.gui("motorcomplex.speed", blocksPerTick);
        }));
    }

    private List<? extends FormattedCharSequence> getElectricInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        TileMotorComplex motor = (TileMotorComplex)((ContainerMotorComplex)this.f_97732_).getSafeHost();
        if (motor == null) {
            return list;
        }
        ComponentElectrodynamic electro = (ComponentElectrodynamic)motor.getComponent(IComponentType.Electrodynamic);
        list.add(ElectroTextUtils.gui("machine.usage", ChatFormatter.getChatDisplayShort((double)(ElectroConstants.MOTORCOMPLEX_USAGE_PER_TICK * (Double)motor.powerMultiplier.getValue() * 20.0), (IDisplayUnit)DisplayUnits.WATT).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        list.add(ElectroTextUtils.gui("machine.voltage", ChatFormatter.getChatDisplayShort((double)electro.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        return list;
    }
}

