/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.client.screen.tile;

import electrodynamics.common.inventory.container.tile.ContainerQuarry;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.tile.machines.quarry.TileCoolantResavoir;
import electrodynamics.common.tile.machines.quarry.TileMotorComplex;
import electrodynamics.common.tile.machines.quarry.TileQuarry;
import electrodynamics.common.tile.machines.quarry.TileSeismicRelay;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.types.ScreenComponentSlot;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentGuiTab;
import voltaic.prefab.screen.component.types.wrapper.WrapperInventoryIO;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.math.Color;

public class ScreenQuarry
extends GenericScreen<ContainerQuarry> {
    public ScreenQuarry(ContainerQuarry container, Inventory inv, Component titleIn) {
        super((GenericContainer)container, inv, titleIn);
        this.f_97727_ += 58;
        this.f_97731_ += 58;
        this.addComponent((AbstractScreenComponent)new ScreenComponentGuiTab((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, (ITexture)ScreenComponentSlot.IconType.MINING_LOCATION, this::getMiningLocationInformation, -25, 132));
        this.addComponent((AbstractScreenComponent)new ScreenComponentGuiTab((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, (ITexture)ScreenComponentSlot.IconType.QUARRY_COMPONENTS, this::getComponentInformation, -25, 106));
        this.addComponent((AbstractScreenComponent)new ScreenComponentGuiTab((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, (ITexture)ScreenComponentSlot.IconType.FLUID_BLUE, this::getFluidInformation, -25, 80));
        this.addComponent((AbstractScreenComponent)new ScreenComponentGuiTab((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, (ITexture)ScreenComponentSlot.IconType.ENCHANTMENT, this::getEnchantmentInformation, -25, 54));
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(this::getElectricInformation, -25, 2));
        new WrapperInventoryIO((GenericScreen)this, -25, 28, 75, 140, 8, 130);
    }

    private List<? extends FormattedCharSequence> getElectricInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        TileQuarry quarry = (TileQuarry)((ContainerQuarry)this.f_97732_).getSafeHost();
        if (quarry != null) {
            ComponentElectrodynamic electro = (ComponentElectrodynamic)quarry.getComponent(IComponentType.Electrodynamic);
            list.add(ElectroTextUtils.gui("quarry.ringusage", ChatFormatter.getChatDisplayShort((double)((Double)quarry.setupPowerUsage.getValue() * 20.0), (IDisplayUnit)DisplayUnits.WATT).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            list.add(ElectroTextUtils.gui("quarry.miningusage", ChatFormatter.getChatDisplayShort((double)((Double)quarry.quarryPowerUsage.getValue() * 20.0), (IDisplayUnit)DisplayUnits.WATT).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            list.add(ElectroTextUtils.gui("machine.voltage", ChatFormatter.getChatDisplayShort((double)electro.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        }
        return list;
    }

    private List<? extends FormattedCharSequence> getEnchantmentInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        TileQuarry quarry = (TileQuarry)((ContainerQuarry)this.f_97732_).getSafeHost();
        if (quarry == null) {
            return list;
        }
        list.add(ElectroTextUtils.gui("quarry.fortune", Component.m_237113_((String)("" + quarry.fortuneLevel.getValue())).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        list.add(ElectroTextUtils.gui("quarry.silktouch", Component.m_237113_((String)("" + quarry.silkTouchLevel.getValue())).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        list.add(ElectroTextUtils.gui("quarry.unbreaking", Component.m_237113_((String)("" + quarry.unbreakingLevel.getValue())).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        return list;
    }

    private List<? extends FormattedCharSequence> getFluidInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        TileQuarry quarry = (TileQuarry)((ContainerQuarry)this.f_97732_).getSafeHost();
        if (quarry == null) {
            return list;
        }
        TileMotorComplex complex = quarry.getMotorComplex();
        MutableComponent text = complex == null ? Component.m_237113_((String)"N/A") : ChatFormatter.getChatDisplayShort((double)((Integer)complex.speed.getValue() * ElectroConstants.QUARRY_WATERUSAGE_PER_BLOCK), (IDisplayUnit)DisplayUnits.BUCKETS);
        list.add(ElectroTextUtils.gui("quarry.wateruse", text.m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        return list;
    }

    private List<? extends FormattedCharSequence> getComponentInformation() {
        ComponentElectrodynamic electro;
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        TileQuarry quarry = (TileQuarry)((ContainerQuarry)this.f_97732_).getSafeHost();
        if (quarry == null) {
            return list;
        }
        TileMotorComplex complex = quarry.getMotorComplex();
        ChatFormatting formatting = complex == null ? ChatFormatting.RED : ((electro = (ComponentElectrodynamic)complex.getComponent(IComponentType.Electrodynamic)).getJoulesStored() >= ElectroConstants.MOTORCOMPLEX_USAGE_PER_TICK * (Double)complex.powerMultiplier.getValue() ? ChatFormatting.GREEN : ChatFormatting.YELLOW);
        list.add(ElectroTextUtils.gui("quarry.motorcomplex", new Object[0]).m_130940_(formatting).m_7532_());
        TileSeismicRelay relay = quarry.getSeismicRelay();
        formatting = relay == null ? ChatFormatting.RED : (quarry.hasCorners() ? ChatFormatting.GREEN : ChatFormatting.YELLOW);
        list.add(ElectroTextUtils.gui("quarry.seismicrelay", new Object[0]).m_130940_(formatting).m_7532_());
        TileCoolantResavoir resavoir = quarry.getFluidResavoir();
        formatting = resavoir == null ? ChatFormatting.RED : (complex == null || resavoir.hasEnoughFluid((int)((Double)complex.powerMultiplier.getValue() * (double)ElectroConstants.QUARRY_WATERUSAGE_PER_BLOCK)) ? ChatFormatting.GREEN : ChatFormatting.YELLOW);
        list.add(ElectroTextUtils.gui("quarry.coolantresavoir", new Object[0]).m_130940_(formatting).m_7532_());
        return list;
    }

    private List<? extends FormattedCharSequence> getMiningLocationInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        TileQuarry quarry = (TileQuarry)((ContainerQuarry)this.f_97732_).getSafeHost();
        if (quarry == null) {
            return list;
        }
        MutableComponent location = ((BlockPos)quarry.miningPos.getValue()).equals((Object)BlockEntityUtils.OUT_OF_REACH) ? ElectroTextUtils.gui("quarry.notavailable", new Object[0]).m_130940_(ChatFormatting.RED) : Component.m_237113_((String)((BlockPos)quarry.miningPos.getValue()).m_123344_()).m_130940_(ChatFormatting.GRAY);
        list.add(ElectroTextUtils.gui("quarry.miningposition", location).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        location = (Boolean)quarry.hasHead.getValue() != false ? ElectroTextUtils.gui("quarry.hashead", new Object[0]).m_130940_(ChatFormatting.GRAY) : ElectroTextUtils.gui("quarry.nohead", new Object[0]).m_130940_(ChatFormatting.RED);
        list.add(ElectroTextUtils.gui("quarry.drillhead", location).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        return list;
    }

    protected void m_280003_(GuiGraphics graphics, int x, int y) {
        super.m_280003_(graphics, x, y);
        TileQuarry quarry = (TileQuarry)((ContainerQuarry)this.f_97732_).getSafeHost();
        if (quarry == null) {
            return;
        }
        if (((Boolean)quarry.hasItemVoid.getValue()).booleanValue()) {
            graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("quarry.voiditems", new Object[0]), 85, 14, Color.TEXT_GRAY.color(), false);
        } else {
            graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("quarry.needvoidcard", new Object[0]), 85, 14, Color.TEXT_GRAY.color(), false);
        }
        graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("quarry.status", new Object[0]), 5, 32, Color.TEXT_GRAY.color(), false);
        int height = 42;
        if (!((Boolean)quarry.isAreaCleared.getValue()).booleanValue()) {
            graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("quarry.clearingarea", new Object[0]), 10, height, Color.TEXT_GRAY.color(), false);
        } else if (!((Boolean)quarry.hasRing.getValue()).booleanValue()) {
            graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("quarry.setup", new Object[0]), 10, height, Color.TEXT_GRAY.color(), false);
        } else if (((Boolean)quarry.running.getValue()).booleanValue()) {
            graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("quarry.mining", new Object[0]), 10, height, Color.TEXT_GRAY.color(), false);
        } else if (((Boolean)quarry.isFinished.getValue()).booleanValue()) {
            graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("quarry.finished", new Object[0]), 10, height, Color.TEXT_GRAY.color(), false);
        } else {
            graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("quarry.notmining", new Object[0]), 10, height, Color.TEXT_GRAY.color(), false);
        }
        graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui("quarry.errors", new Object[0]), 5, 65, Color.TEXT_GRAY.color(), false);
        graphics.m_280614_(this.f_96547_, (Component)ElectroTextUtils.gui(ScreenQuarry.getErrorKey(quarry), new Object[0]), 10, 75, Color.TEXT_GRAY.color(), false);
    }

    private static String getErrorKey(TileQuarry quarry) {
        if (!((Boolean)quarry.hasSeismicRelay.getValue()).booleanValue()) {
            return "quarry.norelay";
        }
        if (!((Boolean)quarry.hasMotorComplex.getValue()).booleanValue()) {
            return "quarry.nomotorcomplex";
        }
        if (!((Boolean)quarry.hasCoolantResavoir.getValue()).booleanValue()) {
            return "quarry.nocoolantresavoir";
        }
        if (!quarry.hasCorners()) {
            return "quarry.nocorners";
        }
        if (!quarry.isMotorComplexPowered()) {
            return "quarry.motorcomplexnotpowered";
        }
        if (!((Boolean)quarry.isPowered.getValue()).booleanValue()) {
            return "quarry.nopower";
        }
        if (((Boolean)quarry.isTryingToMineFrame.getValue()).booleanValue()) {
            return "quarry.miningframe";
        }
        if (!((Boolean)quarry.isAreaCleared.getValue()).booleanValue()) {
            return "quarry.areanotclear";
        }
        if (!((Boolean)quarry.hasRing.getValue()).booleanValue()) {
            return "quarry.noring";
        }
        if (!((Boolean)quarry.hasHead.getValue()).booleanValue()) {
            return "quarry.missinghead";
        }
        if (!quarry.getFluidResavoir().hasEnoughFluid((int)((Double)quarry.getMotorComplex().powerMultiplier.getValue() * (double)ElectroConstants.QUARRY_WATERUSAGE_PER_BLOCK))) {
            return "quarry.nocoolant";
        }
        if (!((ComponentInventory)quarry.getComponent(IComponentType.Inventory)).areOutputsEmpty()) {
            return "quarry.inventoryroom";
        }
        return "quarry.noerrors";
    }
}

