/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.block.connect;

import electrodynamics.common.block.subtype.SubtypeWire;
import electrodynamics.common.network.type.ElectricNetwork;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.tile.electricitygrid.GenericTileWire;
import electrodynamics.common.tile.electricitygrid.TileLogisticalWire;
import electrodynamics.common.tile.electricitygrid.TileWire;
import electrodynamics.common.tile.electricitygrid.transformer.TileGenericTransformer;
import electrodynamics.prefab.utilities.ElectricityUtils;
import electrodynamics.registers.ElectrodynamicsItems;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import voltaic.api.electricity.IInsulator;
import voltaic.api.network.cable.type.IWire;
import voltaic.common.block.connect.AbstractRefreshingConnectBlock;
import voltaic.common.block.connect.EnumConnectType;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.utilities.Scheduler;
import voltaic.prefab.utilities.math.Color;
import voltaic.prefab.utilities.object.TransferPack;

public class BlockWire
extends AbstractRefreshingConnectBlock<GenericTileWire> {
    public static final HashSet<Block> WIRES = new HashSet();
    public final IWire wire;

    public BlockWire(IWire wire) {
        super(wire.getInsulation().getProperties().m_60918_(wire.getInsulation().getSoundType()).m_60978_(0.15f).m_60988_().m_60955_().m_60977_(), wire.getInsulation().wireRadius());
        this.wire = wire;
        if (wire.getWireClass() != SubtypeWire.WireClass.LOGISTICAL) {
            WIRES.add((Block)this);
        }
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return !this.wire.getInsulation().fireproof();
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        int shockVoltage;
        TileWire tile = (TileWire)worldIn.m_7702_(pos);
        if (tile != null && tile.getNetwork() != null && ((ElectricNetwork)tile.getNetwork()).getActiveTransmitted() > 0.0 && ((shockVoltage = tile.wire.getInsulation().shockVoltage()) == 0 || ((ElectricNetwork)tile.getNetwork()).getActiveVoltage() > (double)shockVoltage)) {
            ElectricityUtils.electrecuteEntity(entityIn, TransferPack.joulesVoltage((double)((ElectricNetwork)tile.getNetwork()).getActiveTransmitted(), (double)((ElectricNetwork)tile.getNetwork()).getActiveVoltage()));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_() || state.m_60795_()) {
            return InteractionResult.FAIL;
        }
        Item item = stack.m_41720_();
        boolean isServerSide = !level.f_46443_;
        BlockPlaceContext newCtx = new BlockPlaceContext(player, hand, stack, hitResult);
        if (item == Items.f_42574_) {
            if (this.wire.getInsulation() == SubtypeWire.InsulationMaterial.CERAMIC) {
                BlockWire newWire = SubtypeWire.getWire(this.wire.getWireMaterial(), SubtypeWire.InsulationMaterial.WOOL, this.wire.getWireClass(), SubtypeWire.WireColor.BLACK);
                if (newWire == null) {
                    return InteractionResult.FAIL;
                }
                if (isServerSide) {
                    BlockWire.handleDataCopyAndSet(newWire.m_5573_(newCtx), level, pos, player, hand, stack, state);
                    if (!player.m_7500_()) {
                        BlockWire.handlePlayerItemDrops(player, (Item)ElectrodynamicsItems.ITEM_CERAMICINSULATION.get());
                        stack.m_41622_(1, (LivingEntity)player, stk -> {});
                    }
                    level.m_5594_(null, pos, SoundEvents.f_144233_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.CONSUME;
            }
            if (this.wire.getInsulation() == SubtypeWire.InsulationMaterial.WOOL) {
                BlockWire newWire = SubtypeWire.getWire(this.wire.getWireMaterial(), SubtypeWire.InsulationMaterial.BARE, SubtypeWire.WireClass.BARE, SubtypeWire.WireColor.NONE);
                if (newWire == null) {
                    return InteractionResult.FAIL;
                }
                if (isServerSide) {
                    BlockWire.handleDataCopyAndSet(newWire.m_5573_(newCtx), level, pos, player, hand, stack, state);
                    if (!player.m_7500_()) {
                        BlockWire.handlePlayerItemDrops(player, (Item)ElectrodynamicsItems.ITEM_INSULATION.get());
                        if (this.wire.getWireClass() == SubtypeWire.WireClass.LOGISTICAL) {
                            BlockWire.handlePlayerItemDrops(player, Items.f_42451_);
                        }
                        stack.m_41622_(1, (LivingEntity)player, stk -> {});
                    }
                    level.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.CONSUME;
            }
            return InteractionResult.FAIL;
        }
        if (item == ElectrodynamicsItems.ITEM_INSULATION.get()) {
            if (this.wire.getInsulation() == SubtypeWire.InsulationMaterial.BARE) {
                BlockWire newWire = SubtypeWire.getWire(this.wire.getWireMaterial(), SubtypeWire.InsulationMaterial.WOOL, SubtypeWire.WireClass.INSULATED, SubtypeWire.WireColor.BLACK);
                if (newWire == null) {
                    return InteractionResult.FAIL;
                }
                if (isServerSide) {
                    BlockWire.handleDataCopyAndSet(newWire.m_5573_(newCtx), level, pos, player, hand, stack, state);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                        player.m_21008_(hand, stack);
                    }
                    level.m_5594_(null, pos, SoundEvents.f_12642_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.CONSUME;
            }
            return InteractionResult.FAIL;
        }
        if (item == ElectrodynamicsItems.ITEM_CERAMICINSULATION.get() && this.wire.getInsulation() == SubtypeWire.InsulationMaterial.WOOL && this.wire.getWireClass() == SubtypeWire.WireClass.INSULATED) {
            BlockWire newWire = SubtypeWire.getWire(this.wire.getWireMaterial(), SubtypeWire.InsulationMaterial.CERAMIC, SubtypeWire.WireClass.CERAMIC, SubtypeWire.WireColor.BROWN);
            if (newWire == null) {
                return InteractionResult.FAIL;
            }
            if (isServerSide) {
                BlockWire.handleDataCopyAndSet(newWire.m_5573_(newCtx), level, pos, player, hand, stack, state);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                    player.m_21008_(hand, stack);
                }
                level.m_5594_(null, pos, SoundEvents.f_144235_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.CONSUME;
        }
        if (stack.m_204117_(Tags.Items.DUSTS_REDSTONE) && this.wire.getInsulation() == SubtypeWire.InsulationMaterial.WOOL && this.wire.getWireClass() == SubtypeWire.WireClass.INSULATED) {
            BlockWire newWire = SubtypeWire.getWire(this.wire.getWireMaterial(), SubtypeWire.InsulationMaterial.WOOL, SubtypeWire.WireClass.LOGISTICAL, SubtypeWire.WireColor.BLACK);
            if (newWire == null) {
                return InteractionResult.FAIL;
            }
            if (isServerSide) {
                BlockWire.handleDataCopyAndSet(newWire.m_5573_(newCtx), level, pos, player, hand, stack, state);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                    player.m_21008_(hand, stack);
                }
                level.m_5594_(null, pos, SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.CONSUME;
        }
        IWire.IWireColor dyeColor = SubtypeWire.WireColor.getColorFromDye(stack);
        if (dyeColor != null) {
            BlockWire newWire = SubtypeWire.getWire(this.wire.getWireMaterial(), this.wire.getInsulation(), this.wire.getWireClass(), dyeColor);
            if (newWire == null) {
                return InteractionResult.FAIL;
            }
            if (isServerSide) {
                BlockWire.handleDataCopyAndSet(newWire.m_5573_(newCtx), level, pos, player, hand, stack, state);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                    player.m_21008_(hand, stack);
                }
                level.m_5594_(null, pos, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    private static void handleDataCopyAndSet(BlockState newWire, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, BlockState oldWire) {
        GenericTileWire generic;
        BlockState curCamo = Blocks.f_50016_.m_49966_();
        BlockState curScaffold = Blocks.f_50016_.m_49966_();
        BlockEntity entity = level.m_7702_(pos);
        if (entity != null && entity instanceof GenericTileWire) {
            generic = (GenericTileWire)entity;
            curCamo = generic.getCamoBlock();
            curScaffold = generic.getScaffoldBlock();
        }
        newWire = Block.m_49931_((BlockState)newWire, (LevelAccessor)level, (BlockPos)pos);
        newWire = (BlockState)newWire.m_61124_((Property)VoltaicBlockStates.HAS_SCAFFOLDING, (Comparable)((Boolean)oldWire.m_61143_((Property)VoltaicBlockStates.HAS_SCAFFOLDING)));
        level.m_46597_(pos, newWire);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericTileWire) {
            generic = (GenericTileWire)blockEntity;
            generic.camoflaugedBlock.setValue((Object)curCamo);
            if (!curScaffold.m_60795_()) {
                generic.scaffoldBlock.setValue((Object)curScaffold);
            }
        }
    }

    private static void handlePlayerItemDrops(Player player, Item ... items) {
        for (Item item : items) {
            ItemStack stack = new ItemStack((ItemLike)item);
            if (player.m_36356_(stack)) continue;
            player.m_9236_().m_7967_((Entity)new ItemEntity(player.m_9236_(), (double)((int)player.m_20185_()), (double)((int)player.m_20186_()), (double)((int)player.m_20189_()), stack));
        }
    }

    public boolean m_7899_(BlockState state) {
        return ((BlockWire)state.m_60734_()).wire.getWireClass().conductsRedstone();
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockState.m_60746_(blockAccess, pos, side);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity tile = blockAccess.m_7702_(pos);
        if (tile instanceof TileLogisticalWire) {
            TileLogisticalWire w = (TileLogisticalWire)tile;
            return w.isPowered ? 15 : 0;
        }
        return 0;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (this.wire.getInsulation().fireproof()) {
            return 0;
        }
        return state.m_61138_((Property)VoltaicBlockStates.WATERLOGGED) && (Boolean)state.m_61143_((Property)VoltaicBlockStates.WATERLOGGED) != false ? 0 : 150;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (this.wire.getInsulation().fireproof()) {
            return 0;
        }
        return state.m_61138_((Property)VoltaicBlockStates.WATERLOGGED) && (Boolean)state.m_61143_((Property)VoltaicBlockStates.WATERLOGGED) != false ? 0 : 400;
    }

    public void onCaughtFire(BlockState state, Level world, BlockPos pos, Direction face, LivingEntity igniter) {
        super.onCaughtFire(state, world, pos, face, igniter);
        Scheduler.schedule((int)5, () -> {
            BlockWire wire = SubtypeWire.getWire(this.wire.getWireMaterial(), SubtypeWire.InsulationMaterial.BARE, SubtypeWire.WireClass.BARE, SubtypeWire.WireColor.NONE);
            if (wire == null) {
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            } else {
                world.m_46597_(pos, wire.m_49966_());
            }
        });
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileWire(pos, state);
    }

    public EnumConnectType getConnection(BlockState otherState, BlockEntity otherTile, GenericTileWire thisConductor, Direction dir) {
        EnumConnectType connection = EnumConnectType.NONE;
        if (otherTile instanceof GenericTileWire) {
            GenericTileWire conductor = (GenericTileWire)otherTile;
            connection = ((IWire)conductor.getCableType()).isDefaultColor() || this.wire.isDefaultColor() || conductor.getWireColor() == this.wire.getWireColor() ? EnumConnectType.WIRE : EnumConnectType.NONE;
        } else if (ElectricityUtils.isElectricReceiver(otherTile, dir.m_122424_()) || this.checkRedstone(otherState)) {
            connection = EnumConnectType.INVENTORY;
        }
        return connection;
    }

    private boolean checkRedstone(BlockState otherState) {
        return otherState.m_60803_() && this.wire.getWireClass() == SubtypeWire.WireClass.LOGISTICAL;
    }

    public GenericTileWire getCableIfValid(BlockEntity tile) {
        GenericTileWire conductor;
        if (tile instanceof GenericTileWire && (((IWire)(conductor = (GenericTileWire)tile).getCableType()).isDefaultColor() || this.wire.isDefaultColor() || conductor.getWireColor() == this.wire.getWireColor())) {
            return conductor;
        }
        return null;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!ElectroConstants.CONDUCTORS_BURN_SURROUNDINGS) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericTileWire) {
            GenericTileWire tile = (GenericTileWire)blockEntity;
            ElectricNetwork network = (ElectricNetwork)tile.getNetwork();
            if (network == null) {
                return;
            }
            double voltage = network.getActiveVoltage();
            if (voltage <= 0.0 || voltage <= (double)this.wire.getInsulation().shockVoltage() || network.getActiveTransmitted() <= 0.0) {
                return;
            }
            boolean overMaxVoltage = voltage > TileGenericTransformer.MAX_VOLTAGE_CAP;
            double wireShockVoltage = Math.max(this.wire.getInsulation().shockVoltage(), 1);
            for (Direction dir : Direction.values()) {
                int overvoltage;
                int flamability;
                BlockPos relativePos = pos.m_121945_(dir);
                BlockState relative = level.m_8055_(relativePos);
                if (relative.m_60795_()) continue;
                boolean isFlammable = relative.isFlammable((BlockGetter)level, relativePos, dir);
                if (relative.m_60734_() instanceof BlockWire) continue;
                Block block = relative.m_60734_();
                if (block instanceof IInsulator) {
                    IInsulator insulator = (IInsulator)block;
                    if (!overMaxVoltage || !(voltage > insulator.getMaximumVoltage())) continue;
                    level.m_5594_(null, relativePos, insulator.getBreakingSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_46961_(relativePos, false);
                    continue;
                }
                if (overMaxVoltage) {
                    if (!isFlammable && !(relative.m_60734_().m_7325_() < ElectroConstants.BLOCK_VAPORIZATION_HARDNESS)) continue;
                    level.m_5594_(null, relativePos, SoundEvents.f_12031_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_46961_(relativePos, false);
                    continue;
                }
                if (!isFlammable || (flamability = relative.getFlammability((BlockGetter)level, relativePos, dir)) <= 0 || flamability > (overvoltage = (int)Math.ceil(voltage / wireShockVoltage))) continue;
                boolean blockCaughtFire = false;
                for (Direction relDir : Direction.values()) {
                    BlockPos firePos = relativePos.m_121945_(relDir);
                    if (firePos.equals((Object)pos) || !BaseFireBlock.m_49255_((Level)level, (BlockPos)firePos, (Direction)(relDir == Direction.DOWN || relDir == Direction.UP ? dir : relDir.m_122424_()))) continue;
                    level.m_7731_(firePos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)firePos), 11);
                    blockCaughtFire = true;
                    break;
                }
                if (blockCaughtFire) continue;
                level.m_5594_(null, pos, SoundEvents.f_12031_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_46961_(pos, false);
                break;
            }
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="electrodynamics", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class ColorHandlerInternal {
        private ColorHandlerInternal() {
        }

        @SubscribeEvent
        public static void registerColoredBlocks(RegisterColorHandlersEvent.Block event) {
            WIRES.forEach(block -> event.register((state, level, pos, tintIndex) -> {
                if (tintIndex == 0) {
                    return ((BlockWire)block).wire.getWireColor().getColor().color();
                }
                return Color.WHITE.color();
            }, new Block[]{block}));
        }
    }
}

