/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.block.subtype;

import electrodynamics.prefab.utilities.ElectroTextUtils;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import voltaic.api.ISubtype;
import voltaic.api.network.cable.type.IGasPipe;

public enum SubtypeGasPipe implements ISubtype,
IGasPipe
{
    UNINSULATEDCOPPER(PipeMaterial.COPPER, InsulationMaterial.NONE, 10000L, 2.5, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_), SoundType.f_56743_),
    UNINSULATEDSTEEL(PipeMaterial.STEEL, InsulationMaterial.NONE, 30000L, 2.5, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_), SoundType.f_56743_),
    UNINSULATEDPLASTIC(PipeMaterial.HDPE, InsulationMaterial.NONE, 1000L, 2.5, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_), SoundType.f_56742_);

    private final PipeMaterial pipeMaterial;
    private final InsulationMaterial insulationMaterial;
    private final long maxTransfer;
    private final double effectivePipeHeatLoss;
    private final double radius;
    private final BlockBehaviour.Properties material;
    private final SoundType soundType;

    private SubtypeGasPipe(PipeMaterial pipeMaterial, InsulationMaterial insulationMaterial, long maxTransfer, double radius, BlockBehaviour.Properties material, SoundType soundType) {
        this.pipeMaterial = pipeMaterial;
        this.insulationMaterial = insulationMaterial;
        this.maxTransfer = maxTransfer;
        this.effectivePipeHeatLoss = pipeMaterial.heatLoss * insulationMaterial.heatLoss;
        this.radius = radius;
        this.material = material;
        this.soundType = soundType;
    }

    public long getMaxTransfer() {
        return this.maxTransfer;
    }

    public double getRadius() {
        return this.radius;
    }

    public BlockBehaviour.Properties getProperties() {
        return this.material;
    }

    public SoundType getSoundType() {
        return this.soundType;
    }

    public IGasPipe.IPipeMaterial getPipeMaterial() {
        return this.pipeMaterial;
    }

    public String tag() {
        return "gaspipe" + this.name().toLowerCase(Locale.ROOT);
    }

    public String forgeTag() {
        return this.tag();
    }

    public boolean isItem() {
        return false;
    }

    public static SubtypeGasPipe getPipeForType(PipeMaterial material, InsulationMaterial insulation) {
        for (SubtypeGasPipe pipe : SubtypeGasPipe.values()) {
            if (pipe.pipeMaterial != material || pipe.insulationMaterial != insulation) continue;
            return pipe;
        }
        return UNINSULATEDCOPPER;
    }

    public static double getEffectiveHeatLoss(SubtypeGasPipe pipe, double gasTemperature) {
        double tempDifference = 1.0;
        double aboveOrBelow = gasTemperature > 293.0 ? 1.0 : -1.0;
        return pipe.effectivePipeHeatLoss * tempDifference * aboveOrBelow;
    }

    public static enum PipeMaterial implements IGasPipe.IPipeMaterial
    {
        COPPER(10.0, 16, true, "pipematerialcopper"),
        STEEL(1.0, 128, true, "pipematerialsteel"),
        HDPE(0.05, 16, false, "pipematerialplastic");

        private final double heatLoss;
        private final int maxPressure;
        private final boolean corrodedByAcid;
        private final String tooltipName;

        private PipeMaterial(double heatLoss, int maxPressure, boolean corrodedByAcid, String tooltipName) {
            this.heatLoss = heatLoss;
            this.maxPressure = maxPressure;
            this.corrodedByAcid = corrodedByAcid;
            this.tooltipName = tooltipName;
        }

        public Component getName() {
            return ElectroTextUtils.tooltip(this.tooltipName, new Object[0]);
        }

        public int getMaxPressuire() {
            return this.maxPressure;
        }

        public boolean canBeCorroded() {
            return this.canBeCorroded();
        }
    }

    public static enum InsulationMaterial {
        NONE(1.0, false, "pipeinsulationnone"),
        WOOL(0.005, true, "pipeinsulationwool"),
        CERAMIC(0.05, false, "pipeinsulationceramic");

        public final double heatLoss;
        public final boolean canCombust;
        private final String tooltipName;

        private InsulationMaterial(double heatLoss, boolean canCombust, String tooltipName) {
            this.heatLoss = heatLoss;
            this.canCombust = canCombust;
            this.tooltipName = tooltipName;
        }

        public Component getTranslatedName() {
            return ElectroTextUtils.tooltip(this.tooltipName, new Object[0]);
        }
    }
}

