/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.block.subtype;

import electrodynamics.common.block.connect.BlockWire;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;
import voltaic.api.ISubtype;
import voltaic.api.network.cable.type.IWire;
import voltaic.common.tags.VoltaicTags;
import voltaic.prefab.utilities.math.Color;

public enum SubtypeWire implements ISubtype,
IWire
{
    tin(WireMaterial.TIN, InsulationMaterial.BARE, WireClass.BARE, WireColor.NONE, WireColor.NONE),
    iron(WireMaterial.IRON, InsulationMaterial.BARE, WireClass.BARE, WireColor.NONE, WireColor.NONE),
    copper(WireMaterial.COPPER, InsulationMaterial.BARE, WireClass.BARE, WireColor.NONE, WireColor.NONE),
    silver(WireMaterial.SILVER, InsulationMaterial.BARE, WireClass.BARE, WireColor.NONE, WireColor.NONE),
    gold(WireMaterial.GOLD, InsulationMaterial.BARE, WireClass.BARE, WireColor.NONE, WireColor.NONE),
    superconductive(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.BARE, WireClass.BARE, WireColor.NONE, WireColor.NONE),
    insulatedtinblack(WireMaterial.TIN, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.BLACK, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_TIN_WIRES),
    insulatedironblack(WireMaterial.IRON, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.BLACK, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_IRON_WIRES),
    insulatedcopperblack(WireMaterial.COPPER, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.BLACK, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_COPPER_WIRES),
    insulatedsilverblack(WireMaterial.SILVER, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.BLACK, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_SILVER_WIRES),
    insulatedgoldblack(WireMaterial.GOLD, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.BLACK, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_GOLD_WIRES),
    insulatedsuperconductiveblack(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.BLACK, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_SUPERCONDUCTIVE_WIRES),
    insulatedtinred(WireMaterial.TIN, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.RED, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_TIN_WIRES),
    insulatedironred(WireMaterial.IRON, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.RED, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_IRON_WIRES),
    insulatedcopperred(WireMaterial.COPPER, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.RED, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_COPPER_WIRES),
    insulatedsilverred(WireMaterial.SILVER, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.RED, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_SILVER_WIRES),
    insulatedgoldred(WireMaterial.GOLD, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.RED, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_GOLD_WIRES),
    insulatedsuperconductivered(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.RED, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_SUPERCONDUCTIVE_WIRES),
    insulatedtinwhite(WireMaterial.TIN, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.WHITE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_TIN_WIRES),
    insulatedironwhite(WireMaterial.IRON, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.WHITE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_IRON_WIRES),
    insulatedcopperwhite(WireMaterial.COPPER, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.WHITE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_COPPER_WIRES),
    insulatedsilverwhite(WireMaterial.SILVER, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.WHITE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_SILVER_WIRES),
    insulatedgoldwhite(WireMaterial.GOLD, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.WHITE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_GOLD_WIRES),
    insulatedsuperconductivewhite(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.WHITE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_SUPERCONDUCTIVE_WIRES),
    insulatedtingreen(WireMaterial.TIN, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.GREEN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_TIN_WIRES),
    insulatedirongreen(WireMaterial.IRON, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.GREEN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_IRON_WIRES),
    insulatedcoppergreen(WireMaterial.COPPER, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.GREEN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_COPPER_WIRES),
    insulatedsilvergreen(WireMaterial.SILVER, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.GREEN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_SILVER_WIRES),
    insulatedgoldgreen(WireMaterial.GOLD, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.GREEN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_GOLD_WIRES),
    insulatedsuperconductivegreen(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.GREEN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_SUPERCONDUCTIVE_WIRES),
    insulatedtinblue(WireMaterial.TIN, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.BLUE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_TIN_WIRES),
    insulatedironblue(WireMaterial.IRON, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.BLUE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_IRON_WIRES),
    insulatedcopperblue(WireMaterial.COPPER, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.BLUE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_COPPER_WIRES),
    insulatedsilverblue(WireMaterial.SILVER, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.BLUE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_SILVER_WIRES),
    insulatedgoldblue(WireMaterial.GOLD, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.BLUE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_GOLD_WIRES),
    insulatedsuperconductiveblue(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.BLUE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_SUPERCONDUCTIVE_WIRES),
    insulatedtinyellow(WireMaterial.TIN, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.YELLOW, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_TIN_WIRES),
    insulatedironyellow(WireMaterial.IRON, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.YELLOW, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_IRON_WIRES),
    insulatedcopperyellow(WireMaterial.COPPER, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.YELLOW, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_COPPER_WIRES),
    insulatedsilveryellow(WireMaterial.SILVER, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.YELLOW, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_SILVER_WIRES),
    insulatedgoldyellow(WireMaterial.GOLD, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.YELLOW, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_GOLD_WIRES),
    insulatedsuperconductiveyellow(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.YELLOW, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_SUPERCONDUCTIVE_WIRES),
    insulatedtinbrown(WireMaterial.TIN, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.BROWN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_TIN_WIRES),
    insulatedironbrown(WireMaterial.IRON, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.BROWN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_IRON_WIRES),
    insulatedcopperbrown(WireMaterial.COPPER, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.BROWN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_COPPER_WIRES),
    insulatedsilverbrown(WireMaterial.SILVER, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.BROWN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_SILVER_WIRES),
    insulatedgoldbrown(WireMaterial.GOLD, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.BROWN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_GOLD_WIRES),
    insulatedsuperconductivebrown(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.WOOL, WireClass.INSULATED, WireColor.BROWN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.INSULATED_SUPERCONDUCTIVE_WIRES),
    highlyinsulatedtinblack(WireMaterial.TIN, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.BLACK, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_TIN_WIRES),
    highlyinsulatedironblack(WireMaterial.IRON, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.BLACK, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_IRON_WIRES),
    highlyinsulatedcopperblack(WireMaterial.COPPER, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.BLACK, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_COPPER_WIRES),
    highlyinsulatedsilverblack(WireMaterial.SILVER, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.BLACK, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_SILVER_WIRES),
    highlyinsulatedgoldblack(WireMaterial.GOLD, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.BLACK, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_GOLD_WIRES),
    highlyinsulatedsuperconductiveblack(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.BLACK, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_SUPERCONDUCTIVE_WIRES),
    highlyinsulatedtinred(WireMaterial.TIN, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.RED, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_TIN_WIRES),
    highlyinsulatedironred(WireMaterial.IRON, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.RED, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_IRON_WIRES),
    highlyinsulatedcopperred(WireMaterial.COPPER, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.RED, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_COPPER_WIRES),
    highlyinsulatedsilverred(WireMaterial.SILVER, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.RED, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_SILVER_WIRES),
    highlyinsulatedgoldred(WireMaterial.GOLD, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.RED, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_GOLD_WIRES),
    highlyinsulatedsuperconductivered(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.RED, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_SUPERCONDUCTIVE_WIRES),
    highlyinsulatedtinwhite(WireMaterial.TIN, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.WHITE, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_TIN_WIRES),
    highlyinsulatedironwhite(WireMaterial.IRON, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.WHITE, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_IRON_WIRES),
    highlyinsulatedcopperwhite(WireMaterial.COPPER, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.WHITE, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_COPPER_WIRES),
    highlyinsulatedsilverwhite(WireMaterial.SILVER, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.WHITE, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_SILVER_WIRES),
    highlyinsulatedgoldwhite(WireMaterial.GOLD, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.WHITE, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_GOLD_WIRES),
    highlyinsulatedsuperconductivewhite(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.WHITE, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_SUPERCONDUCTIVE_WIRES),
    highlyinsulatedtingreen(WireMaterial.TIN, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.GREEN, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_TIN_WIRES),
    highlyinsulatedirongreen(WireMaterial.IRON, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.GREEN, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_IRON_WIRES),
    highlyinsulatedcoppergreen(WireMaterial.COPPER, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.GREEN, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_COPPER_WIRES),
    highlyinsulatedsilvergreen(WireMaterial.SILVER, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.GREEN, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_SILVER_WIRES),
    highlyinsulatedgoldgreen(WireMaterial.GOLD, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.GREEN, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_GOLD_WIRES),
    highlyinsulatedsuperconductivegreen(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.GREEN, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_SUPERCONDUCTIVE_WIRES),
    highlyinsulatedtinblue(WireMaterial.TIN, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.BLUE, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_TIN_WIRES),
    highlyinsulatedironblue(WireMaterial.IRON, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.BLUE, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_IRON_WIRES),
    highlyinsulatedcopperblue(WireMaterial.COPPER, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.BLUE, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_COPPER_WIRES),
    highlyinsulatedsilverblue(WireMaterial.SILVER, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.BLUE, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_SILVER_WIRES),
    highlyinsulatedgoldblue(WireMaterial.GOLD, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.BLUE, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_GOLD_WIRES),
    highlyinsulatedsuperconductiveblue(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.BLUE, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_SUPERCONDUCTIVE_WIRES),
    highlyinsulatedtinyellow(WireMaterial.TIN, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.YELLOW, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_TIN_WIRES),
    highlyinsulatedironyellow(WireMaterial.IRON, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.YELLOW, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_IRON_WIRES),
    highlyinsulatedcopperyellow(WireMaterial.COPPER, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.YELLOW, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_COPPER_WIRES),
    highlyinsulatedsilveryellow(WireMaterial.SILVER, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.YELLOW, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_SILVER_WIRES),
    highlyinsulatedgoldyellow(WireMaterial.GOLD, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.YELLOW, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_GOLD_WIRES),
    highlyinsulatedsuperconductiveyellow(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.YELLOW, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_SUPERCONDUCTIVE_WIRES),
    highlyinsulatedtinbrown(WireMaterial.TIN, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.BROWN, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_TIN_WIRES),
    highlyinsulatedironbrown(WireMaterial.IRON, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.BROWN, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_IRON_WIRES),
    highlyinsulatedcopperbrown(WireMaterial.COPPER, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.BROWN, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_COPPER_WIRES),
    highlyinsulatedsilverbrown(WireMaterial.SILVER, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.BROWN, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_SILVER_WIRES),
    highlyinsulatedgoldbrown(WireMaterial.GOLD, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.BROWN, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_GOLD_WIRES),
    highlyinsulatedsuperconductivebrown(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.THICK_WOOL, WireClass.THICK, WireColor.BROWN, WireColor.BLACK, 3.0, (TagKey<Item>)VoltaicTags.Items.THICK_SUPERCONDUCTIVE_WIRES),
    ceramicinsulatedtinblack(WireMaterial.TIN, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.BLACK, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_TIN_WIRES),
    ceramicinsulatedironblack(WireMaterial.IRON, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.BLACK, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_IRON_WIRES),
    ceramicinsulatedcopperblack(WireMaterial.COPPER, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.BLACK, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_COPPER_WIRES),
    ceramicinsulatedsilverblack(WireMaterial.SILVER, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.BLACK, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_SILVER_WIRES),
    ceramicinsulatedgoldblack(WireMaterial.GOLD, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.BLACK, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_GOLD_WIRES),
    ceramicinsulatedsuperconductiveblack(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.BLACK, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_SUPERCONDUCTIVE_WIRES),
    ceramicinsulatedtinred(WireMaterial.TIN, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.RED, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_TIN_WIRES),
    ceramicinsulatedironred(WireMaterial.IRON, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.RED, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_IRON_WIRES),
    ceramicinsulatedcopperred(WireMaterial.COPPER, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.RED, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_COPPER_WIRES),
    ceramicinsulatedsilverred(WireMaterial.SILVER, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.RED, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_SILVER_WIRES),
    ceramicinsulatedgoldred(WireMaterial.GOLD, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.RED, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_GOLD_WIRES),
    ceramicinsulatedsuperconductivered(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.RED, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_SUPERCONDUCTIVE_WIRES),
    ceramicinsulatedtinwhite(WireMaterial.TIN, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.WHITE, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_TIN_WIRES),
    ceramicinsulatedironwhite(WireMaterial.IRON, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.WHITE, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_IRON_WIRES),
    ceramicinsulatedcopperwhite(WireMaterial.COPPER, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.WHITE, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_COPPER_WIRES),
    ceramicinsulatedsilverwhite(WireMaterial.SILVER, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.WHITE, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_SILVER_WIRES),
    ceramicinsulatedgoldwhite(WireMaterial.GOLD, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.WHITE, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_GOLD_WIRES),
    ceramicinsulatedsuperconductivewhite(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.WHITE, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_SUPERCONDUCTIVE_WIRES),
    ceramicinsulatedtingreen(WireMaterial.TIN, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.GREEN, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_TIN_WIRES),
    ceramicinsulatedirongreen(WireMaterial.IRON, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.GREEN, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_IRON_WIRES),
    ceramicinsulatedcoppergreen(WireMaterial.COPPER, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.GREEN, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_COPPER_WIRES),
    ceramicinsulatedsilvergreen(WireMaterial.SILVER, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.GREEN, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_SILVER_WIRES),
    ceramicinsulatedgoldgreen(WireMaterial.GOLD, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.GREEN, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_GOLD_WIRES),
    ceramicinsulatedsuperconductivegreen(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.GREEN, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_SUPERCONDUCTIVE_WIRES),
    ceramicinsulatedtinblue(WireMaterial.TIN, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.BLUE, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_TIN_WIRES),
    ceramicinsulatedironblue(WireMaterial.IRON, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.BLUE, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_IRON_WIRES),
    ceramicinsulatedcopperblue(WireMaterial.COPPER, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.BLUE, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_COPPER_WIRES),
    ceramicinsulatedsilverblue(WireMaterial.SILVER, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.BLUE, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_SILVER_WIRES),
    ceramicinsulatedgoldblue(WireMaterial.GOLD, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.BLUE, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_GOLD_WIRES),
    ceramicinsulatedsuperconductiveblue(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.BLUE, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_SUPERCONDUCTIVE_WIRES),
    ceramicinsulatedtinyellow(WireMaterial.TIN, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.YELLOW, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_TIN_WIRES),
    ceramicinsulatedironyellow(WireMaterial.IRON, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.YELLOW, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_IRON_WIRES),
    ceramicinsulatedcopperyellow(WireMaterial.COPPER, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.YELLOW, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_COPPER_WIRES),
    ceramicinsulatedsilveryellow(WireMaterial.SILVER, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.YELLOW, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_SILVER_WIRES),
    ceramicinsulatedgoldyellow(WireMaterial.GOLD, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.YELLOW, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_GOLD_WIRES),
    ceramicinsulatedsuperconductiveyellow(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.YELLOW, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_SUPERCONDUCTIVE_WIRES),
    ceramicinsulatedtinbrown(WireMaterial.TIN, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.BROWN, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_TIN_WIRES),
    ceramicinsulatedironbrown(WireMaterial.IRON, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.BROWN, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_IRON_WIRES),
    ceramicinsulatedcopperbrown(WireMaterial.COPPER, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.BROWN, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_COPPER_WIRES),
    ceramicinsulatedsilverbrown(WireMaterial.SILVER, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.BROWN, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_SILVER_WIRES),
    ceramicinsulatedgoldbrown(WireMaterial.GOLD, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.BROWN, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_GOLD_WIRES),
    ceramicinsulatedsuperconductivebrown(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.CERAMIC, WireClass.CERAMIC, WireColor.BROWN, WireColor.BROWN, (TagKey<Item>)VoltaicTags.Items.CERAMIC_SUPERCONDUCTIVE_WIRES),
    logisticstinblack(WireMaterial.TIN, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.BLACK, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_TIN_WIRES),
    logisticsironblack(WireMaterial.IRON, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.BLACK, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_IRON_WIRES),
    logisticscopperblack(WireMaterial.COPPER, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.BLACK, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_COPPER_WIRES),
    logisticssilverblack(WireMaterial.SILVER, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.BLACK, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_SILVER_WIRES),
    logisticsgoldblack(WireMaterial.GOLD, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.BLACK, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_GOLD_WIRES),
    logisticssuperconductiveblack(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.BLACK, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_SUPERCONDUCTIVE_WIRES),
    logisticstinred(WireMaterial.TIN, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.RED, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_TIN_WIRES),
    logisticsironred(WireMaterial.IRON, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.RED, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_IRON_WIRES),
    logisticscopperred(WireMaterial.COPPER, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.RED, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_COPPER_WIRES),
    logisticssilverred(WireMaterial.SILVER, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.RED, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_SILVER_WIRES),
    logisticsgoldred(WireMaterial.GOLD, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.RED, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_GOLD_WIRES),
    logisticssuperconductivered(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.RED, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_SUPERCONDUCTIVE_WIRES),
    logisticstinwhite(WireMaterial.TIN, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.WHITE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_TIN_WIRES),
    logisticsironwhite(WireMaterial.IRON, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.WHITE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_IRON_WIRES),
    logisticscopperwhite(WireMaterial.COPPER, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.WHITE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_COPPER_WIRES),
    logisticssilverwhite(WireMaterial.SILVER, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.WHITE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_SILVER_WIRES),
    logisticsgoldwhite(WireMaterial.GOLD, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.WHITE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_GOLD_WIRES),
    logisticssuperconductivewhite(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.WHITE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_SUPERCONDUCTIVE_WIRES),
    logisticstingreen(WireMaterial.TIN, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.GREEN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_TIN_WIRES),
    logisticsirongreen(WireMaterial.IRON, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.GREEN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_IRON_WIRES),
    logisticscoppergreen(WireMaterial.COPPER, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.GREEN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_COPPER_WIRES),
    logisticssilvergreen(WireMaterial.SILVER, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.GREEN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_SILVER_WIRES),
    logisticsgoldgreen(WireMaterial.GOLD, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.GREEN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_GOLD_WIRES),
    logisticssuperconductivegreen(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.GREEN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_SUPERCONDUCTIVE_WIRES),
    logisticstinblue(WireMaterial.TIN, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.BLUE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_TIN_WIRES),
    logisticsironblue(WireMaterial.IRON, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.BLUE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_IRON_WIRES),
    logisticscopperblue(WireMaterial.COPPER, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.BLUE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_COPPER_WIRES),
    logisticssilverblue(WireMaterial.SILVER, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.BLUE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_SILVER_WIRES),
    logisticsgoldblue(WireMaterial.GOLD, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.BLUE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_GOLD_WIRES),
    logisticssuperconductiveblue(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.BLUE, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_SUPERCONDUCTIVE_WIRES),
    logisticstinyellow(WireMaterial.TIN, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.YELLOW, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_TIN_WIRES),
    logisticsironyellow(WireMaterial.IRON, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.YELLOW, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_IRON_WIRES),
    logisticscopperyellow(WireMaterial.COPPER, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.YELLOW, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_COPPER_WIRES),
    logisticssilveryellow(WireMaterial.SILVER, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.YELLOW, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_SILVER_WIRES),
    logisticsgoldyellow(WireMaterial.GOLD, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.YELLOW, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_GOLD_WIRES),
    logisticssuperconductiveyellow(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.YELLOW, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_SUPERCONDUCTIVE_WIRES),
    logisticstinbrown(WireMaterial.TIN, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.BROWN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_TIN_WIRES),
    logisticsironbrown(WireMaterial.IRON, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.BROWN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_IRON_WIRES),
    logisticscopperbrown(WireMaterial.COPPER, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.BROWN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_COPPER_WIRES),
    logisticssilverbrown(WireMaterial.SILVER, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.BROWN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_SILVER_WIRES),
    logisticsgoldbrown(WireMaterial.GOLD, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.BROWN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_GOLD_WIRES),
    logisticssuperconductivebrown(WireMaterial.SUPERCONDUCTIVE, InsulationMaterial.WOOL, WireClass.LOGISTICAL, WireColor.BROWN, WireColor.BLACK, (TagKey<Item>)VoltaicTags.Items.LOGISTICAL_SUPERCONDUCTIVE_WIRES);

    public static final HashMap<IWire.IWireMaterial, HashMap<IWire.IInsulationMaterial, HashMap<IWire.IWireClass, HashMap<IWire.IWireColor, BlockWire>>>> WIRES;
    public static final HashSet<IWire.IWireMaterial> WIRE_MATERIALS;
    private final double resistance;
    private final long ampacity;
    private final WireClass wireClass;
    private final InsulationMaterial insulation;
    private final WireMaterial conductor;
    private final WireColor color;
    private final WireColor defaultColor;
    private final boolean isDefaultColor;
    @javax.annotation.Nullable
    private final TagKey<Item> itemTag;

    private SubtypeWire(WireMaterial conductor, InsulationMaterial insulation, WireClass wireClass, WireColor color, WireColor defaultColor, double dividend, TagKey<Item> tag) {
        this.resistance = conductor.resistance / dividend;
        this.ampacity = (long)((double)conductor.ampacity * dividend);
        this.conductor = conductor;
        this.insulation = insulation;
        this.wireClass = wireClass;
        this.color = color;
        this.defaultColor = defaultColor;
        this.isDefaultColor = color == defaultColor;
        this.itemTag = tag;
    }

    private SubtypeWire(WireMaterial conductor, InsulationMaterial insulation, WireClass wireClass, WireColor color, WireColor defaultColor, TagKey<Item> tag) {
        this(conductor, insulation, wireClass, color, defaultColor, 1.0, tag);
    }

    private SubtypeWire(WireMaterial conductor, InsulationMaterial insulation, WireClass wireClass, WireColor color, WireColor defaultColor, double dividend) {
        this(conductor, insulation, wireClass, color, defaultColor, dividend, null);
    }

    private SubtypeWire(WireMaterial conductor, InsulationMaterial insulation, WireClass wireClass, WireColor color, WireColor defaultColor) {
        this(conductor, insulation, wireClass, color, defaultColor, 1.0, null);
    }

    public double getResistance() {
        return this.resistance;
    }

    public long getAmpacity() {
        return this.ampacity;
    }

    public IWire.IWireClass getWireClass() {
        return this.wireClass;
    }

    public IWire.IInsulationMaterial getInsulation() {
        return this.insulation;
    }

    public IWire.IWireMaterial getWireMaterial() {
        return this.conductor;
    }

    public IWire.IWireColor getWireColor() {
        return this.color;
    }

    public IWire.IWireColor getDefaultColor() {
        return this.defaultColor;
    }

    @Nullable
    public TagKey<Item> getItemTag() {
        return this.itemTag;
    }

    public String tag() {
        return "wire" + this.name();
    }

    public String forgeTag() {
        return this.tag();
    }

    public boolean isItem() {
        return false;
    }

    public boolean isDefaultColor() {
        return this.isDefaultColor;
    }

    @javax.annotation.Nullable
    public static BlockWire getWire(IWire.IWireMaterial wireMaterial, IWire.IInsulationMaterial insulation, IWire.IWireClass wireClass, IWire.IWireColor color) {
        return WIRES.getOrDefault(wireMaterial, new HashMap()).getOrDefault(insulation, new HashMap()).getOrDefault(wireClass, new HashMap()).getOrDefault(color, null);
    }

    public static BlockWire[] getWires(WireMaterial[] conductors, InsulationMaterial insulation, WireClass wireClass, WireColor ... colors) {
        ArrayList<BlockWire> list = new ArrayList<BlockWire>();
        for (WireMaterial conductor : conductors) {
            for (WireColor color : colors) {
                BlockWire wire = SubtypeWire.getWire(conductor, insulation, wireClass, color);
                if (wire == null) continue;
                list.add(wire);
            }
        }
        return list.toArray(new BlockWire[0]);
    }

    static {
        WIRES = new HashMap();
        WIRE_MATERIALS = new HashSet();
    }

    public static enum WireMaterial implements IWire.IWireMaterial
    {
        COPPER(0.0030096, 360L, 1.68E-8),
        GOLD(0.004294, 1000L, 2.44E-8),
        IRON(0.01709, 100L, 1.0E-7),
        SILVER(0.0027984, 600L, 1.59E-8),
        SUPERCONDUCTIVE(0.0, Long.MAX_VALUE, 0.0),
        TIN(0.020064, 60L, 1.09E-7);

        public static final double BASELINE_TEMP_K = 293.15;
        private final double resistance;
        private final long ampacity;
        private final double resistivity;

        private WireMaterial(double resistance, long ampacity, double resistivity) {
            this.resistance = resistance;
            this.ampacity = ampacity;
            this.resistivity = resistivity;
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public double resistance() {
            return this.resistance;
        }

        public long ampacity() {
            return this.ampacity;
        }

        public double materialResistivity() {
            return this.resistivity;
        }

        public static double calculateResistance(double resistivity, double area, double length) {
            return resistivity * length / area;
        }

        public static long calculateAmpacity(double maxOperatingTemp, double resistance, double dialectricLoss, double thermalResistance1, double thermalResistance2, double thermalResistance3, double thermalResistance4, double numConductors, double ratioOfLosses1, double ratioOfLosses2) {
            double deltaT = maxOperatingTemp - 293.15;
            double top = deltaT - dialectricLoss * (0.5 * thermalResistance1 + numConductors * (thermalResistance2 + thermalResistance3 + thermalResistance4));
            double bottom = resistance * thermalResistance1 + numConductors * resistance * (1.0 + ratioOfLosses1) * thermalResistance2 + numConductors * resistance * (1.0 + ratioOfLosses1 + ratioOfLosses2) * (thermalResistance3 + thermalResistance4);
            double ampacity = Math.sqrt(top / bottom);
            return (long)ampacity;
        }
    }

    public static enum InsulationMaterial implements IWire.IInsulationMaterial
    {
        BARE(false, true, 0, 1.0, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_), SoundType.f_56743_),
        WOOL(true, false, 240, 2.0, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283811_).m_280658_(NoteBlockInstrument.GUITAR).m_60978_(0.8f).m_60918_(SoundType.f_56745_).m_278183_(), SoundType.f_56745_),
        THICK_WOOL(true, false, 960, 3.0, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283811_).m_280658_(NoteBlockInstrument.GUITAR).m_60978_(0.8f).m_60918_(SoundType.f_56745_).m_278183_(), SoundType.f_56745_),
        CERAMIC(true, true, 480, 3.0, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60913_(1.5f, 6.0f), SoundType.f_154659_);

        private final boolean insulated;
        private final boolean fireProof;
        private final int shockVoltage;
        private final double radius;
        private final BlockBehaviour.Properties material;
        private final SoundType soundType;

        private InsulationMaterial(boolean insulated, boolean fireProof, int shockVoltage, double radius, BlockBehaviour.Properties material, SoundType sounndType) {
            this.insulated = insulated;
            this.fireProof = fireProof;
            this.shockVoltage = shockVoltage;
            this.radius = radius;
            this.material = material;
            this.soundType = sounndType;
        }

        public boolean insulated() {
            return this.insulated;
        }

        public boolean fireproof() {
            return this.fireProof;
        }

        public int shockVoltage() {
            return this.shockVoltage;
        }

        public double wireRadius() {
            return this.radius;
        }

        public BlockBehaviour.Properties getProperties() {
            return this.material;
        }

        public SoundType getSoundType() {
            return this.soundType;
        }
    }

    public static enum WireClass implements IWire.IWireClass
    {
        BARE(false),
        INSULATED(false),
        THICK(false),
        CERAMIC(false),
        LOGISTICAL(true);

        private final boolean conductsRedstone;

        private WireClass(boolean conductsRedstone) {
            this.conductsRedstone = conductsRedstone;
        }

        public boolean conductsRedstone() {
            return this.conductsRedstone;
        }
    }

    public static enum WireColor implements IWire.IWireColor
    {
        NONE(255, 255, 255, 255, null),
        BLACK(40, 40, 40, 255, (TagKey<Item>)Tags.Items.DYES_BLACK),
        RED(200, 0, 0, 255, (TagKey<Item>)Tags.Items.DYES_RED),
        WHITE(255, 255, 255, 255, (TagKey<Item>)Tags.Items.DYES_WHITE),
        GREEN(24, 147, 50, 255, (TagKey<Item>)Tags.Items.DYES_GREEN),
        BLUE(68, 140, 203, 255, (TagKey<Item>)Tags.Items.DYES_BLUE),
        YELLOW(250, 240, 104, 255, (TagKey<Item>)Tags.Items.DYES_YELLOW),
        BROWN(102, 78, 55, 255, (TagKey<Item>)Tags.Items.DYES_BROWN);

        public final Color color;
        @javax.annotation.Nullable
        public final TagKey<Item> dyeTag;
        public static final HashSet<IWire.IWireColor> WIRE_COLORS;

        private WireColor(int r, int g, int b, int a, TagKey<Item> dyeTag) {
            this.color = new Color(r, g, b, a);
            this.dyeTag = dyeTag;
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        @javax.annotation.Nullable
        public static IWire.IWireColor getColorFromDye(ItemStack item) {
            for (IWire.IWireColor color : WIRE_COLORS) {
                if (color.getDyeTag() == null || !item.m_204117_(color.getDyeTag())) continue;
                return color;
            }
            return null;
        }

        @Nonnull
        public Color getColor() {
            return this.color;
        }

        @Nonnull
        public TagKey<Item> getDyeTag() {
            return this.dyeTag;
        }

        static {
            WIRE_COLORS = new HashSet();
        }
    }
}

