/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.event;

import electrodynamics.common.event.types.living.equipmentchange.HandlerJetpackEquiped;
import electrodynamics.common.event.types.living.hurt.HandlerCompositeArmor;
import electrodynamics.common.event.types.living.hurt.HandlerHydraulicBoots;
import electrodynamics.common.event.types.living.hurt.HandlerJetpackDamage;
import electrodynamics.common.event.types.living.knockback.HandlerJetpackKnockbackImpulse;
import electrodynamics.common.event.types.player.rightclick.HandlerWrench;
import electrodynamics.common.event.types.player.starttracking.HandlerJetpackSound;
import electrodynamics.common.reloadlistener.CoalGeneratorFuelRegister;
import electrodynamics.common.reloadlistener.CombustionFuelRegister;
import electrodynamics.common.reloadlistener.ThermoelectricGeneratorHeatRegister;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import voltaic.common.event.type.AbstractEquipmentChangeHandler;
import voltaic.common.event.type.AbstractLivingDamageHandler;
import voltaic.common.event.type.AbstractLivingKnockbackHandler;
import voltaic.common.event.type.AbstractPlayerStartTrackingHandler;
import voltaic.common.event.type.AbstractRightClickBlockHandler;

@Mod.EventBusSubscriber(modid="electrodynamics", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerEventHandler {
    private static final List<AbstractRightClickBlockHandler> RIGHT_CLICK_HANDLERS = new ArrayList<AbstractRightClickBlockHandler>();
    private static final List<AbstractLivingDamageHandler> LIVING_HURT_HANDLERS = new ArrayList<AbstractLivingDamageHandler>();
    private static final List<AbstractLivingKnockbackHandler> LIVING_KNOCKBACK_HANDLERS = new ArrayList<AbstractLivingKnockbackHandler>();
    private static final List<AbstractEquipmentChangeHandler> EQUIPMENT_CHANGE_HANDLERS = new ArrayList<AbstractEquipmentChangeHandler>();
    private static final List<AbstractPlayerStartTrackingHandler> START_TRACKING_PLAYER_HANDLERS = new ArrayList<AbstractPlayerStartTrackingHandler>();

    public static void init() {
        RIGHT_CLICK_HANDLERS.add(new HandlerWrench());
        LIVING_HURT_HANDLERS.add(new HandlerCompositeArmor());
        LIVING_HURT_HANDLERS.add(new HandlerHydraulicBoots());
        LIVING_HURT_HANDLERS.add(new HandlerJetpackDamage());
        LIVING_KNOCKBACK_HANDLERS.add(new HandlerJetpackKnockbackImpulse());
        EQUIPMENT_CHANGE_HANDLERS.add(new HandlerJetpackEquiped());
        START_TRACKING_PLAYER_HANDLERS.add(new HandlerJetpackSound());
    }

    @SubscribeEvent
    public static void handleRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        RIGHT_CLICK_HANDLERS.forEach(handler -> handler.handle(event));
    }

    @SubscribeEvent
    public static void handlerLivingHurt(LivingDamageEvent event) {
        LIVING_HURT_HANDLERS.forEach(handler -> handler.handle(event));
    }

    @SubscribeEvent
    public static void handleLivingKnockback(LivingKnockBackEvent event) {
        LIVING_KNOCKBACK_HANDLERS.forEach(handler -> handler.handle(event));
    }

    @SubscribeEvent
    public static void handleArmorEquiped(LivingEquipmentChangeEvent event) {
        EQUIPMENT_CHANGE_HANDLERS.forEach(handler -> handler.handler(event));
    }

    @SubscribeEvent
    public static void handlerStartTrackingPlayer(PlayerEvent.StartTracking event) {
        START_TRACKING_PLAYER_HANDLERS.forEach(handler -> handler.handle(event));
    }

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)CombustionFuelRegister.INSTANCE);
        event.addListener((PreparableReloadListener)CoalGeneratorFuelRegister.INSTANCE);
        event.addListener((PreparableReloadListener)ThermoelectricGeneratorHeatRegister.INSTANCE);
    }

    @SubscribeEvent
    public static void serverStartedHandler(ServerStartedEvent event) {
        CoalGeneratorFuelRegister.INSTANCE.generateTagValues();
        ThermoelectricGeneratorHeatRegister.INSTANCE.generateTagValues();
    }
}

