/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.item.gear.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.fluid.RestrictedFluidHandlerItemStack;
import voltaic.api.inventory.InventoryTickConsumer;
import voltaic.common.item.ItemVoltaic;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.VoltaicTextUtils;

public class ItemCanister
extends ItemVoltaic {
    public static final int MAX_FLUID_CAPACITY = 5000;
    public static final List<InventoryTickConsumer> INVENTORY_TICK_CONSUMERS = new ArrayList<InventoryTickConsumer>();

    public ItemCanister(Item.Properties properties, Supplier<CreativeModeTab> creativeTab) {
        super(properties, creativeTab);
    }

    public void addCreativeModeItems(CreativeModeTab group, List<ItemStack> items) {
        items.add(new ItemStack((ItemLike)this));
        if (ForgeCapabilities.FLUID_HANDLER_ITEM != null) {
            for (Fluid liq : ForgeRegistries.FLUIDS.getValues()) {
                if (liq.m_6212_(Fluids.f_76191_)) continue;
                ItemStack temp = new ItemStack((ItemLike)this);
                temp.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(h -> ((RestrictedFluidHandlerItemStack)h).setFluid(new FluidStack(liq, 5000)));
                items.add(temp);
            }
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        super.m_6883_(stack, level, entity, slot, isSelected);
        INVENTORY_TICK_CONSUMERS.forEach(consumer -> consumer.apply(stack, level, entity, Integer.valueOf(slot), Boolean.valueOf(isSelected)));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new RestrictedFluidHandlerItemStack.SwapEmpty(stack, stack, 5000);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (ForgeCapabilities.FLUID_HANDLER_ITEM != null) {
            stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(h -> {
                RestrictedFluidHandlerItemStack restricted = (RestrictedFluidHandlerItemStack)h;
                if (!restricted.getFluid().isEmpty()) {
                    tooltip.add((Component)restricted.getFluid().getDisplayName().m_6881_().m_130940_(ChatFormatting.GRAY));
                }
                tooltip.add((Component)VoltaicTextUtils.ratio((Component)ChatFormatter.formatFluidMilibuckets((double)restricted.getFluidInTank(0).getAmount()), (Component)ChatFormatter.formatFluidMilibuckets((double)5000.0)).m_130940_(ChatFormatting.DARK_GRAY));
            });
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public int m_142158_(ItemStack stack) {
        return (int)Math.round(stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(h -> {
            RestrictedFluidHandlerItemStack cap = (RestrictedFluidHandlerItemStack)h;
            return 13.0 * (double)cap.getFluidInTank(0).getAmount() / (double)cap.getTankCapacity(0);
        }).orElse(13.0));
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(h -> !((RestrictedFluidHandlerItemStack)h).getFluid().isEmpty()).orElse(false);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        this.useCanister(worldIn, playerIn, handIn);
        return InteractionResultHolder.m_19098_((Object)playerIn.m_21120_(handIn));
    }

    public void useCanister(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult trace = ItemCanister.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (world.f_46443_ || trace.m_6662_() == HitResult.Type.MISS || trace.m_6662_() == HitResult.Type.ENTITY) {
            return;
        }
        BlockHitResult blockTrace = trace;
        BlockPos pos = blockTrace.m_82425_();
        BlockState state = world.m_8055_(pos);
        if (!state.m_60819_().m_76170_() || state.m_60819_().m_76178_()) {
            return;
        }
        FluidStack sourceFluid = new FluidStack(state.m_60819_().m_76152_(), 1000);
        IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_FLUID_ITEM);
        if (handler == CapabilityUtils.EMPTY_FLUID_ITEM) {
            return;
        }
        int accepted = handler.fill(sourceFluid, IFluidHandler.FluidAction.SIMULATE);
        if (accepted < 1000) {
            return;
        }
        handler.fill(sourceFluid, IFluidHandler.FluidAction.EXECUTE);
        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        world.m_5594_(null, player.m_20183_(), SoundEvents.f_11781_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

