/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.item.gear.tools.electric;

import electrodynamics.common.inventory.container.item.ContainerElectricDrill;
import electrodynamics.common.item.ItemDrillHead;
import electrodynamics.common.item.gear.tools.electric.utils.ElectricItemTier;
import electrodynamics.common.item.subtype.SubtypeDrillHead;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import electrodynamics.registers.ElectrodynamicsItems;
import electrodynamics.registers.ElectrodynamicsSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import voltaic.api.creativetab.CreativeTabSupplier;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.item.CapabilityItemStackHandler;
import voltaic.api.item.IItemElectric;
import voltaic.common.item.ItemUpgrade;
import voltaic.prefab.inventory.container.types.GenericContainerItem;
import voltaic.prefab.item.ElectricItemProperties;
import voltaic.prefab.item.ItemMultiDigger;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.ItemUtils;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.prefab.utilities.math.Color;

public class ItemElectricDrill
extends ItemMultiDigger
implements IItemElectric,
CreativeTabSupplier {
    private final Supplier<CreativeModeTab> creativeTab;
    private static final List<ItemElectricDrill> DRILLS = new ArrayList<ItemElectricDrill>();
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)"container.electricdrill");
    public static final int SLOT_COUNT = 3;
    public static final double POWER_USAGE = 694.4444444458333;
    private static final String SUBTYPE = "subtype";
    private final ElectricItemProperties properties;

    public ItemElectricDrill(ElectricItemProperties properties, Supplier<CreativeModeTab> creativeTab) {
        super(4.0f, -2.4f, (Tier)ElectricItemTier.DRILL, properties.m_41503_(0), new TagKey[]{BlockTags.f_144283_, BlockTags.f_144282_});
        this.properties = properties;
        this.creativeTab = creativeTab;
        DRILLS.add(this);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_(newStack.m_41720_());
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new CapabilityItemStackHandler(3, stack).setOnChange((item, cap, slot) -> {
            int fortune = 0;
            boolean silkTouch = false;
            double speedBoost = 1.0;
            for (ItemStack content : cap.getItems()) {
                Item patt4315$temp;
                if (content.m_41619_() || !((patt4315$temp = content.m_41720_()) instanceof ItemUpgrade)) continue;
                ItemUpgrade upgrade = (ItemUpgrade)patt4315$temp;
                if (!upgrade.subtype.isEmpty) continue;
                block7: for (int i = 0; i < content.m_41613_(); ++i) {
                    switch (upgrade.subtype) {
                        case basicspeed: {
                            speedBoost = Math.min(speedBoost * 1.5, Math.pow(1.5, 3.0));
                            continue block7;
                        }
                        case advancedspeed: {
                            speedBoost = Math.min(speedBoost * 2.25, Math.pow(2.25, 3.0));
                            continue block7;
                        }
                        case fortune: {
                            if (silkTouch) continue block7;
                            fortune = Math.min(fortune + 1, 9);
                            continue block7;
                        }
                        case silktouch: {
                            if (fortune != 0) continue block7;
                            silkTouch = true;
                            continue block7;
                        }
                    }
                }
            }
            CompoundTag tag = stack.m_41784_();
            ItemUtils.removeEnchantment((ItemStack)item, (Enchantment)Enchantments.f_44987_);
            if (fortune > 0) {
                stack.m_41663_(Enchantments.f_44987_, fortune);
            }
            ItemUtils.removeEnchantment((ItemStack)item, (Enchantment)Enchantments.f_44985_);
            if (silkTouch) {
                stack.m_41663_(Enchantments.f_44985_, 1);
            }
            tag.m_128347_("speedenchant", speedBoost);
        });
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public void addCreativeModeItems(CreativeModeTab group, List<ItemStack> items) {
        ItemStack empty = new ItemStack((ItemLike)this);
        IItemElectric.setEnergyStored((ItemStack)empty, (double)0.0);
        items.add(empty);
        ItemStack charged = new ItemStack((ItemLike)this);
        IItemElectric.setEnergyStored((ItemStack)charged, (double)this.getMaximumCapacity(charged));
        items.add(charged);
    }

    public boolean m_41465_() {
        return false;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (this.getJoulesStored(stack) < this.properties.extract.getJoules()) {
            return 0.0f;
        }
        float normalized = (float)Math.max(1.0, ItemElectricDrill.getHead((ItemStack)stack).speedBoost * ItemElectricDrill.getSpeedBoost(stack));
        return super.m_8102_(stack, state) * normalized;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        IItemElectric.setEnergyStored((ItemStack)stack, (double)(this.getJoulesStored(stack) - this.getPowerUsage(stack)));
        return super.m_6813_(stack, worldIn, state, pos, entityLiving);
    }

    public double getPowerUsage(ItemStack stack) {
        int fortune;
        double multiplier = Math.max(1.0, ItemElectricDrill.getSpeedBoost(stack));
        if (EnchantmentHelper.m_44831_((ItemStack)stack).getOrDefault(Enchantments.f_44985_, 0) > 0) {
            multiplier += 3.0;
        }
        if ((fortune = EnchantmentHelper.m_44831_((ItemStack)stack).getOrDefault(Enchantments.f_44987_, 0).intValue()) > 0) {
            multiplier += (double)fortune;
        }
        return 694.4444444458333 * multiplier;
    }

    public int m_142158_(ItemStack stack) {
        return (int)Math.round(13.0 * this.getJoulesStored(stack) / this.getMaximumCapacity(stack));
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getJoulesStored(stack) < this.getMaximumCapacity(stack);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)ElectroTextUtils.tooltip("item.electric.info", VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)this.getJoulesStored(stack), (IDisplayUnit)DisplayUnits.JOULES), (Component)ChatFormatter.getChatDisplayShort((double)this.getMaximumCapacity(stack), (IDisplayUnit)DisplayUnits.JOULES)).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)ElectroTextUtils.tooltip("item.electric.voltage", ChatFormatter.getChatDisplayShort((double)this.properties.receive.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        IItemElectric.addBatteryTooltip((ItemStack)stack, (Level)worldIn, tooltip);
        tooltip.add((Component)ElectroTextUtils.tooltip("electricdrill.miningspeed", ChatFormatter.getChatDisplayShort((double)(ItemElectricDrill.getHead((ItemStack)stack).speedBoost * 100.0), (IDisplayUnit)DisplayUnits.PERCENTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)ElectroTextUtils.tooltip("electricdrill.usage", ChatFormatter.getChatDisplayShort((double)this.getPowerUsage(stack), (IDisplayUnit)DisplayUnits.JOULES).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)ElectroTextUtils.tooltip("electricdrill.overclock", ChatFormatter.getChatDisplayShort((double)(ItemElectricDrill.getSpeedBoost(stack) * 100.0), (IDisplayUnit)DisplayUnits.PERCENTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
    }

    public ElectricItemProperties getElectricProperties() {
        return this.properties;
    }

    public Item getDefaultStorageBattery() {
        return (Item)ElectrodynamicsItems.ITEM_BATTERY.get();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.f_46443_) {
            player.m_5893_(this.getMenuProvider(level, player, player.m_21120_(hand), hand));
        }
        return super.m_7203_(level, player, hand);
    }

    public MenuProvider getMenuProvider(Level world, Player player, ItemStack stack, InteractionHand hand) {
        return new SimpleMenuProvider((id, inv, play) -> {
            IItemHandler capability = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse((Object)CapabilityUtils.EMPTY_ITEM_HANDLER);
            CapabilityItemStackHandler handler = new CapabilityItemStackHandler(3, stack);
            if (capability != CapabilityUtils.EMPTY_ITEM_HANDLER) {
                handler = (CapabilityItemStackHandler)capability;
            }
            return new ContainerElectricDrill(id, player.m_150109_(), handler, (ContainerData)GenericContainerItem.makeData((InteractionHand)hand));
        }, CONTAINER_TITLE);
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        Item item;
        if (!other.m_41619_() && (item = other.m_41720_()) instanceof ItemDrillHead) {
            ItemDrillHead head = (ItemDrillHead)item;
            ItemStack oldHead = new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DRILLHEAD.getValue((Object)ItemElectricDrill.getHead(stack)));
            ItemElectricDrill.saveHead(stack, head.head);
            access.m_142104_(oldHead);
            player.m_9236_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ElectrodynamicsSounds.SOUND_BATTERY_SWAP.get(), SoundSource.PLAYERS, 0.25f, 1.0f, false);
            return true;
        }
        if (!IItemElectric.overrideOtherStackedOnMe((ItemStack)stack, (ItemStack)other, (Slot)slot, (ClickAction)action, (Player)player, (SlotAccess)access)) {
            return super.m_142305_(stack, other, slot, action, player, access);
        }
        return true;
    }

    public static double getSpeedBoost(ItemStack stack) {
        return stack.m_41784_().m_128459_("speedenchant");
    }

    public static SubtypeDrillHead getHead(ItemStack stack) {
        return SubtypeDrillHead.values()[stack.m_41784_().m_128451_(SUBTYPE)];
    }

    public static void saveHead(ItemStack stack, SubtypeDrillHead head) {
        stack.m_41784_().m_128405_(SUBTYPE, head.ordinal());
    }

    public boolean isAllowedInCreativeTab(CreativeModeTab tab) {
        return this.creativeTab.get() == tab;
    }

    public boolean hasCreativeTab() {
        return this.creativeTab != null;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="electrodynamics", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class ColorHandler {
        private ColorHandler() {
        }

        @SubscribeEvent
        public static void registerColoredBlocks(RegisterColorHandlersEvent.Item event) {
            DRILLS.forEach(item -> event.register((stack, index) -> {
                if (index == 1) {
                    return ItemElectricDrill.getHead((ItemStack)stack).color.color();
                }
                return Color.WHITE.color();
            }, new ItemLike[]{item}));
        }
    }
}

