/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.item.gear.tools.electric;

import electrodynamics.common.inventory.container.item.ContainerSeismicScanner;
import electrodynamics.common.packet.NetworkHandler;
import electrodynamics.common.packet.types.client.PacketAddClientRenderInfo;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import electrodynamics.registers.ElectrodynamicsItems;
import electrodynamics.registers.ElectrodynamicsSounds;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkDirection;
import voltaic.api.item.CapabilityItemStackHandler;
import voltaic.prefab.inventory.container.types.GenericContainerItem;
import voltaic.prefab.item.ElectricItemProperties;
import voltaic.prefab.item.ItemElectric;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.WorldUtils;
import voltaic.prefab.utilities.object.Location;

public class ItemSeismicScanner
extends ItemElectric {
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)"container.seismicscanner");
    public static final int SLOT_COUNT = 1;
    public static final int RADUIS_BLOCKS = 16;
    public static final int COOLDOWN_SECONDS = 10;
    public static final int JOULES_PER_SCAN = 1000;
    public static final String PLAY_LOC = "player";
    public static final String BLOCK_LOC = "block";

    public ItemSeismicScanner(ElectricItemProperties properties, Supplier<CreativeModeTab> creativeTab) {
        super(properties, creativeTab, item -> (Item)ElectrodynamicsItems.ITEM_BATTERY.get());
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new CapabilityItemStackHandler(1, stack);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltips, TooltipFlag flag) {
        boolean onCooldown;
        super.m_7373_(stack, world, tooltips, flag);
        tooltips.add((Component)ElectroTextUtils.tooltip("seismicscanner.use", new Object[0]));
        tooltips.add((Component)ElectroTextUtils.tooltip("seismicscanner.opengui", new Object[0]).m_130940_(ChatFormatting.GRAY));
        boolean bl = onCooldown = stack.m_41782_() && stack.m_41783_().m_128451_("timer") > 0;
        if (onCooldown) {
            tooltips.add((Component)ElectroTextUtils.tooltip("seismicscanner.oncooldown", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED}));
        } else {
            tooltips.add((Component)ElectroTextUtils.tooltip("seismicscanner.showuse", new Object[0]).m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_41465_() {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_) {
            ItemStack scanner = player.m_21120_(hand);
            ItemSeismicScanner seismic = (ItemSeismicScanner)scanner.m_41720_();
            CompoundTag tag = scanner.m_41784_();
            boolean isTimerUp = tag.m_128451_("timer") <= 0;
            boolean isPowered = seismic.getJoulesStored(scanner) >= 1000.0;
            ItemStack ore = scanner.getCapability(ForgeCapabilities.ITEM_HANDLER).map(m -> m.getStackInSlot(0)).orElse(ItemStack.f_41583_);
            if (player.m_6144_() && isTimerUp && isPowered && !ore.m_41619_()) {
                this.extractPower(scanner, this.getElectricProperties().extract.getJoules(), false);
                tag.m_128405_("timer", 200);
                world.m_5594_(null, player.m_20183_(), (SoundEvent)ElectrodynamicsSounds.SOUND_SEISMICSCANNER.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                Item item = ore.m_41720_();
                if (item instanceof BlockItem) {
                    BlockItem oreBlockItem = (BlockItem)item;
                    Location playerPos = new Location(player.m_20097_());
                    Location blockPos = new Location(WorldUtils.getClosestBlockToCenter((LevelReader)world, (BlockPos)playerPos.toBlockPos(), (int)16, (Block[])new Block[]{oreBlockItem.m_40614_()}));
                    playerPos.writeToNBT(tag, "locplayer");
                    blockPos.writeToNBT(tag, "locblock");
                    NetworkHandler.CHANNEL.sendTo((Object)new PacketAddClientRenderInfo(player.m_20148_(), blockPos.toBlockPos()), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
            } else {
                player.m_5893_(this.getMenuProvider(world, player, scanner, hand));
            }
        }
        return super.m_7203_(world, player, hand);
    }

    public MenuProvider getMenuProvider(Level world, Player player, ItemStack stack, InteractionHand hand) {
        return new SimpleMenuProvider((id, inv, play) -> {
            IItemHandler capability = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse((Object)CapabilityUtils.EMPTY_ITEM_HANDLER);
            CapabilityItemStackHandler handler = new CapabilityItemStackHandler(1, stack);
            if (capability != CapabilityUtils.EMPTY_ITEM_HANDLER) {
                handler = (CapabilityItemStackHandler)capability;
            }
            return new ContainerSeismicScanner(id, player.m_150109_(), handler, (ContainerData)GenericContainerItem.makeData((InteractionHand)hand));
        }, CONTAINER_TITLE);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        CompoundTag tag;
        int time;
        if (!world.f_46443_ && (time = (tag = stack.m_41784_()).m_128451_("timer")) > 0) {
            tag.m_128405_("timer", time - 1);
        }
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_(newStack.m_41720_());
    }
}

