/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.network.type;

import electrodynamics.common.tile.electricitygrid.GenericTileWire;
import electrodynamics.prefab.utilities.ElectricityUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import voltaic.api.electricity.ICapabilityElectrodynamic;
import voltaic.api.network.ITickableNetwork;
import voltaic.api.network.cable.type.IWire;
import voltaic.common.network.NetworkRegistry;
import voltaic.prefab.network.AbstractNetwork;
import voltaic.prefab.tile.types.GenericRefreshingConnectTile;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.Scheduler;
import voltaic.prefab.utilities.object.TransferPack;
import voltaic.registers.VoltaicCapabilities;

public class ElectricNetwork
extends AbstractNetwork<GenericTileWire, IWire, TransferPack, ElectricNetwork>
implements ICapabilityElectrodynamic {
    public static final int MAXIMUM_OVERLOAD_PERIOD_TICKS = 20;
    private double resistance = 0.0;
    private double energyLoss = 0.0;
    private double voltage = 0.0;
    private double lastEnergyLoss = 0.0;
    private double lastVoltage = 0.0;
    private final HashSet<BlockEntity> producersToIgnore = new HashSet();
    private double transferBuffer = 0.0;
    private double maxTransferBuffer = 0.0;
    private double minimumVoltage = -1.0;
    private final HashMap<Long, HashSet<GenericTileWire>> ampacityToWireMap = new HashMap();
    private final HashMap<BlockEntity, HashMap<Direction, TransferPack>> lastTransfer = new HashMap();
    private final HashSet<BlockEntity> noUsage = new HashSet();
    private boolean locked = false;
    private int ticksOverloaded = 0;

    public ElectricNetwork(Collection<GenericTileWire> varCables) {
        this.conductorSet.addAll(varCables);
        NetworkRegistry.register((ITickableNetwork)this);
    }

    public ElectricNetwork(Set<ElectricNetwork> networks) {
        for (ElectricNetwork net : networks) {
            if (net == null) continue;
            this.conductorSet.addAll(net.conductorSet);
            net.deregister();
        }
        NetworkRegistry.register((ITickableNetwork)this);
    }

    public void refreshNewNetwork() {
        this.ticksOverloaded = 0;
        this.resistance = 0.0;
        this.energyLoss = 0.0;
        this.voltage = 0.0;
        this.lastEnergyLoss = 0.0;
        this.lastVoltage = 0.0;
        this.producersToIgnore.clear();
        this.transferBuffer = 0.0;
        this.maxTransferBuffer = 0.0;
        this.minimumVoltage = -1.0;
        this.lastTransfer.clear();
        this.noUsage.clear();
        this.ampacityToWireMap.clear();
        super.refreshNewNetwork();
    }

    private TransferPack sendToReceivers(TransferPack maxTransfer, ArrayList<BlockEntity> ignored, boolean debug) {
        if (maxTransfer.getJoules() <= 0.0 || maxTransfer.getVoltage() <= 0.0) {
            return TransferPack.EMPTY;
        }
        Set<BlockEntity> availableAcceptors = this.getEnergyAcceptors();
        double joulesSent = 0.0;
        availableAcceptors.removeAll(ignored);
        availableAcceptors.removeAll(this.noUsage);
        if (availableAcceptors.isEmpty()) {
            return TransferPack.EMPTY;
        }
        Iterator<BlockEntity> it = availableAcceptors.iterator();
        double totalUsage = 0.0;
        HashMap<BlockEntity, Double> usage = new HashMap<BlockEntity, Double>();
        while (it.hasNext()) {
            BlockEntity receiver = it.next();
            double localUsage = 0.0;
            if (this.acceptorInputMap.containsKey(receiver)) {
                boolean shouldRemove = true;
                this.acceptorInputMap.get(receiver);
                for (Direction connection : (HashSet)this.acceptorInputMap.get(receiver)) {
                    TransferPack pack = ElectricityUtils.receivePower(receiver, connection, TransferPack.joulesVoltage((double)maxTransfer.getJoules(), (double)maxTransfer.getVoltage()), true);
                    if (pack.getJoules() == 0.0) continue;
                    shouldRemove = false;
                    totalUsage += pack.getJoules();
                    localUsage += pack.getJoules();
                    break;
                }
                if (shouldRemove) {
                    it.remove();
                }
            }
            usage.put(receiver, localUsage);
        }
        for (BlockEntity receiver : availableAcceptors) {
            TransferPack dedicated = TransferPack.joulesVoltage((double)(maxTransfer.getJoules() * ((Double)usage.get(receiver) / totalUsage)), (double)maxTransfer.getVoltage());
            if (!this.acceptorInputMap.containsKey(receiver)) continue;
            TransferPack perConnection = TransferPack.joulesVoltage((double)(dedicated.getJoules() / (double)((HashSet)this.acceptorInputMap.get(receiver)).size()), (double)maxTransfer.getVoltage());
            HashMap<Direction, TransferPack> perConnectionMap = new HashMap<Direction, TransferPack>();
            for (Direction connection : (HashSet)this.acceptorInputMap.get(receiver)) {
                TransferPack pack = ElectricityUtils.receivePower(receiver, connection, perConnection, debug);
                perConnectionMap.put(connection, pack);
                joulesSent += pack.getJoules();
                if (debug) continue;
                this.transmittedThisTick += pack.getJoules();
            }
            this.lastTransfer.put(receiver, perConnectionMap);
        }
        return TransferPack.joulesVoltage((double)Math.min(maxTransfer.getJoules(), joulesSent), (double)maxTransfer.getVoltage());
    }

    public Set<BlockEntity> getEnergyAcceptors() {
        return new HashSet<BlockEntity>(this.acceptorSet);
    }

    private boolean checkForOverload() {
        if (this.voltage <= 0.0 || this.networkMaxTransfer * this.voltage - this.transmittedThisTick * 20.0 > 0.0) {
            this.ticksOverloaded = 0;
            return false;
        }
        HashSet overloaded = new HashSet();
        for (Map.Entry<Long, HashSet<GenericTileWire>> entry : this.ampacityToWireMap.entrySet()) {
            if (!((double)entry.getKey().longValue() <= this.transmittedLastTick / this.voltage * 20.0) || !((double)entry.getKey().longValue() <= this.transmittedThisTick / this.voltage * 20.0)) continue;
            overloaded.addAll(entry.getValue());
        }
        if (overloaded.isEmpty()) {
            this.ticksOverloaded = 0;
            return false;
        }
        ++this.ticksOverloaded;
        if (this.ticksOverloaded < 20) {
            return true;
        }
        for (GenericTileWire wire : overloaded) {
            Scheduler.schedule((int)1, wire::destroyViolently);
        }
        return true;
    }

    public void updateConductorStatistics(GenericTileWire cable, boolean removed) {
        super.updateConductorStatistics((GenericRefreshingConnectTile)cable, removed);
        if (removed) {
            long ampacity = ((IWire)cable.getCableType()).getAmpacity();
            if (this.ampacityToWireMap.containsKey(ampacity)) {
                HashSet<GenericTileWire> set = this.ampacityToWireMap.get(ampacity);
                set.remove((Object)cable);
                this.ampacityToWireMap.put(ampacity, set);
            }
            this.resistance -= ((IWire)cable.getCableType()).getResistance();
        } else {
            this.resistance += ((IWire)cable.getCableType()).getResistance();
            long ampacity = ((IWire)cable.getCableType()).getAmpacity();
            HashSet<GenericTileWire> set = this.ampacityToWireMap.getOrDefault(ampacity, new HashSet());
            set.add(cable);
            this.ampacityToWireMap.put(ampacity, set);
        }
    }

    public void updateRecieverStatistics(BlockEntity reciever, Direction dir) {
        ICapabilityElectrodynamic electro = (ICapabilityElectrodynamic)reciever.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, dir).orElse((Object)CapabilityUtils.EMPTY_ELECTRO);
        if (electro == CapabilityUtils.EMPTY_ELECTRO || electro.getVoltage() < 0.0) {
            return;
        }
        if (this.minimumVoltage <= 0.0) {
            this.minimumVoltage = electro.getVoltage();
        } else if (electro.getVoltage() < this.minimumVoltage) {
            this.minimumVoltage = electro.getVoltage();
        }
    }

    public void resetReceiverStatistics() {
        this.minimumVoltage = -1.0;
        super.resetReceiverStatistics();
    }

    public void resetConductorStatistics() {
        this.resistance = 0.0;
        this.ampacityToWireMap.clear();
        super.resetConductorStatistics();
    }

    public void addProducer(BlockEntity tile, double d, boolean isEnergyReceiver) {
        if (!isEnergyReceiver) {
            this.producersToIgnore.add(tile);
        }
        this.voltage = Math.max(this.voltage, d);
    }

    public void deregister() {
        this.ampacityToWireMap.clear();
        super.deregister();
    }

    public void tick() {
        super.tick();
        this.lastTransfer.clear();
        this.noUsage.clear();
        if (this.maxTransferBuffer > 0.0) {
            ArrayList<BlockEntity> producersList = new ArrayList<BlockEntity>(this.producersToIgnore);
            if ((int)this.voltage != 0 && this.voltage > 0.0 && this.transferBuffer > 0.0) {
                if (this.resistance > 0.0) {
                    double bufferAsWatts = this.transferBuffer * 20.0;
                    double maxWatts = (-this.voltage * this.voltage + this.voltage * Math.sqrt(this.voltage * this.voltage + 4.0 * bufferAsWatts * this.resistance)) / (2.0 * this.resistance);
                    double maxPerTick = maxWatts / 20.0;
                    TransferPack send = TransferPack.joulesVoltage((double)maxPerTick, (double)this.voltage);
                    double sent = this.sendToReceivers(send, producersList, false).getJoules();
                    double lossPerTick = send.getAmps() * send.getAmps() * this.resistance / 20.0;
                    this.transferBuffer -= sent + lossPerTick;
                    this.energyLoss += lossPerTick;
                    this.transmittedThisTick += lossPerTick;
                    this.checkForOverload();
                } else {
                    this.transferBuffer -= this.sendToReceivers(TransferPack.joulesVoltage((double)this.transferBuffer, (double)this.voltage), producersList, false).getJoules();
                }
            }
        } else {
            this.transferBuffer = 0.0;
        }
        this.lastVoltage = this.voltage;
        if (this.transferBuffer <= 0.0) {
            this.voltage = 0.0;
        }
        this.lastEnergyLoss = this.energyLoss;
        this.energyLoss = 0.0;
        this.maxTransferBuffer = 0.0;
        this.producersToIgnore.clear();
        this.maxTransferBuffer = this.getConnectedLoad(new ICapabilityElectrodynamic.LoadProfile(TransferPack.joulesVoltage((double)this.transmittedLastTick, (double)this.lastVoltage), TransferPack.joulesVoltage((double)this.transmittedLastTick, (double)this.lastVoltage)), Direction.UP).getJoules();
        if (this.getSize() == 0) {
            this.deregister();
        }
    }

    public boolean isConductor(BlockEntity tile, GenericTileWire requesterCable) {
        return ElectricityUtils.isConductor(tile, requesterCable);
    }

    public ElectricNetwork createInstanceConductor(Set<GenericTileWire> conductors) {
        return new ElectricNetwork((Collection<GenericTileWire>)conductors);
    }

    public double getJoulesStored() {
        return this.transferBuffer;
    }

    public void setJoulesStored(double joules) {
        this.transferBuffer = joules;
    }

    public double getMaxJoulesStored() {
        return this.maxTransferBuffer;
    }

    public void onChange() {
    }

    public double getMinimumVoltage() {
        return this.minimumVoltage;
    }

    public double getAmpacity() {
        return this.networkMaxTransfer;
    }

    public double getLastEnergyLoss() {
        return this.lastEnergyLoss;
    }

    public double getVoltage() {
        return this.voltage;
    }

    public double getActiveVoltage() {
        return this.lastVoltage;
    }

    public double getResistance() {
        return this.resistance;
    }

    public TransferPack getConnectedLoad(ICapabilityElectrodynamic.LoadProfile loadProfile, Direction dir) {
        if (this.locked) {
            return TransferPack.EMPTY;
        }
        this.locked = true;
        TransferPack connectedLoad = TransferPack.joulesVoltage((double)0.0, (double)0.0);
        ArrayList load = new ArrayList(this.acceptorSet);
        load.removeAll(this.producersToIgnore);
        for (BlockEntity tile : load) {
            if (tile == null || tile.m_58901_()) {
                this.acceptorInputMap.remove(tile);
                this.acceptorSet.remove(tile);
                continue;
            }
            HashMap lastPerTile = this.lastTransfer.getOrDefault(load, new HashMap());
            boolean noUsage = true;
            for (Direction direction : this.acceptorInputMap.getOrDefault(tile, new HashSet())) {
                IEnergyStorage fe;
                ICapabilityElectrodynamic.LoadProfile profile = new ICapabilityElectrodynamic.LoadProfile(lastPerTile.getOrDefault(lastPerTile, TransferPack.EMPTY), loadProfile.maximumAvailable());
                ICapabilityElectrodynamic electro = (ICapabilityElectrodynamic)tile.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, direction).orElse((Object)CapabilityUtils.EMPTY_ELECTRO);
                TransferPack capLoad = electro == CapabilityUtils.EMPTY_ELECTRO ? ((fe = (IEnergyStorage)tile.getCapability(ForgeCapabilities.ENERGY, direction).orElse((Object)CapabilityUtils.EMPTY_FE)) == CapabilityUtils.EMPTY_FE ? TransferPack.EMPTY : TransferPack.joulesVoltage((double)fe.receiveEnergy(Integer.MAX_VALUE, true), (double)120.0)) : electro.getConnectedLoad(profile, direction);
                if (capLoad.getJoules() == 0.0) continue;
                noUsage = false;
                connectedLoad = TransferPack.joulesVoltage((double)(connectedLoad.getJoules() + capLoad.getJoules()), (double)Math.max(connectedLoad.getVoltage(), capLoad.getVoltage()));
                break;
            }
            if (!noUsage) continue;
            this.noUsage.add(tile);
        }
        this.locked = false;
        return connectedLoad;
    }

    public boolean isEnergyReceiver() {
        return true;
    }

    public boolean isEnergyProducer() {
        return true;
    }

    public TransferPack emit(TransferPack transfer, ArrayList<BlockEntity> ignored, boolean debug) {
        throw new UnsupportedOperationException("No");
    }
}

