/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.electricitygrid;

import electrodynamics.common.network.type.ElectricNetwork;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import voltaic.api.electricity.ICapabilityElectrodynamic;
import voltaic.api.network.cable.type.IWire;
import voltaic.prefab.tile.types.GenericRefreshingConnectTile;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.object.TransferPack;
import voltaic.registers.VoltaicCapabilities;

public abstract class GenericTileWire
extends GenericRefreshingConnectTile<IWire, GenericTileWire, ElectricNetwork> {
    private final ICapabilityElectrodynamic[] handler = new ICapabilityElectrodynamic[6];

    protected GenericTileWire(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        for (final Direction dir : Direction.values()) {
            this.handler[dir.ordinal()] = new ICapabilityElectrodynamic(){

                public double getMaxJoulesStored() {
                    return 0.0;
                }

                public double getJoulesStored() {
                    return 0.0;
                }

                public double getVoltage() {
                    return ((ElectricNetwork)GenericTileWire.this.getNetwork()).getVoltage();
                }

                public double getMinimumVoltage() {
                    return ((ElectricNetwork)GenericTileWire.this.getNetwork()).getMinimumVoltage();
                }

                public TransferPack receivePower(TransferPack transfer, boolean debug) {
                    ArrayList<BlockEntity> ignored = new ArrayList<BlockEntity>();
                    BlockEntity entity = GenericTileWire.this.f_58857_.m_7702_(new BlockPos((Vec3i)GenericTileWire.this.f_58858_).m_121945_(dir));
                    if (entity == null) {
                        return TransferPack.EMPTY;
                    }
                    ICapabilityElectrodynamic electro = (ICapabilityElectrodynamic)entity.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, dir.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ELECTRO);
                    boolean isReciever = electro != CapabilityUtils.EMPTY_ELECTRO && electro.isEnergyReceiver();
                    ignored.add(entity);
                    if (!debug) {
                        ((ElectricNetwork)GenericTileWire.this.getNetwork()).addProducer((BlockEntity)ignored.get(0), transfer.getVoltage(), isReciever);
                    }
                    return ((ElectricNetwork)GenericTileWire.this.getNetwork()).receivePower(transfer, debug);
                }

                public void onChange() {
                }

                public TransferPack getConnectedLoad(ICapabilityElectrodynamic.LoadProfile loadProfile, Direction dir2) {
                    return ((ElectricNetwork)GenericTileWire.this.getNetwork()).getConnectedLoad(loadProfile, dir2);
                }

                public double getMaximumVoltage() {
                    return ((ElectricNetwork)GenericTileWire.this.getNetwork()).getActiveVoltage();
                }

                public double getAmpacity() {
                    return ((ElectricNetwork)GenericTileWire.this.getNetwork()).getAmpacity();
                }

                public boolean isEnergyReceiver() {
                    return ((ElectricNetwork)GenericTileWire.this.getNetwork()).isEnergyReceiver();
                }

                public boolean isEnergyProducer() {
                    return ((ElectricNetwork)GenericTileWire.this.getNetwork()).isEnergyProducer();
                }

                public void setJoulesStored(double joules) {
                    ((ElectricNetwork)GenericTileWire.this.getNetwork()).setJoulesStored(joules);
                }
            };
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK && side != null) {
            return LazyOptional.of(() -> this.handler[side.ordinal()]).cast();
        }
        return LazyOptional.empty();
    }

    public void destroyViolently() {
        this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50083_.m_49966_());
    }

    public double getMaxTransfer() {
        return ((IWire)this.getCableType()).getAmpacity();
    }

    public ElectricNetwork createInstance(Set<ElectricNetwork> electricNetworks) {
        return new ElectricNetwork(electricNetworks);
    }

    public ElectricNetwork createInstanceConductor(Set<GenericTileWire> genericTileWires) {
        return new ElectricNetwork((Collection<GenericTileWire>)genericTileWires);
    }

    public abstract IWire.IWireColor getWireColor();
}

