/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.electricitygrid;

import electrodynamics.common.network.type.ElectricNetwork;
import electrodynamics.common.tile.electricitygrid.GenericTileWire;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.api.electricity.ICapabilityElectrodynamic;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;

public class TileMultimeterBlock
extends GenericTile {
    public SingleProperty<Double> voltage = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "voltageNew", (Object)0.0));
    public SingleProperty<Double> minVoltage = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "minvoltage", (Object)0.0));
    public SingleProperty<Double> joules = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "joulesNew", (Object)0.0));
    public SingleProperty<Double> resistance = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "resistanceNew", (Object)0.0));
    public SingleProperty<Double> loss = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "lossNew", (Object)0.0));
    public CachedTileOutput input;

    public TileMultimeterBlock(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_MULTIMETERBLOCK.get(), worldPosition, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, false).receivePower(this::receivePower).getConnectedLoad(this::getConnectedLoad).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.FRONT}).voltage(-1.0));
    }

    public void tickServer(ComponentTickable tickable) {
        if (tickable.getTicks() % (long)((Double)this.minVoltage.getValue() == 0.0 ? 20 : 2) == 0L) {
            Object object;
            Direction facing = this.getFacing();
            if (this.input == null) {
                this.input = new CachedTileOutput(this.f_58857_, this.f_58858_.m_121945_(facing));
            }
            if ((object = this.input.getSafe()) instanceof GenericTileWire) {
                GenericTileWire cond = (GenericTileWire)((Object)object);
                ElectricNetwork network = (ElectricNetwork)cond.getNetwork();
                this.joules.setValue((Object)network.getActiveTransmitted());
                this.voltage.setValue((Object)network.getActiveVoltage());
                this.minVoltage.setValue((Object)network.getMinimumVoltage());
                this.resistance.setValue((Object)network.getResistance());
                this.loss.setValue((Object)network.getLastEnergyLoss());
            } else {
                this.joules.setValue((Object)0.0);
                this.voltage.setValue((Object)0.0);
                this.minVoltage.setValue((Object)0.0);
                this.resistance.setValue((Object)0.0);
                this.loss.setValue((Object)0.0);
            }
        }
    }

    protected TransferPack receivePower(TransferPack transfer, boolean debug) {
        return TransferPack.EMPTY;
    }

    protected TransferPack getConnectedLoad(ICapabilityElectrodynamic.LoadProfile loadProfile, Direction dir) {
        return TransferPack.EMPTY;
    }
}

