/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.electricitygrid;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerPotentiometer;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.api.electricity.ICapabilityElectrodynamic;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.TransferPack;

public class TilePotentiometer
extends GenericTile {
    public final SingleProperty<Double> powerConsumption = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "consumption", (Object)-1.0));

    public TilePotentiometer(BlockPos pos, BlockState state) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_POTENTIOMETER.get(), pos, state);
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.potentiometer.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerPotentiometer((int)id, (Inventory)player, (ContainerData)this.getCoordsArray())));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).receivePower(this::receivePower).getConnectedLoad(this::getConnectedLoad).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.FRONT, BlockEntityUtils.MachineDirection.BACK, BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT, BlockEntityUtils.MachineDirection.BOTTOM}).voltage(-1.0));
    }

    private TransferPack receivePower(TransferPack pack, boolean debug) {
        if ((Double)this.powerConsumption.getValue() < 0.0) {
            return pack;
        }
        double accepted = Math.min(pack.getJoules(), (Double)this.powerConsumption.getValue());
        return TransferPack.joulesVoltage((double)accepted, (double)pack.getVoltage());
    }

    private TransferPack getConnectedLoad(ICapabilityElectrodynamic.LoadProfile loadProfile, Direction dir) {
        if (dir == Direction.DOWN) {
            return TransferPack.EMPTY;
        }
        return TransferPack.joulesVoltage((double)((Double)this.powerConsumption.getValue() < 0.0 ? Double.MAX_VALUE : (Double)this.powerConsumption.getValue()), (double)-1.0);
    }
}

