/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.electricitygrid.generators;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.ArrayUtils;
import voltaic.api.electricity.generator.IElectricGenerator;
import voltaic.common.item.ItemUpgrade;
import voltaic.common.item.subtype.SubtypeItemUpgrade;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.type.ComponentInventory;

public abstract class GenericGeneratorTile
extends GenericTile
implements IElectricGenerator {
    public final double upgradeMultiplier;
    @Nullable
    public final SubtypeItemUpgrade[] validMultipliers;

    protected GenericGeneratorTile(BlockEntityType<?> tileEntityTypeIn, BlockPos worldPos, BlockState blockState, double multiplier, SubtypeItemUpgrade ... itemUpgrades) {
        super(tileEntityTypeIn, worldPos, blockState);
        this.upgradeMultiplier = multiplier;
        this.validMultipliers = itemUpgrades;
    }

    public void onInventoryChange(ComponentInventory inv, int slot) {
        super.onInventoryChange(inv, slot);
        if (!(inv.getUpgradeContents().isEmpty() || slot < inv.getUpgradeSlotStartIndex() && slot != -1 || this.validMultipliers == null)) {
            this.setMultiplier(1.0);
            for (ItemStack stack : inv.getUpgradeContents()) {
                Item item;
                if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ItemUpgrade)) continue;
                ItemUpgrade upgrade = (ItemUpgrade)item;
                if (!upgrade.subtype.isEmpty) continue;
                for (int i = 0; i < stack.m_41613_(); ++i) {
                    if (!ArrayUtils.contains((Object[])this.validMultipliers, (Object)upgrade.subtype)) continue;
                    this.setMultiplier(this.upgradeMultiplier);
                }
            }
        }
    }
}

